/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.activity.ActivityManagerCapabilities;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class DefaultStartActivityFlagsProvider
implements StartActivityFlagsProvider {
    private final boolean myWaitForDebugger;
    @NotNull
    private final String myExtraFlags;
    @NotNull
    private final Project myProject;

    public DefaultStartActivityFlagsProvider(@NotNull Project project, boolean waitForDebugger, @NotNull String extraFlags) {
        this.myProject = project;
        this.myWaitForDebugger = waitForDebugger;
        this.myExtraFlags = extraFlags;
    }

    @Override
    @NotNull
    public String getFlags(@NotNull IDevice device2) {
        LinkedList flags = Lists.newLinkedList();
        if (this.myWaitForDebugger) {
            flags.add("-D");
            if (DefaultStartActivityFlagsProvider.suspendEnabled() && this.suspendSupported(device2)) {
                flags.add("--suspend");
            }
        }
        if (!this.myExtraFlags.isEmpty()) {
            flags.add(this.myExtraFlags);
        }
        return StringUtil.join((Collection)flags, (String)" ");
    }

    private boolean suspendSupported(IDevice device2) {
        return ActivityManagerCapabilities.suspendSupported(this.myProject, device2);
    }

    private static boolean suspendEnabled() {
        return (Boolean)StudioFlags.DEBUG_ATTEMPT_SUSPENDED_START.get();
    }
}

