/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.android.tools.idea.run.activity.manifest.NodeActivity;
import com.android.tools.manifest.parser.ManifestInfo;
import com.android.tools.manifest.parser.components.IntentFilter;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class DefaultApkActivityLocator
extends ActivityLocator {
    private static final Logger LOG = Logger.getInstance(DefaultApkActivityLocator.class);
    private final ApkProvider myApkProvider;
    private final String myApplicationId;

    public DefaultApkActivityLocator(@NotNull ApkProvider apkProvider, @NotNull String applicationId2) {
        this.myApkProvider = apkProvider;
        this.myApplicationId = applicationId2;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device2) throws ActivityLocator.ActivityLocatorException {
        Collection<ApkInfo> apks2;
        try {
            apks2 = this.myApkProvider.getApks(device2);
        }
        catch (Exception e) {
            throw new ActivityLocator.ActivityLocatorException("Unable to list apks", e);
        }
        if (apks2.isEmpty()) {
            throw new ActivityLocator.ActivityLocatorException("No APKs provided. Unable to extract default activity");
        }
        String defaultActivity = DefaultApkActivityLocator.computeDefaultActivityFromApks(apks2, this.myApplicationId);
        if (defaultActivity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
        return defaultActivity;
    }

    private static String computeDefaultActivityFromApks(@NotNull Collection<ApkInfo> apks2, @NotNull String applicationId2) {
        List filteredApks = apks2.stream().filter(apk -> apk.getApplicationId().equals(applicationId2)).collect(Collectors.toUnmodifiableList());
        if (filteredApks.size() != 1) {
            StringBuilder errorMessage = new StringBuilder();
            if (filteredApks.isEmpty()) {
                errorMessage.append("No matching APK for application: " + applicationId2 + "\n");
            } else {
                errorMessage.append("Multiple APKs present for application: " + applicationId2 + "\n");
                errorMessage.append("Projects:\n");
                for (ApkInfo apkInfo : apks2) {
                    errorMessage.append("  " + apkInfo.getApplicationId() + " containing :\n");
                    for (ApkFileUnit fileUnit : apkInfo.getFiles()) {
                        errorMessage.append("    " + fileUnit.getApkFile() + "\n");
                    }
                }
            }
            throw new IllegalStateException(errorMessage.toString());
        }
        ArrayList<NodeActivity> activities2 = new ArrayList<NodeActivity>();
        ApkInfo apkInfo = (ApkInfo)filteredApks.iterator().next();
        for (ApkFileUnit apkFileUnit : apkInfo.getFiles()) {
            File file2 = apkFileUnit.getApkFile();
            String ext = file2.getName().toLowerCase(Locale.US);
            if (!ext.endsWith(".apk")) continue;
            try (ZipFile zipFile = new ZipFile(file2);){
                ZipEntry manifestEntry = zipFile.getEntry("AndroidManifest.xml");
                if (manifestEntry == null) continue;
                InputStream input2 = zipFile.getInputStream(manifestEntry);
                try {
                    ManifestInfo manifest = ManifestInfo.parseBinaryFromStream((InputStream)input2);
                    activities2.addAll(manifest.activities().stream().map(NodeActivity::new).collect(Collectors.toList()));
                }
                finally {
                    if (input2 == null) continue;
                    input2.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to parse '" + file2.getName() + "' for default activity", (Throwable)e);
            }
        }
        String defaultActivityName = DefaultActivityLocator.computeDefaultActivity(activities2);
        if (defaultActivityName == null) {
            StringBuilder errorMessage = new StringBuilder("Unable to find Default Activity in:\n");
            DefaultApkActivityLocator.printActivities(activities2, errorMessage);
            LOG.info(errorMessage.toString());
        }
        return defaultActivityName;
    }

    private static void printActivities(List<NodeActivity> activities2, StringBuilder message2) {
        for (NodeActivity activity : activities2) {
            message2.append("  " + activity.getQualifiedName() + ":\n");
            for (IntentFilter intent : activity.getIntentFilters()) {
                for (String action2 : intent.getActions()) {
                    message2.append("    " + action2 + "\n");
                }
                for (String category : intent.getCategories()) {
                    message2.append("    " + category + "\n");
                }
            }
        }
    }
}

