/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.DomElement;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActivityLocatorUtils {
    public static boolean containsAction(@NotNull Element filter2, @NotNull String name2) {
        for (Node action2 = filter2.getFirstChild(); action2 != null; action2 = action2.getNextSibling()) {
            if (action2.getNodeType() != 1 || !"action".equals(action2.getNodeName()) || !name2.equals(((Element)action2).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCategory(@NotNull Element filter2, @NotNull String name2) {
        for (Node action2 = filter2.getFirstChild(); action2 != null; action2 = action2.getNextSibling()) {
            if (action2.getNodeType() != 1 || !"category".equals(action2.getNodeName()) || !name2.equals(((Element)action2).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLauncherIntent(@NotNull DefaultActivityLocator.ActivityWrapper activity) {
        return activity.hasAction("android.intent.action.MAIN") && (activity.hasCategory("android.intent.category.LAUNCHER") || activity.hasCategory("android.intent.category.LEANBACK_LAUNCHER"));
    }

    @Nullable
    public static String getQualifiedName(@NotNull Element component2) {
        Attr nameNode = component2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (nameNode == null) {
            return null;
        }
        String name2 = nameNode.getValue();
        int dotIndex = name2.indexOf(46);
        if (dotIndex > 0) {
            return name2;
        }
        Element root = component2.getOwnerDocument().getDocumentElement();
        Attr pkgNode = root.getAttributeNode("package");
        if (pkgNode != null) {
            String pkg = pkgNode.getValue();
            return pkg + (dotIndex == -1 ? "." : "") + name2;
        }
        return name2;
    }

    @Nullable
    public static String getQualifiedName(@NotNull ActivityAlias alias) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String name2 = alias.getName().getStringValue();
        if (name2 == null) {
            return null;
        }
        int dotIndex = name2.indexOf(46);
        if (dotIndex > 0) {
            return name2;
        }
        String pkg = null;
        DomElement parent2 = alias.getParent();
        if (parent2 instanceof Application && (parent2 = parent2.getParent()) instanceof Manifest) {
            Manifest manifest = (Manifest)parent2;
            pkg = manifest.getPackage().getStringValue();
        }
        return pkg == null ? name2 : pkg + (dotIndex == -1 ? "." : "") + name2;
    }

    @Nullable
    public static String getQualifiedName(@NotNull Activity activity) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiClass psiClass = (PsiClass)activity.getActivityClass().getValue();
        if (psiClass == null) {
            Module module2 = activity.getModule();
            if (module2 != null && ApkFacet.getInstance(module2) != null) {
                return activity.getActivityClass().getStringValue();
            }
            return null;
        }
        return ActivityLocatorUtils.getQualifiedActivityName(psiClass);
    }

    @Nullable
    public static String getQualifiedActivityName(@NotNull PsiClass c) {
        return PackageClassConverter.getQualifiedName(c);
    }
}

