/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProviderUtil;
import com.android.tools.idea.projectsystem.gradle.actions.FixAndroidRunConfigurationsAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

@Service
public final class RunConfigurationChecker {
    @NotNull
    private final Project myProject;
    @NotNull
    private AtomicBoolean myCheckPerformed = new AtomicBoolean();

    public RunConfigurationChecker(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public static RunConfigurationChecker getInstance(@NotNull Project project) {
        return (RunConfigurationChecker)project.getService(RunConfigurationChecker.class);
    }

    public void ensureRunConfigsInvokeBuild() {
        if (!((Boolean)StudioFlags.FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        if (!this.myCheckPerformed.compareAndSet(false, true)) {
            return;
        }
        if (MakeBeforeRunTaskProviderUtil.getConfigurationsMissingBeforeRunTask(this.myProject).isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> FixAndroidRunConfigurationsAction.perform(this.myProject));
    }
}

