/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdLaunchListener;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class LaunchableAndroidDevice
implements AndroidDevice {
    private static final Map<Abi, List<Abi>> ABI_MAPPINGS = ImmutableMap.of((Object)Abi.X86_64, (Object)ImmutableList.of((Object)Abi.X86_64, (Object)Abi.X86), (Object)Abi.ARM64_V8A, (Object)ImmutableList.of((Object)Abi.ARM64_V8A, (Object)Abi.ARMEABI_V7A, (Object)Abi.ARMEABI));
    @NotNull
    private final AvdInfo myAvdInfo;
    private final Object myLock = new Object();
    private ListenableFuture<IDevice> myLaunchedEmulator;

    public LaunchableAndroidDevice(@NotNull AvdInfo avdInfo) {
        this.myAvdInfo = avdInfo;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        return this.myAvdInfo.getAndroidVersion();
    }

    @Override
    public int getDensity() {
        String s = (String)this.myAvdInfo.getProperties().get("hw.lcd.density");
        if (s == null) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public boolean supportsMultipleScreenFormats() {
        return this.myAvdInfo.getAndroidVersion().isGreaterOrEqualThan(33) && "resizable".equals(this.myAvdInfo.getProperties().get("hw.device.name"));
    }

    @Override
    @NotNull
    public List<Abi> getAbis() {
        Abi abi = Abi.getEnum((String)this.myAvdInfo.getAbiType());
        if (abi == null) {
            return Collections.emptyList();
        }
        List<Abi> abis = ABI_MAPPINGS.get(abi);
        if (abis != null) {
            return abis;
        }
        return Collections.singletonList(abi);
    }

    @Override
    @NotNull
    public String getSerial() {
        return this.myAvdInfo.getId();
    }

    @Override
    public boolean supportsFeature(@NotNull IDevice.HardwareFeature feature) {
        switch (feature) {
            case WATCH: {
                return SystemImage.WEAR_TAG.equals((Object)this.myAvdInfo.getTag());
            }
            case TV: {
                return SystemImage.ANDROID_TV_TAG.equals((Object)this.myAvdInfo.getTag()) || SystemImage.GOOGLE_TV_TAG.equals((Object)this.myAvdInfo.getTag());
            }
            case AUTOMOTIVE: {
                return SystemImage.AUTOMOTIVE_TAG.equals((Object)this.myAvdInfo.getTag());
            }
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myAvdInfo.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coldBoot(@NotNull Project project) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLaunchedEmulator == null) {
                this.myLaunchedEmulator = AvdManagerConnection.getDefaultAvdManagerConnection().coldBoot(project, this.myAvdInfo, AvdLaunchListener.RequestType.INDIRECT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quickBoot(@NotNull Project project) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLaunchedEmulator == null) {
                this.myLaunchedEmulator = AvdManagerConnection.getDefaultAvdManagerConnection().quickBoot(project, this.myAvdInfo, AvdLaunchListener.RequestType.INDIRECT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootWithSnapshot(@NotNull Project project, @NotNull String snapshot) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLaunchedEmulator == null) {
                this.myLaunchedEmulator = AvdManagerConnection.getDefaultAvdManagerConnection().bootWithSnapshot(project, this.myAvdInfo, snapshot, AvdLaunchListener.RequestType.INDIRECT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ListenableFuture<IDevice> launch(@NotNull Project project) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLaunchedEmulator == null) {
                this.myLaunchedEmulator = AvdManagerConnection.getDefaultAvdManagerConnection().startAvd(project, this.myAvdInfo, AvdLaunchListener.RequestType.INDIRECT);
            }
            return this.myLaunchedEmulator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ListenableFuture<IDevice> getLaunchedDevice() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLaunchedEmulator == null) {
                throw new IllegalStateException("Attempt to get device corresponding to an emulator that hasn't been launched yet.");
            }
            return this.myLaunchedEmulator;
        }
    }

    @Override
    @NotNull
    public LaunchCompatibility canRun(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget projectTarget, @NotNull AndroidFacet facet2, Function<AndroidFacet, EnumSet<IDevice.HardwareFeature>> getRequiredHardwareFeatures, Set<Abi> supportedAbis) {
        LaunchCompatibility compatibility = LaunchCompatibility.YES;
        if (this.myAvdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
            compatibility = AvdManagerConnection.isSystemImageDownloadProblem(this.myAvdInfo.getStatus()) ? new LaunchCompatibility(LaunchCompatibility.State.ERROR, "Missing system image") : new LaunchCompatibility(LaunchCompatibility.State.ERROR, this.myAvdInfo.getErrorMessage());
        }
        return compatibility.combine(LaunchCompatibility.canRunOnDevice(minSdkVersion2, projectTarget, facet2, getRequiredHardwareFeatures, supportedAbis, this));
    }

    @NotNull
    public AvdInfo getAvdInfo() {
        return this.myAvdInfo;
    }

    @Override
    public boolean isDebuggable() {
        return !this.myAvdInfo.hasPlayStore();
    }
}

