/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.model.IdeBasicVariant;
import com.android.tools.idea.gradle.model.IdeTestedTargetVariant;
import com.android.tools.idea.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.projectsystem.gradle.GradleHolderProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.GradleApplicationIdProvider;
import com.android.tools.idea.run.GradleApplicationIdProviderKt;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/run/GradleApplicationIdProvider;", "Lcom/android/tools/idea/run/ApplicationIdProvider;", "androidFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "forTests", "", "androidModel", "Lcom/android/tools/idea/gradle/project/model/GradleAndroidModel;", "basicVariant", "Lcom/android/tools/idea/gradle/model/IdeBasicVariant;", "variant", "Lcom/android/tools/idea/gradle/model/IdeVariant;", "(Lorg/jetbrains/android/facet/AndroidFacet;ZLcom/android/tools/idea/gradle/project/model/GradleAndroidModel;Lcom/android/tools/idea/gradle/model/IdeBasicVariant;Lcom/android/tools/idea/gradle/model/IdeVariant;)V", "getPackageName", "", "getTestPackageName", "getTestProjectTargetApplicationIdProvider", "Companion", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleApplicationIdProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleApplicationIdProvider.kt\ncom/android/tools/idea/run/GradleApplicationIdProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class GradleApplicationIdProvider
implements ApplicationIdProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidFacet androidFacet;
    private final boolean forTests;
    @NotNull
    private final GradleAndroidModel androidModel;
    @NotNull
    private final IdeBasicVariant basicVariant;
    @Nullable
    private final IdeVariant variant;

    private GradleApplicationIdProvider(AndroidFacet androidFacet, boolean forTests, GradleAndroidModel androidModel, IdeBasicVariant basicVariant, IdeVariant variant) {
        this.androidFacet = androidFacet;
        this.forTests = forTests;
        this.androidModel = androidModel;
        this.basicVariant = basicVariant;
        this.variant = variant;
    }

    @Override
    @NotNull
    public String getPackageName() {
        IdeAndroidProjectType projectType = this.androidModel.getAndroidProject().getProjectType();
        String applicationId2 = switch (WhenMappings.$EnumSwitchMapping$0[projectType.ordinal()]) {
            case 1 -> this.getTestPackageName();
            case 2 -> {
                IdeVariant v1 = this.variant;
                if (v1 == null) {
                    throw new ApkProvisionException("Cannot resolve test only project target");
                }
                ApplicationIdProvider var4_2 = this.getTestProjectTargetApplicationIdProvider(v1);
                if (var4_2 != null) {
                    yield var4_2.getPackageName();
                }
                yield null;
            }
            case 3 -> GradleApplicationIdProvider.getPackageName$getBaseFeatureApplicationIdProvider(this, (Function1<? super AndroidFacet, ? extends Module>)((Function1)getPackageName.applicationId.1.INSTANCE)).getPackageName();
            case 4 -> GradleApplicationIdProvider.getPackageName$getBaseFeatureApplicationIdProvider(this, (Function1<? super AndroidFacet, ? extends Module>)((Function1)getPackageName.applicationId.2.INSTANCE)).getPackageName();
            case 5 -> StringKt.nullize$default((String)this.basicVariant.getApplicationId(), (boolean)false, (int)1, null);
            case 6 -> null;
            case 7 -> {
                if (this.androidModel.getAndroidProject().isBaseSplit()) {
                    yield StringKt.nullize$default((String)this.androidModel.getSelectedVariant().getMainArtifact().getApplicationId(), (boolean)false, (int)1, null);
                }
                yield GradleApplicationIdProvider.getPackageName$getBaseFeatureApplicationIdProvider(this, (Function1<? super AndroidFacet, ? extends Module>)((Function1)getPackageName.applicationId.3.INSTANCE)).getPackageName();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        if (applicationId2 == null) {
            String errorMessage = "Could not get applicationId for " + this.androidFacet.getModule().getName() + ". Project type: " + projectType;
            GradleApplicationIdProviderKt.access$getLogger$p().error(errorMessage, new Throwable());
            throw new ApkProvisionException(errorMessage);
        }
        return applicationId2;
    }

    @Override
    @Nullable
    public String getTestPackageName() {
        String result2;
        if (!this.forTests) {
            return null;
        }
        String string = result2 = StringKt.nullize$default((String)(this.androidModel.getAndroidProject().getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_TEST ? this.basicVariant.getApplicationId() : this.basicVariant.getTestApplicationId()), (boolean)false, (int)1, null);
        if (string == null) {
            ApkProvisionException apkProvisionException;
            ApkProvisionException it = apkProvisionException = new ApkProvisionException("[" + this.androidFacet.getModule().getName() + "] Unable to obtain test package.");
            boolean bl = false;
            GradleApplicationIdProviderKt.access$getLogger$p().error((Throwable)it);
            throw (Throwable)apkProvisionException;
        }
        return string;
    }

    private final ApplicationIdProvider getTestProjectTargetApplicationIdProvider(IdeVariant variant) {
        AndroidFacet androidFacet;
        IdeTestedTargetVariant testedTargetVariant;
        block7: {
            block6: {
                IdeTestedTargetVariant ideTestedTargetVariant = (IdeTestedTargetVariant)CollectionsKt.singleOrNull((List)variant.getTestedTargetVariants());
                if (ideTestedTargetVariant == null) {
                    return null;
                }
                testedTargetVariant = ideTestedTargetVariant;
                Module module2 = this.androidFacet.getHolderModule();
                Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"androidFacet\n        .holderModule");
                GradleProjectPath gradleProjectPath = GradleProjectPathKt.getGradleProjectPath(module2);
                if (gradleProjectPath == null) break block6;
                GradleProjectPath it = gradleProjectPath;
                boolean bl = false;
                GradleProjectPath gradleProjectPath2 = new GradleHolderProjectPath(it.getBuildRoot(), testedTargetVariant.getTargetProjectPath());
                Project project = this.androidFacet.getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"androidFacet.module.project");
                Module module3 = GradleProjectPathKt.resolveIn(gradleProjectPath2, project);
                if (module3 != null && (androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)module3)) != null) break block7;
            }
            return null;
        }
        AndroidFacet targetFacet = androidFacet;
        GradleAndroidModel gradleAndroidModel2 = GradleAndroidModel.Companion.get(targetFacet);
        if (gradleAndroidModel2 == null) {
            return null;
        }
        GradleAndroidModel targetModel = gradleAndroidModel2;
        IdeBasicVariant ideBasicVariant = targetModel.findBasicVariantByName(testedTargetVariant.getTargetVariant());
        if (ideBasicVariant == null) {
            return null;
        }
        IdeBasicVariant targetBasicVariant = ideBasicVariant;
        return Companion.createForBaseModule(targetFacet, targetModel, targetBasicVariant);
    }

    private static final ApplicationIdProvider getPackageName$getBaseFeatureApplicationIdProvider(GradleApplicationIdProvider this$0, Function1<? super AndroidFacet, ? extends Module> baseFeatureGetter) {
        Module module2 = (Module)baseFeatureGetter.invoke((Object)this$0.androidFacet);
        if (module2 == null) {
            throw new ApkProvisionException("Can't get base-app module for " + this$0.androidFacet.getModule().getName());
        }
        Module baseModule = module2;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)baseModule);
        if (androidFacet == null) {
            throw new ApkProvisionException("Can't get base-app Android Facet for " + this$0.androidFacet.getModule().getName());
        }
        AndroidFacet baseFacet = androidFacet;
        GradleAndroidModel gradleAndroidModel2 = GradleAndroidModel.Companion.get(baseFacet);
        if (gradleAndroidModel2 == null) {
            throw new ApkProvisionException("Can't get base-app Android Facet for " + this$0.androidFacet.getModule().getName());
        }
        GradleAndroidModel baseModel = gradleAndroidModel2;
        return Companion.createForBaseModule(baseFacet, baseModel, baseModel.getSelectedBasicVariant());
    }

    @JvmStatic
    @NotNull
    public static final GradleApplicationIdProvider create(@NotNull AndroidFacet androidFacet, boolean forTests, @NotNull GradleAndroidModel androidModel, @NotNull IdeBasicVariant basicVariant, @NotNull IdeVariant variant) {
        return Companion.create(androidFacet, forTests, androidModel, basicVariant, variant);
    }

    @JvmStatic
    @NotNull
    public static final GradleApplicationIdProvider createForBaseModule(@NotNull AndroidFacet androidFacet, @NotNull GradleAndroidModel androidModel, @NotNull IdeBasicVariant basicVariant) {
        return Companion.createForBaseModule(androidFacet, androidModel, basicVariant);
    }

    public /* synthetic */ GradleApplicationIdProvider(AndroidFacet androidFacet, boolean forTests, GradleAndroidModel androidModel, IdeBasicVariant basicVariant, IdeVariant variant, DefaultConstructorMarker $constructor_marker) {
        this(androidFacet, forTests, androidModel, basicVariant, variant);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/run/GradleApplicationIdProvider$Companion;", "", "()V", "create", "Lcom/android/tools/idea/run/GradleApplicationIdProvider;", "androidFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "forTests", "", "androidModel", "Lcom/android/tools/idea/gradle/project/model/GradleAndroidModel;", "basicVariant", "Lcom/android/tools/idea/gradle/model/IdeBasicVariant;", "variant", "Lcom/android/tools/idea/gradle/model/IdeVariant;", "createForBaseModule", "intellij.android.projectSystem.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleApplicationIdProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleApplicationIdProvider.kt\ncom/android/tools/idea/run/GradleApplicationIdProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GradleApplicationIdProvider create(@NotNull AndroidFacet androidFacet, boolean forTests, @NotNull GradleAndroidModel androidModel, @NotNull IdeBasicVariant basicVariant, @NotNull IdeVariant variant) {
            Intrinsics.checkNotNullParameter((Object)androidFacet, (String)"androidFacet");
            Intrinsics.checkNotNullParameter((Object)androidModel, (String)"androidModel");
            Intrinsics.checkNotNullParameter((Object)basicVariant, (String)"basicVariant");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            if (!Intrinsics.areEqual((Object)basicVariant.getName(), (Object)variant.getName())) {
                boolean bl = false;
                String string = "variant.name(" + variant.getName() + ") != basicVariant.name(" + basicVariant.getName() + ")";
                throw new IllegalArgumentException(string.toString());
            }
            return new GradleApplicationIdProvider(androidFacet, forTests, androidModel, basicVariant, variant, null);
        }

        @JvmStatic
        @NotNull
        public final GradleApplicationIdProvider createForBaseModule(@NotNull AndroidFacet androidFacet, @NotNull GradleAndroidModel androidModel, @NotNull IdeBasicVariant basicVariant) {
            Intrinsics.checkNotNullParameter((Object)androidFacet, (String)"androidFacet");
            Intrinsics.checkNotNullParameter((Object)androidModel, (String)"androidModel");
            Intrinsics.checkNotNullParameter((Object)basicVariant, (String)"basicVariant");
            return new GradleApplicationIdProvider(androidFacet, false, androidModel, basicVariant, null, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IdeAndroidProjectType.values().length];
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_LIBRARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_TEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_INSTANTAPP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_DYNAMIC_FEATURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_APP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_ATOM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_FEATURE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

