/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceStateCache<T>
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Table<String, String, T> myCache = HashBasedTable.create();

    public DeviceStateCache(@NotNull Disposable parent2) {
        Disposer.register((Disposable)parent2, (Disposable)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @Nullable
    public T get(@NotNull IDevice device2, @NotNull String pkgName) {
        return (T)this.myCache.get((Object)device2.getSerialNumber(), (Object)pkgName);
    }

    @Nullable
    public T put(@NotNull IDevice device2, @NotNull String pkgName, @NotNull T data) {
        return (T)this.myCache.put((Object)device2.getSerialNumber(), (Object)pkgName, data);
    }

    public void deviceConnected(IDevice device2) {
    }

    public void deviceDisconnected(IDevice device2) {
        this.myCache.row((Object)device2.getSerialNumber()).clear();
    }

    public void deviceChanged(IDevice device2, int changeMask) {
    }
}

