/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceChooser;
import com.android.tools.idea.run.DeviceChooserDialog;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.sdk.AndroidPlatform;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceSelectionUtils {
    @NotNull
    private static final Logger LOG = Logger.getInstance(DeviceSelectionUtils.class);
    @NonNls
    private static final String ANDROID_TARGET_DEVICES_PROPERTY = "AndroidTargetDevices";

    @Nullable
    public static Collection<IDevice> chooseRunningDevice(final @NotNull AndroidFacet facet2, final @NotNull Predicate<IDevice> deviceFilter, final @NotNull DeviceCount deviceCount) {
        List<IDevice> compatibleDevices = DeviceSelectionUtils.getAllCompatibleDevices(deviceFilter);
        if (compatibleDevices.isEmpty()) {
            return ImmutableList.of();
        }
        if (compatibleDevices.size() == 1) {
            return compatibleDevices;
        }
        final AtomicReference devicesRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                devicesRef.set(DeviceSelectionUtils.chooseDevicesManually(facet2, (Predicate<IDevice>)deviceFilter, deviceCount));
            }
        });
        return ((IDevice[])devicesRef.get()).length > 0 ? ImmutableList.copyOf((Object[])((IDevice[])devicesRef.get())) : null;
    }

    @NotNull
    public static List<IDevice> getAllCompatibleDevices(Predicate<IDevice> deviceFilter) {
        ArrayList<IDevice> compatibleDevices = new ArrayList<IDevice>();
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge != null) {
            IDevice[] devices2;
            for (IDevice device2 : devices2 = bridge.getDevices()) {
                if (!deviceFilter.apply((Object)device2)) continue;
                compatibleDevices.add(device2);
            }
        }
        return compatibleDevices;
    }

    @NotNull
    public static Collection<IDevice> getOnlineDevices(@Nullable Collection<IDevice> devices2) {
        if (devices2 == null) {
            return Collections.emptyList();
        }
        ArrayList online = Lists.newArrayListWithExpectedSize((int)devices2.size());
        for (IDevice device2 : devices2) {
            if (!device2.isOnline()) continue;
            online.add(device2);
        }
        return online;
    }

    @NotNull
    private static IDevice[] chooseDevicesManually(@NotNull AndroidFacet facet2, @NotNull Predicate<IDevice> filter2, @NotNull DeviceCount deviceCount) {
        Project project = facet2.getModule().getProject();
        String value2 = PropertiesComponent.getInstance((Project)project).getValue(ANDROID_TARGET_DEVICES_PROPERTY);
        String[] selectedSerials = value2 != null ? DeviceSelectionUtils.deserialize(value2) : null;
        AndroidPlatform platform = AndroidPlatforms.getInstance(facet2.getModule());
        if (platform == null) {
            LOG.error("Android platform not set for module: " + facet2.getModule().getName());
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        DeviceChooserDialog chooser = new DeviceChooserDialog(facet2, platform.getTarget(), deviceCount.isMultiple(), selectedSerials, filter2);
        chooser.show();
        IDevice[] devices2 = chooser.getSelectedDevices();
        if (chooser.getExitCode() != 0 || devices2.length == 0) {
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        PropertiesComponent.getInstance((Project)project).setValue(ANDROID_TARGET_DEVICES_PROPERTY, DeviceSelectionUtils.serialize(devices2));
        return devices2;
    }

    @NotNull
    public static String serialize(@NotNull IDevice[] devices2) {
        StringBuilder builder2 = new StringBuilder();
        int n = devices2.length;
        for (int i = 0; i < n; ++i) {
            builder2.append(devices2[i].getSerialNumber());
            if (i >= n - 1) continue;
            builder2.append(' ');
        }
        return builder2.toString();
    }

    @NotNull
    private static String[] deserialize(@NotNull String s) {
        return s.split(" ");
    }
}

