/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.DeviceChooserListener;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AvdManagerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceChooser
implements Disposable,
AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final int UPDATE_DELAY_MILLIS = 250;
    private static final String[] COLUMN_TITLES = new String[]{"Device", "State", "Compatible", "Serial Number"};
    private static final int DEVICE_NAME_COLUMN_INDEX = 0;
    private static final int DEVICE_STATE_COLUMN_INDEX = 1;
    private static final int COMPATIBILITY_COLUMN_INDEX = 2;
    private static final int SERIAL_COLUMN_INDEX = 3;
    public static final IDevice[] EMPTY_DEVICE_ARRAY = new IDevice[0];
    private final List<DeviceChooserListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final MergingUpdateQueue myUpdateQueue;
    private volatile boolean myProcessSelectionFlag = true;
    private final JComponent myPanel;
    private final JBTable myDeviceTable;
    private final Predicate<IDevice> myFilter;
    private final ListenableFuture<AndroidVersion> myMinSdkVersion;
    private final AndroidFacet myFacet;
    private final IAndroidTarget myProjectTarget;
    private final Set<Abi> mySupportedAbis;
    private int[] mySelectedRows;
    private final AtomicBoolean myDevicesDetected = new AtomicBoolean();

    public DeviceChooser(boolean multipleSelection, final @NotNull Action okAction, @NotNull AndroidFacet facet2, @NotNull IAndroidTarget projectTarget, @Nullable Predicate<IDevice> filter2) {
        this.myFacet = facet2;
        this.myFilter = filter2;
        this.myMinSdkVersion = StudioAndroidModuleInfo.getInstance(facet2).getRuntimeMinSdkVersion();
        this.myProjectTarget = projectTarget;
        AndroidModel androidModel = AndroidModel.get(facet2);
        this.mySupportedAbis = androidModel != null ? androidModel.getSupportedAbis() : Collections.emptySet();
        this.myDeviceTable = new JBTable();
        this.myPanel = ScrollPaneFactory.createScrollPane((Component)this.myDeviceTable);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)550, (int)220));
        MyDeviceTableModel tableModel2 = new MyDeviceTableModel(EMPTY_DEVICE_ARRAY);
        this.myDeviceTable.setModel((TableModel)tableModel2);
        this.myDeviceTable.setSelectionMode(multipleSelection ? 2 : 0);
        this.myDeviceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DeviceChooser.this.myProcessSelectionFlag) {
                    DeviceChooser.this.fireSelectedDevicesChanged();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (DeviceChooser.this.myDeviceTable.isEnabled() && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myDeviceTable);
        this.myDeviceTable.setDefaultRenderer(LaunchCompatibility.class, (TableCellRenderer)((Object)new LaunchCompatibilityRenderer()));
        this.myDeviceTable.setDefaultRenderer(IDevice.class, (TableCellRenderer)((Object)new DeviceRenderer.DeviceNameRenderer(AvdManagerUtils.getAvdManager(facet2), new DeviceNamePropertiesFetcher(this, new FutureCallback<DeviceNameProperties>(){

            public void onSuccess(@Nullable DeviceNameProperties result2) {
                DeviceChooser.this.updateTable();
            }

            public void onFailure(@NotNull Throwable t) {
                Logger.getInstance(DeviceChooser.class).warn("Error retrieving device name properties", t);
            }
        }))));
        this.myDeviceTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                }
            }
        });
        this.myDeviceTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int i;
                if (e.getButton() == 3 && (i = DeviceChooser.this.myDeviceTable.rowAtPoint(e.getPoint())) >= 0) {
                    Object serial = DeviceChooser.this.myDeviceTable.getValueAt(i, 3);
                    final String serialString = serial.toString();
                    JBPopupMenu popupMenu = new JBPopupMenu();
                    AbstractAction action2 = new AbstractAction("Copy Serial Number"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(serialString));
                        }
                    };
                    popupMenu.add((Action)action2);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
                super.mouseReleased(e);
            }
        });
        DeviceChooser.setColumnWidth(this.myDeviceTable, 0, "Samsung Galaxy Nexus Android 4.1 (API 17)");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 1, "offline");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 2, "Compatible");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 3, "123456");
        this.myDeviceTable.setAutoCreateColumnsFromModel(false);
        this.myDeviceTable.setAutoCreateRowSorter(true);
        this.myUpdateQueue = new MergingUpdateQueue("android.device.chooser", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.myMinSdkVersion.addListener(() -> tableModel2.fireTableDataChanged(), arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0));
    }

    private static void setColumnWidth(JBTable deviceTable2, int columnIndex, String sampleText) {
        int width = DeviceChooser.getWidth(deviceTable2, sampleText);
        deviceTable2.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
    }

    private static int getWidth(JBTable deviceTable2, String sampleText) {
        FontMetrics metrics = deviceTable2.getFontMetrics(deviceTable2.getFont());
        return metrics.stringWidth(sampleText);
    }

    public void init(@Nullable String[] selectedSerials) {
        this.updateTable();
        if (selectedSerials != null) {
            this.resetSelection(selectedSerials);
        }
    }

    private void resetSelection(@NotNull String[] selectedSerials) {
        MyDeviceTableModel model2 = (MyDeviceTableModel)this.myDeviceTable.getModel();
        HashSet selectedSerialsSet = new HashSet();
        Collections.addAll(selectedSerialsSet, selectedSerials);
        IDevice[] myDevices = model2.myDevices;
        ListSelectionModel selectionModel = this.myDeviceTable.getSelectionModel();
        boolean cleared = false;
        int n = myDevices.length;
        for (int i = 0; i < n; ++i) {
            String serialNumber = myDevices[i].getSerialNumber();
            if (!selectedSerialsSet.contains(serialNumber)) continue;
            if (!cleared) {
                selectionModel.clearSelection();
                cleared = true;
            }
            selectionModel.addSelectionInterval(i, i);
        }
    }

    private void updateTable() {
        IDevice[] devices2 = this.getFilteredDevices();
        if (devices2.length > 1) {
            Arrays.sort(devices2, new Comparator<IDevice>(){

                @Override
                public int compare(IDevice device1, IDevice device2) {
                    int apiLevel1 = this.safeGetApiLevel(device1);
                    int apiLevel2 = this.safeGetApiLevel(device2);
                    return apiLevel2 - apiLevel1;
                }

                private int safeGetApiLevel(IDevice device2) {
                    try {
                        String s = device2.getProperty("ro.build.version.sdk");
                        return StringUtil.isNotEmpty((String)s) ? Integer.parseInt(s) : 0;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myDevicesDetected.set(devices2.length > 0);
            this.refreshTable(devices2);
        });
    }

    private void refreshTable(IDevice[] devices2) {
        Object[] selectedDevices = this.getSelectedDevices(false);
        TIntArrayList selectedRows = new TIntArrayList();
        for (int i = 0; i < devices2.length; ++i) {
            if (ArrayUtil.indexOf((Object[])selectedDevices, (Object)devices2[i]) < 0) continue;
            selectedRows.add(i);
        }
        this.myProcessSelectionFlag = false;
        this.myDeviceTable.setModel((TableModel)new MyDeviceTableModel(devices2));
        if (selectedRows.isEmpty() && devices2.length > 0) {
            this.myDeviceTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        for (int selectedRow : selectedRows.toNativeArray()) {
            if (selectedRow >= devices2.length) continue;
            this.myDeviceTable.getSelectionModel().addSelectionInterval(selectedRow, selectedRow);
        }
        this.fireSelectedDevicesChanged();
        this.myProcessSelectionFlag = true;
    }

    public boolean hasDevices() {
        return this.myDevicesDetected.get();
    }

    public JComponent getPreferredFocusComponent() {
        return this.myDeviceTable;
    }

    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Nullable
    public ValidationInfo doValidate() {
        Object message2;
        if (!this.myDeviceTable.isEnabled()) {
            return null;
        }
        int[] rows = this.mySelectedRows != null ? this.mySelectedRows : this.myDeviceTable.getSelectedRows();
        boolean hasIncompatible = false;
        boolean hasCompatible = false;
        for (int row2 : rows) {
            if (!this.isRowCompatible(row2)) {
                hasIncompatible = true;
                continue;
            }
            hasCompatible = true;
        }
        if (!hasIncompatible) {
            return null;
        }
        if (hasCompatible) {
            message2 = "At least one of the selected devices is incompatible. Will only install on compatible devices.";
        } else {
            String devicesAre = rows.length > 1 ? "devices are" : "device is";
            message2 = "The selected " + devicesAre + " incompatible.";
        }
        return new ValidationInfo((String)message2);
    }

    @NotNull
    public IDevice[] getSelectedDevices() {
        return this.getSelectedDevices(true);
    }

    @NotNull
    private IDevice[] getSelectedDevices(boolean onlyCompatible) {
        int[] rows = this.mySelectedRows != null ? this.mySelectedRows : this.myDeviceTable.getSelectedRows();
        ArrayList<IDevice> result2 = new ArrayList<IDevice>();
        block0: for (int row2 : rows) {
            IDevice[] devices2;
            if (row2 < 0 || onlyCompatible && !this.isRowCompatible(row2)) continue;
            Object serial = this.myDeviceTable.getValueAt(row2, 3);
            for (IDevice device2 : devices2 = this.getFilteredDevices()) {
                if (!device2.getSerialNumber().equals(serial.toString())) continue;
                result2.add(device2);
                continue block0;
            }
        }
        return result2.toArray(new IDevice[0]);
    }

    @NotNull
    private IDevice[] getFilteredDevices() {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null || !bridge.isConnected()) {
            return EMPTY_DEVICE_ARRAY;
        }
        ArrayList<IDevice> filteredDevices = new ArrayList<IDevice>();
        for (IDevice device2 : bridge.getDevices()) {
            if (this.myFilter != null && !this.myFilter.apply((Object)device2)) continue;
            filteredDevices.add(device2);
        }
        return filteredDevices.toArray(new IDevice[0]);
    }

    private boolean isRowCompatible(int row2) {
        Object compatibility = this.myDeviceTable.getValueAt(row2, 2);
        return compatibility instanceof LaunchCompatibility && ((LaunchCompatibility)compatibility).getState() != LaunchCompatibility.State.ERROR;
    }

    public void finish() {
        this.mySelectedRows = this.myDeviceTable.getSelectedRows();
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void setEnabled(boolean enabled2) {
        this.myDeviceTable.setEnabled(enabled2);
    }

    @NotNull
    private static String getDeviceState(@NotNull IDevice device2) {
        IDevice.DeviceState state2 = device2.getState();
        return state2 != null ? StringUtil.capitalize((String)StringUtil.toLowerCase((String)state2.name())) : "";
    }

    private void fireSelectedDevicesChanged() {
        for (DeviceChooserListener listener2 : this.myListeners) {
            listener2.selectedDevicesChanged();
        }
    }

    public void addListener(@NotNull DeviceChooserListener listener2) {
        this.myListeners.add(listener2);
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        this.postUpdate();
    }

    public void deviceConnected(@NotNull IDevice device2) {
        this.postUpdate();
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
        this.postUpdate();
    }

    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        this.postUpdate();
    }

    private void postUpdate() {
        this.myUpdateQueue.queue(new Update("updateTable"){

            public void run() {
                DeviceChooser.this.updateTable();
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    private class MyDeviceTableModel
    extends AbstractTableModel {
        private final IDevice[] myDevices;

        public MyDeviceTableModel(IDevice[] devices2) {
            this.myDevices = devices2;
        }

        @Override
        public String getColumnName(int column2) {
            return COLUMN_TITLES[column2];
        }

        @Override
        public int getRowCount() {
            return this.myDevices.length;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_TITLES.length;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.myDevices.length) {
                return null;
            }
            IDevice device2 = this.myDevices[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return device2;
                }
                case 3: {
                    return device2.getSerialNumber();
                }
                case 1: {
                    return DeviceChooser.getDeviceState(device2);
                }
                case 2: {
                    ConnectedAndroidDevice connectedDevice = new ConnectedAndroidDevice(device2);
                    try {
                        return DeviceChooser.this.myMinSdkVersion.isDone() ? connectedDevice.canRun((AndroidVersion)DeviceChooser.this.myMinSdkVersion.get(), DeviceChooser.this.myProjectTarget, DeviceChooser.this.myFacet, (Function<AndroidFacet, EnumSet<IDevice.HardwareFeature>>)((Function)LaunchCompatibilityCheckerImpl::getRequiredHardwareFeatures), DeviceChooser.this.mySupportedAbis) : Boolean.valueOf(false);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        return false;
                    }
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return LaunchCompatibility.class;
            }
            if (columnIndex == 0) {
                return IDevice.class;
            }
            return String.class;
        }
    }

    private static class LaunchCompatibilityRenderer
    extends ColoredTableCellRenderer {
        private LaunchCompatibilityRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JTable table2, Object value2, boolean selected, boolean hasFocus, int row2, int column2) {
            if (!(value2 instanceof LaunchCompatibility)) {
                return;
            }
            LaunchCompatibility compatibility = (LaunchCompatibility)value2;
            LaunchCompatibility.State state2 = compatibility.getState();
            if (state2 == LaunchCompatibility.State.OK) {
                this.append("Yes");
            } else {
                if (state2 == LaunchCompatibility.State.ERROR) {
                    this.append("No", SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.append("Maybe");
                }
                String reason = compatibility.getReason();
                if (reason != null) {
                    this.append(", ");
                    this.append(reason);
                }
            }
        }
    }
}

