/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessText {
    private static final Key<AndroidProcessText> KEY = new Key("ANDROID_PROCESS_TEXT");
    private final List<MyFragment> myFragments = new ArrayList<MyFragment>();

    private AndroidProcessText(@NotNull ProcessHandler processHandler2) {
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key outputType) {
                List<MyFragment> list2 = AndroidProcessText.this.myFragments;
                synchronized (list2) {
                    AndroidProcessText.this.myFragments.add(new MyFragment(event2.getText(), outputType));
                }
            }
        });
        processHandler2.putUserData(KEY, (Object)this);
    }

    public static void attach(@NotNull ProcessHandler processHandler2) {
        new AndroidProcessText(processHandler2);
    }

    @Nullable
    public static AndroidProcessText get(@NotNull ProcessHandler processHandler2) {
        return (AndroidProcessText)processHandler2.getUserData(KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTo(@NotNull ProcessHandler processHandler2) {
        List<MyFragment> list2 = this.myFragments;
        synchronized (list2) {
            for (MyFragment fragment : this.myFragments) {
                processHandler2.notifyTextAvailable(fragment.getText(), fragment.getOutputType());
            }
        }
    }

    private static class MyFragment {
        private final String myText;
        private final Key myOutputType;

        private MyFragment(@NotNull String text2, @NotNull Key outputType) {
            this.myText = text2;
            this.myOutputType = outputType;
        }

        @NotNull
        public String getText() {
            return this.myText;
        }

        @NotNull
        public Key getOutputType() {
            return this.myOutputType;
        }
    }
}

