/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.tasks.LiveUpdateDeployer;
import com.android.tools.idea.editors.literals.LiteralReference;
import com.android.tools.idea.editors.literals.LiteralUsageReference;
import com.android.tools.idea.editors.literals.LiveLiteralsMonitorHandler;
import com.android.tools.idea.editors.literals.LiveLiteralsService;
import com.android.tools.idea.editors.liveedit.LiveEditApplicationConfiguration;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.util.StudioPathManager;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class AndroidLiveLiteralDeployMonitor {
    private static LogWrapper LOGGER = new LogWrapper(Logger.getInstance(AndroidLiveLiteralDeployMonitor.class));
    private static final Map<Project, Map<String, Long>> ACTIVE_PROJECTS = new HashMap<Project, Map<String, Long>>();
    private static final Multimap<Project, String> ACTIVE_DEVICES = ArrayListMultimap.create();

    public static Callable<?> getCallback(Project project, String packageName2, IDevice device2) {
        String deviceId = device2.getSerialNumber();
        LiveLiteralsService.getInstance(project).liveLiteralsMonitorStopped(deviceId + "#" + packageName2);
        if (!LiveEditApplicationConfiguration.Companion.getInstance().isLiveLiterals()) {
            return null;
        }
        if (!AndroidLiveLiteralDeployMonitor.supportLiveLiteral(device2)) {
            return null;
        }
        LOGGER.info("Creating monitor for project %s targeting app %s", new Object[]{project.getName(), packageName2});
        return () -> {
            Map<Project, Map<String, Long>> map2 = ACTIVE_PROJECTS;
            synchronized (map2) {
                if (!ACTIVE_PROJECTS.containsKey(project)) {
                    LiveLiteralsService service = LiveLiteralsService.Companion.getInstance(project);
                    LiteralChangesListener listener2 = new LiteralChangesListener(project, packageName2);
                    service.addOnLiteralsChangedListener(service, (Function1<? super List<? extends LiteralReference>, Unit>)((Function1)listener2::onLiteralsChanged));
                    Disposer.register((Disposable)service, (Disposable)listener2);
                    ACTIVE_PROJECTS.put(project, new HashMap());
                } else {
                    ACTIVE_PROJECTS.get(project).clear();
                }
            }
            LiveLiteralsMonitorHandler.DeviceType deviceType = device2.isEmulator() ? LiveLiteralsMonitorHandler.DeviceType.EMULATOR : LiveLiteralsMonitorHandler.DeviceType.PHYSICAL;
            ACTIVE_DEVICES.put((Object)project, (Object)deviceId);
            LiveLiteralsService.getInstance(project).liveLiteralsMonitorStarted(deviceId + "#" + packageName2, deviceType);
            return null;
        };
    }

    private static void pushLiteralsToDevice(Project project, String packageName2, List<LiteralReference> changes, long timestamp) {
        LOGGER.info("Change detected for project %s targeting app %s", new Object[]{project.getName(), packageName2});
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Map<Project, Map<String, Long>> map2 = ACTIVE_PROJECTS;
            synchronized (map2) {
                List<AndroidSessionInfo> sessions = AndroidSessionInfo.findActiveSession(project);
                if (sessions == null) {
                    LOGGER.info("No running session found for %s", new Object[]{packageName2});
                    return;
                }
                Map<String, Long> lastUpdate = ACTIVE_PROJECTS.get(project);
                HashSet missingClients = Sets.newHashSet((Iterable)ACTIVE_DEVICES.get((Object)project));
                for (AndroidSessionInfo session2 : sessions) {
                    ExecutionTarget target2 = session2.getExecutionTarget();
                    if (!(target2 instanceof AndroidExecutionTarget)) continue;
                    for (IDevice iDevice : ((AndroidExecutionTarget)target2).getRunningDevices()) {
                        if (!AndroidLiveLiteralDeployMonitor.supportLiveLiteral(iDevice)) continue;
                        missingClients.remove(iDevice.getSerialNumber());
                        AdbClient adb = new AdbClient(iDevice, (ILogger)LOGGER);
                        MetricsRecorder metrics = new MetricsRecorder();
                        AdbInstaller installer = new AdbInstaller(AndroidLiveLiteralDeployMonitor.getLocalInstaller(), adb, (Collection)metrics.getDeployMetrics(), (ILogger)LOGGER, AdbInstaller.Mode.DAEMON);
                        LiveUpdateDeployer deployer = new LiveUpdateDeployer((ILogger)LOGGER);
                        ArrayList<LiveUpdateDeployer.UpdateLiveLiteralParam> params2 = new ArrayList<LiveUpdateDeployer.UpdateLiveLiteralParam>();
                        for (LiteralReference change : changes) {
                            for (LiteralUsageReference use2 : change.getUsages()) {
                                String key = "";
                                int offset = use2.getRange().getStartOffset();
                                String helper2 = AndroidLiveLiteralDeployMonitor.qualifyNameToHelperClassName(use2.getFqName().toString());
                                String type = AndroidLiveLiteralDeployMonitor.constTypeToJvmType(change.getConstantValue());
                                LiveUpdateDeployer.UpdateLiveLiteralParam param = new LiveUpdateDeployer.UpdateLiveLiteralParam(key, offset, helper2, type, change.getConstantValue().toString());
                                String lookup = AndroidLiveLiteralDeployMonitor.getLiteralTimeStampKey(adb.getSerial(), helper2, offset);
                                if (lastUpdate.getOrDefault(lookup, 0L) < timestamp) {
                                    params2.add(param);
                                    lastUpdate.put(lookup, timestamp);
                                    LOGGER.info("Live Literal Value of type %s updated to %s", new Object[]{type, change.getConstantValue().toString()});
                                    continue;
                                }
                                LOGGER.warning("Live Literal Value of type %s not updated to %s since it outdated", new Object[]{type, change.getConstantValue().toString()});
                            }
                        }
                        LOGGER.info("Invoking Deployer.updateLiveLiteral for %s", new Object[]{packageName2});
                        String deviceId = adb.getSerial() + "#" + packageName2;
                        String pushKey = String.valueOf(params2.hashCode());
                        LiveLiteralsService.getInstance(project).liveLiteralPushStarted(deviceId, pushKey);
                        List errors2 = deployer.updateLiveLiteral((Installer)installer, adb, packageName2, params2);
                        LiveLiteralsService.getInstance(project).liveLiteralPushed(deviceId, pushKey, errors2.stream().map(e -> new LiveLiteralsMonitorHandler.Problem(LiveLiteralsMonitorHandler.Problem.Severity.ERROR, e.getMessage())).collect(Collectors.toList()));
                    }
                }
                for (String missingId : missingClients) {
                    LiveLiteralsService.getInstance(project).liveLiteralsMonitorStopped(missingId + "#" + packageName2);
                    ACTIVE_DEVICES.get((Object)project).remove(missingId);
                }
            }
        });
    }

    private static boolean supportLiveLiteral(IDevice device2) {
        return device2.getVersion().isGreaterOrEqualThan(30);
    }

    private static String constTypeToJvmType(Object constValue) {
        if (constValue instanceof Character) {
            return "C";
        }
        if (constValue instanceof Byte) {
            return "B";
        }
        if (constValue instanceof Integer) {
            return "I";
        }
        if (constValue instanceof Long) {
            return "J";
        }
        if (constValue instanceof Short) {
            return "S";
        }
        if (constValue instanceof Float) {
            return "F";
        }
        if (constValue instanceof Double) {
            return "D";
        }
        if (constValue instanceof Boolean) {
            return "Z";
        }
        return "Ljava/lang/String;";
    }

    @VisibleForTesting
    static String qualifyNameToHelperClassName(String name2) {
        Object helper2 = name2;
        while (((String)helper2).endsWith(".<anonymous>")) {
            helper2 = ((String)helper2).substring(0, ((String)helper2).length() - ".<anonymous>".length());
        }
        if (!((String)(helper2 = ((String)helper2).indexOf(".") == -1 ? "no.name.space.from.LiveLiteralMonitor" : ((String)helper2).substring(0, ((String)helper2).lastIndexOf(".")))).endsWith("Kt")) {
            helper2 = (String)helper2 + "Kt";
        }
        helper2 = ((String)helper2).substring(0, ((String)helper2).lastIndexOf(46) + 1) + "LiveLiterals$" + ((String)helper2).substring(((String)helper2).lastIndexOf(46) + 1);
        return helper2;
    }

    private static String getLocalInstaller() {
        Path path2 = StudioPathManager.isRunningFromSources() ? StudioPathManager.resolvePathFromSourcesRoot((String)"bazel-bin/tools/base/deploy/installer/android-installer") : Paths.get(PathManager.getHomePath(), "plugins/android/resources/installer");
        return path2.toString();
    }

    public static String getLiteralTimeStampKey(String deviceId, String helper2, int offset) {
        return String.format(Locale.ENGLISH, "[device=%s]-%s[offset=%d]", deviceId, helper2, offset);
    }

    private static class LiteralChangesListener
    implements Disposable {
        private Project project;
        private final String packageName;

        private LiteralChangesListener(Project project, String packageName2) {
            this.project = project;
            this.packageName = packageName2;
        }

        public void dispose() {
            ACTIVE_PROJECTS.remove(this.project);
            ACTIVE_DEVICES.removeAll((Object)this.project);
            this.project = null;
        }

        public Unit onLiteralsChanged(List<? extends LiteralReference> changes) {
            long timestamp = System.nanoTime();
            AndroidLiveLiteralDeployMonitor.pushLiteralsToDevice(this.project, this.packageName, changes, timestamp);
            return Unit.INSTANCE;
        }
    }
}

