/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.deploy.DeploymentConfiguration;
import com.android.tools.idea.editors.literals.LiveEditService;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidLiveLiteralDeployMonitor;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.activity.launch.DeepLinkLaunch;
import com.android.tools.idea.run.deployment.liveedit.LiveEditApp;
import com.android.tools.idea.run.profiler.AbstractProfilerExecutorGroup;
import com.android.tools.idea.run.profiler.ProfilingMode;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.ApplyChangesTask;
import com.android.tools.idea.run.tasks.ApplyCodeChangesTask;
import com.android.tools.idea.run.tasks.ClearAppStorageTask;
import com.android.tools.idea.run.tasks.DeployTask;
import com.android.tools.idea.run.tasks.KillAndRestartAppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.RunInstantAppTask;
import com.android.tools.idea.run.tasks.SandboxSdkLaunchTask;
import com.android.tools.idea.run.tasks.ShowLogcatTask;
import com.android.tools.idea.run.tasks.StartLiveUpdateMonitoringTask;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.stats.RunStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class AndroidLaunchTasksProvider {
    private final Logger myLogger = Logger.getInstance(AndroidLaunchTasksProvider.class);
    private final AndroidRunConfiguration myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final AndroidFacet myFacet;
    private final ApplicationIdProvider myApplicationIdProvider;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;
    private final Boolean myDebug;
    private final Project myProject;

    public AndroidLaunchTasksProvider(@NotNull AndroidRunConfiguration runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions, Boolean isDebug) {
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myProject = facet2.getModule().getProject();
        this.myFacet = facet2;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myApkProvider = apkProvider;
        this.myLaunchOptions = launchOptions;
        this.myDebug = isDebug;
    }

    @NotNull
    public List<LaunchTask> getTasks(@NotNull IDevice device2) throws ExecutionException {
        String packageName2;
        ArrayList<LaunchTask> launchTasks = new ArrayList<LaunchTask>();
        boolean useApplyChanges = this.shouldApplyChanges() || this.shouldApplyCodeChanges();
        try {
            AppLaunchTask appLaunchTask;
            packageName2 = this.myApplicationIdProvider.getPackageName();
            launchTasks.addAll(this.getDeployTasks(device2, packageName2));
            StringBuilder amStartOptions = new StringBuilder();
            for (AndroidLaunchTaskContributor taskContributor : (AndroidLaunchTaskContributor[])AndroidLaunchTaskContributor.EP_NAME.getExtensions()) {
                String amOptions = taskContributor.getAmStartOptions(packageName2, this.myRunConfig, device2, this.myEnv.getExecutor());
                amStartOptions.append(amStartOptions.length() == 0 ? "" : " ").append(amOptions);
                LaunchTask task2 = taskContributor.getTask(packageName2, this.myRunConfig, device2, this.myEnv.getExecutor());
                if (task2 == null) continue;
                launchTasks.add(task2);
            }
            if (!this.shouldDeployAsInstant() && (appLaunchTask = this.myRunConfig.getApplicationLaunchTask(this.myApplicationIdProvider, this.myFacet, amStartOptions.toString(), this.myDebug, this.myApkProvider, device2)) != null) {
                launchTasks.add(new KillAndRestartAppLaunchTask(packageName2));
                if (this.shouldDebugSandboxSdk(device2)) {
                    launchTasks.add(new SandboxSdkLaunchTask(packageName2));
                }
                launchTasks.add(appLaunchTask);
            }
        }
        catch (ApkProvisionException e) {
            if (useApplyChanges) {
                this.myLogger.error((Throwable)e);
            } else {
                this.myLogger.warn((Throwable)e);
            }
            throw new ExecutionException("Unable to determine application id: " + e);
        }
        catch (IllegalStateException e) {
            throw new ExecutionException("Unable to determine application id: " + e);
        }
        if (this.myLaunchOptions.isOpenLogcatAutomatically()) {
            launchTasks.add(new ShowLogcatTask(this.myProject, packageName2));
        }
        return launchTasks;
    }

    @NotNull
    @VisibleForTesting
    List<LaunchTask> getDeployTasks(@NotNull IDevice device2, @NotNull String packageName2) throws ApkProvisionException {
        if (!this.myLaunchOptions.isDeploy()) {
            return Collections.emptyList();
        }
        ArrayList<LaunchTask> tasks = new ArrayList<LaunchTask>();
        DeployType deployType = this.getDeployType();
        List<String> disabledFeatures = this.myLaunchOptions.getDisabledDynamicFeatures();
        List<ApkInfo> packages = this.myApkProvider.getApks(device2).stream().map(apkInfo -> AndroidLaunchTasksProvider.filterDisabledFeatures(apkInfo, disabledFeatures)).collect(Collectors.toList());
        switch (deployType) {
            case RUN_INSTANT_APP: {
                if (this.myLaunchOptions.isClearAppStorage()) {
                    tasks.add(new ClearAppStorageTask(packageName2));
                }
                DeepLinkLaunch.State state2 = (DeepLinkLaunch.State)this.myRunConfig.getLaunchOptionState("launch_deep_link");
                assert (state2 != null);
                tasks.add(new RunInstantAppTask(this.myApkProvider.getApks(device2), state2.DEEP_LINK, disabledFeatures));
                break;
            }
            case APPLY_CHANGES: {
                tasks.add(new ApplyChangesTask(this.myProject, packages, this.isApplyChangesFallbackToRun(), this.myLaunchOptions.getAlwaysInstallWithPm()));
                tasks.add(new StartLiveUpdateMonitoringTask(AndroidLiveLiteralDeployMonitor.getCallback(this.myProject, packageName2, device2)));
                tasks.add(new StartLiveUpdateMonitoringTask(() -> LiveEditService.getInstance(this.myProject).notifyAppRefresh(device2)));
                break;
            }
            case APPLY_CODE_CHANGES: {
                tasks.add(new ApplyCodeChangesTask(this.myProject, packages, this.isApplyCodeChangesFallbackToRun(), this.myLaunchOptions.getAlwaysInstallWithPm()));
                tasks.add(new StartLiveUpdateMonitoringTask(AndroidLiveLiteralDeployMonitor.getCallback(this.myProject, packageName2, device2)));
                tasks.add(new StartLiveUpdateMonitoringTask(() -> LiveEditService.getInstance(this.myProject).notifyAppRefresh(device2)));
                break;
            }
            case DEPLOY: {
                if (this.myLaunchOptions.isClearAppStorage()) {
                    tasks.add(new ClearAppStorageTask(packageName2));
                }
                tasks.add(new DeployTask(this.myProject, packages, this.myLaunchOptions.getPmInstallOptions(device2), this.myLaunchOptions.getInstallOnAllUsers(), this.myLaunchOptions.getAlwaysInstallWithPm()));
                tasks.add(new StartLiveUpdateMonitoringTask(AndroidLiveLiteralDeployMonitor.getCallback(this.myProject, packageName2, device2)));
                LiveEditApp app = new LiveEditApp(AndroidLaunchTasksProvider.getApkPaths(device2, this.myApkProvider), device2.getVersion().getApiLevel());
                tasks.add(new StartLiveUpdateMonitoringTask(() -> LiveEditService.getInstance(this.myProject).notifyAppDeploy(packageName2, device2, app, (Function0<Boolean>)((Function0)this::isLiveEditable))));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled Deploy Type");
            }
        }
        return ImmutableList.copyOf(tasks);
    }

    private boolean isLiveEditable() {
        RunProfile runProfile = this.myEnv.getRunProfile();
        AbstractProfilerExecutorGroup.AbstractProfilerSetting profilerSetting = AbstractProfilerExecutorGroup.Companion.getExecutorSetting(this.myEnv.getExecutor().getId());
        if (!LiveEditService.usesCompose(this.myProject)) {
            return false;
        }
        if (profilerSetting != null && profilerSetting.getProfilingMode() != ProfilingMode.DEBUGGABLE) {
            return false;
        }
        if (!(runProfile instanceof AndroidRunConfigurationBase)) {
            return false;
        }
        AndroidRunConfigurationBase config2 = (AndroidRunConfigurationBase)runProfile;
        Module module2 = ((AndroidRunConfigurationModule)config2.getConfigurationModule()).getModule();
        if (module2 == null) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null && LaunchUtils.canDebugApp(facet2);
    }

    private static Set<Path> getApkPaths(@NotNull IDevice device2, @NotNull ApkProvider apkProvider) throws ApkProvisionException {
        HashSet<Path> apksPaths = new HashSet<Path>();
        for (ApkInfo apkInfo : apkProvider.getApks(device2)) {
            for (ApkFileUnit apkFileUnit : apkInfo.getFiles()) {
                apksPaths.add(apkFileUnit.getApkPath());
            }
        }
        return apksPaths;
    }

    private boolean isApplyCodeChangesFallbackToRun() {
        return DeploymentConfiguration.getInstance().APPLY_CODE_CHANGES_FALLBACK_TO_RUN;
    }

    private boolean isApplyChangesFallbackToRun() {
        return DeploymentConfiguration.getInstance().APPLY_CHANGES_FALLBACK_TO_RUN;
    }

    public void fillStats(RunStats stats) {
        stats.setApplyChangesFallbackToRun(this.isApplyChangesFallbackToRun());
        stats.setApplyCodeChangesFallbackToRun(this.isApplyCodeChangesFallbackToRun());
        stats.setRunAlwaysInstallWithPm(this.myLaunchOptions.getAlwaysInstallWithPm());
        stats.setIsComposeProject(LiveEditService.usesCompose(this.myProject));
    }

    @NotNull
    private static ApkInfo filterDisabledFeatures(ApkInfo apkInfo, List<String> disabledFeatures) {
        if (apkInfo.getFiles().size() > 1) {
            List filtered = apkInfo.getFiles().stream().filter(feature -> DynamicAppUtils.isFeatureEnabled(disabledFeatures, feature)).collect(Collectors.toList());
            return new ApkInfo(filtered, apkInfo.getApplicationId());
        }
        return apkInfo;
    }

    private boolean shouldDeployAsInstant() {
        return ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 4 || this.myLaunchOptions.isDeployAsInstant();
    }

    private boolean shouldApplyChanges() {
        SwapInfo swapInfo = (SwapInfo)this.myEnv.getUserData(SwapInfo.SWAP_INFO_KEY);
        return swapInfo != null && swapInfo.getType() == SwapInfo.SwapType.APPLY_CHANGES;
    }

    private boolean shouldApplyCodeChanges() {
        SwapInfo swapInfo = (SwapInfo)this.myEnv.getUserData(SwapInfo.SWAP_INFO_KEY);
        return swapInfo != null && swapInfo.getType() == SwapInfo.SwapType.APPLY_CODE_CHANGES;
    }

    private boolean shouldDebugSandboxSdk(IDevice device2) {
        return this.hasDebugSandboxSdkEnabled() && device2.getVersion().isGreaterOrEqualThan(33) && this.myDebug != false && this.hasPrivacySandboxSdk(device2);
    }

    private boolean hasDebugSandboxSdkEnabled() {
        Object state2 = this.myRunConfig.getAndroidDebuggerContext().getAndroidDebuggerState();
        if (state2 != null) {
            return (Boolean)StudioFlags.LAUNCH_SANDBOX_SDK_PROCESS_WITH_DEBUGGER_ATTACHED_ON_DEBUG.get() != false && ((AndroidDebuggerState)state2).DEBUG_SANDBOX_SDK;
        }
        return false;
    }

    private boolean hasPrivacySandboxSdk(IDevice device2) {
        try {
            Collection<ApkInfo> apkList = this.myApkProvider.getApks(device2);
            for (ApkInfo apk : apkList) {
                if (!apk.isSandboxApk()) continue;
                return true;
            }
            return false;
        }
        catch (ApkProvisionException e) {
            return false;
        }
    }

    private DeployType getDeployType() {
        if (this.shouldDeployAsInstant()) {
            return DeployType.RUN_INSTANT_APP;
        }
        if (this.shouldApplyChanges()) {
            return DeployType.APPLY_CHANGES;
        }
        if (this.shouldApplyCodeChanges()) {
            return DeployType.APPLY_CODE_CHANGES;
        }
        return DeployType.DEPLOY;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum DeployType {
        RUN_INSTANT_APP{

            @Override
            public String asDisplayName() {
                return "Instant App Launch";
            }
        }
        ,
        APPLY_CHANGES{

            @Override
            public String asDisplayName() {
                return "Apply Changes";
            }
        }
        ,
        APPLY_CODE_CHANGES{

            @Override
            public String asDisplayName() {
                return "Apply Code Changes";
            }
        }
        ,
        DEPLOY{

            @Override
            public String asDisplayName() {
                return "Launch";
            }
        };


        public abstract String asDisplayName();
    }
}

