/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidConfigurationProducer
extends JavaRunConfigurationProducerBase<AndroidRunConfiguration> {
    public AndroidConfigurationProducer() {
        super((ConfigurationType)AndroidRunConfigurationType.getInstance());
    }

    @Nullable
    private static PsiClass getActivityClass(ConfigurationContext context2) {
        GlobalSearchScope scope2;
        Location location = context2.getLocation();
        if (location == null) {
            return null;
        }
        Module module2 = context2.getModule();
        if (module2 == null) {
            return null;
        }
        if ((location = JavaExecutionUtil.stepIntoSingleClass((Location)location)) == null) {
            return null;
        }
        PsiElement element2 = location.getPsiElement();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)element2.getProject());
        PsiClass activityClass = facade.findClass("android.app.Activity", scope2 = module2.getModuleWithDependenciesAndLibrariesScope(true));
        if (activityClass == null) {
            return null;
        }
        PsiClass elementClass = (PsiClass)AndroidPsiUtils.getPsiParentOfType((PsiElement)element2, PsiClass.class, (boolean)false);
        while (elementClass != null) {
            if (elementClass.isInheritor(activityClass, true)) {
                return elementClass;
            }
            elementClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementClass, PsiClass.class);
        }
        return null;
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(@NotNull ConfigurationContext context2) {
        return AndroidConfigurationProducer.getActivityClass(context2) == null ? null : super.createConfigurationFromContext(context2);
    }

    protected boolean setupConfigurationFromContext(@NotNull AndroidRunConfiguration configuration, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        PsiClass activity = AndroidConfigurationProducer.getActivityClass(context2);
        if (activity == null) {
            return false;
        }
        String activityName = activity.getQualifiedName();
        if (activityName == null) {
            return false;
        }
        sourceElement.set((Object)activity);
        configuration.setLaunchActivity(activityName);
        configuration.setName(JavaExecutionUtil.getPresentableClassName((String)activityName));
        this.setupConfigurationModule(context2, configuration);
        TargetSelectionMode targetSelectionMode = AndroidUtils.getDefaultTargetSelectionMode(context2.getModule(), (ConfigurationType)AndroidRunConfigurationType.getInstance(), AndroidTestRunConfigurationType.getInstance());
        if (targetSelectionMode != null) {
            configuration.getDeployTargetContext().setTargetSelectionMode(targetSelectionMode);
        }
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull AndroidRunConfiguration configuration, @NotNull ConfigurationContext context2) {
        Module confModule;
        PsiClass activity = AndroidConfigurationProducer.getActivityClass(context2);
        if (activity == null) {
            return false;
        }
        String activityName = activity.getQualifiedName();
        if (activityName == null) {
            return false;
        }
        Module contextModule = AndroidUtils.getAndroidModule(context2);
        return Objects.equals(contextModule, confModule = ((AndroidRunConfigurationModule)configuration.getConfigurationModule()).getModule()) && configuration.isLaunchingActivity(activityName);
    }
}

