/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.android.tools.idea.lang.androidSql.parser.AndroidSqlLexer;
import com.android.tools.idea.room.migrations.json.DatabaseViewBundle;
import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.FieldBundle;
import com.android.tools.idea.room.migrations.json.ForeignKeyBundle;
import com.android.tools.idea.room.migrations.json.FtsEntityBundle;
import com.android.tools.idea.room.migrations.json.FtsOptionsBundle;
import com.android.tools.idea.room.migrations.json.IndexBundle;
import com.android.tools.idea.room.migrations.json.PrimaryKeyBundle;
import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.android.tools.idea.room.migrations.update.EntityUpdate;
import com.android.tools.idea.room.migrations.update.SchemaDiffUtil;
import com.intellij.openapi.util.InvalidDataException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStatementsGenerator {
    private static final String TMP_TABLE_NAME_TEMPLATE = "%s_data$android_studio_tmp";

    @NotNull
    public static List<String> getMigrationStatements(@NotNull DatabaseUpdate databaseUpdate) {
        ArrayList<String> updateStatements = new ArrayList<String>();
        databaseUpdate.getRenamedEntities().forEach((oldName, newName2) -> updateStatements.add(SqlStatementsGenerator.getRenameTableStatement(oldName, newName2)));
        for (EntityBundle entity : databaseUpdate.getNewEntities().values()) {
            updateStatements.add(SqlStatementsGenerator.getCreateTableStatement(entity.getTableName(), entity));
        }
        for (EntityUpdate entityUpdate : databaseUpdate.getModifiedEntities().values()) {
            updateStatements.addAll(SqlStatementsGenerator.getMigrationStatements(entityUpdate));
        }
        for (EntityBundle entity : databaseUpdate.getDeletedEntities().values()) {
            updateStatements.add(SqlStatementsGenerator.getDropTableStatement(entity.getTableName()));
        }
        for (DatabaseViewBundle view : databaseUpdate.getDeletedViews()) {
            updateStatements.add(SqlStatementsGenerator.getDropViewStatement(view));
        }
        for (DatabaseViewBundle view : databaseUpdate.getNewOrModifiedViews()) {
            updateStatements.add(SqlStatementsGenerator.getCreateViewStatement(view));
        }
        for (String tableName : databaseUpdate.getTablesToForeignKeyCheck()) {
            updateStatements.add(SqlStatementsGenerator.getForeignKeyConstraintCheck(tableName));
        }
        return updateStatements;
    }

    @NotNull
    public static List<String> getMigrationStatements(@NotNull EntityUpdate entityUpdate) {
        String tableName = entityUpdate.getNewTableName();
        ArrayList<String> updateStatements = new ArrayList<String>();
        if (entityUpdate.isComplexUpdate()) {
            if (entityUpdate.shouldCreateAnFtsEntity() && SchemaDiffUtil.ftsTableNeedsExternalContentSource((FtsEntityBundle)entityUpdate.getNewState())) {
                updateStatements.addAll(SqlStatementsGenerator.getComplexUpdateForFtsTableWithExternalContent(entityUpdate));
            } else {
                updateStatements.addAll(SqlStatementsGenerator.getComplexTableUpdate(entityUpdate));
            }
        } else {
            if (entityUpdate.shouldRenameTable()) {
                updateStatements.add(SqlStatementsGenerator.getRenameTableStatement(entityUpdate.getOldTableName(), entityUpdate.getNewTableName()));
            }
            Map<String, FieldBundle> newFields = entityUpdate.getNewFields();
            for (FieldBundle fieldBundle : newFields.values()) {
                updateStatements.add(SqlStatementsGenerator.getAddColumnStatement(tableName, fieldBundle));
            }
            Map<FieldBundle, String> renamedFields = entityUpdate.getRenamedFields();
            for (Map.Entry<FieldBundle, String> entry : renamedFields.entrySet()) {
                updateStatements.add(SqlStatementsGenerator.getRenameColumnStatement(tableName, entry.getValue(), entry.getKey().getColumnName()));
            }
            Map<FieldBundle, String> map2 = entityUpdate.getValuesForUninitializedFields();
            if (!map2.isEmpty()) {
                updateStatements.add(SqlStatementsGenerator.getUpdateColumnsValuesStatement(tableName, map2));
            }
        }
        for (IndexBundle index2 : entityUpdate.getIndicesToBeDropped()) {
            updateStatements.add(SqlStatementsGenerator.getDropIndexStatement(index2));
        }
        for (IndexBundle index2 : entityUpdate.getIndicesToBeCreated()) {
            updateStatements.add(SqlStatementsGenerator.getCreateIndexStatement(index2, tableName));
        }
        return updateStatements;
    }

    @NotNull
    private static List<String> getComplexTableUpdate(@NotNull EntityUpdate entityUpdate) {
        ArrayList<String> updateStatements = new ArrayList<String>();
        String dataSource = SqlStatementsGenerator.getDataSourceForComplexUpdate(entityUpdate);
        Map<String, String> columnNameToColumnValue = SqlStatementsGenerator.getColumnNameToColumnValueMapping(entityUpdate);
        if (columnNameToColumnValue.isEmpty()) {
            updateStatements.add(SqlStatementsGenerator.getDropTableStatement(entityUpdate.getOldTableName()));
            updateStatements.add(SqlStatementsGenerator.getCreateTableStatement(entityUpdate.getNewTableName(), entityUpdate.getNewState()));
        } else {
            String oldTableName = !entityUpdate.shouldRenameTable() ? entityUpdate.getNewTableName() : entityUpdate.getOldTableName();
            String newTableName = !entityUpdate.shouldRenameTable() ? String.format(TMP_TABLE_NAME_TEMPLATE, oldTableName) : entityUpdate.getNewTableName();
            updateStatements.add(SqlStatementsGenerator.getCreateTableStatement(newTableName, entityUpdate.getNewState()));
            updateStatements.add(SqlStatementsGenerator.getInsertIntoTableStatement(newTableName, new ArrayList<String>(columnNameToColumnValue.keySet()), SqlStatementsGenerator.getSelectFromTableStatement(dataSource, new ArrayList<String>(columnNameToColumnValue.values()))));
            updateStatements.add(SqlStatementsGenerator.getDropTableStatement(oldTableName));
            if (!entityUpdate.shouldRenameTable()) {
                updateStatements.add(SqlStatementsGenerator.getRenameTableStatement(newTableName, oldTableName));
            }
        }
        return updateStatements;
    }

    private static List<String> getComplexUpdateForFtsTableWithExternalContent(@NotNull EntityUpdate entityUpdate) {
        ArrayList<String> updateStatements = new ArrayList<String>();
        String oldTableName = entityUpdate.getOldTableName();
        String newTableName = entityUpdate.getNewTableName();
        String dataSource = SqlStatementsGenerator.getDataSourceForComplexUpdate(entityUpdate);
        Map<String, String> columnNameToColumnValue = SqlStatementsGenerator.getColumnNameToColumnValueMapping(entityUpdate);
        updateStatements.add(SqlStatementsGenerator.getDropTableStatement(oldTableName));
        updateStatements.add(SqlStatementsGenerator.getCreateTableStatement(newTableName, entityUpdate.getNewState()));
        updateStatements.add(SqlStatementsGenerator.getInsertIntoTableStatement(newTableName, new ArrayList<String>(columnNameToColumnValue.keySet()), SqlStatementsGenerator.getSelectFromTableStatement(dataSource, new ArrayList<String>(columnNameToColumnValue.values()))));
        return updateStatements;
    }

    @NotNull
    private static String getSelectFromTableStatement(@NotNull String tableName, @NotNull List<String> columnNames) {
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder(String.format("SELECT %s\n", SqlStatementsGenerator.getColumnEnumeration(columnNames)));
        statement.append(String.format("\tFROM %s;", tableName));
        return statement.toString();
    }

    @NotNull
    private static String getInsertIntoTableStatement(@NotNull String tableName, @NotNull List<String> columnNames, @NotNull String values) {
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder(String.format("INSERT INTO %s (%s)\n\t", tableName, SqlStatementsGenerator.getColumnEnumeration(columnNames)));
        statement.append(values);
        if (!statement.toString().endsWith(";")) {
            statement.append(";");
        }
        return statement.toString();
    }

    @NotNull
    private static String getRenameTableStatement(@NotNull String oldName, @NotNull String newName2) {
        return String.format("ALTER TABLE %s RENAME TO %s;", AndroidSqlLexer.getValidName(oldName), AndroidSqlLexer.getValidName(newName2));
    }

    @NotNull
    private static String getCreateTableStatement(@NotNull String tableName, @NotNull EntityBundle entity) {
        if (entity instanceof FtsEntityBundle) {
            return SqlStatementsGenerator.getCreateTableStatementFromEntityBundle(tableName, entity);
        }
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder(String.format("CREATE TABLE %s\n(\n", tableName));
        for (FieldBundle field2 : entity.getFields()) {
            statement.append(String.format("\t%s,\n", SqlStatementsGenerator.getColumnDescription(field2)));
            if (!SqlStatementsGenerator.shouldAddAutoIncrementToColumn(field2, entity.getPrimaryKey())) continue;
            statement.replace(statement.length() - 2, statement.length(), "");
            statement.append(" PRIMARY KEY AUTOINCREMENT,\n");
        }
        if (!entity.getPrimaryKey().isAutoGenerate()) {
            statement.append(String.format("\t%s,\n", SqlStatementsGenerator.getPrimaryKeyConstraint(entity.getPrimaryKey())));
        }
        if (entity.getForeignKeys() != null) {
            for (ForeignKeyBundle foreignKey : entity.getForeignKeys()) {
                statement.append(String.format("\t%s,\n", SqlStatementsGenerator.getForeignKeyConstraint(foreignKey)));
            }
        }
        statement.replace(statement.length() - 2, statement.length() - 1, "");
        statement.append(");");
        return statement.toString();
    }

    @NotNull
    private static String getCreateTableStatementFromEntityBundle(@NotNull String tableName, @NotNull EntityBundle entity) {
        Object statement = entity.getCreateSql().replace("${TABLE_NAME}", tableName);
        if (!((String)statement).trim().endsWith(";")) {
            statement = (String)statement + ";";
        }
        return statement;
    }

    @NotNull
    private static String getDropTableStatement(@NotNull String tableName) {
        tableName = AndroidSqlLexer.getValidName(tableName);
        return String.format("DROP TABLE %s;", tableName);
    }

    @NotNull
    private static String getAddColumnStatement(@NotNull String tableName, @NotNull FieldBundle field2) {
        tableName = AndroidSqlLexer.getValidName(tableName);
        return String.format("ALTER TABLE %s ADD COLUMN %s;", tableName, SqlStatementsGenerator.getColumnDescription(field2));
    }

    private static String getRenameColumnStatement(@NotNull String tableName, @NotNull String oldColumnName, @NotNull String newColumnName) {
        tableName = AndroidSqlLexer.getValidName(tableName);
        oldColumnName = AndroidSqlLexer.getValidName(oldColumnName);
        newColumnName = AndroidSqlLexer.getValidName(newColumnName);
        return String.format("ALTER TABLE %s RENAME COLUMN %s TO %s;", tableName, oldColumnName, newColumnName);
    }

    @NotNull
    private static String getColumnDescription(@NotNull FieldBundle field2) {
        StringBuilder fieldDescription = new StringBuilder(String.format("%s %s", AndroidSqlLexer.getValidName(field2.getColumnName()), field2.getAffinity()));
        if (field2.getDefaultValue() != null) {
            fieldDescription.append(String.format(" DEFAULT %s", SqlStatementsGenerator.toSqlStringLiteral(field2.getDefaultValue())));
        }
        if (field2.isNonNull()) {
            fieldDescription.append(" NOT NULL");
        }
        return fieldDescription.toString();
    }

    @NotNull
    private static String getPrimaryKeyConstraint(@NotNull PrimaryKeyBundle primaryKey) {
        return String.format("PRIMARY KEY (%s)", SqlStatementsGenerator.getColumnEnumeration(primaryKey.getColumnNames()));
    }

    @NotNull
    private static String getForeignKeyConstraint(@NotNull ForeignKeyBundle foreignKey) {
        String onUpdate = foreignKey.getOnUpdate() != null && !foreignKey.getOnUpdate().isEmpty() ? String.format(" ON UPDATE %s", foreignKey.getOnUpdate()) : "";
        String onDelete = foreignKey.getOnDelete() != null && !foreignKey.getOnDelete().isEmpty() ? String.format(" ON DELETE %s", foreignKey.getOnDelete()) : "";
        return String.format("FOREIGN KEY (%s) REFERENCES %s (%s)%s%s", SqlStatementsGenerator.getColumnEnumeration(foreignKey.getColumns()), AndroidSqlLexer.getValidName(foreignKey.getTable()), SqlStatementsGenerator.getColumnEnumeration(foreignKey.getReferencedColumns()), onUpdate, onDelete);
    }

    private static String getForeignKeyConstraintCheck(@NotNull String tableName) {
        return String.format("PRAGMA foreign_key_check(%s);", AndroidSqlLexer.getValidName(tableName));
    }

    @NotNull
    private static String getCreateIndexStatement(@NotNull IndexBundle index2, @NotNull String tableName) {
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder("CREATE ");
        if (index2.isUnique()) {
            statement.append("UNIQUE ");
        }
        statement.append(String.format("INDEX %s ON %s (%s);", AndroidSqlLexer.getValidName(index2.getName()), tableName, SqlStatementsGenerator.getColumnEnumeration(index2.getColumnNames())));
        return statement.toString();
    }

    @NotNull
    private static String getDropIndexStatement(@NotNull IndexBundle index2) {
        return String.format("DROP INDEX %s;", AndroidSqlLexer.getValidName(index2.getName()));
    }

    @NotNull
    private static String getUpdateColumnsValuesStatement(@NotNull String tableName, @NotNull Map<FieldBundle, String> newFieldsValues) {
        tableName = AndroidSqlLexer.getValidName(tableName);
        StringBuilder statement = new StringBuilder(String.format("UPDATE %s\nSET", tableName));
        String valueAssignments = newFieldsValues.keySet().stream().map(fieldBundle -> String.format("\t%s = %s", fieldBundle.getColumnName(), SqlStatementsGenerator.toSqlStringLiteral((String)newFieldsValues.get(fieldBundle)))).collect(Collectors.joining(",\n"));
        statement.append(valueAssignments);
        statement.append(";");
        return statement.toString();
    }

    @NotNull
    private static String getCreateViewStatement(@NotNull DatabaseViewBundle view) {
        Object statement = view.getCreateSql().replace("${VIEW_NAME}", AndroidSqlLexer.getValidName(view.getViewName()));
        if (!((String)statement).trim().endsWith(";")) {
            statement = (String)statement + ";";
        }
        return statement;
    }

    @NotNull
    private static String getDropViewStatement(@NotNull DatabaseViewBundle view) {
        return String.format("DROP VIEW %s;", AndroidSqlLexer.getValidName(view.getViewName()));
    }

    @NotNull
    private static String getColumnEnumeration(@NotNull List<String> columnNames) {
        return columnNames.stream().map(c -> AndroidSqlLexer.getValidName(c)).collect(Collectors.joining(", "));
    }

    @NotNull
    private static String toSqlStringLiteral(@NotNull String value2) {
        if (value2.contains("'")) {
            value2 = value2.replaceAll("'", "''");
        }
        return String.format("'%s'", value2);
    }

    private static boolean shouldAddAutoIncrementToColumn(@NotNull FieldBundle field2, @NotNull PrimaryKeyBundle primaryKey) {
        return primaryKey.isAutoGenerate() && field2.getAffinity().toLowerCase(Locale.US).equals("integer") && primaryKey.getColumnNames().size() == 1 && primaryKey.getColumnNames().get(0).equals(field2.getColumnName());
    }

    @NotNull
    private static String getDataSourceForComplexUpdate(@NotNull EntityUpdate entityUpdate) {
        EntityBundle newState = entityUpdate.getNewState();
        if (entityUpdate.shouldCreateAnFtsEntity() && SchemaDiffUtil.ftsTableNeedsExternalContentSource((FtsEntityBundle)newState)) {
            return ((FtsEntityBundle)newState).getFtsOptions().getContentTable();
        }
        if (entityUpdate.shouldRenameTable()) {
            return entityUpdate.getOldTableName();
        }
        return entityUpdate.getNewTableName();
    }

    @Nullable
    private static String getValueForField(@NotNull FieldBundle field2, @NotNull EntityUpdate entityUpdate) {
        FtsOptionsBundle ftsOptions;
        String userSpecifiedValue = entityUpdate.getValuesForUninitializedFields().get(field2);
        if (userSpecifiedValue != null) {
            return SqlStatementsGenerator.toSqlStringLiteral(userSpecifiedValue);
        }
        if (entityUpdate.shouldCreateAnFtsEntity() && (ftsOptions = ((FtsEntityBundle)entityUpdate.getNewState()).getFtsOptions()) != null && ftsOptions.getContentTable() != null && !ftsOptions.getContentTable().isEmpty()) {
            return AndroidSqlLexer.getValidName(field2.getColumnName());
        }
        String oldColumnName = entityUpdate.getRenamedFields().get(field2);
        if (oldColumnName != null) {
            return AndroidSqlLexer.getValidName(oldColumnName);
        }
        String columnName = field2.getColumnName();
        if (entityUpdate.getUnmodifiedFields().get(columnName) != null || entityUpdate.getModifiedFields().get(columnName) != null) {
            return AndroidSqlLexer.getValidName(columnName);
        }
        return null;
    }

    @NotNull
    private static Map<String, String> getColumnNameToColumnValueMapping(@NotNull EntityUpdate entityUpdate) {
        LinkedHashMap<String, String> columnNameToColumnValue = new LinkedHashMap<String, String>();
        for (FieldBundle field2 : entityUpdate.getAllFields()) {
            String value2 = SqlStatementsGenerator.getValueForField(field2, entityUpdate);
            if (value2 == null) {
                if (!SqlStatementsGenerator.columnNeedsUserSpecifiedValue(field2)) continue;
                throw new InvalidDataException("NOT NULL column without default value or user specified value.");
            }
            columnNameToColumnValue.put(AndroidSqlLexer.getValidName(field2.getColumnName()), value2);
        }
        return columnNameToColumnValue;
    }

    private static boolean columnNeedsUserSpecifiedValue(@NotNull FieldBundle field2) {
        return field2.isNonNull() && (field2.getDefaultValue() == null || field2.getDefaultValue().isEmpty());
    }
}

