/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public interface MigrationTestGenerator {
    public static final String RULE_ANNOTATION_QUALIFIED_NAME = "org.junit.Rule";
    public static final String TEST_ANNOTATION_QUALIFIED_NAME = "org.junit.Test";
    public static final String RUN_WITH_ANNOTATION_QUALIFIED_NAME = "org.junit.runner.RunWith";
    public static final String OLD_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME = "androidx.test.runner.AndroidJUnit4";
    public static final String NEW_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME = "androidx.test.ext.junit.runners.AndroidJUnit4";
    public static final String IO_EXCEPTION_QUALIFIED_NAME = "java.io.IOException";
    public static final String ASSERT_QUALIFIED_NAME = "org.junit.Assert";
    public static final String MIGRATION_TEST_HELPER_QUALIFIED_NAME = "androidx.room.testing.MigrationTestHelper";
    public static final String FRAMEWORK_SQLITE_OPEN_FACTORY_HELPER_QUALIFIED_NAME = "androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory";
    public static final String INSTRUMENTATION_REGISTRY_QUALIFIED_NAME_QUALIFIED_NAME = "androidx.test.platform.app.InstrumentationRegistry";
    public static final String SUPPORT_SQLITE_DATABASE_QUALIFIED_NAME = "androidx.sqlite.db.SupportSQLiteDatabase";
    public static final String MIGRATION_TEST_HELPER_FIELD_NAME = "migrationTestHelper";
    public static final String EXEC_SQL_STATEMENT = "db.execSQL(\"INSERT INTO table_name (column_name) VALUES (value);\")";
    public static final String CLOSE_STATEMENT = "db.close()";
    public static final String ASSERT_STATEMENT = "%s.fail(\"TODO: Verify data after migration is correct\")";
    public static final String EXEC_SQL_COMMENT = "// TODO: Insert data in the test database using SQL queries.";
    public static final String CLOSE_COMMENT = "// Prepare for the next version.";
    public static final String ASSERT_COMMENT = "// MigrationTestHelper automatically verifies the schema changes, but you need to validate that the data was migrated properly.";

    public void createMigrationTest(@NotNull PsiPackage var1, @NotNull PsiDirectory var2, @NotNull String var3, @NotNull String var4, int var5, int var6);

    @NotNull
    public static String getMigrationTestName(int migrationStartVersion, int migrationEndVersion) {
        return String.format(Locale.US, "Migration_%d_%d_Test", migrationStartVersion, migrationEndVersion);
    }

    @NotNull
    public static String getMigrationTestMethodName(int migrationStartVersion, int migrationEndVersion) {
        return String.format(Locale.US, "testMigrate%dTo%d", migrationStartVersion, migrationEndVersion);
    }

    public static String getTestDatabaseFieldName(@NotNull String databaseName) {
        return String.format("TEST_%s", CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, databaseName));
    }

    @NotNull
    public static String getTestDatabaseName(@NotNull String databaseName) {
        return String.format("\"test-%s\"", CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, databaseName));
    }

    @NotNull
    public static String selectRunnerClass(@NotNull JavaPsiFacade javaPsiFacade, @NotNull GlobalSearchScope migrationTestResolveScope) {
        String runnerQualifiedName;
        try {
            PsiClass runnerClass = (PsiClass)MoreObjects.firstNonNull((Object)javaPsiFacade.findClass(NEW_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME, migrationTestResolveScope), (Object)javaPsiFacade.findClass(OLD_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME, migrationTestResolveScope));
            runnerQualifiedName = runnerClass.getQualifiedName();
        }
        catch (Exception e) {
            runnerQualifiedName = NEW_ANDROID_JUNIT4_RUNNER_QUALIFIED_NAME;
        }
        if (!1.$assertionsDisabled && runnerQualifiedName == null) {
            throw new AssertionError();
        }
        return runnerQualifiedName;
    }

    @NotNull
    public static String getInstrumentationParameter(@NotNull CodeType codeType) {
        String instrumentationRegistry = codeType == CodeType.JAVA_CODE ? INSTRUMENTATION_REGISTRY_QUALIFIED_NAME_QUALIFIED_NAME : StringUtil.getShortName((String)INSTRUMENTATION_REGISTRY_QUALIFIED_NAME_QUALIFIED_NAME);
        return String.format("%s.getInstrumentation()", instrumentationRegistry);
    }

    @NotNull
    public static String getDatabaseCanonicalNameParameter(@NotNull CodeType codeType, @NotNull String databaseClassQualifiedName) {
        if (codeType == CodeType.JAVA_CODE) {
            return String.format("%s.class.getCanonicalName()", databaseClassQualifiedName);
        }
        return String.format("%s::class.java.canonicalName", StringUtil.getShortName((String)databaseClassQualifiedName));
    }

    @NotNull
    public static String getFrameworkSqliteOpenFactoryHelperParameter(@NotNull CodeType codeType) {
        if (codeType == CodeType.JAVA_CODE) {
            return String.format("new %s()", FRAMEWORK_SQLITE_OPEN_FACTORY_HELPER_QUALIFIED_NAME);
        }
        return String.format("%s()", StringUtil.getShortName((String)FRAMEWORK_SQLITE_OPEN_FACTORY_HELPER_QUALIFIED_NAME));
    }

    @NotNull
    public static String getHelperInitializationExpression(@NotNull CodeType codeType, @NotNull String databaseClassQualifiedName) {
        if (codeType == CodeType.JAVA_CODE) {
            return String.format("%s = new %s(\n%s,\n %s,\n %s);", MIGRATION_TEST_HELPER_FIELD_NAME, MIGRATION_TEST_HELPER_QUALIFIED_NAME, MigrationTestGenerator.getInstrumentationParameter(codeType), MigrationTestGenerator.getDatabaseCanonicalNameParameter(codeType, databaseClassQualifiedName), MigrationTestGenerator.getFrameworkSqliteOpenFactoryHelperParameter(codeType));
        }
        return String.format("val %s: MigrationTestHelper = MigrationTestHelper(\n%s,\n %s,\n %s)", MIGRATION_TEST_HELPER_FIELD_NAME, MigrationTestGenerator.getInstrumentationParameter(codeType), MigrationTestGenerator.getDatabaseCanonicalNameParameter(codeType, databaseClassQualifiedName), MigrationTestGenerator.getFrameworkSqliteOpenFactoryHelperParameter(codeType));
    }

    @NotNull
    public static String getCreateDatabaseStatement(@NotNull CodeType codeType, @NotNull String databaseName, int databaseVersion) {
        String createDatabaseStatementTemplate = codeType == CodeType.JAVA_CODE ? "androidx.sqlite.db.SupportSQLiteDatabase db = %s.createDatabase(%s, %d);" : "var db = %s.createDatabase(%s, %d)";
        return String.format(Locale.US, createDatabaseStatementTemplate, MIGRATION_TEST_HELPER_FIELD_NAME, MigrationTestGenerator.getTestDatabaseFieldName(databaseName), databaseVersion);
    }

    @NotNull
    public static String getCreateDatabaseComment(int databaseVersion) {
        return String.format(Locale.US, "// Create database with schema version %d.", databaseVersion);
    }

    @NotNull
    public static String getExecSqlStatement(@NotNull CodeType codeType) {
        if (codeType == CodeType.JAVA_CODE) {
            return "db.execSQL(\"INSERT INTO table_name (column_name) VALUES (value);\");";
        }
        return EXEC_SQL_STATEMENT;
    }

    @NotNull
    public static String getCloseStatement(@NotNull CodeType codeType) {
        if (codeType == CodeType.JAVA_CODE) {
            return "db.close();";
        }
        return CLOSE_STATEMENT;
    }

    @NotNull
    public static String getRunAndValidateMigrationStatement(@NotNull CodeType codeType, @NotNull String databaseName, @NotNull String migrationQualifiedName, int databaseVersion) {
        if (codeType == CodeType.JAVA_CODE) {
            return String.format(Locale.US, "db = %s.runMigrationsAndValidate(%s, %d, true, new %s());", MIGRATION_TEST_HELPER_FIELD_NAME, MigrationTestGenerator.getTestDatabaseFieldName(databaseName), databaseVersion, migrationQualifiedName);
        }
        return String.format(Locale.US, "db = %s.runMigrationsAndValidate(%s, %d, true, %s())", MIGRATION_TEST_HELPER_FIELD_NAME, MigrationTestGenerator.getTestDatabaseFieldName(databaseName), databaseVersion, StringUtil.getShortName((String)migrationQualifiedName));
    }

    @NotNull
    public static String getRunAndValidateMigrationComment(@NotNull String migrationName, int databaseVersion) {
        return String.format(Locale.US, "// Re-open the database with version %d and provide %s as the migration process.", databaseVersion, migrationName);
    }

    @NotNull
    public static String getAssertStatement(@NotNull CodeType codeType) {
        if (codeType == CodeType.JAVA_CODE) {
            return String.format(ASSERT_STATEMENT, ASSERT_QUALIFIED_NAME) + ";";
        }
        return String.format(ASSERT_STATEMENT, StringUtil.getShortName((String)ASSERT_QUALIFIED_NAME));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum CodeType {
        JAVA_CODE,
        KOTLIN_CODE;

    }
}

