/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.retention.actions;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.emulator.control.SnapshotPackage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdLaunchListener;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.emulatorcommand.EmulatorCommandBuilder;
import com.android.tools.idea.avdmanager.emulatorcommand.EmulatorCommandBuilderFactory;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.io.grpc.stub.ClientCallStreamObserver;
import com.android.tools.idea.io.grpc.stub.ClientResponseObserver;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.retention.actions.FindEmulatorAndSetupRetention;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.testartifacts.instrumented.RetentionConstantsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.actions.AndroidConnectDebuggerAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0007\u001a\u001a\u0010\u001e\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020\u000bH\u0002\u001a\u0014\u0010 \u001a\u00020\u0015*\u00020!2\u0006\u0010\"\u001a\u00020\u000bH\u0003\u001a\u0014\u0010#\u001a\u00020\u0015*\u00020!2\u0006\u0010\"\u001a\u00020\u000bH\u0003\u001a$\u0010$\u001a\u00020\u0015*\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0003\u001a$\u0010)\u001a\u00020\u0015*\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"CLIENTS_READY_FRACTION", "", "DEBUGGER_CONNECTED_FRACTION", "DEBUGGER_PAUSED_FRACTION", "LOAD_SNAPSHOT_FRACTION", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "NOTIFICATION_GROUP_NAME", "", "PUSH_SNAPSHOT_FRACTION", "bootEmulator", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/ddmlib/IDevice;", "project", "Lcom/intellij/openapi/project/Project;", "avdInfo", "Lcom/android/sdklib/internal/avd/AvdInfo;", "isManagedDevice", "", "parameters", "", "connectDebugger", "", "device", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "filterEmulatorBootParameters", "showErrorMessage", "message", "deleteSnapshotSync", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "snapshotId", "loadSnapshotSync", "pushAndLoadAndDeleteSync", "snapshotFile", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "pushSnapshotSync", "intellij.android.testRetention"})
@SourceDebugExtension(value={"SMAP\nFindEmulatorAndSetupRetention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindEmulatorAndSetupRetention.kt\ncom/android/tools/idea/retention/actions/FindEmulatorAndSetupRetentionKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,554:1\n10#2:555\n*S KotlinDebug\n*F\n+ 1 FindEmulatorAndSetupRetention.kt\ncom/android/tools/idea/retention/actions/FindEmulatorAndSetupRetentionKt\n*L\n548#1:555\n*E\n"})
public final class FindEmulatorAndSetupRetentionKt {
    private static final double PUSH_SNAPSHOT_FRACTION = 0.6;
    private static final double LOAD_SNAPSHOT_FRACTION = 0.7;
    private static final double CLIENTS_READY_FRACTION = 0.8;
    private static final double DEBUGGER_CONNECTED_FRACTION = 0.9;
    private static final double DEBUGGER_PAUSED_FRACTION = 0.95;
    @NotNull
    private static final String NOTIFICATION_GROUP_NAME = "Retention Snapshot Load";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final NotificationGroup NOTIFICATION_GROUP;

    private static final ListenableFuture<IDevice> bootEmulator(Project project, AvdInfo avdInfo, boolean isManagedDevice, List<String> parameters2) {
        AvdManagerConnection avdManagerConnection = isManagedDevice ? AvdManagerConnection.getDefaultGradleAvdManagerConnection() : AvdManagerConnection.getDefaultAvdManagerConnection();
        Intrinsics.checkNotNullExpressionValue((Object)avdManagerConnection, (String)"if (isManagedDevice) {\n \u2026vdManagerConnection()\n  }");
        AvdManagerConnection avdManagerConnection2 = avdManagerConnection;
        ListenableFuture<IDevice> listenableFuture = avdManagerConnection2.startAvd(project, avdInfo, AvdLaunchListener.RequestType.INDIRECT, new EmulatorCommandBuilderFactory(parameters2){
            final /* synthetic */ List<String> $parameters;
            {
                this.$parameters = $parameters;
            }

            @NotNull
            public final EmulatorCommandBuilder newEmulatorCommandBuilder(@NotNull Path emulator, @NotNull AvdInfo avd) {
                Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
                Intrinsics.checkNotNullParameter((Object)avd, (String)"avd");
                return new EmulatorCommandBuilder(emulator, avd).addAllStudioEmuParams((Collection<String>)FindEmulatorAndSetupRetentionKt.filterEmulatorBootParameters(this.$parameters));
            }
        });
        Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"parameters: List<String>\u2026rameters(parameters))\n  }");
        return listenableFuture;
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @NotNull
    public static final List<String> filterEmulatorBootParameters(@NotNull List<String> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        filtered = new ArrayList<E>();
        if (parameters.isEmpty()) {
            return filtered;
        }
        iterator = parameters.iterator();
        iterator.next();
        block8: while (iterator.hasNext()) {
            parameter = iterator.next();
            switch (parameter.hashCode()) {
                case -1624306786: {
                    if (parameter.equals("-qt-hide-window")) continue block8;
                    break;
                }
                case 1564544307: {
                    if (!parameter.equals("-netdelay")) {
                        break;
                    }
                    ** GOTO lbl31
                }
                case 1437570: {
                    if (!parameter.equals("-avd")) {
                        break;
                    }
                    ** GOTO lbl31
                }
                case 1133689726: {
                    if (!parameter.equals("-idle-grpc-timeout")) {
                        break;
                    }
                    ** GOTO lbl31
                }
                case 1692213425: {
                    if (parameter.equals("-grpc-use-token")) continue block8;
                    break;
                }
                case 1578718199: {
                    if (!parameter.equals("-netspeed")) break;
lbl31:
                    // 4 sources

                    iterator.next();
                    continue block8;
                }
            }
            if (StringsKt.startsWith$default((String)parameter, (String)"@", (boolean)false, (int)2, null)) continue;
            filtered.add(parameter);
        }
        return CollectionsKt.toList((Iterable)filtered);
    }

    @Slow
    private static final void connectDebugger(IDevice device2, DataContext dataContext) {
        Object object;
        Project project;
        Client client2;
        block4: {
            String packageName2 = (String)dataContext.getData(RetentionConstantsKt.PACKAGE_NAME_KEY);
            client2 = device2.getClient(packageName2);
            if (client2 == null) {
                LOG.warn("Cannot connect to " + packageName2);
                return;
            }
            Project project2 = (Project)dataContext.getData(CommonDataKeys.PROJECT);
            if (project2 == null) {
                return;
            }
            project = project2;
            Object[] objectArray = AndroidDebugger.EP_NAME.getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"EP_NAME.extensions");
            for (Object object2 : objectArray) {
                AndroidDebugger it = (AndroidDebugger)object2;
                boolean bl = false;
                if (!(it.supportsProject(project) && Intrinsics.areEqual((Object)it.getId(), (Object)"Java"))) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        AndroidDebugger androidDebugger = (AndroidDebugger)object;
        if (androidDebugger == null) {
            LOG.warn("Cannot find java debuggers.");
            return;
        }
        AndroidConnectDebuggerAction.closeOldSessionAndRun(project, androidDebugger, client2, null);
    }

    @Slow
    private static final boolean pushAndLoadAndDeleteSync(EmulatorController $this$pushAndLoadAndDeleteSync, String snapshotId, File snapshotFile, ProgressIndicator indicator) {
        return FindEmulatorAndSetupRetentionKt.pushSnapshotSync($this$pushAndLoadAndDeleteSync, snapshotId, snapshotFile, indicator) && FindEmulatorAndSetupRetentionKt.loadSnapshotSync($this$pushAndLoadAndDeleteSync, snapshotId) && FindEmulatorAndSetupRetentionKt.deleteSnapshotSync($this$pushAndLoadAndDeleteSync, snapshotId);
    }

    @Slow
    private static final boolean loadSnapshotSync(EmulatorController $this$loadSnapshotSync, String snapshotId) {
        CountDownLatch doneSignal = new CountDownLatch(1);
        Ref.BooleanRef succeeded = new Ref.BooleanRef();
        succeeded.element = true;
        $this$loadSnapshotSync.loadSnapshot(snapshotId, (StreamObserver<SnapshotPackage>)((StreamObserver)new StreamObserver<SnapshotPackage>(succeeded, doneSignal){
            final /* synthetic */ Ref.BooleanRef $succeeded;
            final /* synthetic */ CountDownLatch $doneSignal;
            {
                this.$succeeded = $succeeded;
                this.$doneSignal = $doneSignal;
            }

            public void onNext(@NotNull SnapshotPackage response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.getSuccess()) {
                    this.$succeeded.element = false;
                    FindEmulatorAndSetupRetentionKt.access$showErrorMessage(null, "Snapshot load failed: " + response2.getErr().toString(Charset.defaultCharset()));
                }
            }

            public void onCompleted() {
                this.$doneSignal.countDown();
            }

            public void onError(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$succeeded.element = false;
                this.$doneSignal.countDown();
            }
        }));
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)doneSignal);
        return succeeded.element;
    }

    @Slow
    private static final boolean deleteSnapshotSync(EmulatorController $this$deleteSnapshotSync, String snapshotId) {
        CountDownLatch doneSignal = new CountDownLatch(1);
        Ref.BooleanRef succeeded = new Ref.BooleanRef();
        succeeded.element = true;
        $this$deleteSnapshotSync.deleteSnapshot(snapshotId, (StreamObserver<SnapshotPackage>)((StreamObserver)new StreamObserver<SnapshotPackage>(succeeded, doneSignal){
            final /* synthetic */ Ref.BooleanRef $succeeded;
            final /* synthetic */ CountDownLatch $doneSignal;
            {
                this.$succeeded = $succeeded;
                this.$doneSignal = $doneSignal;
            }

            public void onNext(@NotNull SnapshotPackage response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.getSuccess()) {
                    this.$succeeded.element = false;
                    FindEmulatorAndSetupRetentionKt.access$showErrorMessage(null, "Snapshot load failed: " + response2.getErr().toString(Charset.defaultCharset()));
                }
            }

            public void onCompleted() {
                this.$doneSignal.countDown();
            }

            public void onError(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$succeeded.element = false;
                this.$doneSignal.countDown();
            }
        }));
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)doneSignal);
        return succeeded.element;
    }

    @Slow
    private static final boolean pushSnapshotSync(EmulatorController $this$pushSnapshotSync, String snapshotId, File snapshotFile, ProgressIndicator indicator) throws IOException {
        SnapshotPackage.Format format;
        if (snapshotFile.isDirectory()) {
            format = SnapshotPackage.Format.DIRECTORY;
        } else {
            String string = FilesKt.getExtension((File)snapshotFile).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            format = Intrinsics.areEqual((Object)string, (Object)"gz") ? SnapshotPackage.Format.TARGZ : SnapshotPackage.Format.TAR;
        }
        SnapshotPackage.Format format2 = format;
        FileInputStream snapshotFileStream = format2 == SnapshotPackage.Format.DIRECTORY ? null : new FileInputStream(snapshotFile);
        long fileSize = format2 == SnapshotPackage.Format.DIRECTORY ? 0L : snapshotFile.length();
        Ref.LongRef totalBytesSent = new Ref.LongRef();
        Ref.BooleanRef succeeded = new Ref.BooleanRef();
        succeeded.element = true;
        CountDownLatch doneSignal = new CountDownLatch(1);
        $this$pushSnapshotSync.pushSnapshot((ClientResponseObserver<SnapshotPackage, SnapshotPackage>)((ClientResponseObserver)new ClientResponseObserver<SnapshotPackage, SnapshotPackage>(snapshotFileStream, doneSignal, succeeded, snapshotId, format2, snapshotFile, totalBytesSent, indicator, fileSize){
            final /* synthetic */ FileInputStream $snapshotFileStream;
            final /* synthetic */ CountDownLatch $doneSignal;
            final /* synthetic */ Ref.BooleanRef $succeeded;
            final /* synthetic */ String $snapshotId;
            final /* synthetic */ SnapshotPackage.Format $format;
            final /* synthetic */ File $snapshotFile;
            final /* synthetic */ Ref.LongRef $totalBytesSent;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ long $fileSize;
            {
                this.$snapshotFileStream = $snapshotFileStream;
                this.$doneSignal = $doneSignal;
                this.$succeeded = $succeeded;
                this.$snapshotId = $snapshotId;
                this.$format = $format;
                this.$snapshotFile = $snapshotFile;
                this.$totalBytesSent = $totalBytesSent;
                this.$indicator = $indicator;
                this.$fileSize = $fileSize;
            }

            public void onCompleted() {
                FileInputStream fileInputStream = this.$snapshotFileStream;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                this.$doneSignal.countDown();
            }

            public void onError(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$succeeded.element = false;
                FileInputStream fileInputStream = this.$snapshotFileStream;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                this.$doneSignal.countDown();
            }

            public void beforeStart(@NotNull ClientCallStreamObserver<SnapshotPackage> clientCallStreamObserver) {
                Intrinsics.checkNotNullParameter(clientCallStreamObserver, (String)"clientCallStreamObserver");
                Ref.BooleanRef snapshotIdSent = new Ref.BooleanRef();
                Ref.BooleanRef completionRequested = new Ref.BooleanRef();
                byte[] bytes2 = new byte[0x200000];
                clientCallStreamObserver.setOnReadyHandler(new Runnable(clientCallStreamObserver, snapshotIdSent, this.$snapshotId, this.$format, this.$snapshotFile, this.$snapshotFileStream, bytes2, this.$totalBytesSent, this.$indicator, this.$fileSize, completionRequested){
                    final /* synthetic */ ClientCallStreamObserver<SnapshotPackage> $clientCallStreamObserver;
                    final /* synthetic */ Ref.BooleanRef $snapshotIdSent;
                    final /* synthetic */ String $snapshotId;
                    final /* synthetic */ SnapshotPackage.Format $format;
                    final /* synthetic */ File $snapshotFile;
                    final /* synthetic */ FileInputStream $snapshotFileStream;
                    final /* synthetic */ byte[] $bytes;
                    final /* synthetic */ Ref.LongRef $totalBytesSent;
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ long $fileSize;
                    final /* synthetic */ Ref.BooleanRef $completionRequested;
                    {
                        this.$clientCallStreamObserver = $clientCallStreamObserver;
                        this.$snapshotIdSent = $snapshotIdSent;
                        this.$snapshotId = $snapshotId;
                        this.$format = $format;
                        this.$snapshotFile = $snapshotFile;
                        this.$snapshotFileStream = $snapshotFileStream;
                        this.$bytes = $bytes;
                        this.$totalBytesSent = $totalBytesSent;
                        this.$indicator = $indicator;
                        this.$fileSize = $fileSize;
                        this.$completionRequested = $completionRequested;
                    }

                    public final void run() {
                        if (!this.$clientCallStreamObserver.isReady()) {
                            return;
                        }
                        if (!this.$snapshotIdSent.element) {
                            this.$clientCallStreamObserver.onNext((Object)SnapshotPackage.newBuilder().setSnapshotId(this.$snapshotId).setFormat(this.$format).setPath(this.$snapshotFile.getAbsolutePath()).build());
                            this.$snapshotIdSent.element = true;
                        }
                        int bytesRead = 0;
                        while (this.$clientCallStreamObserver.isReady()) {
                            FileInputStream fileInputStream = this.$snapshotFileStream;
                            int n = bytesRead = fileInputStream != null ? fileInputStream.read(this.$bytes) : -1;
                            if (bytesRead <= 0) break;
                            this.$clientCallStreamObserver.onNext((Object)SnapshotPackage.newBuilder().setPayload(ByteString.copyFrom((byte[])this.$bytes, (int)0, (int)bytesRead)).build());
                            this.$totalBytesSent.element += (long)bytesRead;
                            this.$indicator.setFraction((double)this.$totalBytesSent.element / (double)this.$fileSize * 0.6);
                        }
                        if (bytesRead < 0 && !this.$completionRequested.element) {
                            this.$completionRequested.element = true;
                            this.$clientCallStreamObserver.onCompleted();
                        }
                    }
                });
            }

            public void onNext(@NotNull SnapshotPackage response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.getSuccess()) {
                    this.$succeeded.element = false;
                    FindEmulatorAndSetupRetentionKt.access$showErrorMessage(null, "Snapshot push failed: " + response2.getErr().toString(Charset.defaultCharset()));
                }
            }
        }));
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)doneSignal);
        return succeeded.element;
    }

    private static final void showErrorMessage(Project project, String message2) {
        NOTIFICATION_GROUP.createNotification(message2, NotificationType.ERROR).notify(project);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$showErrorMessage(Project project, String message2) {
        FindEmulatorAndSetupRetentionKt.showErrorMessage(project, message2);
    }

    public static final /* synthetic */ ListenableFuture access$bootEmulator(Project project, AvdInfo avdInfo, boolean isManagedDevice, List parameters2) {
        return FindEmulatorAndSetupRetentionKt.bootEmulator(project, avdInfo, isManagedDevice, parameters2);
    }

    public static final /* synthetic */ boolean access$pushAndLoadAndDeleteSync(EmulatorController $receiver, String snapshotId, File snapshotFile, ProgressIndicator indicator) {
        return FindEmulatorAndSetupRetentionKt.pushAndLoadAndDeleteSync($receiver, snapshotId, snapshotFile, indicator);
    }

    public static final /* synthetic */ void access$connectDebugger(IDevice device2, DataContext dataContext) {
        FindEmulatorAndSetupRetentionKt.connectDebugger(device2, dataContext);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(FindEmulatorAndSetupRetention.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        LOG = logger2;
        NOTIFICATION_GROUP = new NotificationGroup(NOTIFICATION_GROUP_NAME, NotificationDisplayType.BALLOON, false, null, null, 28, null);
    }
}

