/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.retention.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.retention.actions.FindEmulatorAndSetupRetention;
import com.android.tools.idea.retention.actions.FindEmulatorAndSetupRetentionKt;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.AvdManagerCache;
import com.android.tools.idea.sdk.IdeAvdManagers;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.RunningEmulatorCatalog;
import com.android.tools.idea.testartifacts.instrumented.RetentionConstantsKt;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/retention/actions/FindEmulatorAndSetupRetention;", "Lcom/intellij/openapi/actionSystem/AnAction;", "avdManagerCache", "Lcom/android/tools/idea/sdk/AvdManagerCache;", "(Lcom/android/tools/idea/sdk/AvdManagerCache;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.testRetention"})
public final class FindEmulatorAndSetupRetention
extends AnAction {
    @NotNull
    private final AvdManagerCache avdManagerCache;

    public FindEmulatorAndSetupRetention(@NotNull AvdManagerCache avdManagerCache) {
        Intrinsics.checkNotNullParameter((Object)avdManagerCache, (String)"avdManagerCache");
        this.avdManagerCache = avdManagerCache;
    }

    public /* synthetic */ FindEmulatorAndSetupRetention(AvdManagerCache avdManagerCache, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            avdManagerCache = (AvdManagerCache)IdeAvdManagers.INSTANCE;
        }
        this(avdManagerCache);
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        DataContext dataContext = event2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"event.dataContext");
        DataContext dataContext2 = dataContext;
        Project project = (Project)dataContext2.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, dataContext2, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ DataContext $dataContext;
            final /* synthetic */ FindEmulatorAndSetupRetention this$0;
            {
                this.$project = $project;
                this.$dataContext = $dataContext;
                this.this$0 = $receiver;
                super($project, "Loading retained test failure", true);
            }

            public void onFinished() {
                block0: {
                    Runnable runnable2 = (Runnable)this.$dataContext.getData(RetentionConstantsKt.RETENTION_ON_FINISH_KEY);
                    if (runnable2 == null) break block0;
                    runnable2.run();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Sequence sequence;
                Sequence sequence2;
                Object[] objectArray;
                Object v3;
                String deviceName;
                block27: {
                    AvdManager avdManager2;
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    indicator.setIndeterminate(false);
                    indicator.setFraction(0.0);
                    deviceName = (String)this.$dataContext.getData(RetentionConstantsKt.AVD_NAME_KEY);
                    Object object = this.$dataContext.getData(RetentionConstantsKt.IS_MANAGED_DEVICE);
                    Intrinsics.checkNotNull((Object)object);
                    boolean isManagedDevice = (Boolean)object;
                    RunningEmulatorCatalog catalog = RunningEmulatorCatalog.Companion.getInstance();
                    AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                    Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance().tryToChooseSdkHandler()");
                    AndroidSdkHandler androidSdkHandler2 = androidSdkHandler;
                    Path baseAvdFolder = isManagedDevice ? AndroidLocationsSingleton.INSTANCE.getGradleAvdLocation() : AndroidLocationsSingleton.INSTANCE.getAvdLocation();
                    AvdManager avdManager3 = avdManager2 = FindEmulatorAndSetupRetention.access$getAvdManagerCache$p(this.this$0).getAvdManager(androidSdkHandler2, baseAvdFolder);
                    AvdInfo avdInfo = avdManager3 != null ? avdManager3.getAvd(deviceName, true) : null;
                    try {
                        AndroidDebugBridge.init((boolean)true);
                    }
                    catch (IllegalStateException exp) {
                        FindEmulatorAndSetupRetentionKt.access$getLOG$p().debug("ADB already initialized: " + exp);
                    }
                    if (!AndroidDebugBridge.getClientSupport()) {
                        FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Adb client support required. Please try to reboot adb by running \"adb kill-server\"");
                        return;
                    }
                    if (avdInfo == null) {
                        FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Cannot find valid AVD with name: " + deviceName);
                        return;
                    }
                    if (!avdManager2.isAvdRunning(avdInfo)) {
                        List list2 = (List)this.$dataContext.getData(RetentionConstantsKt.EMULATOR_SNAPSHOT_LAUNCH_PARAMETERS);
                        ListenableFuture deviceFuture = FindEmulatorAndSetupRetentionKt.access$bootEmulator(this.$project, avdInfo, isManagedDevice, list2 == null ? CollectionsKt.emptyList() : list2);
                        IDevice device2 = (IDevice)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((Future)deviceFuture));
                        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable)new ThrowableComputable(device2){
                            final /* synthetic */ IDevice $device;
                            {
                                this.$device = $device;
                            }

                            public final Boolean compute() {
                                return this.$device.isOnline();
                            }
                        });
                    }
                    Set emulatorControllers = (Set)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((Future)catalog.updateNow()));
                    Intrinsics.checkNotNullExpressionValue((Object)emulatorControllers, (String)"emulatorControllers");
                    Iterable iterable = emulatorControllers;
                    for (T t : iterable) {
                        EmulatorController it = (EmulatorController)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getEmulatorId().getAvdId(), (Object)deviceName)) continue;
                        v3 = t;
                        break block27;
                    }
                    v3 = null;
                }
                EmulatorController emulatorController = v3;
                if (emulatorController == null) {
                    FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Failed to find or launch to AVD with device name: " + deviceName);
                    return;
                }
                if (emulatorController.getConnectionState() != EmulatorController.ConnectionState.CONNECTED) {
                    EmulatorController.connectGrpc$default(emulatorController, 0, 1, null);
                }
                String emulatorSerialString = "emulator-" + emulatorController.getEmulatorId().getSerialPort();
                String string = (String)this.$dataContext.getData(RetentionConstantsKt.EMULATOR_SNAPSHOT_ID_KEY);
                if (string == null) {
                    return;
                }
                String snapshotId = string;
                File file2 = (File)this.$dataContext.getData(RetentionConstantsKt.EMULATOR_SNAPSHOT_FILE_KEY);
                if (file2 == null) {
                    return;
                }
                File snapshotFile = file2;
                Boolean bl = (Boolean)this.$dataContext.getData(RetentionConstantsKt.RETENTION_AUTO_CONNECT_DEBUGGER_KEY);
                if (bl == null) {
                    bl = false;
                }
                boolean shouldAttachDebugger = bl;
                String string2 = (String)this.$dataContext.getData(RetentionConstantsKt.PACKAGE_NAME_KEY);
                if (string2 == null) {
                    return;
                }
                String packageName2 = string2;
                if (!shouldAttachDebugger) {
                    if (!FindEmulatorAndSetupRetentionKt.access$pushAndLoadAndDeleteSync(emulatorController, snapshotId, snapshotFile, indicator)) {
                        FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Failed to import snapshots. Please try to boot emulator (" + deviceName + ") with the same command line parameters as you run the test.");
                    }
                    return;
                }
                AndroidDebugBridge bl2 = AndroidDebugBridge.getBridge();
                if (bl2 != null && (objectArray = bl2.getDevices()) != null && (sequence2 = ArraysKt.asSequence((Object[])objectArray)) != null && (sequence = SequencesKt.filter((Sequence)sequence2, (Function1)((Function1)new Function1<IDevice, Boolean>(emulatorSerialString){
                    final /* synthetic */ String $emulatorSerialString;
                    {
                        this.$emulatorSerialString = $emulatorSerialString;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(IDevice it) {
                        return Intrinsics.areEqual((Object)it.getSerialNumber(), (Object)this.$emulatorSerialString);
                    }
                }))) != null) {
                    void $this$forEach$iv;
                    Sequence sequence3 = sequence;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        IDevice it = (IDevice)element$iv;
                        boolean bl3 = false;
                        Client client2 = it.getClient(packageName2);
                        if (client2 != null) {
                            client2.kill();
                        }
                    }
                }
                CountDownLatch deviceReadySignal = new CountDownLatch(1);
                AndroidDebugBridge.IDeviceChangeListener deviceChangeListener2 = new AndroidDebugBridge.IDeviceChangeListener(emulatorSerialString, deviceReadySignal){
                    final /* synthetic */ String $emulatorSerialString;
                    final /* synthetic */ CountDownLatch $deviceReadySignal;
                    {
                        this.$emulatorSerialString = $emulatorSerialString;
                        this.$deviceReadySignal = $deviceReadySignal;
                    }

                    public void deviceDisconnected(@NotNull IDevice device2) {
                        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                    }

                    public void deviceConnected(@NotNull IDevice device2) {
                        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                        if (Intrinsics.areEqual((Object)this.$emulatorSerialString, (Object)device2.getSerialNumber())) {
                            this.$deviceReadySignal.countDown();
                            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
                        }
                    }

                    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
                        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                        if (device2.isOnline() && Intrinsics.areEqual((Object)this.$emulatorSerialString, (Object)device2.getSerialNumber())) {
                            this.$deviceReadySignal.countDown();
                            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
                        }
                    }
                };
                AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceChangeListener2);
                try {
                    if (!FindEmulatorAndSetupRetentionKt.access$pushAndLoadAndDeleteSync(emulatorController, snapshotId, snapshotFile, indicator)) {
                        FindEmulatorAndSetupRetentionKt.access$showErrorMessage(this.$project, "Failed to import snapshots. Please try to boot emulator (" + deviceName + ") with the same command line parameters as you run the test.");
                        return;
                    }
                    indicator.setFraction(0.7);
                    FindEmulatorAndSetupRetentionKt.access$getLOG$p().info("Snapshot loaded.");
                    ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)deviceReadySignal);
                    FindEmulatorAndSetupRetentionKt.access$getLOG$p().info("Device ready.");
                }
                finally {
                    AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceChangeListener2);
                }
                Ref.ObjectRef targetDevice = new Ref.ObjectRef();
                AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
                if (androidDebugBridge == null) {
                    String $i$f$forEach = "Required value was null.";
                    throw new IllegalArgumentException($i$f$forEach.toString());
                }
                AndroidDebugBridge adb = androidDebugBridge;
                FindEmulatorAndSetupRetentionKt.access$getLOG$p().info("Checking client for " + packageName2 + ".");
                ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable)new ThrowableComputable((Ref.ObjectRef<IDevice>)targetDevice, adb, packageName2, emulatorSerialString){
                    final /* synthetic */ Ref.ObjectRef<IDevice> $targetDevice;
                    final /* synthetic */ AndroidDebugBridge $adb;
                    final /* synthetic */ String $packageName;
                    final /* synthetic */ String $emulatorSerialString;
                    {
                        this.$targetDevice = $targetDevice;
                        this.$adb = $adb;
                        this.$packageName = $packageName;
                        this.$emulatorSerialString = $emulatorSerialString;
                    }

                    public final Boolean compute() {
                        IDevice iDevice;
                        Object object;
                        block4: {
                            IDevice[] iDeviceArray = this.$adb.getDevices();
                            Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"adb.devices");
                            Object[] objectArray = iDeviceArray;
                            String string = this.$emulatorSerialString;
                            Ref.ObjectRef<IDevice> objectRef = this.$targetDevice;
                            for (Object object2 : objectArray) {
                                IDevice device2 = (IDevice)object2;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)device2.getSerialNumber(), (Object)string)) continue;
                                object = object2;
                                break block4;
                            }
                            object = null;
                        }
                        IDevice iDevice2 = (IDevice)object;
                        if (iDevice2 == null) {
                            return false;
                        }
                        objectRef.element = iDevice2;
                        DeploymentApplicationService deploymentApplicationService = DeploymentApplicationService.Companion.getInstance();
                        if (this.$targetDevice.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"targetDevice");
                            iDevice = null;
                        } else {
                            iDevice = (IDevice)this.$targetDevice.element;
                        }
                        return !((Collection)deploymentApplicationService.findClient(iDevice, this.$packageName)).isEmpty();
                    }
                });
                FindEmulatorAndSetupRetentionKt.access$getLOG$p().info("Client ready.");
                indicator.setFraction(0.8);
                CountDownLatch debugSessionReadySignal = new CountDownLatch(1);
                MessageBusConnection messageBusConnection = this.$project.getMessageBus().connect();
                Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
                MessageBusConnection messageBusConnection2 = messageBusConnection;
                try {
                    IDevice iDevice;
                    Topic topic = XDebuggerManager.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    messageBusConnection2.subscribe(topic, (Object)new XDebuggerManagerListener(messageBusConnection2, debugSessionReadySignal){
                        final /* synthetic */ MessageBusConnection $messageBusConnection;
                        final /* synthetic */ CountDownLatch $debugSessionReadySignal;
                        {
                            this.$messageBusConnection = $messageBusConnection;
                            this.$debugSessionReadySignal = $debugSessionReadySignal;
                        }

                        public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
                            if (currentSession != null) {
                                this.$messageBusConnection.disconnect();
                                this.$debugSessionReadySignal.countDown();
                            }
                        }
                    });
                    if (targetDevice.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"targetDevice");
                        iDevice = null;
                    } else {
                        iDevice = (IDevice)targetDevice.element;
                    }
                    FindEmulatorAndSetupRetentionKt.access$connectDebugger(iDevice, this.$dataContext);
                    ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)debugSessionReadySignal);
                    indicator.setFraction(0.9);
                }
                catch (Exception exception) {
                    messageBusConnection2.disconnect();
                    throw exception;
                }
                XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.getProject()).getCurrentSession();
                Intrinsics.checkNotNull((Object)xDebugSession);
                XDebugSession currentSession = xDebugSession;
                CountDownLatch pauseSignal = new CountDownLatch(1);
                currentSession.addSessionListener(new XDebugSessionListener(currentSession, pauseSignal){
                    final /* synthetic */ XDebugSession $currentSession;
                    final /* synthetic */ CountDownLatch $pauseSignal;
                    {
                        this.$currentSession = $currentSession;
                        this.$pauseSignal = $pauseSignal;
                    }

                    public void sessionPaused() {
                        this.$currentSession.removeSessionListener((XDebugSessionListener)this);
                        this.$pauseSignal.countDown();
                    }

                    public void settingsChanged() {
                        this.$currentSession.pause();
                    }
                });
                currentSession.pause();
                ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)pauseSignal);
                indicator.setFraction(0.95);
                CountDownLatch stackReadySignal = new CountDownLatch(1);
                AppUIUtil.invokeOnEdt((Runnable)new Runnable(currentSession){
                    final /* synthetic */ XDebugSession $currentSession;
                    {
                        this.$currentSession = $currentSession;
                    }

                    public final void run() {
                        RunnerLayoutUi $this$run_u24lambda_u240 = this.$currentSession.getUI();
                        boolean bl = false;
                        $this$run_u24lambda_u240.selectAndFocus($this$run_u24lambda_u240.findContent("FrameContent"), true, false);
                    }
                });
                currentSession.getSuspendContext().computeExecutionStacks(new XSuspendContext.XExecutionStackContainer(stackReadySignal, this.$project, currentSession){
                    private boolean foundUserFrame;
                    final /* synthetic */ CountDownLatch $stackReadySignal;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ XDebugSession $currentSession;
                    {
                        this.$stackReadySignal = $stackReadySignal;
                        this.$project = $project;
                        this.$currentSession = $currentSession;
                    }

                    public final boolean getFoundUserFrame() {
                        return this.foundUserFrame;
                    }

                    public final void setFoundUserFrame(boolean bl) {
                        this.foundUserFrame = bl;
                    }

                    public void errorOccurred(@NotNull String errorMessage) {
                        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                        this.$stackReadySignal.countDown();
                        FindEmulatorAndSetupRetentionKt.access$getLOG$p().warn(String.valueOf(errorMessage));
                    }

                    public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
                        Intrinsics.checkNotNullParameter(executionStacks, (String)"executionStacks");
                        if (this.foundUserFrame) {
                            return;
                        }
                        for (XExecutionStack xExecutionStack : executionStacks) {
                            xExecutionStack.computeStackFrames(0, new XExecutionStack.XStackFrameContainer(this.$stackReadySignal, this, this.$project, this.$currentSession, xExecutionStack){
                                final /* synthetic */ CountDownLatch $stackReadySignal;
                                final /* synthetic */ actionPerformed.run.8 this$0;
                                final /* synthetic */ Project $project;
                                final /* synthetic */ XDebugSession $currentSession;
                                final /* synthetic */ XExecutionStack $stack;
                                {
                                    this.$stackReadySignal = $stackReadySignal;
                                    this.this$0 = $receiver;
                                    this.$project = $project;
                                    this.$currentSession = $currentSession;
                                    this.$stack = $stack;
                                }

                                public void errorOccurred(@NotNull String errorMessage) {
                                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                                    this.$stackReadySignal.countDown();
                                    FindEmulatorAndSetupRetentionKt.access$getLOG$p().warn(String.valueOf(errorMessage));
                                }

                                public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
                                    Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
                                    if (this.this$0.getFoundUserFrame()) {
                                        return;
                                    }
                                    for (XStackFrame xStackFrame : stackFrames) {
                                        Navigatable navigatable;
                                        XSourcePosition xSourcePosition;
                                        boolean bl;
                                        Object object = xStackFrame.getSourcePosition();
                                        if (object != null && (object = object.getFile()) != null && (object = object.getCanonicalPath()) != null) {
                                            String string = this.$project.getBasePath();
                                            if (string == null) {
                                                string = "";
                                            }
                                            bl = StringsKt.startsWith$default((String)object, (String)string, (boolean)false, (int)2, null);
                                        } else {
                                            bl = false;
                                        }
                                        if (!bl || (xSourcePosition = xStackFrame.getSourcePosition()) == null || (navigatable = xSourcePosition.createNavigatable(this.$project)) == null) continue;
                                        Navigatable navigatable2 = navigatable;
                                        var var8_8 = this.this$0;
                                        XDebugSession xDebugSession = this.$currentSession;
                                        XExecutionStack xExecutionStack = this.$stack;
                                        CountDownLatch countDownLatch = this.$stackReadySignal;
                                        Navigatable it = navigatable2;
                                        boolean bl2 = false;
                                        AppUIUtil.invokeOnEdt((Runnable)new Runnable(xDebugSession, xExecutionStack, xStackFrame, countDownLatch){
                                            final /* synthetic */ XDebugSession $currentSession;
                                            final /* synthetic */ XExecutionStack $stack;
                                            final /* synthetic */ XStackFrame $frame;
                                            final /* synthetic */ CountDownLatch $stackReadySignal;
                                            {
                                                this.$currentSession = $currentSession;
                                                this.$stack = $stack;
                                                this.$frame = $frame;
                                                this.$stackReadySignal = $stackReadySignal;
                                            }

                                            public final void run() {
                                                this.$currentSession.setCurrentStackFrame(this.$stack, this.$frame);
                                                this.$stackReadySignal.countDown();
                                            }
                                        });
                                        var8_8.setFoundUserFrame(true);
                                        return;
                                    }
                                }
                            });
                        }
                        if (last && !this.foundUserFrame) {
                            this.$stackReadySignal.countDown();
                        }
                    }
                });
                ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)stackReadySignal);
                FindEmulatorAndSetupRetentionKt.access$getLOG$p().info("Ready for debugging.");
            }
        });
    }

    public void update(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        super.update(event2);
        String snapshotId = (String)event2.getDataContext().getData(RetentionConstantsKt.EMULATOR_SNAPSHOT_ID_KEY);
        File snapshotFile = (File)event2.getDataContext().getData(RetentionConstantsKt.EMULATOR_SNAPSHOT_FILE_KEY);
        event2.getPresentation().setEnabledAndVisible(snapshotId != null && snapshotFile != null);
    }

    public FindEmulatorAndSetupRetention() {
        this(null, 1, null);
    }

    public static final /* synthetic */ AvdManagerCache access$getAvdManagerCache$p(FindEmulatorAndSetupRetention $this) {
        return $this.avdManagerCache;
    }
}

