/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicFileResourceItem;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.tools.idea.res.FileTimeStampLengthHasher;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.utils.Base128OutputStream;
import com.intellij.openapi.vfs.VirtualFile;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsFileResourceItem
extends BasicFileResourceItem {
    @Nullable
    private final VirtualFile myVirtualFile;

    public VfsFileResourceItem(@NotNull ResourceType type, @NotNull String name2, @NotNull RepositoryConfiguration configuration, @NotNull ResourceVisibility visibility, @NotNull String relativePath) {
        this(type, name2, configuration, visibility, relativePath, ((ResourceFolderRepository)configuration.getRepository()).getResourceDir().findFileByRelativePath(relativePath));
    }

    public VfsFileResourceItem(@NotNull ResourceType type, @NotNull String name2, @NotNull RepositoryConfiguration configuration, @NotNull ResourceVisibility visibility, @NotNull String relativePath, @Nullable VirtualFile virtualFile) {
        super(type, name2, configuration, visibility, relativePath);
        this.myVirtualFile = virtualFile;
    }

    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.write(FileTimeStampLengthHasher.hash(this.myVirtualFile));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        VfsFileResourceItem other = (VfsFileResourceItem)((Object)obj);
        return this.isValid() == other.isValid();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public boolean isValid() {
        return this.myVirtualFile != null;
    }
}

