/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.concurrency.AndroidIoManager;
import com.android.tools.idea.AndroidProjectModelUtils;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.AarResourceRepositoryCache;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.res.TestAppResourceRepository;
import com.android.tools.res.ResourceNamespacing;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidTargetData;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioResourceRepositoryManager
implements Disposable,
ResourceRepositoryManager {
    private static final Key<StudioResourceRepositoryManager> KEY = Key.create((String)StudioResourceRepositoryManager.class.getName());
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private static final Object TEST_RESOURCES_LOCK = new Object();
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceNamespacing myNamespacing;
    @Nullable
    private ResourceNamespace mySharedNamespaceInstance;
    @Nullable
    private ResourceNamespace mySharedTestNamespaceInstance;
    private AppResourceRepository myAppResources;
    private ProjectResourceRepository myProjectResources;
    private LocalResourceRepository myModuleResources;
    private LocalResourceRepository myTestAppResources;
    private LocalResourceRepository myTestModuleResources;
    private CachedValue<LocalesAndLanguages> myLocalesAndLanguages;
    private Map<ExternalAndroidLibrary, AarResourceRepository> myLibraryResourceMap;
    private final Object myLibraryLock = new Object();

    @NotNull
    public static StudioResourceRepositoryManager getInstance(@NotNull AndroidFacet facet2) {
        StudioResourceRepositoryManager manager;
        ResourceNamespacing namespacing = StudioResourceRepositoryManager.toResourceNamespacing(AndroidProjectModelUtils.getNamespacing(facet2));
        StudioResourceRepositoryManager instance2 = (StudioResourceRepositoryManager)facet2.getUserData(KEY);
        if (instance2 != null && instance2.myNamespacing != namespacing) {
            if (facet2.replace(KEY, (Object)instance2, null)) {
                Disposer.dispose((Disposable)instance2);
            }
            instance2 = null;
        }
        if (instance2 == null && (instance2 = (StudioResourceRepositoryManager)facet2.putUserDataIfAbsent(KEY, (Object)(manager = new StudioResourceRepositoryManager(facet2, namespacing)))) == manager) {
            Disposer.register((Disposable)facet2, (Disposable)instance2);
            AndroidProjectRootListener.ensureSubscribed(manager.getProject());
        }
        return instance2;
    }

    @Nullable
    public static StudioResourceRepositoryManager getInstance(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 == null ? null : StudioResourceRepositoryManager.getInstance(facet2);
    }

    @Nullable
    public static StudioResourceRepositoryManager getInstance(@NotNull PsiElement element2) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
        if (module2 == null) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return null;
        }
        return StudioResourceRepositoryManager.getInstance(facet2);
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getAppResources(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null ? StudioResourceRepositoryManager.getAppResources(facet2) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getAppResources(@NotNull AndroidFacet facet2) {
        return StudioResourceRepositoryManager.getInstance(facet2).getAppResources();
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getProjectResources(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null ? StudioResourceRepositoryManager.getProjectResources(facet2) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getProjectResources(@NotNull AndroidFacet facet2) {
        return StudioResourceRepositoryManager.getInstance(facet2).getProjectResources();
    }

    @Slow
    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null ? StudioResourceRepositoryManager.getModuleResources(facet2) : null;
    }

    @Slow
    @NotNull
    public static LocalResourceRepository getModuleResources(@NotNull AndroidFacet facet2) {
        return StudioResourceRepositoryManager.getInstance(facet2).getModuleResources();
    }

    private static ResourceNamespacing toResourceNamespacing(@NotNull Namespacing namespacing) {
        return switch (namespacing) {
            default -> throw new IncompatibleClassChangeError();
            case Namespacing.DISABLED -> ResourceNamespacing.DISABLED;
            case Namespacing.REQUIRED -> ResourceNamespacing.REQUIRED;
        };
    }

    private StudioResourceRepositoryManager(@NotNull AndroidFacet facet2, @NotNull ResourceNamespacing namespacing) {
        this.myFacet = facet2;
        this.myNamespacing = namespacing;
    }

    @Slow
    @Nullable
    public ResourceRepository getResourcesForNamespace(@NotNull ResourceNamespace namespace) {
        return namespace.equals((Object)ResourceNamespace.ANDROID) ? this.getFrameworkResources(Collections.emptySet()) : this.getAppResources();
    }

    @Override
    @Slow
    @NotNull
    public LocalResourceRepository getAppResources() {
        LocalResourceRepository appResources = this.getCachedAppResources();
        if (appResources != null) {
            return appResources;
        }
        this.getLibraryResources();
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = APP_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myAppResources = AppResourceRepository.create(this.myFacet, this.getLibraryResources());
                    Disposer.register((Disposable)this, (Disposable)this.myAppResources);
                }
                return this.myAppResources;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getCachedAppResources() {
        Object object = APP_RESOURCES_LOCK;
        synchronized (object) {
            return this.myAppResources;
        }
    }

    @Override
    @Slow
    @NotNull
    public LocalResourceRepository getProjectResources() {
        LocalResourceRepository projectResources = this.getCachedProjectResources();
        if (projectResources != null) {
            return projectResources;
        }
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = PROJECT_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myProjectResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myProjectResources = ProjectResourceRepository.create(this.myFacet);
                    Disposer.register((Disposable)this, (Disposable)this.myProjectResources);
                }
                return this.myProjectResources;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getCachedProjectResources() {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            return this.myProjectResources;
        }
    }

    @Override
    @Slow
    @NotNull
    public LocalResourceRepository getModuleResources() {
        LocalResourceRepository moduleResources = this.getCachedModuleResources();
        if (moduleResources != null) {
            return moduleResources;
        }
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = MODULE_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myModuleResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getNamespace());
                    }
                    this.myModuleResources = ModuleResourceRepository.forMainResources(this.myFacet, this.getNamespace());
                    StudioResourceRepositoryManager.registerIfDisposable(this, this.myModuleResources);
                }
                return this.myModuleResources;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalResourceRepository getCachedModuleResources() {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            return this.myModuleResources;
        }
    }

    @NotNull
    public LocalResourceRepository getTestAppResources() {
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestAppResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getTestNamespace());
                    }
                    this.myTestAppResources = this.computeTestAppResources();
                    StudioResourceRepositoryManager.registerIfDisposable(this, this.myTestAppResources);
                }
                return this.myTestAppResources;
            }
        });
    }

    @NotNull
    public LocalResourceRepository getTestModuleResources() {
        return (LocalResourceRepository)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestModuleResources == null) {
                    if (this.myFacet.isDisposed()) {
                        return new LocalResourceRepository.EmptyRepository(this.getTestNamespace());
                    }
                    this.myTestModuleResources = ModuleResourceRepository.forTestResources(this.myFacet, this.getTestNamespace());
                    StudioResourceRepositoryManager.registerIfDisposable(this, this.myTestModuleResources);
                }
                return this.myTestModuleResources;
            }
        });
    }

    @NotNull
    private LocalResourceRepository computeTestAppResources() {
        LocalResourceRepository moduleTestResources = this.getTestModuleResources();
        return TestAppResourceRepository.create(this.myFacet, moduleTestResources);
    }

    @Override
    @Slow
    @Nullable
    public ResourceRepository getFrameworkResources(@NotNull Set<String> languages2) {
        AndroidPlatform androidPlatform = AndroidPlatforms.getInstance(this.myFacet.getModule());
        if (androidPlatform == null) {
            return null;
        }
        return AndroidTargetData.get(androidPlatform.getSdkData(), androidPlatform.getTarget()).getFrameworkResources(languages2);
    }

    @Slow
    @NotNull
    public List<ResourceRepository> getAppResourcesForNamespace(@NotNull ResourceNamespace namespace) {
        AppResourceRepository appRepository = (AppResourceRepository)this.getAppResources();
        if (this.myNamespacing == ResourceNamespacing.DISABLED) {
            return ImmutableList.of((Object)appRepository);
        }
        return ImmutableList.copyOf(appRepository.getRepositoriesForNamespace(namespace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResources() {
        this.resetLibraries();
        SampleDataResourceRepository.SampleDataRepositoryManager.getInstance(this.myFacet).reset();
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources != null) {
                StudioResourceRepositoryManager.disposeIfDisposable(this.myModuleResources);
                this.myModuleResources = null;
            }
        }
        object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources != null) {
                Disposer.dispose((Disposable)this.myProjectResources);
                this.myProjectResources = null;
                this.myLocalesAndLanguages = null;
            }
        }
        object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources != null) {
                Disposer.dispose((Disposable)this.myAppResources);
                this.myAppResources = null;
            }
        }
        object = TEST_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myTestAppResources != null) {
                StudioResourceRepositoryManager.disposeIfDisposable(this.myTestAppResources);
                this.myTestAppResources = null;
            }
            if (this.myTestModuleResources != null) {
                StudioResourceRepositoryManager.disposeIfDisposable(this.myTestModuleResources);
                this.myTestModuleResources = null;
            }
        }
    }

    private static void disposeIfDisposable(@NotNull Object object) {
        if (object instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)object));
        }
    }

    private static void registerIfDisposable(@NotNull Disposable parent2, @NotNull Object object) {
        if (object instanceof Disposable) {
            Disposer.register((Disposable)parent2, (Disposable)((Disposable)object));
        }
    }

    public void dispose() {
    }

    public void resetAllCaches() {
        this.resetResources();
        ConfigurationManager.getOrCreateInstance(this.myFacet.getModule()).getResolverCache().reset();
        ResourceFolderRegistry.getInstance(this.getProject()).reset();
        AarResourceRepositoryCache.getInstance().clear();
    }

    @NotNull
    private Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLibraries() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            this.myLibraryResourceMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRootsAndLibraries() {
        block8: {
            try {
                Map<ExternalAndroidLibrary, AarResourceRepository> oldLibraryResourceMap;
                ProjectResourceRepository projectResources = (ProjectResourceRepository)this.getCachedProjectResources();
                AppResourceRepository appResources = (AppResourceRepository)this.getCachedAppResources();
                if (projectResources != null) {
                    projectResources.updateRoots();
                }
                Object object = this.myLibraryLock;
                synchronized (object) {
                    oldLibraryResourceMap = this.myLibraryResourceMap;
                    this.myLibraryResourceMap = null;
                }
                if (appResources != null) {
                    appResources.updateRoots(this.getLibraryResources());
                }
                if (oldLibraryResourceMap != null && oldLibraryResourceMap.size() == Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
            }
            catch (IllegalStateException e) {
                if (this.myFacet.isDisposed()) break block8;
                throw e;
            }
        }
    }

    @Override
    @NotNull
    public ResourceNamespacing getNamespacing() {
        return this.myNamespacing;
    }

    @Override
    @NotNull
    public ResourceNamespace getNamespace() {
        if (this.myNamespacing == ResourceNamespacing.DISABLED) {
            return ResourceNamespace.RES_AUTO;
        }
        String packageName2 = ProjectSystemUtil.getModuleSystem(this.myFacet).getPackageName();
        if (packageName2 == null) {
            return ResourceNamespace.RES_AUTO;
        }
        if (this.mySharedNamespaceInstance == null || !packageName2.equals(this.mySharedNamespaceInstance.getPackageName())) {
            this.mySharedNamespaceInstance = ResourceNamespace.fromPackageName((String)packageName2);
        }
        return this.mySharedNamespaceInstance;
    }

    @NotNull
    public ResourceNamespace getTestNamespace() {
        if (this.myNamespacing == ResourceNamespacing.DISABLED) {
            return ResourceNamespace.RES_AUTO;
        }
        String testPackageName = ProjectSystemUtil.getModuleSystem(this.myFacet).getTestPackageName();
        if (testPackageName == null) {
            return ResourceNamespace.RES_AUTO;
        }
        if (this.mySharedTestNamespaceInstance == null || !testPackageName.equals(this.mySharedTestNamespaceInstance.getPackageName())) {
            this.mySharedTestNamespaceInstance = ResourceNamespace.fromPackageName((String)testPackageName);
        }
        return this.mySharedTestNamespaceInstance;
    }

    @Slow
    @NotNull
    public Collection<VirtualFile> getAllResourceDirs() {
        return ((AppResourceRepository)this.getAppResources()).getAllResourceDirs();
    }

    @Nullable
    public AarResourceRepository findLibraryResources(@NotNull ExternalAndroidLibrary library) {
        return this.getLibraryResourceMap().get(library);
    }

    @Slow
    @NotNull
    public Collection<AarResourceRepository> getLibraryResources() {
        return this.getLibraryResourceMap().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<ExternalAndroidLibrary, AarResourceRepository> getLibraryResourceMap() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            if (this.myLibraryResourceMap == null) {
                this.myLibraryResourceMap = this.computeLibraryResourceMap();
            }
            return this.myLibraryResourceMap;
        }
    }

    @NotNull
    private Map<ExternalAndroidLibrary, AarResourceRepository> computeLibraryResourceMap() {
        Collection<ExternalAndroidLibrary> libraries2 = AndroidProjectModelUtils.findDependenciesWithResources(this.myFacet.getModule()).values();
        AarResourceRepositoryCache aarResourceRepositoryCache = AarResourceRepositoryCache.getInstance();
        Function<ExternalAndroidLibrary, AarResourceRepository> factory2 = this.myNamespacing == ResourceNamespacing.DISABLED ? aarResourceRepositoryCache::getSourceRepository : aarResourceRepositoryCache::getProtoRepository;
        ExecutorService executor2 = AndroidIoManager.getInstance().getBackgroundDiskIoExecutor();
        HashMap futures = Maps.newHashMapWithExpectedSize((int)libraries2.size());
        for (ExternalAndroidLibrary library : libraries2) {
            futures.put(library, executor2.submit(() -> (AarResourceRepository)factory2.apply(library)));
        }
        ImmutableMap.Builder map2 = ImmutableMap.builder();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                map2.put((Object)((ExternalAndroidLibrary)entry.getKey()), (Object)((AarResourceRepository)((Future)entry.getValue()).get()));
            }
            catch (ExecutionException e) {
                StudioResourceRepositoryManager.cancelPendingTasks(futures.values());
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new UncheckedExecutionException(e.getCause());
            }
            catch (InterruptedException e) {
                StudioResourceRepositoryManager.cancelPendingTasks(futures.values());
                throw new ProcessCanceledException((Throwable)e);
            }
        }
        return map2.build();
    }

    private static void cancelPendingTasks(Collection<Future<AarResourceRepository>> futures) {
        futures.forEach(f -> f.cancel(true));
    }

    @Override
    @NotNull
    public ImmutableList<Locale> getLocalesInProject() {
        return this.getLocalesAndLanguages().locales;
    }

    @NotNull
    public ImmutableSortedSet<String> getLanguagesInProject() {
        return this.getLocalesAndLanguages().languages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private LocalesAndLanguages getLocalesAndLanguages() {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myLocalesAndLanguages == null) {
                this.myLocalesAndLanguages = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                    LocalResourceRepository projectResources = StudioResourceRepositoryManager.getProjectResources(this.myFacet);
                    SortedSet localeQualifiers = ResourceRepositoryUtil.getLocales((ResourceRepository)projectResources);
                    ImmutableList.Builder localesBuilder = ImmutableList.builderWithExpectedSize((int)localeQualifiers.size());
                    ImmutableSortedSet.Builder languagesBuilder = ImmutableSortedSet.naturalOrder();
                    for (LocaleQualifier localeQualifier : localeQualifiers) {
                        localesBuilder.add((Object)Locale.create((LocaleQualifier)localeQualifier));
                        String language = localeQualifier.getLanguage();
                        if (language == null) continue;
                        languagesBuilder.add((Object)language);
                    }
                    return CachedValueProvider.Result.create((Object)new LocalesAndLanguages((ImmutableList<Locale>)localesBuilder.build(), (ImmutableSortedSet<String>)languagesBuilder.build()), (Object[])new Object[]{projectResources});
                });
            }
            return (LocalesAndLanguages)this.myLocalesAndLanguages.getValue();
        }
    }

    private static class LocalesAndLanguages {
        @NotNull
        final ImmutableList<Locale> locales;
        @NotNull
        final ImmutableSortedSet<String> languages;

        LocalesAndLanguages(@NotNull ImmutableList<Locale> locales, @NotNull ImmutableSortedSet<String> languages2) {
            this.locales = locales;
            this.languages = languages2;
        }
    }
}

