/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.ResourceUpdateTraceSettings;
import com.android.tools.idea.util.FileExtensions;
import com.android.utils.FlightRecorder;
import com.android.utils.TraceUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceUpdateTracer {
    private static boolean enabled;
    private static final Logger LOG;

    static void startTracing() {
        FlightRecorder.initialize((int)((Integer)StudioFlags.RESOURCE_REPOSITORY_TRACE_SIZE.get()));
        enabled = true;
    }

    static void stopTracing() {
        enabled = false;
    }

    public static boolean isTracingActive() {
        return enabled;
    }

    public static void dumpTrace(@Nullable String message2) {
        List trace = FlightRecorder.getAndClear();
        if (trace.isEmpty()) {
            if (message2 == null) {
                LOG.info("No resource updates recorded");
            } else {
                LOG.info(message2 + " - no resource updates recorded");
            }
        } else {
            Object intro = Strings.isNullOrEmpty((String)message2) ? "" : message2 + "\n";
            LOG.info((String)intro + "--- Resource update trace: ---\n" + Joiner.on((char)'\n').join((Iterable)trace) + "\n------------------------------");
        }
    }

    public static void log(@NotNull Supplier<?> lazyRecord) {
        if (enabled) {
            FlightRecorder.log(() -> TraceUtils.currentTime() + " " + lazyRecord.get());
        }
    }

    public static void logDirect(@NotNull Supplier<?> lazyRecord) {
        if (enabled) {
            LOG.info(lazyRecord.get().toString());
        }
    }

    @Nullable
    public static String pathForLogging(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        PathString path2 = FileExtensions.toPathString(file2);
        return path2.subpath(Math.max(path2.getNameCount() - 6, 0), path2.getNameCount()).getNativePath();
    }

    @Nullable
    public static String pathForLogging(@Nullable PsiFile file2) {
        return file2 == null ? null : ResourceUpdateTracer.pathForLogging(file2.getVirtualFile());
    }

    @Nullable
    public static String pathForLogging(@Nullable VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            return null;
        }
        return ResourceUpdateTracer.pathForLogging(FileExtensions.toPathString(file2), project);
    }

    @NotNull
    public static String pathForLogging(@NotNull PathString file2, @NotNull Project project) {
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir == null) {
            return file2.subpath(Math.max(file2.getNameCount() - 4, 0), file2.getNameCount()).getNativePath();
        }
        return FileExtensions.toPathString(projectDir).relativize(file2).getNativePath();
    }

    @NotNull
    public static String pathsForLogging(@NotNull Collection<? extends VirtualFile> files2, @NotNull Project project) {
        return files2.stream().map(file2 -> ResourceUpdateTracer.pathForLogging(file2, project)).collect(Collectors.joining(", "));
    }

    static {
        LOG = Logger.getInstance(ResourceUpdateTracer.class);
        if (ResourceUpdateTraceSettings.getInstance().getEnabled()) {
            ResourceUpdateTracer.startTracing();
        }
    }
}

