/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AndroidRClassBase;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.ResourceRepositoryInnerRClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceRepositoryRClass
extends AndroidRClassBase {
    private static final Logger LOG = Logger.getInstance(ResourceRepositoryRClass.class);
    @NotNull
    private final ResourcesSource mySource;

    public ResourceRepositoryRClass(@NotNull PsiManager psiManager, @NotNull ResourcesSource source) {
        super(psiManager, source.getPackageName());
        this.mySource = source;
    }

    @Override
    @NotNull
    protected PsiClass[] doGetInnerClasses() {
        if (DumbService.isDumb((Project)this.getProject())) {
            LOG.debug("R_CLASS_AUGMENT: empty because of dumb mode");
            return PsiClass.EMPTY_ARRAY;
        }
        ResourceType[] types2 = this.mySource.getTransitivity() == Transitivity.TRANSITIVE ? this.mySource.getResourceRepository().getResourceTypes(this.mySource.getResourceNamespace()).toArray(new ResourceType[0]) : ResourceType.values();
        ArrayList<ResourceRepositoryInnerRClass> result2 = new ArrayList<ResourceRepositoryInnerRClass>();
        for (ResourceType type : types2) {
            if (!type.getHasInnerClass()) continue;
            result2.add(new ResourceRepositoryInnerRClass(type, this.mySource, this));
        }
        LOG.debug("R_CLASS_AUGMENT: " + result2.size() + " classes added");
        return result2.toArray(PsiClass.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    protected ModificationTracker getInnerClassesDependencies() {
        return () -> this.mySource.getResourceRepository().getModificationCount();
    }

    @Nullable
    public String getQualifiedName() {
        String packageName2 = this.mySource.getPackageName();
        return packageName2 == null ? "R" : packageName2 + ".R";
    }

    public static interface ResourcesSource {
        @Nullable
        public String getPackageName();

        @NotNull
        public Transitivity getTransitivity();

        @NotNull
        public StudioResourceRepositoryManager getResourceRepositoryManager();

        @NotNull
        public LocalResourceRepository getResourceRepository();

        @NotNull
        public ResourceNamespace getResourceNamespace();

        @NotNull
        public AndroidLightField.FieldModifier getFieldModifier();
    }

    public static enum Transitivity {
        TRANSITIVE,
        NON_TRANSITIVE;

    }
}

