/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.utils.DataBindingUtils;
import com.android.utils.HashCodes;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.concurrency.SameThreadExecutor;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceNotificationManager {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myObserverLock = new Object();
    @NotNull
    private final Map<Module, ModuleEventObserver> myModuleToObserverMap = new HashMap<Module, ModuleEventObserver>();
    @NotNull
    private final Map<VirtualFile, FileEventObserver> myFileToObserverMap = new HashMap<VirtualFile, FileEventObserver>();
    @NotNull
    private final Map<Configuration, ConfigurationEventObserver> myConfigurationToObserverMap = new HashMap<Configuration, ConfigurationEventObserver>();
    @Nullable
    private ProjectPsiTreeObserver myProjectPsiTreeObserver;
    @NotNull
    private final ProjectBuildObserver myProjectBuildObserver = new ProjectBuildObserver();
    private final AtomicBoolean myPendingNotify = new AtomicBoolean();
    private boolean myIgnoreChildrenChanged;
    private long myModificationCount;
    @NotNull
    private EnumSet<Reason> myEvents = EnumSet.noneOf(Reason.class);

    public ResourceNotificationManager(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public static ResourceNotificationManager getInstance(@NotNull Project project) {
        return (ResourceNotificationManager)project.getService(ResourceNotificationManager.class);
    }

    @NotNull
    public ResourceVersion getCurrentVersion(@NotNull AndroidFacet facet2, @Nullable PsiFile file2, @Nullable Configuration configuration) {
        LocalResourceRepository repository2 = StudioResourceRepositoryManager.getAppResources(facet2);
        if (file2 != null) {
            long fileStamp = file2.getModificationStamp();
            if (configuration != null) {
                return new ResourceVersion(repository2.getModificationCount(), fileStamp, configuration.getModificationCount(), configuration.getConfigurationManager().getStateVersion(), this.myModificationCount);
            }
            return new ResourceVersion(repository2.getModificationCount(), fileStamp, 0L, 0L, this.myModificationCount);
        }
        return new ResourceVersion(repository2.getModificationCount(), 0L, 0L, 0L, this.myModificationCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResourceVersion addListener(@NotNull ResourceChangeListener listener2, @NotNull AndroidFacet facet2, @Nullable VirtualFile file2, @Nullable Configuration configuration) {
        Module module2 = facet2.getModule();
        Object object = this.myObserverLock;
        synchronized (object) {
            ModuleEventObserver moduleEventObserver = this.myModuleToObserverMap.get(module2);
            if (moduleEventObserver == null) {
                if (this.myModuleToObserverMap.isEmpty()) {
                    if (this.myProjectPsiTreeObserver == null) {
                        this.myProjectPsiTreeObserver = new ProjectPsiTreeObserver();
                    }
                    this.myProjectBuildObserver.startListening();
                }
                moduleEventObserver = new ModuleEventObserver(facet2);
                this.myModuleToObserverMap.put(module2, moduleEventObserver);
            }
            moduleEventObserver.addListener(listener2);
            if (file2 != null) {
                FileEventObserver fileEventObserver = this.myFileToObserverMap.get(file2);
                if (fileEventObserver == null) {
                    fileEventObserver = new FileEventObserver(module2);
                    this.myFileToObserverMap.put(file2, fileEventObserver);
                }
                fileEventObserver.addListener(listener2);
                if (configuration != null) {
                    ConfigurationEventObserver configurationEventObserver = this.myConfigurationToObserverMap.get(configuration);
                    if (configurationEventObserver == null) {
                        configurationEventObserver = new ConfigurationEventObserver(configuration);
                        this.myConfigurationToObserverMap.put(configuration, configurationEventObserver);
                    }
                    configurationEventObserver.addListener(listener2);
                }
            } else assert (configuration == null) : configuration;
        }
        return this.getCurrentVersion(facet2, file2 != null ? AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)file2) : null, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull ResourceChangeListener listener2, @NotNull AndroidFacet facet2, @Nullable VirtualFile file2, @Nullable Configuration configuration) {
        Object object = this.myObserverLock;
        synchronized (object) {
            if (file2 != null) {
                FileEventObserver fileEventObserver;
                ConfigurationEventObserver configurationEventObserver;
                if (configuration != null && (configurationEventObserver = this.myConfigurationToObserverMap.get(configuration)) != null) {
                    configurationEventObserver.removeListener(listener2);
                    if (!configurationEventObserver.hasListeners()) {
                        this.myConfigurationToObserverMap.remove(configuration);
                    }
                }
                if ((fileEventObserver = this.myFileToObserverMap.get(file2)) != null) {
                    fileEventObserver.removeListener(listener2);
                    if (!fileEventObserver.hasListeners()) {
                        this.myFileToObserverMap.remove(file2);
                    }
                }
            } else assert (configuration == null) : configuration;
            Module module2 = facet2.getModule();
            ModuleEventObserver moduleEventObserver = this.myModuleToObserverMap.get(module2);
            if (moduleEventObserver != null) {
                moduleEventObserver.removeListener(listener2);
                if (!moduleEventObserver.hasListeners()) {
                    Disposer.dispose((Disposable)moduleEventObserver);
                    if (this.myModuleToObserverMap.isEmpty() && this.myProjectPsiTreeObserver != null) {
                        this.myProjectBuildObserver.stopListening();
                        this.myProjectPsiTreeObserver = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiTreeChangeListener getPsiListener() {
        Object object = this.myObserverLock;
        synchronized (object) {
            return this.myProjectPsiTreeObserver;
        }
    }

    private void notice(@NotNull Reason reason, @Nullable VirtualFile source) {
        this.myEvents.add(reason);
        if (!this.myPendingNotify.compareAndSet(false, true)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (!this.myPendingNotify.compareAndSet(true, false)) {
                return;
            }
            if (source == null) {
                this.scheduleFinalNotification();
            } else {
                application.runWriteAction(() -> this.scheduleFinalNotificationAfterRepositoriesHaveBeenUpdated(source));
            }
        });
    }

    private void scheduleFinalNotificationAfterRepositoriesHaveBeenUpdated(@NotNull VirtualFile source) {
        AtomicInteger count2 = new AtomicInteger(1);
        ResourceFolderRegistry resourceFolderRegistry = ResourceFolderRegistry.getInstance(this.myProject);
        resourceFolderRegistry.dispatchToRepositories(source, (repository2, file2) -> {
            count2.incrementAndGet();
            repository2.invokeAfterPendingUpdatesFinish(SameThreadExecutor.INSTANCE, () -> {
                if (count2.decrementAndGet() == 0) {
                    this.scheduleFinalNotification();
                }
            });
        });
        if (count2.decrementAndGet() == 0) {
            this.scheduleFinalNotification();
        }
    }

    private void scheduleFinalNotification() {
        ApplicationManager.getApplication().invokeLater(() -> {
            ImmutableSet reason = ImmutableSet.copyOf(this.myEvents);
            this.myEvents = EnumSet.noneOf(Reason.class);
            this.notifyListeners((ImmutableSet<Reason>)reason);
            this.myEvents.clear();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(@NotNull ImmutableSet<Reason> reason) {
        ArrayList<ModuleEventObserver> observers;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Iterator iterator2 = this.myObserverLock;
        synchronized (iterator2) {
            observers = new ArrayList<ModuleEventObserver>(this.myModuleToObserverMap.values());
        }
        for (ModuleEventObserver moduleEventObserver : observers) {
            moduleEventObserver.notifyListeners(reason);
        }
    }

    private class ProjectBuildObserver
    implements ProjectSystemBuildManager.BuildListener {
        private boolean myAlreadyAddedBuildListener;
        private boolean myIgnoreBuildEvents;

        private ProjectBuildObserver() {
        }

        private void startListening() {
            if (!this.myAlreadyAddedBuildListener) {
                this.myAlreadyAddedBuildListener = true;
                ProjectSystemUtil.getProjectSystem(ResourceNotificationManager.this.myProject).getBuildManager().addBuildListener((Disposable)ResourceNotificationManager.this.myProject, this);
            }
            this.myIgnoreBuildEvents = false;
        }

        private void stopListening() {
            this.myIgnoreBuildEvents = true;
        }

        @Override
        public void buildStarted(@NotNull ProjectSystemBuildManager.BuildMode mode) {
        }

        @Override
        public void beforeBuildCompleted(@NotNull ProjectSystemBuildManager.BuildResult result2) {
        }

        @Override
        public void buildCompleted(@NotNull ProjectSystemBuildManager.BuildResult result2) {
            if (!this.myIgnoreBuildEvents) {
                ++ResourceNotificationManager.this.myModificationCount;
                ResourceNotificationManager.this.notice(Reason.PROJECT_BUILD, null);
            }
        }
    }

    public static enum Reason {
        RESOURCE_EDIT,
        EDIT,
        CONFIGURATION_CHANGED,
        SDK_CHANGED,
        VARIANT_CHANGED,
        GRADLE_SYNC,
        PROJECT_BUILD,
        IMAGE_RESOURCE_CHANGED;

    }

    public static class ResourceVersion {
        private final long myResourceGeneration;
        private final long myFileGeneration;
        private final long myConfigurationGeneration;
        private final long myProjectConfigurationGeneration;
        private final long myOtherGeneration;

        private ResourceVersion(long resourceGeneration, long fileGeneration, long configurationGeneration, long projectConfigurationGeneration, long otherGeneration) {
            this.myResourceGeneration = resourceGeneration;
            this.myFileGeneration = fileGeneration;
            this.myConfigurationGeneration = configurationGeneration;
            this.myProjectConfigurationGeneration = projectConfigurationGeneration;
            this.myOtherGeneration = otherGeneration;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceVersion version2 = (ResourceVersion)o;
            return this.myResourceGeneration == version2.myResourceGeneration && this.myFileGeneration == version2.myFileGeneration && this.myConfigurationGeneration == version2.myConfigurationGeneration && this.myProjectConfigurationGeneration == version2.myProjectConfigurationGeneration && this.myOtherGeneration == version2.myOtherGeneration;
        }

        public int hashCode() {
            return HashCodes.mix((int)Long.hashCode(this.myResourceGeneration), (int)Long.hashCode(this.myFileGeneration), (int)Long.hashCode(this.myConfigurationGeneration), (int)Long.hashCode(this.myProjectConfigurationGeneration), (int)Long.hashCode(this.myOtherGeneration));
        }

        @NotNull
        public String toString() {
            return "ResourceVersion{resource=" + this.myResourceGeneration + ", file=" + this.myFileGeneration + ", configuration=" + this.myConfigurationGeneration + ", projectConfiguration=" + this.myProjectConfigurationGeneration + ", other=" + this.myOtherGeneration + "}";
        }
    }

    private class ModuleEventObserver
    implements ModificationTracker,
    ResourceFolderManager.ResourceFolderListener,
    Disposable {
        private final AndroidFacet myFacet;
        private long myGeneration;
        private final Object myListenersLock = new Object();
        private MessageBusConnection myConnection;
        @NotNull
        private final List<ResourceChangeListener> myListeners = new ArrayList<ResourceChangeListener>(4);

        private ModuleEventObserver(AndroidFacet facet2) {
            this.myFacet = facet2;
            this.myGeneration = this.getAppResourcesModificationCount();
            Disposer.register((Disposable)facet2, (Disposable)this);
        }

        public long getModificationCount() {
            return this.myGeneration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(@NotNull ResourceChangeListener listener2) {
            Object object = this.myListenersLock;
            synchronized (object) {
                if (this.myListeners.isEmpty()) {
                    this.registerListeners();
                }
                this.myListeners.add(listener2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeListener(@NotNull ResourceChangeListener listener2) {
            Object object = this.myListenersLock;
            synchronized (object) {
                this.myListeners.remove(listener2);
                if (this.myListeners.isEmpty()) {
                    this.unregisterListeners();
                }
            }
        }

        private void registerListeners() {
            if (AndroidModel.isRequired(this.myFacet)) {
                StudioResourceRepositoryManager.getProjectResources(this.myFacet);
                assert (this.myConnection == null);
                this.myConnection = this.myFacet.getModule().getProject().getMessageBus().connect((Disposable)this.myFacet);
                this.myConnection.subscribe(ResourceFolderManager.TOPIC, (Object)this);
                ResourceFolderManager.getInstance(this.myFacet);
            }
        }

        private void unregisterListeners() {
            if (this.myConnection != null) {
                this.myConnection.disconnect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(@NotNull ImmutableSet<Reason> reason) {
            ArrayList<ResourceChangeListener> listeners;
            if (this.myFacet.isDisposed()) {
                return;
            }
            long generation = this.getAppResourcesModificationCount();
            if (reason.size() == 1 && reason.contains((Object)Reason.RESOURCE_EDIT) && generation == this.myGeneration) {
                return;
            }
            this.myGeneration = generation;
            ApplicationManager.getApplication().assertIsDispatchThread();
            Iterator iterator2 = this.myListenersLock;
            synchronized (iterator2) {
                listeners = new ArrayList<ResourceChangeListener>(this.myListeners);
            }
            for (ResourceChangeListener listener2 : listeners) {
                listener2.resourcesChanged(reason);
            }
        }

        private long getAppResourcesModificationCount() {
            LocalResourceRepository appResources = StudioResourceRepositoryManager.getInstance(this.myFacet).getCachedAppResources();
            return appResources == null ? 0L : appResources.getModificationCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasListeners() {
            Object object = this.myListenersLock;
            synchronized (object) {
                return !this.myListeners.isEmpty();
            }
        }

        @Override
        public void mainResourceFoldersChanged(@NotNull AndroidFacet facet2, @NotNull List<? extends VirtualFile> folders) {
            if (facet2.getModule() == this.myFacet.getModule()) {
                ++ResourceNotificationManager.this.myModificationCount;
                ResourceNotificationManager.this.notice(Reason.GRADLE_SYNC, null);
            }
        }

        @Override
        public void testResourceFoldersChanged(@NotNull AndroidFacet facet2, @NotNull List<? extends VirtualFile> folders) {
            if (facet2.getModule() == this.myFacet.getModule()) {
                ++ResourceNotificationManager.this.myModificationCount;
                ResourceNotificationManager.this.notice(Reason.GRADLE_SYNC, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Object object = ResourceNotificationManager.this.myObserverLock;
            synchronized (object) {
                ResourceNotificationManager.this.myModuleToObserverMap.remove(this.myFacet.getModule());
            }
        }
    }

    private class ProjectPsiTreeObserver
    implements PsiTreeChangeListener {
        private ProjectPsiTreeObserver() {
        }

        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event2) {
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event2) {
        }

        public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event2) {
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event2) {
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event2) {
            ResourceNotificationManager.this.myIgnoreChildrenChanged = false;
        }

        public void beforePropertyChange(@NotNull PsiTreeChangeEvent event2) {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event2) {
            ResourceNotificationManager.this.myIgnoreChildrenChanged = true;
            if (this.isIgnorable(event2)) {
                return;
            }
            VirtualFile file2 = this.getVirtualFile(event2);
            if (file2 != null && this.isRelevantFile(file2)) {
                String text2;
                PsiElement child = event2.getChild();
                PsiElement parent2 = event2.getParent();
                if (child instanceof XmlAttribute && parent2 instanceof XmlTag) {
                    if (((XmlAttribute)child).getValueElement() == null) {
                        return;
                    }
                } else if (parent2 instanceof XmlAttribute && child instanceof XmlAttributeValue) {
                    XmlAttributeValue attributeValue = (XmlAttributeValue)child;
                    if (attributeValue.getValue().isEmpty()) {
                        return;
                    }
                } else if (parent2 instanceof XmlAttributeValue && child instanceof XmlToken && event2.getOldChild() == null && (text2 = child.getText()).startsWith("@") && !DataBindingUtils.isBindingExpression((String)text2)) {
                    if (text2.equals("@") || text2.equals("@android:")) {
                        return;
                    }
                    ResourceUrl url = ResourceUrl.parse((String)text2);
                    if (url != null && url.name.isEmpty()) {
                        return;
                    }
                }
                ResourceNotificationManager.this.notice(Reason.EDIT, file2);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT, file2);
            }
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event2) {
            ResourceNotificationManager.this.myIgnoreChildrenChanged = true;
            if (this.isIgnorable(event2)) {
                return;
            }
            VirtualFile file2 = this.getVirtualFile(event2);
            if (file2 != null && this.isRelevantFile(file2)) {
                XmlAttributeValue valueElement;
                PsiElement child = event2.getChild();
                PsiElement parent2 = event2.getParent();
                if (parent2 instanceof XmlAttribute && child instanceof XmlToken && ((valueElement = ((XmlAttribute)parent2).getValueElement()) == null || valueElement.getValue().isEmpty())) {
                    return;
                }
                ResourceNotificationManager.this.notice(Reason.EDIT, file2);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT, file2);
            }
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event2) {
            ResourceNotificationManager.this.myIgnoreChildrenChanged = true;
            if (this.isIgnorable(event2)) {
                return;
            }
            VirtualFile file2 = this.getVirtualFile(event2);
            if (file2 != null && this.isRelevantFile(file2)) {
                PsiElement child = event2.getChild();
                PsiElement parent2 = event2.getParent();
                if (parent2 instanceof XmlAttribute && child instanceof XmlToken) {
                    XmlAttributeValue valueElement = ((XmlAttribute)parent2).getValueElement();
                    if (valueElement == null || valueElement.getValue().isEmpty()) {
                        return;
                    }
                } else if (parent2 instanceof XmlAttributeValue && child instanceof XmlToken && event2.getOldChild() != null) {
                    String newText = child.getText();
                    String prevText = event2.getOldChild().getText();
                    if (newText.startsWith("@") && !DataBindingUtils.isBindingExpression((String)newText)) {
                        ResourceUrl prevUrl = ResourceUrl.parse((String)prevText);
                        ResourceUrl newUrl = ResourceUrl.parse((String)newText);
                        if (prevUrl != null && prevUrl.name.isEmpty()) {
                            prevUrl = null;
                        }
                        if (newUrl != null && newUrl.name.isEmpty()) {
                            newUrl = null;
                        }
                        if (prevUrl == null && newUrl == null) {
                            return;
                        }
                    }
                }
                ResourceNotificationManager.this.notice(Reason.EDIT, file2);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT, file2);
            }
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event2) {
            this.check(event2);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event2) {
            if (ResourceNotificationManager.this.myIgnoreChildrenChanged) {
                return;
            }
            this.check(event2);
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event2) {
            if ("fileName".equals(event2.getPropertyName())) {
                PsiElement child = event2.getElement();
                VirtualFile file2 = child instanceof PsiFile ? ((PsiFile)child).getVirtualFile() : null;
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT, file2);
            }
        }

        @Nullable
        private VirtualFile getVirtualFile(@NotNull PsiTreeChangeEvent event2) {
            PsiFile psiFile = event2.getFile();
            return psiFile == null ? null : psiFile.getVirtualFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isRelevantFile(@NotNull VirtualFile virtualFile) {
            Object object = ResourceNotificationManager.this.myObserverLock;
            synchronized (object) {
                return ResourceNotificationManager.this.myFileToObserverMap.containsKey(virtualFile);
            }
        }

        private boolean isIgnorable(@NotNull PsiTreeChangeEvent event2) {
            PsiElement child = event2.getChild();
            PsiElement parent2 = event2.getParent();
            if (child instanceof PsiErrorElement || parent2 instanceof XmlComment) {
                return true;
            }
            if ((child instanceof PsiWhiteSpace || child instanceof XmlText || parent2 instanceof XmlText) && IdeResourcesUtil.getFolderType(event2.getFile()) != ResourceFolderType.VALUES) {
                return true;
            }
            PsiFile file2 = event2.getFile();
            return file2 != null && (file2.getParent() == null || !file2.getViewProvider().isPhysical());
        }

        private void check(@NotNull PsiTreeChangeEvent event2) {
            if (this.isIgnorable(event2)) {
                return;
            }
            VirtualFile file2 = this.getVirtualFile(event2);
            if (file2 != null && this.isRelevantFile(file2)) {
                ResourceNotificationManager.this.notice(Reason.EDIT, file2);
            } else {
                ResourceNotificationManager.this.notice(Reason.RESOURCE_EDIT, file2);
            }
        }
    }

    public static interface ResourceChangeListener {
        public void resourcesChanged(@NotNull ImmutableSet<Reason> var1);
    }

    private class FileEventObserver
    implements BulkFileListener {
        private final List<ResourceChangeListener> myListeners = new ArrayList<ResourceChangeListener>(2);
        private final Module myModule;
        private MessageBusConnection myMessageBusConnection;

        private FileEventObserver(Module module2) {
            this.myModule = module2;
        }

        private void addListener(@NotNull ResourceChangeListener listener2) {
            if (this.myListeners.isEmpty()) {
                this.registerListeners();
            }
            this.myListeners.add(listener2);
        }

        private void removeListener(@NotNull ResourceChangeListener listener2) {
            this.myListeners.remove(listener2);
            if (this.myListeners.isEmpty()) {
                this.unregisterListeners();
            }
        }

        private void registerListeners() {
            this.myMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myModule);
            this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        }

        private void unregisterListeners() {
            this.myMessageBusConnection.disconnect();
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            events.stream().filter(event2 -> {
                VirtualFile file2 = event2.getFile();
                if (file2 == null) {
                    return false;
                }
                VirtualFile parent2 = file2.getParent();
                if (parent2 == null) {
                    return false;
                }
                ResourceFolderType resType = ResourceFolderType.getFolderType((String)parent2.getName());
                return ResourceFolderType.DRAWABLE == resType || ResourceFolderType.MIPMAP == resType;
            }).findAny().ifPresent(event2 -> ResourceNotificationManager.this.notice(Reason.IMAGE_RESOURCE_CHANGED, event2.getFile()));
        }

        private boolean hasListeners() {
            return !this.myListeners.isEmpty();
        }
    }

    private class ConfigurationEventObserver
    implements ConfigurationListener {
        private final Configuration myConfiguration;
        private final List<ResourceChangeListener> myListeners = new ArrayList<ResourceChangeListener>(2);

        private ConfigurationEventObserver(Configuration configuration) {
            this.myConfiguration = configuration;
        }

        private void addListener(@NotNull ResourceChangeListener listener2) {
            if (this.myListeners.isEmpty()) {
                this.registerListeners();
            }
            this.myListeners.add(listener2);
        }

        private void removeListener(@NotNull ResourceChangeListener listener2) {
            this.myListeners.remove(listener2);
            if (this.myListeners.isEmpty()) {
                this.unregisterListeners();
            }
        }

        private boolean hasListeners() {
            return !this.myListeners.isEmpty();
        }

        private void registerListeners() {
            this.myConfiguration.addListener(this);
        }

        private void unregisterListeners() {
            this.myConfiguration.removeListener(this);
        }

        @Override
        public boolean changed(int flags) {
            if ((flags & 0xCFE) != 0) {
                ResourceNotificationManager.this.notice(Reason.CONFIGURATION_CHANGED, null);
            }
            return true;
        }
    }
}

