/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicDensityBasedFileResourceItem;
import com.android.resources.base.BasicFileResourceItem;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.RepositoryLoader;
import com.android.resources.base.ResourceSerializationUtil;
import com.android.resources.base.ResourceSourceFile;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.AbstractResourceRepositoryWithLocking;
import com.android.tools.idea.res.AndroidFileChangeListener;
import com.android.tools.idea.res.FileTimeStampLengthHasher;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.LoggingPsiTreeChangeListener;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceFilesUtil;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceItemSource;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.res.ResourceUpdateTracer;
import com.android.tools.idea.res.VfsDensityBasedFileResourceItem;
import com.android.tools.idea.res.VfsFileResourceItem;
import com.android.tools.idea.res.VfsResourceFile;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.sdk.AndroidTargetData;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.SdkUtils;
import com.android.utils.TraceUtils;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ResourceFolderRepository
extends LocalResourceRepository
implements LoadableResourceRepository {
    static final String CACHE_FILE_FORMAT_VERSION = "2";
    private static final byte[] CACHE_FILE_HEADER = "Resource cache".getBytes(StandardCharsets.UTF_8);
    private static final double CACHE_STALENESS_THRESHOLD = 0.05;
    private static final Comparator<ResourceItemSource<?>> SOURCE_COMPARATOR = Comparator.comparing(ResourceItemSource::getFolderConfiguration);
    private static final Logger LOG = Logger.getInstance(ResourceFolderRepository.class);
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final PsiTreeChangeListener myPsiListener;
    @NotNull
    private final VirtualFile myResourceDir;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final String myResourcePathPrefix;
    @NotNull
    private final PathString myResourcePathBase;
    private int myNumXmlFilesLoadedInitially;
    private int myNumXmlFilesLoadedInitiallyFromSources;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResourceTable = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
    @NotNull
    private final ConcurrentMap<VirtualFile, ResourceItemSource<?>> mySources = new ConcurrentHashMap();
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final PsiNameHelper myPsiNameHelper;
    @NotNull
    private final WolfTheProblemSolver myWolfTheProblemSolver;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    @NotNull
    private final ExecutorService updateExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ResourceFolderRepository", (int)1);
    @NotNull
    private final Deque<Runnable> updateQueue = new ArrayDeque<Runnable>();
    @NotNull
    private final Object scanLock = new Object();
    @NotNull
    private final Set<VirtualFile> pendingScans = new HashSet<VirtualFile>();
    @NotNull
    private final HashMap<VirtualFile, ProgressIndicator> runningScans = new HashMap();
    private int fileRescans;
    private int layoutlibCacheFlushes;

    @NotNull
    static ResourceFolderRepository create(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace, @Nullable ResourceFolderRepositoryCachingData cachingData) {
        return new ResourceFolderRepository(facet2, dir, namespace, cachingData);
    }

    private ResourceFolderRepository(@NotNull AndroidFacet facet2, @NotNull VirtualFile resourceDir, @NotNull ResourceNamespace namespace, @Nullable ResourceFolderRepositoryCachingData cachingData) {
        super(resourceDir.getName());
        this.myFacet = facet2;
        this.myResourceDir = resourceDir;
        this.myNamespace = namespace;
        this.myResourcePathPrefix = RepositoryLoader.portableFileName((String)this.myResourceDir.getPath()) + "/";
        this.myResourcePathBase = new PathString(this.myResourcePathPrefix);
        this.myPsiManager = PsiManager.getInstance((Project)this.getProject());
        this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        this.myPsiNameHelper = PsiNameHelper.getInstance((Project)this.getProject());
        this.myWolfTheProblemSolver = WolfTheProblemSolver.getInstance((Project)this.getProject());
        IncrementalUpdatePsiListener psiListener = new IncrementalUpdatePsiListener();
        this.myPsiListener = LOG.isDebugEnabled() ? new LoggingPsiTreeChangeListener((PsiTreeChangeListener)psiListener, LOG) : psiListener;
        Loader loader = new Loader(this, cachingData);
        loader.load();
        Disposer.register((Disposable)this.myFacet, this.updateExecutor::shutdownNow);
        ResourceUpdateTracer.logDirect(() -> TraceUtils.getSimpleId((Object)this) + " " + this.pathForLogging(resourceDir) + " created for module " + facet2.getModule().getName());
    }

    @NotNull
    public VirtualFile getResourceDir() {
        return this.myResourceDir;
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    @NotNull
    public Path getOrigin() {
        return Paths.get(this.myResourceDir.getPath(), new String[0]);
    }

    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        return this.myResourcePathPrefix + relativeResourcePath;
    }

    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        return this.myResourcePathBase.resolve(relativeResourcePath);
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    public boolean containsUserDefinedResources() {
        return true;
    }

    @Override
    @VisibleForTesting
    public int getFileRescans() {
        return this.fileRescans;
    }

    @VisibleForTesting
    public int getLayoutlibCacheFlushes() {
        return this.layoutlibCacheFlushes;
    }

    private static void addToResult(@NotNull ResourceItem item2, @NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        result2.computeIfAbsent(item2.getType(), t -> LinkedListMultimap.create()).put((Object)item2.getName(), (Object)item2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitToRepository(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        if (!itemsByType.isEmpty()) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                this.commitToRepositoryWithoutLock(itemsByType);
            }
        }
    }

    private void commitToRepositoryWithoutLock(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".commitToRepositoryWithoutLock");
        block0: for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : itemsByType.entrySet()) {
            if (ResourceUpdateTracer.isTracingActive()) {
                for (ResourceItem item2 : entry.getValue().values()) {
                    ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ": Committing " + item2.getType() + "/" + item2.getName());
                }
            }
            ListMultimap<String, ResourceItem> map2 = this.getOrCreateMap(entry.getKey());
            map2.putAll((Multimap)entry.getValue());
            if (!ResourceUpdateTracer.isTracingActive() || entry.getKey() != ResourceType.STRING) continue;
            for (String name2 : entry.getValue().keySet()) {
                ResourceItem item3;
                FolderConfiguration configuration;
                List items2 = map2.get((Object)name2);
                if (items2.isEmpty() || (configuration = (item3 = (ResourceItem)items2.get(0)).getConfiguration()).getLocaleQualifier() == null) continue;
                ResourceUpdateTracer.dumpTrace("Resource " + item3.getReferenceToSelf().getResourceUrl() + " is missing in the default locale");
                continue block0;
            }
        }
    }

    @VisibleForTesting
    boolean hasFreshFileCache() {
        return (double)this.myNumXmlFilesLoadedInitiallyFromSources <= (double)this.myNumXmlFilesLoadedInitially * 0.05;
    }

    @TestOnly
    int getNumXmlFilesLoadedInitially() {
        return this.myNumXmlFilesLoadedInitially;
    }

    @TestOnly
    int getNumXmlFilesLoadedInitiallyFromSources() {
        return this.myNumXmlFilesLoadedInitiallyFromSources;
    }

    @Nullable
    private PsiFile ensureValid(@NotNull PsiFile psiFile) {
        if (psiFile.isValid()) {
            return psiFile;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && virtualFile.exists() && !this.getProject().isDisposed()) {
            return this.myPsiManager.findFile(virtualFile);
        }
        return null;
    }

    private void scanFileResourceFileAsPsi(@NotNull PsiFile file2, @NotNull ResourceFolderType folderType, @NotNull FolderConfiguration folderConfiguration, @NotNull ResourceType type, boolean idGenerating, @NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        String resourceName = SdkUtils.fileNameToResourceName((String)file2.getName());
        if (!this.checkResourceFilename(file2, folderType)) {
            return;
        }
        RepositoryConfiguration configuration = new RepositoryConfiguration((LoadableResourceRepository)this, folderConfiguration);
        PsiResourceItem item2 = PsiResourceItem.forFile(resourceName, type, this, file2);
        if (idGenerating) {
            ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>();
            items2.add(item2);
            ResourceFolderRepository.addToResult(item2, result2);
            this.addIds((PsiElement)file2, items2, result2);
            PsiResourceFile resourceFile = new PsiResourceFile(file2, items2, folderType, configuration);
            this.mySources.put(file2.getVirtualFile(), resourceFile);
        } else {
            PsiResourceFile resourceFile = new PsiResourceFile(file2, Collections.singletonList(item2), folderType, configuration);
            this.mySources.put(file2.getVirtualFile(), resourceFile);
            ResourceFolderRepository.addToResult(item2, result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2.shouldVisitNamespace(this.myNamespace)) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (ResourceFolderRepository.acceptByResources(this.myResourceTable, (ResourceVisitor)visitor2) == ResourceVisitor.VisitResult.ABORT) {
                    return ResourceVisitor.VisitResult.ABORT;
                }
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return null;
        }
        return this.myResourceTable.get(type);
    }

    @NotNull
    private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType type) {
        return this.myResourceTable.computeIfAbsent(type, k -> LinkedListMultimap.create());
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    private void addIds(@NotNull PsiElement element2, @NotNull List<PsiResourceItem> items2, @NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        if (element2 instanceof XmlTag) {
            this.addIds((XmlTag)element2, items2, result2);
        }
        Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)element2, XmlTag.class);
        for (XmlTag tag : xmlTags) {
            this.addIds(tag, items2, result2);
        }
    }

    private void addIds(@NotNull XmlTag tag, @NotNull List<PsiResourceItem> items2, @NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        assert (tag.isValid());
        for (XmlAttribute attribute2 : tag.getAttributes()) {
            String id2 = this.createIdNameFromAttribute(attribute2);
            if (id2 == null) continue;
            PsiResourceItem item2 = PsiResourceItem.forXmlTag(id2, ResourceType.ID, this, attribute2.getParent());
            items2.add(item2);
            ResourceFolderRepository.addToResult(item2, result2);
        }
    }

    @Nullable
    private String createIdNameFromAttribute(@NotNull XmlAttribute attribute2) {
        String id2;
        String attributeValue = StringUtil.notNullize((String)attribute2.getValue()).trim();
        if (attributeValue.startsWith("@+id/") && !attribute2.getNamespace().equals("http://schemas.android.com/tools") && ResourceFolderRepository.isValidValueResourceName(id2 = attributeValue.substring("@+id/".length()))) {
            return id2;
        }
        return null;
    }

    private boolean scanValueFileAsPsi(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull PsiFile file2, @NotNull FolderConfiguration folderConfiguration) {
        boolean added = false;
        FileType fileType = file2.getFileType();
        if (fileType == XmlFileType.INSTANCE) {
            XmlFile xmlFile = (XmlFile)file2;
            assert (xmlFile.isValid());
            XmlDocument document2 = xmlFile.getDocument();
            if (document2 != null) {
                XmlTag root = document2.getRootTag();
                if (root == null) {
                    return false;
                }
                if (!root.getName().equals("resources")) {
                    return false;
                }
                XmlTag[] subTags = root.getSubTags();
                ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>(subTags.length);
                for (XmlTag tag : subTags) {
                    XmlTag[] attrs;
                    ProgressManager.checkCanceled();
                    String name2 = tag.getAttributeValue("name");
                    ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
                    if (type == null || !ResourceFolderRepository.isValidValueResourceName(name2)) continue;
                    PsiResourceItem item2 = PsiResourceItem.forXmlTag(name2, type, this, tag);
                    ResourceFolderRepository.addToResult(item2, result2);
                    items2.add(item2);
                    added = true;
                    if (type != ResourceType.STYLEABLE || (attrs = tag.getSubTags()).length <= 0) continue;
                    for (XmlTag child : attrs) {
                        String attrName = child.getAttributeValue("name");
                        if (!ResourceFolderRepository.isValidValueResourceName(attrName) || attrName.startsWith("android:") || child.getAttribute("format") == null && child.getSubTags().length <= 0) continue;
                        PsiResourceItem attrItem = PsiResourceItem.forXmlTag(attrName, ResourceType.ATTR, this, child);
                        items2.add(attrItem);
                        ResourceFolderRepository.addToResult(attrItem, result2);
                    }
                }
                PsiResourceFile resourceFile = new PsiResourceFile(file2, items2, ResourceFolderType.VALUES, new RepositoryConfiguration((LoadableResourceRepository)this, folderConfiguration));
                this.mySources.put(file2.getVirtualFile(), resourceFile);
            }
        }
        return added;
    }

    @Contract(value="null -> false")
    private static boolean isValidValueResourceName(@Nullable String name2) {
        return !StringUtil.isEmpty((String)name2) && ValueResourceNameValidator.getErrorText((String)name2, null) == null;
    }

    private boolean checkResourceFilename(@NotNull PathString file2, @NotNull ResourceFolderType folderType) {
        VirtualFile virtualFile;
        if (FileResourceNameValidator.getErrorTextForFileResource((String)file2.getFileName(), (ResourceFolderType)folderType) != null && (virtualFile = FileExtensions.toVirtualFile(file2)) != null) {
            this.myWolfTheProblemSolver.reportProblemsFromExternalSource(virtualFile, (Object)this);
        }
        return this.myPsiNameHelper.isIdentifier(SdkUtils.fileNameToResourceName((String)file2.getFileName()));
    }

    private boolean checkResourceFilename(@NotNull PsiFile file2, @NotNull ResourceFolderType folderType) {
        VirtualFile virtualFile;
        if (FileResourceNameValidator.getErrorTextForFileResource((String)file2.getName(), (ResourceFolderType)folderType) != null && (virtualFile = file2.getVirtualFile()) != null) {
            this.myWolfTheProblemSolver.reportProblemsFromExternalSource(virtualFile, (Object)this);
        }
        return this.myPsiNameHelper.isIdentifier(SdkUtils.fileNameToResourceName((String)file2.getName()));
    }

    private boolean isResourceFolder(@NotNull VirtualFile virtualFile) {
        VirtualFile parentDirectory;
        if (virtualFile.isDirectory() && (parentDirectory = virtualFile.getParent()) != null) {
            return parentDirectory.equals(this.myResourceDir);
        }
        return false;
    }

    private boolean isResourceFile(@NotNull VirtualFile virtualFile) {
        VirtualFile parent2 = virtualFile.getParent();
        return parent2 != null && this.isResourceFolder(parent2);
    }

    private boolean isResourceFile(@NotNull PsiFile psiFile) {
        return this.isResourceFile(psiFile.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isScanPending(@NotNull VirtualFile virtualFile) {
        Object object = this.scanLock;
        synchronized (object) {
            return this.pendingScans.contains(virtualFile);
        }
    }

    public void convertToPsiIfNeeded(@NotNull VirtualFile virtualFile) {
        VirtualFile grandparent;
        VirtualFile parent2 = virtualFile.getParent();
        VirtualFile virtualFile2 = grandparent = parent2 == null ? null : parent2.getParent();
        if (this.myResourceDir.equals(grandparent)) {
            this.scheduleScan(virtualFile);
        }
    }

    private boolean convertToPsiIfNeeded(@NotNull PsiFile psiFile, @NotNull ResourceFolderType folderType) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        ResourceItemSource resourceFile = (ResourceItemSource)this.mySources.get(virtualFile);
        if (resourceFile instanceof PsiResourceFile) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converting to PSI ", new Object[]{psiFile});
        }
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".convertToPsiIfNeeded " + this.pathForLogging(psiFile) + " converting to PSI");
        this.scheduleScan(virtualFile, folderType);
        return true;
    }

    void scheduleScan(@NotNull VirtualFile virtualFile) {
        ResourceFolderType folderType = ResourceFilesUtil.getFolderType(virtualFile);
        if (folderType != null) {
            this.scheduleScan(virtualFile, folderType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleScan(@NotNull VirtualFile virtualFile, @NotNull ResourceFolderType folderType) {
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile));
        Object object = this.scanLock;
        synchronized (object) {
            if (!this.pendingScans.add(virtualFile)) {
                ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " pending already");
                return;
            }
        }
        this.scheduleUpdate(() -> {
            EmptyProgressIndicator runHandle;
            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " preparing to scan");
            if (!virtualFile.isValid() || !this.isScanPending(virtualFile)) {
                ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " pending already");
                return;
            }
            PsiFile psiFile = this.findPsiFile(virtualFile);
            if (psiFile == null) {
                ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan no PSI " + this.pathForLogging(virtualFile));
                return;
            }
            Object object = this.scanLock;
            synchronized (object) {
                if (!this.pendingScans.remove(virtualFile)) {
                    ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " scanned already");
                    return;
                }
                runHandle = new EmptyProgressIndicator();
                ProgressIndicator oldRunHandle = this.runningScans.put(virtualFile, (ProgressIndicator)runHandle);
                if (oldRunHandle != null) {
                    oldRunHandle.cancel();
                }
            }
            try {
                ProgressManager.getInstance().runProcess(() -> this.scan(psiFile, folderType), (ProgressIndicator)runHandle);
            }
            finally {
                object = this.scanLock;
                synchronized (object) {
                    this.runningScans.remove(virtualFile, runHandle);
                    ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scheduleScan " + this.pathForLogging(virtualFile) + " finished scanning");
                }
            }
        });
    }

    @NotNull
    private String pathForLogging(@NotNull VirtualFile virtualFile) {
        return ResourceUpdateTracer.pathForLogging(virtualFile, this.getProject());
    }

    @Nullable
    private String pathForLogging(@Nullable PsiFile file2) {
        return file2 == null ? null : this.pathForLogging(file2.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate(@NotNull Runnable updateAction) {
        boolean wasEmpty;
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scheduleUpdate scheduling " + updateAction);
        Deque<Runnable> deque = this.updateQueue;
        synchronized (deque) {
            wasEmpty = this.updateQueue.isEmpty();
            this.updateQueue.add(updateAction);
        }
        if (wasEmpty) {
            try {
                this.updateExecutor.execute(() -> {
                    while (true) {
                        Runnable action2;
                        Deque<Runnable> deque = this.updateQueue;
                        synchronized (deque) {
                            action2 = this.updateQueue.poll();
                            if (action2 == null) {
                                break;
                            }
                        }
                        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ": Update " + action2 + " started");
                        try {
                            ReadAction.nonBlocking((Runnable)action2).expireWith((Disposable)this.myFacet).executeSynchronously();
                            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ": Update " + action2 + " finished");
                        }
                        catch (ProcessCanceledException e) {
                            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ": Update " + action2 + " was canceled");
                        }
                        catch (Throwable e) {
                            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ": Update " + action2 + " finished with exception " + e + "\n" + TraceUtils.getStackTrace((Throwable)e));
                            LOG.error(e);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @Override
    public void invokeAfterPendingUpdatesFinish(@NotNull Executor executor2, @NotNull Runnable callback2) {
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".invokeAfterPendingUpdatesFinish " + callback2);
        this.scheduleUpdate(() -> executor2.execute(callback2));
    }

    @Nullable
    private PsiFile findPsiFile(@NotNull VirtualFile virtualFile) {
        try {
            return PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile);
        }
        catch (AlreadyDisposedException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(@NotNull PsiFile psiFile, @NotNull ResourceFolderType folderType) {
        ProgressManager.checkCanceled();
        if (!this.isResourceFile(psiFile) || !AndroidFileChangeListener.isRelevantFile(psiFile) || psiFile.getProject().isDisposed()) {
            return;
        }
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scan " + this.pathForLogging(psiFile));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rescanning ", new Object[]{psiFile});
        }
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        PsiFile file2 = psiFile;
        if (folderType == ResourceFolderType.VALUES) {
            ++this.fileRescans;
            ResourceItemSource source = (ResourceItemSource)this.mySources.remove(file2.getVirtualFile());
            boolean removed = false;
            if (source != null) {
                removed = this.removeItemsFromSource(source);
            }
            file2 = this.ensureValid(file2);
            boolean added = false;
            if (file2 != null) {
                FolderConfiguration folderConfiguration;
                PsiDirectory parent2 = file2.getParent();
                assert (parent2 != null);
                PsiDirectory fileParent = psiFile.getParent();
                if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                    ProgressManager.checkCanceled();
                    added = this.scanValueFileAsPsi(result2, file2, folderConfiguration);
                }
            }
            if (added || removed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
                this.invalidateParentCaches((SingleNamespaceResourceRepository)this, ResourceType.values());
            }
        } else if (this.checkResourceFilename(file2, folderType)) {
            ResourceItemSource source = (ResourceItemSource)this.mySources.get(file2.getVirtualFile());
            if (source instanceof PsiResourceFile && file2.getFileType() == XmlFileType.INSTANCE) {
                PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType)) {
                    ++this.fileRescans;
                    HashSet<String> idsBefore = new HashSet<String>();
                    Object parent2 = ITEM_MAP_LOCK;
                    synchronized (parent2) {
                        ListMultimap<String, ResourceItem> idMultimap = this.myResourceTable.get(ResourceType.ID);
                        if (idMultimap != null) {
                            ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                            for (PsiResourceItem item2 : psiResourceFile) {
                                if (item2.getType() != ResourceType.ID) continue;
                                idsBefore.add(item2.getName());
                                idItems.add(item2);
                            }
                            for (String id2 : idsBefore) {
                                List mapItems = idMultimap.get((Object)id2);
                                if (mapItems.isEmpty()) continue;
                                ArrayList<ResourceItem> toDelete = new ArrayList<ResourceItem>(mapItems.size());
                                for (ResourceItem mapItem : mapItems) {
                                    if (!(mapItem instanceof PsiResourceItem) || ((PsiResourceItem)mapItem).getSourceFile() != psiResourceFile) continue;
                                    toDelete.add(mapItem);
                                }
                                for (ResourceItem item3 : toDelete) {
                                    idMultimap.remove((Object)item3.getName(), (Object)item3);
                                }
                            }
                            for (PsiResourceItem item2 : idItems) {
                                psiResourceFile.removeItem(item2);
                            }
                        }
                    }
                    ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                    file2 = this.ensureValid(file2);
                    if (file2 != null) {
                        ProgressManager.checkCanceled();
                        this.addIds((PsiElement)file2, idItems, result2);
                    }
                    if (!idItems.isEmpty()) {
                        for (PsiResourceItem item4 : idItems) {
                            psiResourceFile.addItem(item4);
                        }
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches((SingleNamespaceResourceRepository)this, ResourceType.ID);
                }
            } else {
                if (source != null) {
                    this.removeItemsFromSource(source);
                }
                ++this.fileRescans;
                PsiDirectory parent3 = file2.getParent();
                assert (parent3 != null);
                ResourceType type = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderType);
                boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
                ProgressManager.checkCanceled();
                this.clearLayoutlibCaches(file2.getVirtualFile(), folderType);
                file2 = this.ensureValid(file2);
                if (file2 != null) {
                    FolderConfiguration folderConfiguration;
                    PsiDirectory fileParent = psiFile.getParent();
                    if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                        boolean idGeneratingFile = idGeneratingFolder && file2.getFileType() == XmlFileType.INSTANCE;
                        ProgressManager.checkCanceled();
                        this.scanFileResourceFileAsPsi(file2, folderType, folderConfiguration, type, idGeneratingFile, result2);
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches((SingleNamespaceResourceRepository)this, ResourceType.values());
                }
            }
        }
        this.commitToRepository(result2);
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".scan " + this.pathForLogging(psiFile) + " end");
    }

    private void scan(@NotNull VirtualFile file2) {
        ResourceFolderType folderType = ResourceFilesUtil.getFolderType(file2);
        if (folderType == null || !this.isResourceFile(file2) || !AndroidFileChangeListener.isRelevantFile(file2)) {
            return;
        }
        if (!file2.exists()) {
            this.removeResourcesContainedInFileOrDirectory(file2);
            return;
        }
        PsiFile psiFile = this.myPsiManager.findFile(file2);
        if (psiFile != null) {
            Document document2 = this.myPsiDocumentManager.getDocument(psiFile);
            if (document2 != null && this.myPsiDocumentManager.isUncommited(document2)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Committing ", new Object[]{document2});
                }
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                    this.myPsiDocumentManager.commitDocument(document2);
                    this.scheduleScan(file2, folderType);
                });
                return;
            }
            this.scan(psiFile, folderType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItemsForTag(@NotNull ResourceItemSource<PsiResourceItem> source, @NotNull XmlTag xmlTag, @NotNull ResourceType resourceType) {
        boolean changed = false;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            Iterator sourceIter = source.iterator();
            while (sourceIter.hasNext()) {
                PsiResourceItem item2 = (PsiResourceItem)sourceIter.next();
                if (!item2.wasTag(xmlTag)) continue;
                ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(resourceType);
                List items2 = map2.get((Object)item2.getName());
                Iterator iter = items2.iterator();
                while (iter.hasNext()) {
                    ResourceItem candidate = (ResourceItem)iter.next();
                    if (candidate != item2) continue;
                    iter.remove();
                    changed = true;
                    break;
                }
                sourceIter.remove();
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItemsFromSource(@NotNull ResourceItemSource<?> source) {
        boolean changed = false;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceItem item2 : source) {
                ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(item2.getType());
                List items2 = map2.get((Object)item2.getName());
                Iterator iter = items2.iterator();
                while (iter.hasNext()) {
                    ResourceItem candidate = (ResourceItem)iter.next();
                    if (candidate != item2) continue;
                    iter.remove();
                    changed = true;
                    break;
                }
                if (!items2.isEmpty()) continue;
                map2.removeAll((Object)item2.getName());
            }
        }
        return changed;
    }

    private void getAndroidTargetDataThenRun(@NotNull VirtualFile file2, @NotNull Consumer<AndroidTargetData> consumer) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.myFacet.isDisposed()) {
                return;
            }
            ConfigurationManager configurationManager = ConfigurationManager.findExistingInstance(this.myFacet.getModule());
            if (configurationManager == null) {
                return;
            }
            IAndroidTarget target2 = configurationManager.getConfiguration(file2).getTarget();
            if (target2 == null) {
                return;
            }
            consumer.accept(AndroidTargetData.getTargetData(target2, AndroidPlatforms.getInstance(this.myFacet.getModule())));
        });
    }

    private void bitmapUpdated(@NotNull VirtualFile bitmap) {
        Module module2 = this.myFacet.getModule();
        this.getAndroidTargetDataThenRun(bitmap, targetData -> targetData.clearLayoutBitmapCache(module2));
    }

    void clearFontCache(@NotNull VirtualFile virtualFile) {
        this.getAndroidTargetDataThenRun(virtualFile, targetData -> targetData.clearFontCache(virtualFile.getPath()));
    }

    @NotNull
    public PsiTreeChangeListener getPsiListener() {
        return this.myPsiListener;
    }

    @Override
    protected void setModificationCount(long count2) {
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".setModificationCount " + count2);
        super.setModificationCount(count2);
    }

    void onFileCreated(@NotNull VirtualFile file2) {
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".onFileCreated " + this.pathForLogging(file2));
        this.scheduleScan(file2);
    }

    void onFileOrDirectoryRemoved(@NotNull VirtualFile file2) {
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".onFileOrDirectoryRemoved " + this.pathForLogging(file2));
        this.scheduleUpdate(() -> this.removeResourcesContainedInFileOrDirectory(file2));
    }

    private void removeResourcesContainedInFileOrDirectory(@NotNull VirtualFile file2) {
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".processRemovalOfFileOrDirectory " + this.pathForLogging(file2));
        if (file2.isDirectory()) {
            Iterator iterator2 = this.mySources.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                VirtualFile sourceFile = (VirtualFile)entry.getKey();
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)sourceFile, (boolean)true)) continue;
                ResourceItemSource source = (ResourceItemSource)entry.getValue();
                this.removeSource(sourceFile, source);
                iterator2.remove();
            }
        } else {
            ResourceItemSource source = (ResourceItemSource)this.mySources.remove(file2);
            if (source != null) {
                this.removeSource(file2, source);
            }
            this.myWolfTheProblemSolver.clearProblemsFromExternalSource(file2, (Object)this);
        }
    }

    private void removeSource(@NotNull VirtualFile file2, @NotNull ResourceItemSource<?> source) {
        ResourceFolderType folderType;
        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)this) + ".onSourceRemoved " + this.pathForLogging(file2));
        boolean removed = this.removeItemsFromSource(source);
        if (removed) {
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches((SingleNamespaceResourceRepository)this, ResourceType.values());
        }
        if ((folderType = ResourceFilesUtil.getFolderType(file2)) != null) {
            this.clearLayoutlibCaches(file2, folderType);
        }
    }

    @Nullable
    private XmlTag findItemElement(@NotNull XmlTag tag) {
        for (XmlTag parentTag = tag; parentTag != null; parentTag = parentTag.getParentTag()) {
            if (!ResourceFolderRepository.isItemElement(parentTag)) continue;
            return parentTag;
        }
        return null;
    }

    @NotNull
    private Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    private void clearLayoutlibCaches(@NotNull VirtualFile file2, @NotNull ResourceFolderType folderType) {
        if ("xml".equals(file2.getExtension())) {
            return;
        }
        if (folderType == ResourceFolderType.DRAWABLE) {
            ++this.layoutlibCacheFlushes;
            this.bitmapUpdated(file2);
        } else if (folderType == ResourceFolderType.FONT) {
            ++this.layoutlibCacheFlushes;
            this.clearFontCache(file2);
        }
    }

    private static boolean isItemElement(@NotNull XmlTag xmlTag) {
        String tag = xmlTag.getName();
        if (tag.equals("resources")) {
            return false;
        }
        return tag.equals("item") || ResourceType.fromXmlTagName((String)tag) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findValueResourceItem(@NotNull XmlTag tag, @NotNull PsiFile file2) {
        if (!tag.isValid()) {
            ResourceItemSource resourceFile = (ResourceItemSource)this.mySources.get(file2.getVirtualFile());
            if (resourceFile != null) {
                assert (resourceFile instanceof PsiResourceFile);
                PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                for (PsiResourceItem item2 : psiResourceFile) {
                    if (!item2.wasTag(tag)) continue;
                    return item2;
                }
            }
            return null;
        }
        String name2 = tag.getAttributeValue("name");
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return name2 != null ? this.findValueResourceItem(tag, file2, name2) : null;
        }
    }

    @Nullable
    private ResourceItem findValueResourceItem(@NotNull XmlTag tag, @NotNull PsiFile file2, @NotNull String name2) {
        ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
        return this.findResourceItem(type, file2, name2, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findResourceItem(@Nullable ResourceType type, @NotNull PsiFile file2, @Nullable String name2, @Nullable XmlTag tag) {
        if (type == null || name2 == null) {
            return null;
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file2.getVirtualFile());
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map2 = this.myResourceTable.get(type);
            if (map2 == null) {
                return null;
            }
            List items2 = map2.get((Object)name2);
            if (tag != null) {
                for (ResourceItem resourceItem : items2) {
                    PsiResourceItem psiResourceItem;
                    if (!(resourceItem instanceof PsiResourceItem) || !(psiResourceItem = (PsiResourceItem)resourceItem).wasTag(tag)) continue;
                    return resourceItem;
                }
            } else {
                for (ResourceItem item2 : items2) {
                    if (item2 instanceof PsiResourceItem) {
                        if (!Objects.equals(((PsiResourceItem)item2).getPsiFile(), file2)) continue;
                        return item2;
                    }
                    ResourceFile resourceFile = (ResourceFile)((ResourceMergerItem)item2).getSourceFile();
                    if (resourceFile == null || !FileUtil.filesEqual((File)resourceFile.getFile(), (File)ioFile)) continue;
                    return item2;
                }
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.myResourceDir + ": @" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        return Collections.singleton(this.myResourceDir);
    }

    @NotNull
    public VfsResourceFile deserializeResourceSourceFile(@NotNull Base128InputStream stream, @NotNull List<RepositoryConfiguration> configurations) throws IOException {
        String relativePath = stream.readString();
        if (relativePath == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        int configIndex = stream.readInt();
        RepositoryConfiguration configuration = configurations.get(configIndex);
        VirtualFile virtualFile = ((ResourceFolderRepository)configuration.getRepository()).getResourceDir().findFileByRelativePath(relativePath);
        if (!stream.validateContents(FileTimeStampLengthHasher.hash(virtualFile))) {
            virtualFile = null;
        }
        return new VfsResourceFile(virtualFile, configuration);
    }

    @NotNull
    public BasicFileResourceItem deserializeFileResourceItem(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name2, @NotNull ResourceVisibility visibility, @NotNull List<RepositoryConfiguration> configurations) throws IOException {
        Density density;
        String relativePath = stream.readString();
        if (relativePath == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        int configIndex = stream.readInt();
        RepositoryConfiguration configuration = configurations.get(configIndex);
        int encodedDensity = stream.readInt();
        VirtualFile virtualFile = ((ResourceFolderRepository)configuration.getRepository()).getResourceDir().findFileByRelativePath(relativePath);
        boolean idGenerating = false;
        String folderName = new PathString(relativePath).getParentFileName();
        if (folderName != null) {
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
            boolean bl = idGenerating = folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
        }
        if (idGenerating) {
            if (!stream.validateContents(FileTimeStampLengthHasher.hash(virtualFile))) {
                virtualFile = null;
            }
            if (encodedDensity == 0) {
                return new VfsFileResourceItem(resourceType, name2, configuration, visibility, relativePath, virtualFile);
            }
            density = Density.values()[encodedDensity - 1];
            return new VfsDensityBasedFileResourceItem(resourceType, name2, configuration, visibility, relativePath, virtualFile, density);
        }
        if (encodedDensity == 0) {
            return new BasicFileResourceItem(resourceType, name2, configuration, visibility, relativePath);
        }
        density = Density.values()[encodedDensity - 1];
        return new BasicDensityBasedFileResourceItem(resourceType, name2, configuration, visibility, relativePath, density);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateParentCaches() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            super.invalidateParentCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateParentCaches(@NotNull SingleNamespaceResourceRepository repository2, ResourceType ... types2) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            super.invalidateParentCaches(repository2, types2);
        }
    }

    private final class IncrementalUpdatePsiListener
    extends PsiTreeChangeAdapter {
        private boolean myIgnoreChildrenChanged;

        private IncrementalUpdatePsiListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childAdded(@NotNull PsiTreeChangeEvent event2) {
            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childAdded " + ResourceFolderRepository.this.pathForLogging(event2.getFile()));
            try {
                PsiFile psiFile = event2.getFile();
                if (psiFile != null && AndroidFileChangeListener.isRelevantFile(psiFile)) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (this.rescheduleScanIfRunning(virtualFile)) {
                        return;
                    }
                    ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile);
                    if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                        PsiElement child = event2.getChild();
                        PsiElement parent2 = event2.getParent();
                        if (folderType == ResourceFolderType.VALUES) {
                            if (child instanceof XmlTag) {
                                XmlTag tag = (XmlTag)child;
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                ResourceFolderRepository.this.scheduleUpdate(() -> {
                                    ResourceItem parentItem;
                                    XmlTag parentTag;
                                    ResourceItemSource source;
                                    if (!tag.isValid()) {
                                        ResourceFolderRepository.this.scan(psiFile, folderType);
                                        return;
                                    }
                                    if (ResourceFolderRepository.isItemElement(tag) && (source = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(virtualFile)) != null) {
                                        assert (source instanceof PsiResourceFile);
                                        PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                                        String name2 = tag.getAttributeValue("name");
                                        if (ResourceFolderRepository.isValidValueResourceName(name2)) {
                                            ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
                                            if (type == ResourceType.STYLEABLE) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            if (type != null) {
                                                PsiResourceItem item2 = PsiResourceItem.forXmlTag(name2, type, ResourceFolderRepository.this, tag);
                                                Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                                synchronized (object) {
                                                    ResourceFolderRepository.this.getOrCreateMap(type).put((Object)name2, (Object)item2);
                                                    psiResourceFile.addItem(item2);
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, type);
                                                }
                                                return;
                                            }
                                        }
                                    }
                                    if ((parentTag = tag.getParentTag()) != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) != null && (parentItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                                        if (((PsiResourceItem)parentItem).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                        }
                                        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childAdded " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " recomputed: " + parentItem);
                                        return;
                                    }
                                    ResourceFolderRepository.this.scan(psiFile, folderType);
                                });
                            } else if (parent2 instanceof XmlText) {
                                XmlText text2 = (XmlText)parent2;
                                this.handleValueXmlTextEdit((PsiElement)text2.getParentTag(), psiFile);
                            } else if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent2, psiFile);
                            } else if (!(parent2 instanceof XmlComment) && !(child instanceof XmlComment)) {
                                ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                            }
                            return;
                        }
                        if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == XmlFileType.INSTANCE) {
                            if (parent2 instanceof XmlComment || child instanceof XmlComment) {
                                return;
                            }
                            if (parent2 instanceof XmlText || child instanceof XmlText && child.getText().trim().isEmpty()) {
                                return;
                            }
                            if (parent2 instanceof XmlElement && child instanceof XmlElement) {
                                if (child instanceof XmlTag) {
                                    ResourceFolderRepository.this.scheduleUpdate(() -> {
                                        if (!child.isValid()) {
                                            ResourceFolderRepository.this.scan(psiFile, folderType);
                                            return;
                                        }
                                        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
                                        ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>();
                                        ResourceFolderRepository.this.addIds(child, items2, result2);
                                        if (!items2.isEmpty()) {
                                            ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                            if (!(resourceFile instanceof PsiResourceFile)) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                            for (PsiResourceItem item2 : items2) {
                                                psiResourceFile.addItem(item2);
                                            }
                                            ResourceFolderRepository.this.commitToRepository(result2);
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                            ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, ResourceType.ID);
                                        }
                                    });
                                    return;
                                }
                                if (child instanceof XmlAttribute || parent2 instanceof XmlAttribute) {
                                    XmlAttribute attribute2 = parent2 instanceof XmlAttribute ? (XmlAttribute)parent2 : (XmlAttribute)child;
                                    String id2 = ResourceFolderRepository.this.createIdNameFromAttribute(attribute2);
                                    if (id2 != null) {
                                        if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                            return;
                                        }
                                        ResourceFolderRepository.this.scheduleUpdate(() -> {
                                            if (!attribute2.isValid()) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            PsiResourceItem newIdResource = PsiResourceItem.forXmlTag(id2, ResourceType.ID, ResourceFolderRepository.this, attribute2.getParent());
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                                if (resourceFile != null) {
                                                    assert (resourceFile instanceof PsiResourceFile);
                                                    PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                                    psiResourceFile.addItem(newIdResource);
                                                    ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ": Adding id/" + newIdResource.getName());
                                                    ResourceFolderRepository.this.getOrCreateMap(ResourceType.ID).put((Object)newIdResource.getName(), (Object)newIdResource);
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, ResourceType.ID);
                                                }
                                            }
                                        });
                                        return;
                                    }
                                }
                            }
                        } else if (folderType == ResourceFolderType.FONT) {
                            ResourceFolderRepository.this.clearFontCache(psiFile.getVirtualFile());
                        }
                    }
                }
                this.myIgnoreChildrenChanged = true;
            }
            finally {
                ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childAdded " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " end");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childRemoved(@NotNull PsiTreeChangeEvent event2) {
            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childRemoved " + ResourceFolderRepository.this.pathForLogging(event2.getFile()));
            try {
                PsiFile psiFile = event2.getFile();
                if (psiFile != null && AndroidFileChangeListener.isRelevantFile(psiFile)) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (this.rescheduleScanIfRunning(virtualFile)) {
                        return;
                    }
                    ResourceFolderType folderType = ResourceFilesUtil.getFolderType(virtualFile);
                    if (folderType != null && ResourceFolderRepository.this.isResourceFile(virtualFile)) {
                        PsiElement child = event2.getChild();
                        PsiElement parent2 = event2.getParent();
                        if (folderType == ResourceFolderType.VALUES) {
                            if (child instanceof XmlTag) {
                                XmlTag parentTag;
                                XmlTag tag = (XmlTag)child;
                                if (parent2 instanceof XmlTag && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag = (XmlTag)parent2) != null) {
                                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                        return;
                                    }
                                    ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                    if (resourceItem instanceof PsiResourceItem) {
                                        ResourceItem declareStyleable;
                                        if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                        }
                                        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childRemoved " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " recomputed: " + resourceItem);
                                        if (resourceItem.getType() == ResourceType.ATTR && (parentTag = parentTag.getParentTag()) != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE && (declareStyleable = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem && ((PsiResourceItem)declareStyleable).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                        }
                                        return;
                                    }
                                }
                                if (ResourceFolderRepository.isItemElement(tag)) {
                                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                        return;
                                    }
                                    ResourceFolderRepository.this.scheduleUpdate(() -> {
                                        ResourceType type;
                                        String name2;
                                        ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(virtualFile);
                                        if (source == null) {
                                            ResourceFolderRepository.this.scan(psiFile, folderType);
                                            return;
                                        }
                                        PsiResourceFile resourceFile = (PsiResourceFile)source;
                                        if (tag.isValid()) {
                                            name2 = tag.getAttributeValue("name");
                                        } else {
                                            ResourceItem item2 = ResourceFolderRepository.this.findValueResourceItem(tag, psiFile);
                                            if (item2 == null) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            name2 = item2.getName();
                                        }
                                        if (name2 != null && (type = IdeResourcesUtil.getResourceTypeForResourceTag(tag)) != null) {
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                boolean removed = ResourceFolderRepository.this.removeItemsForTag(resourceFile, tag, type);
                                                if (removed) {
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, type);
                                                }
                                            }
                                        }
                                    });
                                }
                                return;
                            }
                            if (parent2 instanceof XmlText) {
                                XmlText text2 = (XmlText)parent2;
                                this.handleValueXmlTextEdit((PsiElement)text2.getParentTag(), psiFile);
                            } else if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent2, psiFile);
                            } else {
                                if (parent2 instanceof XmlComment || child instanceof XmlComment) {
                                    return;
                                }
                                ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                            }
                        } else if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == XmlFileType.INSTANCE) {
                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        } else if (folderType == ResourceFolderType.FONT) {
                            ResourceFolderRepository.this.clearFontCache(virtualFile);
                        }
                    }
                }
                this.myIgnoreChildrenChanged = true;
            }
            finally {
                ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childRemoved " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " end");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childReplaced(@NotNull PsiTreeChangeEvent event2) {
            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event2.getFile()));
            try {
                PsiFile psiFile = event2.getFile();
                if (psiFile != null) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (this.rescheduleScanIfRunning(virtualFile)) {
                        return;
                    }
                    if (AndroidFileChangeListener.isRelevantFile(virtualFile)) {
                        PsiElement parent2;
                        ResourceFolderType folderType = ResourceFilesUtil.getFolderType(virtualFile);
                        if (folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == XmlFileType.INSTANCE) {
                            PsiElement parent3 = event2.getParent();
                            PsiElement child = event2.getChild();
                            if (parent3 instanceof XmlText || child instanceof XmlText || parent3 instanceof XmlComment || child instanceof XmlComment) {
                                return;
                            }
                            if (parent3 instanceof XmlElement && child instanceof XmlElement) {
                                if (event2.getOldChild() == event2.getNewChild()) {
                                    ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                    return;
                                }
                                if (child instanceof XmlAttributeValue) {
                                    assert (parent3 instanceof XmlAttribute) : parent3;
                                    XmlAttribute attribute2 = (XmlAttribute)parent3;
                                    PsiElement oldChild = event2.getOldChild();
                                    PsiElement newChild = event2.getNewChild();
                                    if (oldChild instanceof XmlAttributeValue && newChild instanceof XmlAttributeValue) {
                                        String oldText = ((XmlAttributeValue)oldChild).getValue().trim();
                                        String newText = ((XmlAttributeValue)newChild).getValue().trim();
                                        if (oldText.startsWith("@+id/") || newText.startsWith("@+id/")) {
                                            ResourceUrl newResourceUrl;
                                            ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                            if (!(resourceFile instanceof PsiResourceFile)) {
                                                ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                                return;
                                            }
                                            ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldText);
                                            if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newText))) {
                                                return;
                                            }
                                            XmlTag xmlTag = attribute2.getParent();
                                            ResourceFolderRepository.this.scheduleUpdate(() -> {
                                                if (!xmlTag.isValid()) {
                                                    ResourceFolderRepository.this.scan(psiFile, folderType);
                                                    return;
                                                }
                                                HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
                                                ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>();
                                                ResourceFolderRepository.this.addIds(xmlTag, items2, result2);
                                                Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                                synchronized (object) {
                                                    PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                                    ResourceFolderRepository.this.removeItemsForTag(psiResourceFile, xmlTag, ResourceType.ID);
                                                    for (PsiResourceItem item2 : items2) {
                                                        psiResourceFile.addItem(item2);
                                                    }
                                                    ResourceFolderRepository.this.commitToRepositoryWithoutLock(result2);
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                }
                                            });
                                            return;
                                        }
                                    }
                                } else if (parent3 instanceof XmlAttributeValue) {
                                    PsiElement grandParent = parent3.getParent();
                                    if (grandParent instanceof XmlProcessingInstruction) {
                                        return;
                                    }
                                    assert (grandParent instanceof XmlAttribute) : parent3;
                                    XmlAttribute attribute3 = (XmlAttribute)grandParent;
                                    XmlTag xmlTag = attribute3.getParent();
                                    String oldText = StringUtil.notNullize((String)event2.getOldChild().getText()).trim();
                                    String newText = StringUtil.notNullize((String)event2.getNewChild().getText()).trim();
                                    ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " oldText: \"" + oldText + "\" newText: \"" + newText + "\"");
                                    if (oldText.startsWith("@+id/") || newText.startsWith("@+id/")) {
                                        ResourceUrl newResourceUrl;
                                        ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                        if (!(resourceFile instanceof PsiResourceFile)) {
                                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                                            return;
                                        }
                                        ResourceUrl oldResourceUrl = ResourceUrl.parse((String)oldText);
                                        if (Objects.equals(oldResourceUrl, newResourceUrl = ResourceUrl.parse((String)newText))) {
                                            return;
                                        }
                                        ResourceFolderRepository.this.scheduleUpdate(() -> {
                                            if (!xmlTag.isValid()) {
                                                ResourceFolderRepository.this.scan(psiFile, folderType);
                                                return;
                                            }
                                            HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
                                            ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>();
                                            ResourceFolderRepository.this.addIds(xmlTag, items2, result2);
                                            Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                                ResourceFolderRepository.this.removeItemsForTag(psiResourceFile, xmlTag, ResourceType.ID);
                                                ResourceFolderRepository.this.commitToRepository(result2);
                                                for (PsiResourceItem item2 : items2) {
                                                    psiResourceFile.addItem(item2);
                                                }
                                                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, ResourceType.ID);
                                            }
                                        });
                                        return;
                                    }
                                }
                                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                return;
                            }
                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        } else if (folderType == ResourceFolderType.VALUES) {
                            PsiElement parent4 = event2.getParent();
                            if (parent4 instanceof XmlElement) {
                                if (parent4 instanceof XmlComment) {
                                    return;
                                }
                                if (parent4 instanceof XmlTag) {
                                    XmlTag parentTag = (XmlTag)parent4;
                                    if (IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                        if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                            return;
                                        }
                                        ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                        if (resourceItem instanceof PsiResourceItem) {
                                            if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                            }
                                            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " recomputed: " + resourceItem);
                                            return;
                                        }
                                    }
                                    if (parentTag.getName().equals("resources") && event2.getOldChild() instanceof XmlText && event2.getNewChild() instanceof XmlText) {
                                        return;
                                    }
                                }
                                if (parent4 instanceof XmlText) {
                                    XmlText text2 = (XmlText)parent4;
                                    this.handleValueXmlTextEdit((PsiElement)text2.getParentTag(), psiFile);
                                    return;
                                }
                                if (parent4 instanceof XmlAttributeValue) {
                                    PsiElement attribute4 = parent4.getParent();
                                    if (attribute4 instanceof XmlProcessingInstruction) {
                                        return;
                                    }
                                    PsiElement tag = attribute4.getParent();
                                    assert (attribute4 instanceof XmlAttribute) : attribute4;
                                    XmlAttribute xmlAttribute = (XmlAttribute)attribute4;
                                    assert (tag instanceof XmlTag) : tag;
                                    XmlTag xmlTag = (XmlTag)tag;
                                    String attributeName = xmlAttribute.getName();
                                    if (ResourceFolderRepository.isItemElement(xmlTag) && attributeName.equals("name")) {
                                        ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(xmlTag);
                                        if (type != null) {
                                            String oldName = event2.getOldChild().getText();
                                            String newName2 = event2.getNewChild().getText();
                                            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " oldName: \"" + oldName + "\" newName: \"" + newName2 + "\"");
                                            if (oldName.equals(newName2)) {
                                                return;
                                            }
                                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                                return;
                                            }
                                            ResourceFolderRepository.this.scheduleUpdate(() -> {
                                                XmlTag parentTag;
                                                if (!xmlTag.isValid()) {
                                                    ResourceFolderRepository.this.scan(psiFile, folderType);
                                                    return;
                                                }
                                                ResourceItem item2 = ResourceFolderRepository.this.findResourceItem(type, psiFile, oldName, xmlTag);
                                                if (item2 == null && ResourceFolderRepository.isValidValueResourceName(oldName)) {
                                                    ResourceFolderRepository.this.scan(psiFile, folderType);
                                                    return;
                                                }
                                                Object object = AbstractResourceRepositoryWithLocking.ITEM_MAP_LOCK;
                                                synchronized (object) {
                                                    ListMultimap<String, ResourceItem> items2 = ResourceFolderRepository.this.myResourceTable.get(type);
                                                    if (items2 == null) {
                                                        ResourceFolderRepository.this.scan(psiFile, folderType);
                                                        return;
                                                    }
                                                    if (item2 != null) {
                                                        items2.remove((Object)oldName, (Object)item2);
                                                    }
                                                    if (ResourceFolderRepository.isValidValueResourceName(newName2)) {
                                                        PsiResourceItem newItem = PsiResourceItem.forXmlTag(newName2, type, ResourceFolderRepository.this, xmlTag);
                                                        items2.put((Object)newName2, (Object)newItem);
                                                        ResourceItemSource resourceFile = (ResourceItemSource)ResourceFolderRepository.this.mySources.get(psiFile.getVirtualFile());
                                                        if (resourceFile != null) {
                                                            PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                                                            if (item2 != null) {
                                                                psiResourceFile.removeItem((PsiResourceItem)item2);
                                                            }
                                                            psiResourceFile.addItem(newItem);
                                                        } else assert (false) : item2;
                                                    }
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches((SingleNamespaceResourceRepository)ResourceFolderRepository.this, type);
                                                }
                                                if (type == ResourceType.ATTR && (parentTag = xmlTag.getParentTag()) != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) == ResourceType.STYLEABLE) {
                                                    ResourceItem style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                                    if (style instanceof PsiResourceItem) {
                                                        ((PsiResourceItem)style).recomputeValue();
                                                    }
                                                    ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " recomputed: " + style);
                                                }
                                            });
                                            return;
                                        }
                                        XmlTag parentTag = xmlTag.getParentTag();
                                        if (parentTag != null && IdeResourcesUtil.getResourceTypeForResourceTag(parentTag) != null) {
                                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                                return;
                                            }
                                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                            if (resourceItem instanceof PsiResourceItem) {
                                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                }
                                                ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " recomputed: " + resourceItem);
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                            ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        } else if (folderType == ResourceFolderType.COLOR) {
                            PsiElement parent5 = event2.getParent();
                            if (parent5 instanceof XmlElement) {
                                PsiElement attribute5;
                                if (parent5 instanceof XmlComment) {
                                    return;
                                }
                                if (parent5 instanceof XmlAttributeValue && (attribute5 = parent5.getParent()) instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                return;
                            }
                        } else if (folderType == ResourceFolderType.FONT) {
                            ResourceFolderRepository.this.clearFontCache(psiFile.getVirtualFile());
                        } else if (folderType != null && (parent2 = event2.getParent()) instanceof XmlElement) {
                            if (parent2 instanceof XmlComment) {
                                return;
                            }
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                        }
                    }
                }
                this.myIgnoreChildrenChanged = true;
            }
            finally {
                ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childReplaced " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " end");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean rescheduleScanIfRunning(@NotNull VirtualFile virtualFile) {
            Object object = ResourceFolderRepository.this.scanLock;
            synchronized (object) {
                if (ResourceFolderRepository.this.pendingScans.contains(virtualFile)) {
                    ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".rescheduleScanIfRunning " + ResourceFolderRepository.this.pathForLogging(virtualFile) + " scan is already pending");
                    return true;
                }
                if (ResourceFolderRepository.this.runningScans.containsKey(virtualFile)) {
                    ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".rescheduleScanIfRunning " + ResourceFolderRepository.this.pathForLogging(virtualFile) + " rescheduling scan");
                    ResourceFolderRepository.this.scheduleScan(virtualFile);
                    return true;
                }
            }
            return false;
        }

        private void handleValueXmlTextEdit(@Nullable PsiElement parent2, @NotNull PsiFile psiFile) {
            XmlTag style;
            if (!(parent2 instanceof XmlTag)) {
                return;
            }
            XmlTag parentTag = (XmlTag)parent2;
            String parentTagName = parentTag.getName();
            if (parentTagName.equals("resources")) {
                return;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (parentTagName.equals("item") && (style = parentTag.getParentTag()) != null && ResourceType.fromXmlTagName((String)style.getName()) != null) {
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile);
                assert (folderType != null);
                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                    return;
                }
                ResourceFolderRepository.this.scheduleUpdate(() -> {
                    if (!style.isValid()) {
                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        return;
                    }
                    ResourceItem item2 = ResourceFolderRepository.this.findValueResourceItem(style, psiFile);
                    if (item2 instanceof PsiResourceItem) {
                        boolean cleared = ((PsiResourceItem)item2).recomputeValue();
                        if (cleared) {
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                        }
                        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".handleValueXmlTextEdit " + ResourceFolderRepository.this.pathForLogging(virtualFile) + " recomputed: " + item2);
                    }
                });
                return;
            }
            XmlTag itemTag = ResourceFolderRepository.this.findItemElement(parentTag);
            if (itemTag != null) {
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile);
                assert (folderType != null);
                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                    return;
                }
                ResourceFolderRepository.this.scheduleUpdate(() -> {
                    if (!itemTag.isValid()) {
                        ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                        return;
                    }
                    ResourceItem item2 = ResourceFolderRepository.this.findValueResourceItem(itemTag, psiFile);
                    if (item2 instanceof PsiResourceItem) {
                        boolean cleared = ((PsiResourceItem)item2).recomputeValue();
                        if (cleared) {
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                        }
                        ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".handleValueXmlTextEdit " + ResourceFolderRepository.this.pathForLogging(virtualFile) + " recomputed: " + item2);
                    }
                });
            }
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event2) {
            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".beforeChildrenChange " + ResourceFolderRepository.this.pathForLogging(event2.getFile()));
            this.myIgnoreChildrenChanged = false;
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event2) {
            PsiElement firstChild;
            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event2.getFile()));
            PsiElement parent2 = event2.getParent();
            if (this.myIgnoreChildrenChanged) {
                if (parent2 != event2.getChild()) {
                    ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " event already processed");
                    return;
                }
            } else if (event2 instanceof PsiTreeChangeEventImpl && ((PsiTreeChangeEventImpl)event2).isGenericChange()) {
                ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " generic change");
                return;
            }
            PsiElement psiElement = firstChild = parent2 != null && !(parent2 instanceof PsiFile) ? parent2.getFirstChild() : null;
            if (firstChild instanceof PsiWhiteSpace && firstChild == parent2.getLastChild()) {
                ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " white space");
                return;
            }
            PsiFile psiFile = event2.getFile();
            if (psiFile != null && AndroidFileChangeListener.isRelevantFile(psiFile)) {
                ResourceFolderType folderType;
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile != null && (folderType = IdeResourcesUtil.getFolderType(psiFile)) != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    ResourceFolderRepository.this.scheduleScan(virtualFile, folderType);
                }
            } else if (LOG.isDebugEnabled()) {
                Throwable throwable = new Throwable();
                throwable.fillInStackTrace();
                LOG.debug("Received unexpected childrenChanged event for inter-file operations", throwable);
            }
            ResourceUpdateTracer.log(() -> TraceUtils.getSimpleId((Object)((Object)this)) + ".childrenChanged " + ResourceFolderRepository.this.pathForLogging(event2.getFile()) + " end");
        }
    }

    private static class Loader
    extends RepositoryLoader<ResourceFolderRepository> {
        @NotNull
        private final ResourceFolderRepository myRepository;
        @NotNull
        private final VirtualFile myResourceDir;
        @NotNull
        private final PsiManager myPsiManager;
        @Nullable
        private final ResourceFolderRepositoryCachingData myCachingData;
        @NotNull
        private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResources = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);
        @NotNull
        private final Map<VirtualFile, ResourceItemSource<BasicResourceItem>> mySources = new HashMap<VirtualFile, ResourceItemSource<BasicResourceItem>>();
        @NotNull
        private final Map<VirtualFile, BasicFileResourceItem> myFileResources = new HashMap<VirtualFile, BasicFileResourceItem>();
        @Nullable
        private VirtualFile myLastVirtualFile;
        @Nullable
        private PathString myLastPathString;
        @NotNull
        Set<VirtualFile> myFilesToReparseAsPsi = new HashSet<VirtualFile>();
        private final FileDocumentManager myFileDocumentManager;

        Loader(@NotNull ResourceFolderRepository repository2, @Nullable ResourceFolderRepositoryCachingData cachingData) {
            super(VfsUtilCore.virtualToIoFile((VirtualFile)repository2.myResourceDir).toPath(), null, repository2.getNamespace());
            this.myRepository = repository2;
            this.myResourceDir = repository2.myResourceDir;
            this.myPsiManager = repository2.myPsiManager;
            this.myCachingData = cachingData;
            this.myDefaultVisibility = ResourceVisibility.UNDEFINED;
            this.myFileDocumentManager = FileDocumentManager.getInstance();
        }

        public void load() {
            Executor executor2;
            if (!this.myResourceDir.isValid()) {
                return;
            }
            this.loadFromPersistentCache();
            ApplicationManager.getApplication().runReadAction(this::getPsiDirsForListener);
            this.scanResFolder();
            this.populateRepository();
            ApplicationManager.getApplication().runReadAction(this::scanQueuedPsiResources);
            if (this.myCachingData != null && !this.myRepository.hasFreshFileCache() && (executor2 = this.myCachingData.getCacheCreationExecutor()) != null) {
                executor2.execute(this::createCacheFile);
            }
        }

        private void loadFromPersistentCache() {
            if (this.myCachingData == null) {
                return;
            }
            byte[] fileHeader = this.getCacheFileHeader(this.myCachingData);
            try (Base128InputStream stream2 = new Base128InputStream(this.myCachingData.getCacheFile());){
                if (!stream2.validateContents(fileHeader)) {
                    return;
                }
                ResourceSerializationUtil.readResourcesFromStream((Base128InputStream)stream2, (Map)Maps.newHashMapWithExpectedSize((int)1000), null, (LoadableResourceRepository)this.myRepository, item2 -> this.addResourceItem((BasicResourceItem)item2, this.myRepository));
            }
            catch (NoSuchFileException stream2) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                this.mySources.clear();
                this.myFileResources.clear();
                LOG.warn("Failed to load resources from cache file " + this.myCachingData.getCacheFile(), e);
            }
        }

        protected byte[] getCacheFileHeader(@NotNull ResourceFolderRepositoryCachingData cachingData) {
            return ResourceSerializationUtil.getCacheFileHeader(stream -> {
                stream.write(CACHE_FILE_HEADER);
                stream.writeString(ResourceFolderRepository.CACHE_FILE_FORMAT_VERSION);
                stream.writeString(this.myResourceDir.getPath());
                stream.writeString(cachingData.getCodeVersion());
            });
        }

        private void createCacheFile() {
            assert (this.myCachingData != null);
            byte[] header = this.getCacheFileHeader(this.myCachingData);
            try {
                ResourceSerializationUtil.createPersistentCache((Path)this.myCachingData.getCacheFile(), (byte[])header, stream -> ResourceSerializationUtil.writeResourcesToStream(this.myResources, (Base128OutputStream)stream, config2 -> true));
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void scanResFolder() {
            try {
                void var3_8;
                VirtualFile[] virtualFileArray = this.myResourceDir.getChildren();
                int n = virtualFileArray.length;
                boolean bl = false;
                while (var3_8 < n) {
                    String folderName;
                    RepositoryLoader.FolderInfo folderInfo;
                    VirtualFile subDir = virtualFileArray[var3_8];
                    if (subDir.isValid() && subDir.isDirectory() && (folderInfo = RepositoryLoader.FolderInfo.create((String)(folderName = subDir.getName()), (Map)this.myFolderConfigCache)) != null) {
                        RepositoryConfiguration configuration = this.getConfiguration(this.myRepository, folderInfo.configuration);
                        for (VirtualFile file3 : subDir.getChildren()) {
                            if (file3.getName().startsWith(".")) continue;
                            if (this.myFileDocumentManager.isFileModified(file3)) {
                                this.myFilesToReparseAsPsi.add(file3);
                                continue;
                            }
                            if (folderInfo.folderType == ResourceFolderType.VALUES ? this.mySources.containsKey(file3) : this.myFileResources.containsKey(file3)) {
                                if (!Loader.isParsableFile(file3, folderInfo)) continue;
                                this.countCacheHit();
                                continue;
                            }
                            PathString pathString = FileExtensions.toPathString(file3);
                            this.myLastVirtualFile = file3;
                            this.myLastPathString = pathString;
                            try {
                                this.loadResourceFile(pathString, folderInfo, configuration);
                                if (!Loader.isParsableFile(file3, folderInfo)) continue;
                                this.countCacheMiss();
                            }
                            catch (ParsingException e) {
                                this.myFilesToReparseAsPsi.add(file3);
                            }
                        }
                    }
                    ++var3_8;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile, (Throwable)e);
            }
            super.finishLoading((LoadableResourceRepository)this.myRepository);
            for (Map.Entry<VirtualFile, BasicFileResourceItem> entry : this.myFileResources.entrySet()) {
                VirtualFile virtualFile = entry.getKey();
                BasicFileResourceItem item2 = entry.getValue();
                ResourceItemSource source = this.mySources.computeIfAbsent(virtualFile, file2 -> new VfsResourceFile((VirtualFile)file2, item2.getRepositoryConfiguration()));
                source.addItem(item2);
            }
            ArrayList<ResourceItemSource<BasicResourceItem>> sortedSources = new ArrayList<ResourceItemSource<BasicResourceItem>>(this.mySources.values());
            sortedSources.sort(SOURCE_COMPARATOR);
            for (ResourceItemSource resourceItemSource : sortedSources) {
                for (ResourceItem item3 : resourceItemSource) {
                    this.getOrCreateMap(item3.getType()).put((Object)item3.getName(), (Object)item3);
                }
            }
        }

        private void loadResourceFile(@NotNull PathString file2, @NotNull RepositoryLoader.FolderInfo folderInfo, @NotNull RepositoryConfiguration configuration) {
            if (folderInfo.resourceType == null) {
                if (Loader.isXmlFile((PathString)file2)) {
                    this.parseValueResourceFile(file2, configuration);
                }
            } else if (this.myRepository.checkResourceFilename(file2, folderInfo.folderType)) {
                if (Loader.isXmlFile((PathString)file2) && folderInfo.isIdGenerating) {
                    this.parseIdGeneratingResourceFile(file2, configuration);
                }
                BasicFileResourceItem item2 = this.createFileResourceItem(file2, folderInfo.resourceType, configuration, folderInfo.isIdGenerating);
                this.addResourceItem((BasicResourceItem)item2, (ResourceFolderRepository)item2.getRepository());
            }
        }

        private static boolean isParsableFile(@NotNull VirtualFile file2, @NotNull RepositoryLoader.FolderInfo folderInfo) {
            return (folderInfo.folderType == ResourceFolderType.VALUES || folderInfo.isIdGenerating) && Loader.isXmlFile((String)file2.getName());
        }

        private void populateRepository() {
            this.myRepository.mySources.putAll(this.mySources);
            this.myRepository.commitToRepositoryWithoutLock(this.myResources);
        }

        @NotNull
        private ListMultimap<String, ResourceItem> getOrCreateMap(@NotNull ResourceType resourceType) {
            return this.myResources.computeIfAbsent(resourceType, type -> LinkedListMultimap.create());
        }

        @NotNull
        protected InputStream getInputStream(@NotNull PathString file2) throws IOException {
            VirtualFile virtualFile = this.getVirtualFile(file2);
            if (virtualFile == null) {
                throw new NoSuchFileException(file2.getNativePath());
            }
            return virtualFile.getInputStream();
        }

        @Nullable
        private VirtualFile getVirtualFile(@NotNull PathString file2) {
            return file2.equals((Object)this.myLastPathString) ? this.myLastVirtualFile : FileExtensions.toVirtualFile(file2);
        }

        private void getPsiDirsForListener() {
            PsiDirectory resourceDirPsi = this.myPsiManager.findDirectory(this.myResourceDir);
            if (resourceDirPsi != null) {
                resourceDirPsi.getSubdirectories();
            }
        }

        protected void addResourceItem(@NotNull BasicResourceItem item2, @NotNull ResourceFolderRepository repository2) {
            if (item2 instanceof BasicValueResourceItemBase) {
                VfsResourceFile sourceFile = (VfsResourceFile)((BasicValueResourceItemBase)item2).getSourceFile();
                VirtualFile virtualFile = sourceFile.getVirtualFile();
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    sourceFile.addItem(item2);
                    this.mySources.put(virtualFile, sourceFile);
                }
            } else if (item2 instanceof VfsFileResourceItem) {
                VfsFileResourceItem fileResourceItem = (VfsFileResourceItem)item2;
                VirtualFile virtualFile = fileResourceItem.getVirtualFile();
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    this.myFileResources.put(virtualFile, fileResourceItem);
                }
            } else if (item2 instanceof BasicFileResourceItem) {
                BasicFileResourceItem fileResourceItem = (BasicFileResourceItem)item2;
                VirtualFile virtualFile = this.getVirtualFile(fileResourceItem.getSource());
                if (virtualFile != null && virtualFile.isValid() && !virtualFile.isDirectory()) {
                    this.myFileResources.put(virtualFile, fileResourceItem);
                }
            } else {
                throw new IllegalArgumentException("Unexpected type: " + item2.getClass().getName());
            }
        }

        @NotNull
        private BasicFileResourceItem createFileResourceItem(@NotNull PathString file2, @NotNull ResourceType resourceType, @NotNull RepositoryConfiguration configuration, boolean idGenerating) {
            DensityQualifier densityQualifier;
            String resourceName = SdkUtils.fileNameToResourceName((String)file2.getFileName());
            ResourceVisibility visibility = this.getVisibility(resourceType, resourceName);
            Density density = null;
            if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)resourceType) && (densityQualifier = configuration.getFolderConfiguration().getDensityQualifier()) != null) {
                density = densityQualifier.getValue();
            }
            return this.createFileResourceItem(file2, resourceType, resourceName, configuration, visibility, density, idGenerating);
        }

        @NotNull
        protected ResourceSourceFile createResourceSourceFile(@NotNull PathString file2, @NotNull RepositoryConfiguration configuration) {
            VirtualFile virtualFile = this.getVirtualFile(file2);
            return new VfsResourceFile(virtualFile, configuration);
        }

        @NotNull
        private BasicFileResourceItem createFileResourceItem(@NotNull PathString file2, @NotNull ResourceType type, @NotNull String name2, @NotNull RepositoryConfiguration configuration, @NotNull ResourceVisibility visibility, @Nullable Density density, boolean idGenerating) {
            if (!idGenerating) {
                return super.createFileResourceItem(file2, type, name2, configuration, visibility, density);
            }
            VirtualFile virtualFile = this.getVirtualFile(file2);
            String relativePath = this.getResRelativePath(file2);
            return density == null ? new VfsFileResourceItem(type, name2, configuration, visibility, relativePath, virtualFile) : new VfsDensityBasedFileResourceItem(type, name2, configuration, visibility, relativePath, virtualFile, density);
        }

        protected void handleParsingError(@NotNull PathString file2, @NotNull Exception e) {
            throw new ParsingException(e);
        }

        private void scanQueuedPsiResources() {
            for (VirtualFile file2 : this.myFilesToReparseAsPsi) {
                this.myRepository.scan(file2);
            }
        }

        private void countCacheHit() {
            ++this.myRepository.myNumXmlFilesLoadedInitially;
        }

        private void countCacheMiss() {
            ++this.myRepository.myNumXmlFilesLoadedInitially;
            ++this.myRepository.myNumXmlFilesLoadedInitiallyFromSources;
        }
    }

    private static class ParsingException
    extends RuntimeException {
        ParsingException(Throwable cause) {
            super(cause);
        }
    }
}

