/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceUpdateTracer;
import com.android.utils.TraceUtils;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SameThreadExecutor;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class MultiResourceRepository
extends LocalResourceRepository
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MultiResourceRepository.class);
    @NotNull
    private ImmutableList<LocalResourceRepository> myLocalResources = ImmutableList.of();
    @NotNull
    private ImmutableList<AarResourceRepository> myLibraryResources = ImmutableList.of();
    @NotNull
    private ImmutableList<ResourceRepository> myChildren = ImmutableList.of();
    @NotNull
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myLeafsByNamespace = ImmutableListMultimap.of();
    @NotNull
    private ImmutableListMultimap<ResourceNamespace, SingleNamespaceResourceRepository> myRepositoriesByNamespace = ImmutableListMultimap.of();
    @NotNull
    private ResourceItemComparator myResourceComparator = new ResourceItemComparator(new ResourcePriorityComparator((Collection<SingleNamespaceResourceRepository>)ImmutableList.of()));
    private long[] myModificationCounts;
    private final ResourceTable myCachedMaps = new ResourceTable();
    private final Table<SingleNamespaceResourceRepository, ResourceType, Set<String>> myResourceNames = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));
    private final Table<ResourceNamespace, ResourceType, Set<SingleNamespaceResourceRepository>> myUnreconciledResources = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));

    MultiResourceRepository(@NotNull String displayName2) {
        super(displayName2);
        LowMemoryWatcher.register(this::onLowMemory, (Disposable)this);
        ResourceUpdateTracer.logDirect(() -> "Created " + TraceUtils.getSimpleId((Object)this) + " " + displayName2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(@NotNull List<? extends LocalResourceRepository> localResources, @NotNull Collection<? extends AarResourceRepository> libraryResources, @NotNull Collection<? extends ResourceRepository> otherResources) {
        ResourceUpdateTracer.logDirect(() -> TraceUtils.getSimpleId((Object)this) + ".setChildren([" + TraceUtils.getSimpleIds((Iterable)localResources) + "], ...)");
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository child : this.myLocalResources) {
                child.removeParent(this);
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.myLocalResources = ImmutableList.copyOf(localResources);
            this.myLibraryResources = ImmutableList.copyOf(libraryResources);
            int size = this.myLocalResources.size() + this.myLibraryResources.size() + otherResources.size();
            this.myChildren = ImmutableList.builderWithExpectedSize((int)size).addAll(this.myLocalResources).addAll(this.myLibraryResources).addAll(otherResources).build();
            ImmutableListMultimap.Builder mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeLeafs(this, (ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository>)mapBuilder);
            this.myLeafsByNamespace = mapBuilder.build();
            mapBuilder = ImmutableListMultimap.builder();
            MultiResourceRepository.computeNamespaceMap(this, (ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository>)mapBuilder);
            this.myRepositoriesByNamespace = mapBuilder.build();
            this.myResourceComparator = new ResourceItemComparator(new ResourcePriorityComparator((Collection<SingleNamespaceResourceRepository>)this.myLeafsByNamespace.values()));
            this.myModificationCounts = new long[localResources.size()];
            if (localResources.size() == 1) {
                LocalResourceRepository child = localResources.get(0);
                child.setModificationCount(this.getModificationCount());
            }
            int i = 0;
            for (LocalResourceRepository child : this.myLocalResources) {
                child.addParent(this);
                this.myModificationCounts[i++] = child.getModificationCount();
            }
            this.myCachedMaps.clear();
            this.invalidateParentCaches();
        }
    }

    private static void computeLeafs(@NotNull ResourceRepository repository2, @NotNull ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository2 instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository2).myChildren) {
                MultiResourceRepository.computeLeafs(child, result2);
            }
        } else {
            for (SingleNamespaceResourceRepository resourceRepository : repository2.getLeafResourceRepositories()) {
                result2.put((Object)resourceRepository.getNamespace(), (Object)resourceRepository);
            }
        }
    }

    private static void computeNamespaceMap(@NotNull ResourceRepository repository2, @NotNull ImmutableListMultimap.Builder<ResourceNamespace, SingleNamespaceResourceRepository> result2) {
        if (repository2 instanceof SingleNamespaceResourceRepository) {
            SingleNamespaceResourceRepository singleNamespaceRepository = (SingleNamespaceResourceRepository)repository2;
            ResourceNamespace namespace = singleNamespaceRepository.getNamespace();
            result2.put((Object)namespace, (Object)singleNamespaceRepository);
        } else if (repository2 instanceof MultiResourceRepository) {
            for (ResourceRepository child : ((MultiResourceRepository)repository2).myChildren) {
                MultiResourceRepository.computeNamespaceMap(child, result2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<LocalResourceRepository> getLocalResources() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLocalResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<AarResourceRepository> getLibraryResources() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLibraryResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ResourceRepository> getChildren() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<SingleNamespaceResourceRepository> getRepositoriesForNamespace(@NotNull ResourceNamespace namespace) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myRepositoriesByNamespace.get((Object)namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationCount() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myLocalResources.size() == 1) {
                return ((LocalResourceRepository)this.myLocalResources.get(0)).getModificationCount();
            }
            boolean changed = false;
            for (int i = 0; i < this.myLocalResources.size(); ++i) {
                LocalResourceRepository child = (LocalResourceRepository)this.myLocalResources.get(i);
                long rev = child.getModificationCount();
                if (rev == this.myModificationCounts[i]) continue;
                this.myModificationCounts[i] = rev;
                changed = true;
            }
            if (changed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            return super.getModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<ResourceNamespace> getNamespaces() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myRepositoriesByNamespace.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceNamespace namespace : this.getNamespaces()) {
                if (!visitor2.shouldVisitNamespace(namespace)) continue;
                for (ResourceType type : ResourceType.values()) {
                    ListMultimap<String, ResourceItem> map2;
                    if (!visitor2.shouldVisitResourceType(type) || (map2 = this.getMap(namespace, type)) == null) continue;
                    for (ResourceItem item2 : map2.values()) {
                        if (visitor2.visit(item2) != ResourceVisitor.VisitResult.ABORT) continue;
                        return ResourceVisitor.VisitResult.ABORT;
                    }
                }
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        Stopwatch stopwatch;
        ImmutableList repositoriesForNamespace = this.myLeafsByNamespace.get((Object)namespace);
        if (repositoriesForNamespace.size() == 1) {
            SingleNamespaceResourceRepository repository2 = (SingleNamespaceResourceRepository)repositoriesForNamespace.get(0);
            return MultiResourceRepository.getResourcesUnderLock(repository2, namespace, type);
        }
        ListMultimap map2 = (ListMultimap)this.myCachedMaps.get((Object)namespace, (Object)type);
        Set unreconciledRepositories = null;
        if (map2 != null && (unreconciledRepositories = (Set)this.myUnreconciledResources.get((Object)namespace, (Object)type)) == null) {
            return map2;
        }
        Object object = stopwatch = LOG.isDebugEnabled() ? Stopwatch.createStarted() : null;
        if (map2 == null) {
            for (SingleNamespaceResourceRepository repository3 : repositoriesForNamespace) {
                ListMultimap<String, ResourceItem> items2 = MultiResourceRepository.getResourcesUnderLock(repository3, namespace, type);
                if (items2.isEmpty()) continue;
                if (map2 == null) {
                    map2 = type == ResourceType.STYLEABLE || type == ResourceType.ID ? ArrayListMultimap.create() : new PerConfigResourceMap(this.myResourceComparator);
                    this.myCachedMaps.put((Object)namespace, (Object)type, (Object)map2);
                }
                map2.putAll(items2);
                if (!(repository3 instanceof LocalResourceRepository)) continue;
                this.myResourceNames.put((Object)repository3, (Object)type, (Object)ImmutableSet.copyOf((Collection)items2.keySet()));
            }
        } else {
            for (SingleNamespaceResourceRepository unreconciledRepository : unreconciledRepositories) {
                Predicate<ResourceItem> filter2 = item2 -> item2.getRepository().equals(unreconciledRepository);
                Set names = (Set)this.myResourceNames.get((Object)unreconciledRepository, (Object)type);
                if (names != null) {
                    PerConfigResourceMap perConfigMap = map2 instanceof PerConfigResourceMap ? (PerConfigResourceMap)map2 : null;
                    for (String name2 : names) {
                        if (perConfigMap != null) {
                            perConfigMap.removeIf(name2, filter2);
                            continue;
                        }
                        List items3 = map2.get((Object)name2);
                        items3.removeIf(filter2);
                        if (!items3.isEmpty()) continue;
                        map2.removeAll((Object)name2);
                    }
                }
                ListMultimap<String, ResourceItem> unreconciledResources = MultiResourceRepository.getResourcesUnderLock(unreconciledRepository, namespace, type);
                map2.putAll(unreconciledResources);
                assert (unreconciledRepository instanceof LocalResourceRepository);
                this.myResourceNames.put((Object)unreconciledRepository, (Object)type, (Object)ImmutableSet.copyOf((Collection)unreconciledResources.keySet()));
                if (!map2.isEmpty()) continue;
                this.myCachedMaps.remove((Object)namespace, (Object)type);
            }
            this.myUnreconciledResources.remove((Object)namespace, (Object)type);
        }
        if (stopwatch != null) {
            LOG.debug(String.format(Locale.US, "Merged %d resources of type %s in %s for %s.", map2 == null ? 0 : map2.size(), type, stopwatch, this.getClass().getSimpleName()));
        }
        return map2;
    }

    @NotNull
    private static ListMultimap<String, ResourceItem> getResourcesUnderLock(@NotNull SingleNamespaceResourceRepository repository2, @NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (repository2 instanceof LocalResourceRepository) {
            ListMultimap<String, ResourceItem> map2 = ((LocalResourceRepository)repository2).getMapPackageAccessible(namespace, type);
            return map2 == null ? ImmutableListMultimap.of() : map2;
        }
        return repository2.getResources(namespace, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository child : this.myLocalResources) {
                child.removeParent(this);
            }
        }
    }

    public void invalidateCache() {
        this.clearCachedData();
        this.setModificationCount(ourModificationCounter.incrementAndGet());
        this.invalidateParentCaches();
    }

    private void clearCachedData() {
        this.myCachedMaps.clear();
        this.myResourceNames.clear();
        this.myUnreconciledResources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLowMemory() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.clearCachedData();
        }
        LOG.warn(this.getDisplayName() + ": Cached data cleared due to low memory");
    }

    public void invalidateCache(@NotNull SingleNamespaceResourceRepository repository2, ResourceType ... types2) {
        ResourceNamespace namespace = repository2.getNamespace();
        ImmutableList leafs = this.myLeafsByNamespace.get((Object)namespace);
        if (leafs.contains((Object)repository2)) {
            if (leafs.size() != 1) {
                for (ResourceType type : types2) {
                    if (this.myCachedMaps.get((Object)namespace, (Object)type) == null) continue;
                    HashSet<SingleNamespaceResourceRepository> repositories = (HashSet<SingleNamespaceResourceRepository>)this.myUnreconciledResources.get((Object)namespace, (Object)type);
                    if (repositories == null) {
                        repositories = new HashSet<SingleNamespaceResourceRepository>();
                        this.myUnreconciledResources.put((Object)namespace, (Object)type, repositories);
                    }
                    repositories.add(repository2);
                }
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            this.invalidateParentCaches(repository2, types2);
        }
    }

    @Override
    public void invokeAfterPendingUpdatesFinish(@NotNull Executor executor2, @NotNull Runnable callback2) {
        ImmutableList<LocalResourceRepository> repositories = this.getLocalResources();
        AtomicInteger count2 = new AtomicInteger(repositories.size());
        for (LocalResourceRepository childRepository : repositories) {
            childRepository.invokeAfterPendingUpdatesFinish(SameThreadExecutor.INSTANCE, () -> {
                if (count2.decrementAndGet() == 0) {
                    executor2.execute(callback2);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
            for (LocalResourceRepository resourceRepository : this.myLocalResources) {
                result2.addAll(resourceRepository.computeResourceDirs());
            }
            return result2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return this.myLeafsByNamespace.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public int getFileRescans() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            int count2 = 0;
            for (LocalResourceRepository resourceRepository : this.myLocalResources) {
                count2 += resourceRepository.getFileRescans();
            }
            return count2;
        }
    }

    private static class ResourceItemComparator
    implements Comparator<ResourceItem> {
        private final Comparator<ResourceItem> myPriorityComparator;

        ResourceItemComparator(Comparator<ResourceItem> priorityComparator) {
            this.myPriorityComparator = priorityComparator;
        }

        @Override
        public int compare(@NotNull ResourceItem item1, @NotNull ResourceItem item2) {
            int c = item1.getConfiguration().compareTo(item2.getConfiguration());
            if (c != 0) {
                return c;
            }
            return this.myPriorityComparator.compare(item1, item2);
        }
    }

    private static class ResourcePriorityComparator
    implements Comparator<ResourceItem> {
        private final Object2IntMap<SingleNamespaceResourceRepository> repositoryOrdering;

        ResourcePriorityComparator(@NotNull Collection<SingleNamespaceResourceRepository> repositories) {
            this.repositoryOrdering = new Object2IntOpenHashMap(repositories.size());
            int i = 0;
            for (SingleNamespaceResourceRepository repository2 : repositories) {
                this.repositoryOrdering.put((Object)repository2, i++);
            }
        }

        @Override
        public int compare(@NotNull ResourceItem item1, @NotNull ResourceItem item2) {
            return Integer.compare(this.getOrdering(item1), this.getOrdering(item2));
        }

        private int getOrdering(@NotNull ResourceItem item2) {
            int ordering = this.repositoryOrdering.getInt((Object)item2.getRepository());
            assert (ordering >= 0);
            return ordering;
        }
    }

    private static class PerConfigResourceMap
    implements ListMultimap<String, ResourceItem> {
        private final Map<String, List<ResourceItem>> myMap = new HashMap<String, List<ResourceItem>>();
        private int mySize = 0;
        @NotNull
        private final ResourceItemComparator myComparator;
        @Nullable
        private Values myValues;

        private PerConfigResourceMap(@NotNull ResourceItemComparator comparator2) {
            this.myComparator = comparator2;
        }

        @NotNull
        public List<ResourceItem> get(@Nullable String key) {
            List<ResourceItem> items2 = this.myMap.get(key);
            return items2 == null ? ImmutableList.of() : items2;
        }

        @NotNull
        public Set<String> keySet() {
            return this.myMap.keySet();
        }

        @NotNull
        public Multiset<String> keys() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Collection<ResourceItem> values() {
            Values values = this.myValues;
            if (values == null) {
                this.myValues = values = new Values();
            }
            return values;
        }

        @NotNull
        public Collection<Map.Entry<String, ResourceItem>> entries() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public List<ResourceItem> removeAll(@Nullable Object key) {
            List<ResourceItem> removed = this.myMap.remove(key);
            if (removed != null) {
                this.mySize -= removed.size();
            }
            return removed == null ? ImmutableList.of() : removed;
        }

        boolean removeIf(@NotNull String key, @NotNull Predicate<? super ResourceItem> filter2) {
            List<ResourceItem> list2 = this.myMap.get(key);
            if (list2 == null) {
                return false;
            }
            int oldSize = list2.size();
            boolean removed = list2.removeIf(filter2);
            this.mySize += list2.size() - oldSize;
            if (list2.isEmpty()) {
                this.myMap.remove(key);
            }
            return removed;
        }

        public void clear() {
            this.myMap.clear();
            this.mySize = 0;
        }

        public int size() {
            return this.mySize;
        }

        public boolean isEmpty() {
            return this.mySize == 0;
        }

        public boolean containsKey(@Nullable Object key) {
            return this.myMap.containsKey(key);
        }

        public boolean containsValue(@Nullable Object value2) {
            throw new UnsupportedOperationException();
        }

        public boolean containsEntry(@Nullable Object key, @Nullable Object value2) {
            throw new UnsupportedOperationException();
        }

        public boolean put(@NotNull String key, @NotNull ResourceItem item2) {
            List list2 = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
            int oldSize = list2.size();
            list2.add(item2);
            this.mySize += list2.size() - oldSize;
            return true;
        }

        public boolean remove(@Nullable Object key, @Nullable Object value2) {
            throw new UnsupportedOperationException();
        }

        public boolean putAll(@NotNull String key, @NotNull Iterable<? extends ResourceItem> items2) {
            if (items2 instanceof Collection) {
                if (((Collection)items2).isEmpty()) {
                    return false;
                }
                List list2 = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
                int oldSize = list2.size();
                boolean added = list2.addAll((Collection)items2);
                this.mySize += list2.size() - oldSize;
                return added;
            }
            boolean added = false;
            List list3 = null;
            int oldSize = 0;
            for (ResourceItem resourceItem : items2) {
                if (list3 == null) {
                    list3 = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
                    oldSize = list3.size();
                }
                added = list3.add(resourceItem);
            }
            if (list3 != null) {
                this.mySize += list3.size() - oldSize;
            }
            return added;
        }

        public boolean putAll(Multimap<? extends String, ? extends ResourceItem> multimap) {
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                String key = (String)entry.getKey();
                Collection items2 = (Collection)entry.getValue();
                if (items2.isEmpty()) continue;
                List list2 = this.myMap.computeIfAbsent(key, k -> new PerConfigResourceList());
                int oldSize = list2.size();
                list2.addAll(items2);
                this.mySize += list2.size() - oldSize;
            }
            return !multimap.isEmpty();
        }

        @NotNull
        public List<ResourceItem> replaceValues(@Nullable String key, @NotNull Iterable<? extends ResourceItem> values) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Map<String, Collection<ResourceItem>> asMap() {
            return this.myMap;
        }

        private class Values
        extends AbstractCollection<ResourceItem> {
            private Values() {
            }

            @Override
            @NotNull
            public Iterator<ResourceItem> iterator() {
                return new ValuesIterator();
            }

            @Override
            public int size() {
                return PerConfigResourceMap.this.mySize;
            }

            private class ValuesIterator
            implements Iterator<ResourceItem> {
                private final Iterator<List<ResourceItem>> myOuterCursor;
                private List<ResourceItem> myCurrentList;
                private int myInnerCursor;

                private ValuesIterator() {
                    this.myOuterCursor = PerConfigResourceMap.this.myMap.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.myCurrentList != null || this.myOuterCursor.hasNext();
                }

                @Override
                public ResourceItem next() {
                    if (this.myCurrentList == null) {
                        this.myCurrentList = this.myOuterCursor.next();
                        this.myInnerCursor = 0;
                    }
                    try {
                        ResourceItem item2 = this.myCurrentList.get(this.myInnerCursor);
                        if (++this.myInnerCursor >= this.myCurrentList.size()) {
                            this.myCurrentList = null;
                        }
                        return item2;
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new NoSuchElementException();
                    }
                }
            }
        }

        private class PerConfigResourceList
        extends AbstractList<ResourceItem> {
            private final List<List<ResourceItem>> myResourceItems = new ArrayList<List<ResourceItem>>();

            private PerConfigResourceList() {
            }

            @Override
            @NotNull
            public ResourceItem get(int index2) {
                return this.myResourceItems.get(index2).get(0);
            }

            @Override
            public int size() {
                return this.myResourceItems.size();
            }

            @Override
            public boolean add(@NotNull ResourceItem item2) {
                this.add(item2, 0);
                return true;
            }

            @Override
            public boolean addAll(@NotNull Collection<? extends ResourceItem> items2) {
                if (items2.isEmpty()) {
                    return false;
                }
                if (items2.size() == 1) {
                    return this.add(items2.iterator().next());
                }
                List<ResourceItem> sortedItems = this.sortedItems(items2);
                int start2 = 0;
                for (ResourceItem item2 : sortedItems) {
                    start2 = this.add(item2, start2);
                }
                return true;
            }

            private int add(ResourceItem item2, int start2) {
                int index2 = this.findConfigIndex(item2, start2, this.myResourceItems.size());
                if (index2 < 0) {
                    this.myResourceItems.add(index2 ^= 0xFFFFFFFF, (List<ResourceItem>)new SmartList((Object)item2));
                } else {
                    List<ResourceItem> nested = this.myResourceItems.get(index2);
                    int i = nested.size();
                    while (--i >= 0 && PerConfigResourceMap.this.myComparator.myPriorityComparator.compare(item2, nested.get(i)) <= 0) {
                    }
                    nested.add(i + 1, item2);
                }
                return index2;
            }

            @Override
            public void clear() {
                this.myResourceItems.clear();
            }

            @Override
            public boolean remove(@Nullable Object item2) {
                assert (item2 != null);
                int index2 = this.remove((ResourceItem)item2, this.myResourceItems.size());
                return index2 >= 0;
            }

            @Override
            public boolean removeAll(@NotNull Collection<?> items2) {
                if (items2.isEmpty()) {
                    return false;
                }
                if (items2.size() == 1) {
                    return this.remove(items2.iterator().next());
                }
                List<ResourceItem> itemsToDelete = this.sortedItems(items2);
                boolean modified = false;
                int end = this.myResourceItems.size();
                int i = itemsToDelete.size();
                while (--i >= 0) {
                    int index2 = this.remove(itemsToDelete.get(i), end);
                    if (index2 > 0) {
                        modified = true;
                        end = index2;
                        continue;
                    }
                    end = ~index2;
                }
                return modified;
            }

            @Override
            public boolean removeIf(@NotNull Predicate<? super ResourceItem> filter2) {
                boolean removed = false;
                int i = this.myResourceItems.size();
                while (--i >= 0) {
                    List<ResourceItem> nested = this.myResourceItems.get(i);
                    int j = nested.size();
                    while (--j >= 0) {
                        ResourceItem item2 = nested.get(j);
                        if (!filter2.test((ResourceItem)item2)) continue;
                        nested.remove(j);
                        removed = true;
                    }
                    if (!nested.isEmpty()) continue;
                    this.myResourceItems.remove(i);
                }
                return removed;
            }

            private int remove(@NotNull ResourceItem item2, int end) {
                int index2 = this.findConfigIndex(item2, 0, end);
                if (index2 < 0) {
                    return index2;
                }
                List<ResourceItem> nested = this.myResourceItems.get(index2);
                if (!nested.remove(item2)) {
                    return ~(index2 + 1);
                }
                if (nested.isEmpty()) {
                    this.myResourceItems.remove(index2);
                    return index2;
                }
                return index2 + 1;
            }

            @NotNull
            private List<ResourceItem> sortedItems(@NotNull Collection<? extends ResourceItem> items2) {
                ArrayList<ResourceItem> sortedItems = new ArrayList<ResourceItem>(items2);
                sortedItems.sort(PerConfigResourceMap.this.myComparator);
                return sortedItems;
            }

            private int findConfigIndex(@NotNull ResourceItem item2, int start2, int end) {
                FolderConfiguration config2 = item2.getConfiguration();
                int low = start2;
                int high = end;
                while (low < high) {
                    int mid = low + high >>> 1;
                    FolderConfiguration value2 = this.myResourceItems.get(mid).get(0).getConfiguration();
                    int c = value2.compareTo(config2);
                    if (c < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (c > 0) {
                        high = mid;
                        continue;
                    }
                    return mid;
                }
                return ~low;
            }
        }
    }
}

