/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import org.jetbrains.annotations.NotNull;

class LoggingPsiTreeChangeListener
implements PsiTreeChangeListener {
    @NotNull
    private final PsiTreeChangeListener myWrappedListener;
    @NotNull
    private final Logger myLogger;

    LoggingPsiTreeChangeListener(@NotNull PsiTreeChangeListener wrappedListener, @NotNull Logger logger2) {
        this.myWrappedListener = wrappedListener;
        this.myLogger = logger2;
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.beforeChildAddition(event2);
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.beforeChildRemoval(event2);
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.beforeChildReplacement(event2);
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.beforeChildMovement(event2);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.beforeChildrenChange(event2);
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.beforePropertyChange(event2);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.childAdded(event2);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.childRemoved(event2);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.childReplaced(event2);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.childrenChanged(event2);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.childMoved(event2);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event2) {
        this.logEvent(event2);
        this.myWrappedListener.propertyChanged(event2);
    }

    private void logEvent(@NotNull PsiTreeChangeEvent event2) {
        this.myLogger.debug("Handling event ", new Object[]{event2});
    }
}

