/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.projectmodel.DynamicResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.res.DynamicValueResourceItem;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DynamicValueResourceRepository
extends LocalResourceRepository
implements Disposable,
SingleNamespaceResourceRepository {
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResourceTable = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);

    private DynamicValueResourceRepository(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace) {
        super("Gradle Dynamic");
        this.myFacet = facet2;
        this.myNamespace = namespace;
        assert (AndroidModel.isRequired(facet2));
    }

    private void registerListeners() {
        this.myFacet.getModule().getProject().getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
            if (result2.isSuccessful()) {
                this.notifyProjectSynced();
            }
        });
    }

    public void dispose() {
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myFacet);
    }

    @NotNull
    public static DynamicValueResourceRepository create(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace) {
        DynamicValueResourceRepository repository2 = new DynamicValueResourceRepository(facet2, namespace);
        try {
            repository2.registerListeners();
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)repository2);
            throw t;
        }
        return repository2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @NotNull
    public static DynamicValueResourceRepository createForTest(@NotNull AndroidFacet facet2, @NotNull ResourceNamespace namespace, @NotNull Map<String, DynamicResourceValue> values) {
        DynamicValueResourceRepository repository2 = new DynamicValueResourceRepository(facet2, namespace);
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            repository2.addValues(values);
        }
        Disposer.register((Disposable)facet2, (Disposable)repository2);
        return repository2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProjectSynced() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.myResourceTable.clear();
            this.invalidateParentCaches(this, ResourceType.values());
        }
    }

    private void addValues(@NotNull Map<String, DynamicResourceValue> resValues) {
        for (Map.Entry<String, DynamicResourceValue> entry : resValues.entrySet()) {
            DynamicResourceValue field2 = entry.getValue();
            String name2 = entry.getKey();
            ResourceType type = field2.getType();
            ArrayListMultimap map2 = this.myResourceTable.get(type);
            if (map2 == null) {
                map2 = ArrayListMultimap.create();
                this.myResourceTable.put(type, (ListMultimap<String, ResourceItem>)map2);
            } else if (map2.containsKey((Object)name2)) continue;
            DynamicValueResourceItem item2 = new DynamicValueResourceItem(this, type, name2, field2.getValue());
            map2.put((Object)name2, (Object)item2);
        }
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return null;
        }
        return this.getResourceTable().get(type);
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2.shouldVisitNamespace(this.myNamespace)) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (DynamicValueResourceRepository.acceptByResources(this.myResourceTable, (ResourceVisitor)visitor2) == ResourceVisitor.VisitResult.ABORT) {
                    return ResourceVisitor.VisitResult.ABORT;
                }
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @NotNull
    private Map<ResourceType, ListMultimap<String, ResourceItem>> getResourceTable() {
        AndroidModel androidModel;
        if (this.myResourceTable.isEmpty() && (androidModel = AndroidModel.get(this.myFacet.getModule())) != null) {
            this.addValues(androidModel.getResValues());
        }
        return this.myResourceTable;
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        return ImmutableSet.of();
    }
}

