/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.PredefinedSampleDataResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.StudioModuleClassLoaderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class AppResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;
    private final Object RESOURCE_MAP_LOCK = new Object();
    @Nullable
    private Collection<VirtualFile> myResourceDirs;

    @NotNull
    static AppResourceRepository create(@NotNull AndroidFacet facet2, @NotNull Collection<AarResourceRepository> libraryRepositories) {
        AppResourceRepository repository2 = new AppResourceRepository(facet2, AppResourceRepository.computeLocalRepositories(facet2), libraryRepositories);
        AndroidProjectRootListener.ensureSubscribed(facet2.getModule().getProject());
        return repository2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Collection<VirtualFile> getAllResourceDirs() {
        Object object = this.RESOURCE_MAP_LOCK;
        synchronized (object) {
            if (this.myResourceDirs == null) {
                ImmutableList.Builder result2 = ImmutableList.builder();
                for (LocalResourceRepository resourceRepository : this.getLocalResources()) {
                    result2.addAll(resourceRepository.getResourceDirs());
                }
                this.myResourceDirs = result2.build();
            }
            return this.myResourceDirs;
        }
    }

    private static List<LocalResourceRepository> computeLocalRepositories(@NotNull AndroidFacet facet2) {
        return ImmutableList.of((Object)StudioResourceRepositoryManager.getProjectResources(facet2), (Object)SampleDataResourceRepository.getInstance(facet2));
    }

    private AppResourceRepository(@NotNull AndroidFacet facet2, @NotNull List<LocalResourceRepository> localResources, @NotNull Collection<AarResourceRepository> libraryResources) {
        super(facet2.getModule().getName() + " with modules and libraries");
        this.myFacet = facet2;
        this.setChildren(localResources, libraryResources, (Collection<? extends ResourceRepository>)ImmutableList.of((Object)((Object)PredefinedSampleDataResourceRepository.getInstance())));
    }

    void updateRoots(@NotNull Collection<? extends AarResourceRepository> libraryResources) {
        List<LocalResourceRepository> localResources = AppResourceRepository.computeLocalRepositories(this.myFacet);
        this.updateRoots(localResources, libraryResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateRoots(@NotNull List<? extends LocalResourceRepository> localResources, @NotNull Collection<? extends AarResourceRepository> libraryResources) {
        Object object = this.RESOURCE_MAP_LOCK;
        synchronized (object) {
            this.myResourceDirs = null;
        }
        this.invalidateResourceDirs();
        this.setChildren(localResources, libraryResources, (Collection<? extends ResourceRepository>)ImmutableList.of((Object)((Object)PredefinedSampleDataResourceRepository.getInstance())));
        Module module2 = this.myFacet.getModule();
        ResourceIdManager.get(module2).resetDynamicIds();
        ResourceClassRegistry.get(module2.getProject()).clearCache();
        StudioModuleClassLoaderManager.get().clearCache(module2);
    }

    @TestOnly
    @NotNull
    static AppResourceRepository createForTest(@NotNull AndroidFacet facet2, @NotNull List<LocalResourceRepository> modules, @NotNull Collection<AarResourceRepository> libraries2) {
        AppResourceRepository repository2 = new AppResourceRepository(facet2, modules, libraries2);
        Disposer.register((Disposable)facet2, (Disposable)repository2);
        return repository2;
    }
}

