/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectRootListener {
    public static void ensureSubscribed(@NotNull Project project) {
        project.getService(AndroidProjectRootListener.class);
    }

    private AndroidProjectRootListener(final @NotNull Project project) {
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event2) {
                AndroidProjectRootListener.moduleRootsOrDependenciesChanged(project);
            }
        });
    }

    private static void moduleRootsOrDependenciesChanged(@NotNull Project project) {
        new MyDumbModeTask(project).queue(project);
    }

    private static void moduleRootsOrDependenciesChanged(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 != null) {
            if (AndroidModel.isRequired(facet2) && AndroidModel.get(facet2) == null) {
                return;
            }
            AndroidDependenciesCache.getInstance(module2).dropCache();
            ResourceFolderManager.getInstance(facet2).checkForChanges();
            StudioResourceRepositoryManager.getInstance(facet2).updateRootsAndLibraries();
        }
    }

    private static class MyDumbModeTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        private MyDumbModeTask(@NotNull Project project) {
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (!this.myProject.isDisposed()) {
                indicator.setText("Updating resource repository roots");
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
                for (Module module2 : moduleManager.getModules()) {
                    AndroidProjectRootListener.moduleRootsOrDependenciesChanged(module2);
                }
            }
        }

        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            if (taskFromQueue instanceof MyDumbModeTask && ((MyDumbModeTask)taskFromQueue).myProject.equals(this.myProject)) {
                return this;
            }
            return null;
        }
    }
}

