/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.projectmodel.ResourceFolder;
import com.android.resources.aar.AarProtoResourceRepository;
import com.android.resources.aar.AarResourceRepository;
import com.android.resources.aar.AarSourceResourceRepository;
import com.android.resources.aar.CachingData;
import com.android.tools.concurrency.AndroidIoManager;
import com.android.tools.idea.res.AarResourceRepositoryCache;
import com.android.tools.res.AndroidPluginVersion;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\tRN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/res/AarResourceRepositoryCache;", "", "()V", "myProtoRepositories", "Lcom/google/common/cache/Cache;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Lcom/android/resources/aar/AarProtoResourceRepository;", "mySourceRepositories", "Lcom/android/projectmodel/ResourceFolder;", "Lcom/android/resources/aar/AarSourceResourceRepository;", "clear", "", "createCachingData", "Lcom/android/resources/aar/CachingData;", "library", "Lcom/android/projectmodel/ExternalAndroidLibrary;", "getProtoRepository", "getSourceRepository", "removeProtoRepository", "resApkFile", "removeSourceRepository", "resourceFolder", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAarResourceRepositoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AarResourceRepositoryCache.kt\ncom/android/tools/idea/res/AarResourceRepositoryCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n8#2:148\n*S KotlinDebug\n*F\n+ 1 AarResourceRepositoryCache.kt\ncom/android/tools/idea/res/AarResourceRepositoryCache\n*L\n112#1:148\n*E\n"})
public final class AarResourceRepositoryCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Cache<Path, AarProtoResourceRepository> myProtoRepositories = CacheBuilder.newBuilder().softValues().build();
    private final Cache<ResourceFolder, AarSourceResourceRepository> mySourceRepositories = CacheBuilder.newBuilder().softValues().build();

    private AarResourceRepositoryCache() {
    }

    @NotNull
    public final AarSourceResourceRepository getSourceRepository(@NotNull ExternalAndroidLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        ResourceFolder resourceFolder = library.getResFolder();
        if (resourceFolder == null) {
            throw new IllegalArgumentException("No resources for " + library.libraryName());
        }
        ResourceFolder resFolder = resourceFolder;
        if (resFolder.getRoot().toPath() == null) {
            throw new IllegalArgumentException("Cannot find resource directory " + resFolder.getRoot() + " for " + library.libraryName());
        }
        Cache<ResourceFolder, AarSourceResourceRepository> cache2 = this.mySourceRepositories;
        Intrinsics.checkNotNullExpressionValue(cache2, (String)"mySourceRepositories");
        AarResourceRepository aarResourceRepository = AarResourceRepositoryCache.Companion.getRepository(resFolder, cache2, (Function0)new Function0<AarSourceResourceRepository>(resFolder, library, this){
            final /* synthetic */ ResourceFolder $resFolder;
            final /* synthetic */ ExternalAndroidLibrary $library;
            final /* synthetic */ AarResourceRepositoryCache this$0;
            {
                this.$resFolder = $resFolder;
                this.$library = $library;
                this.this$0 = $receiver;
                super(0);
            }

            public final AarSourceResourceRepository invoke() {
                return AarSourceResourceRepository.create((PathString)this.$resFolder.getRoot(), (Collection)this.$resFolder.getResources(), (String)this.$library.libraryName(), (CachingData)AarResourceRepositoryCache.access$createCachingData(this.this$0, this.$library));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)aarResourceRepository, (String)"fun getSourceRepository(\u2026gData(library))\n    }\n  }");
        return (AarSourceResourceRepository)aarResourceRepository;
    }

    @NotNull
    public final AarProtoResourceRepository getProtoRepository(@NotNull ExternalAndroidLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        PathString pathString = library.getResApkFile();
        if (pathString == null) {
            throw new IllegalArgumentException("No res.apk for " + library.libraryName());
        }
        PathString resApkPath = pathString;
        Path path2 = resApkPath.toPath();
        if (path2 == null) {
            throw new IllegalArgumentException("Cannot find " + resApkPath + " for " + library.libraryName());
        }
        Path resApkFile = path2;
        Cache<Path, AarProtoResourceRepository> cache2 = this.myProtoRepositories;
        Intrinsics.checkNotNullExpressionValue(cache2, (String)"myProtoRepositories");
        AarResourceRepository aarResourceRepository = AarResourceRepositoryCache.Companion.getRepository(resApkFile, cache2, (Function0)new Function0<AarProtoResourceRepository>(resApkFile, library){
            final /* synthetic */ Path $resApkFile;
            final /* synthetic */ ExternalAndroidLibrary $library;
            {
                this.$resApkFile = $resApkFile;
                this.$library = $library;
                super(0);
            }

            public final AarProtoResourceRepository invoke() {
                return AarProtoResourceRepository.create((Path)this.$resApkFile, (String)this.$library.libraryName());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)aarResourceRepository, (String)"library: ExternalAndroid\u2026 library.libraryName()) }");
        return (AarProtoResourceRepository)aarResourceRepository;
    }

    public final void removeProtoRepository(@NotNull Path resApkFile) {
        Intrinsics.checkNotNullParameter((Object)resApkFile, (String)"resApkFile");
        this.myProtoRepositories.invalidate((Object)resApkFile);
    }

    public final void removeSourceRepository(@NotNull ResourceFolder resourceFolder) {
        Intrinsics.checkNotNullParameter((Object)resourceFolder, (String)"resourceFolder");
        this.mySourceRepositories.invalidate((Object)resourceFolder);
    }

    public final void clear() {
        this.myProtoRepositories.invalidateAll();
        this.mySourceRepositories.invalidateAll();
    }

    private final CachingData createCachingData(ExternalAndroidLibrary library) {
        Comparable<FileTime> modificationTime;
        ResourceFolder resFolder;
        block9: {
            FileTime fileTime;
            resFolder = library.getResFolder();
            if (resFolder == null || resFolder.getResources() != null) {
                return null;
            }
            modificationTime = null;
            try {
                Path path2 = resFolder.getRoot().toPath();
                Intrinsics.checkNotNull((Object)path2);
                fileTime = Files.getLastModifiedTime(path2, new LinkOption[0]);
            }
            catch (NoSuchFileException e) {
                return null;
            }
            modificationTime = fileTime;
            PathString pathString = library.getLocation();
            if (pathString != null) {
                PathString it = pathString;
                boolean bl = false;
                try {
                    Path libraryPath = it.toPath();
                    if (libraryPath == null) {
                        AarResourceRepositoryCache $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger2 = Logger.getInstance(AarResourceRepositoryCache.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                        logger2.error("Library " + library.libraryName() + " has an invalid location: \"" + it + "\"");
                        break block9;
                    }
                    modificationTime = RangesKt.coerceAtLeast((Comparable)modificationTime, (Comparable)Files.getLastModifiedTime(libraryPath, new LinkOption[0]));
                }
                catch (NoSuchFileException libraryPath) {
                }
            }
        }
        String string = modificationTime.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"modificationTime.toString()");
        String contentVersion = string;
        String string2 = AndroidPluginVersion.getAndroidPluginVersion();
        if (string2 == null) {
            return null;
        }
        String codeVersion = string2;
        PathString path3 = resFolder.getRoot();
        String string3 = Hashing.farmHashFingerprint64().hashUnencodedChars((CharSequence)path3.getPortablePath()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"farmHashFingerprint64().\u2026.portablePath).toString()");
        String pathHash = string3;
        String[] $i$f$thisLogger = "%s_%s.dat";
        Object[] objectArray = new Object[2];
        Object object = library.getLocation();
        if (object == null || (object = object.getFileName()) == null) {
            object = "";
        }
        objectArray[0] = object;
        objectArray[1] = pathHash;
        String string4 = String.format((String)$i$f$thisLogger, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        String filename = string4;
        $i$f$thisLogger = new String[]{"caches/resources", filename};
        Path cacheFile = Paths.get(PathManager.getSystemPath(), $i$f$thisLogger);
        Executor executor2 = ApplicationManager.getApplication().isUnitTestMode() ? (Executor)createCachingData.executor.1.INSTANCE : (Executor)AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)cacheFile, (String)"cacheFile");
        return new CachingData(cacheFile, contentVersion, codeVersion, executor2);
    }

    @NotNull
    public static final AarResourceRepositoryCache getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ CachingData access$createCachingData(AarResourceRepositoryCache $this, ExternalAndroidLibrary library) {
        return $this.createCachingData(library);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JG\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\n\"\b\b\u0001\u0010\t*\u00020\u000b2\u0006\u0010\f\u001a\u0002H\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\t0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/res/AarResourceRepositoryCache$Companion;", "", "()V", "instance", "Lcom/android/tools/idea/res/AarResourceRepositoryCache;", "getInstance$annotations", "getInstance", "()Lcom/android/tools/idea/res/AarResourceRepositoryCache;", "getRepository", "T", "K", "Lcom/android/resources/aar/AarResourceRepository;", "key", "cache", "Lcom/google/common/cache/Cache;", "factory", "Lkotlin/Function0;", "(Ljava/lang/Object;Lcom/google/common/cache/Cache;Lkotlin/jvm/functions/Function0;)Lcom/android/resources/aar/AarResourceRepository;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AarResourceRepositoryCache getInstance() {
            Object object = ApplicationManager.getApplication().getService(AarResourceRepositoryCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026ositoryCache::class.java)");
            return (AarResourceRepositoryCache)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        private final <K, T extends AarResourceRepository> T getRepository(K key, Cache<K, T> cache2, Function0<? extends T> factory2) {
            return (T)((AarResourceRepository)CacheUtils.getAndUnwrap(cache2, key, (Function0)new Function0<T>(factory2){
                final /* synthetic */ Function0<T> $factory;
                {
                    this.$factory = $factory;
                    super(0);
                }

                @NotNull
                public final T invoke() {
                    return (T)((AarResourceRepository)this.$factory.invoke());
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

