/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.utils.SdkUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertFromWebpAction
extends DumbAwareAction {
    @Nls(capitalization=Nls.Capitalization.Title)
    public static final String TITLE = "Convert from WebP to PNG";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        int answer2 = Messages.showYesNoCancelDialog((Project)project, (String)"Delete .webp files after saving as .png?", (String)TITLE, null);
        if (answer2 == 2) {
            return;
        }
        boolean delete2 = answer2 == 0;
        VirtualFile[] files2 = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        this.perform(project, files2, delete2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void perform(@NotNull Project project, @NotNull VirtualFile[] files2, boolean deleteWebp) {
        this.convert(project, Arrays.asList(files2), deleteWebp);
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null && e.getProject() != null) {
            for (VirtualFile file2 : files2) {
                if (!SdkUtils.endsWithIgnoreCase((String)file2.getName(), (String)".webp")) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void convert(@NotNull Project project, @NotNull Collection<VirtualFile> files2, boolean delete2) {
        ProgressManager.getInstance().run((Task)new WebpConversionTask(project, files2, delete2));
    }

    private static void refreshFolders(List<VirtualFile> toRefresh) {
        for (VirtualFile dir : toRefresh) {
            dir.refresh(true, true);
        }
    }

    @NotNull
    private static List<VirtualFile> computeParentFolders(@NotNull List<VirtualFile> files2) {
        ArrayList<VirtualFile> toRefresh = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files2) {
            VirtualFile parent2 = file2.getParent();
            if (parent2 == null || toRefresh.contains(parent2)) continue;
            toRefresh.add(parent2);
        }
        return toRefresh;
    }

    static class WebpConversionTask
    extends Task.Backgroundable {
        private final Project myProject;
        private final Collection<VirtualFile> myFiles;
        private final boolean myDelete;
        private List<VirtualFile> myParentFolders;
        private List<VirtualFile> myConvertedFiles;

        public WebpConversionTask(Project project, Collection<VirtualFile> files2, boolean delete2) {
            super(project, ConvertFromWebpAction.TITLE, true);
            this.myProject = project;
            this.myFiles = files2;
            this.myDelete = delete2;
        }

        public void onFinished() {
            this.writeImages((Object)this, this.myProject, this.myConvertedFiles);
            ConvertFromWebpAction.refreshFolders(this.myParentFolders);
        }

        private void writeImages(@NotNull Object requestor, @NotNull Project project, @NotNull List<VirtualFile> files2) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (VirtualFile file2 : files2) {
                    try {
                        BufferedImage image;
                        if (!file2.isValid() || (image = ImageIO.read(file2.getInputStream())) == null) continue;
                        ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                        ImageIO.write((RenderedImage)image, "PNG", stream);
                        byte[] encoded = stream.toByteArray();
                        VirtualFile folder = file2.getParent();
                        VirtualFile output = folder.createChildData(requestor, file2.getNameWithoutExtension() + ".png");
                        try (BufferedOutputStream fos = new BufferedOutputStream(output.getOutputStream((Object)this));){
                            ((OutputStream)fos).write(encoded);
                        }
                        if (!this.myDelete) continue;
                        file2.delete(requestor);
                    }
                    catch (IOException e) {
                        Logger.getInstance(ConvertFromWebpAction.class).warn(e.getMessage());
                    }
                }
            });
        }

        public void run(@NotNull ProgressIndicator progressIndicator) {
            LinkedList<VirtualFile> images = new LinkedList<VirtualFile>(this.myFiles);
            this.myConvertedFiles = WebpConversionTask.findImages(progressIndicator, images);
            this.myParentFolders = ConvertFromWebpAction.computeParentFolders(this.myConvertedFiles);
        }

        @NotNull
        private static List<VirtualFile> findImages(@NotNull ProgressIndicator progressIndicator, LinkedList<VirtualFile> images) {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            while (!images.isEmpty()) {
                progressIndicator.checkCanceled();
                VirtualFile file2 = images.pop();
                progressIndicator.setText(file2.getPresentableUrl());
                if (file2.isDirectory()) {
                    for (VirtualFile f : file2.getChildren()) {
                        images.push(f);
                    }
                    continue;
                }
                if (!SdkUtils.endsWithIgnoreCase((String)file2.getName(), (String)".webp")) continue;
                files2.add(file2);
            }
            return files2;
        }
    }
}

