/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.RenderModuleDependencies;
import com.android.tools.idea.rendering.parsers.DomPullParser;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

class MenuLayoutParserFactory {
    @NotNull
    private static final String FRAME_LAYOUT_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<FrameLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\" />\n";

    private MenuLayoutParserFactory() {
    }

    @NotNull
    public static ILayoutPullParser create(@NotNull RenderXmlFile psiFile, @NotNull LayoutlibCallbackImpl layoutlibCallback) {
        ResourceRepositoryManager repositoryManager;
        Document frameLayoutDocument = XmlUtils.parseDocumentSilently((String)FRAME_LAYOUT_XML, (boolean)true);
        if (frameLayoutDocument == null) {
            return LayoutPullParsers.createEmptyParser();
        }
        ActionBarHandler actionBarHandler = layoutlibCallback.getActionBarHandler();
        if (actionBarHandler != null && (repositoryManager = actionBarHandler.getResourceRepositoryManager()) != null) {
            ResourceReference menuResource = new ResourceReference(repositoryManager.getNamespace(), ResourceType.MENU, SdkUtils.fileNameToResourceName((String)psiFile.getName()));
            actionBarHandler.setMenuIds(Collections.singletonList(menuResource));
        }
        return DomPullParser.createFromDocument(frameLayoutDocument, Collections.emptyMap());
    }

    @NotNull
    public static ILayoutPullParser createInNavigationView(@NotNull RenderXmlFile file2, @NotNull RenderModuleDependencies dependencies2) {
        String navViewTag = dependencies2.getDependsOnAndroidX() ? AndroidXConstants.NAVIGATION_VIEW.newName() : AndroidXConstants.NAVIGATION_VIEW.oldName();
        String xml = "<" + navViewTag + " xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:layout_width=\"wrap_content\"\n    android:layout_height=\"match_parent\"\n    app:menu=\"@menu/" + SdkUtils.fileNameToResourceName((String)file2.getName()) + "\" />\n";
        Document document2 = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
        return document2 == null ? LayoutPullParsers.createEmptyParser() : DomPullParser.createFromDocument(document2);
    }
}

