/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.tools.rendering.parsers.RenderXmlAttribute;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.utils.DataBindingUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeSnapshot {
    @Nullable
    public String namespace;
    @Nullable
    public String prefix;
    @NotNull
    public String name;
    @Nullable
    public String value;

    AttributeSnapshot(@Nullable String namespace, @Nullable String prefix, @NotNull String name2, @Nullable String value2) {
        this.namespace = namespace;
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.name = name2;
        this.value = value2;
    }

    @Nullable
    public static AttributeSnapshot createAttributeSnapshot(@NotNull RenderXmlAttribute attribute2) {
        String localName = attribute2.getLocalName();
        String namespace = attribute2.getNamespace();
        String prefix = attribute2.getNamespacePrefix();
        String value2 = attribute2.getValue();
        if (value2 != null && DataBindingUtils.isBindingExpression((String)value2) && (value2 = attribute2.getBindingExprDefault()) == null) {
            return null;
        }
        return new AttributeSnapshot(namespace, prefix, localName, value2);
    }

    @NotNull
    public static List<AttributeSnapshot> createAttributesForTag(@NotNull RenderXmlTag tag) {
        List<RenderXmlAttribute> renderAttributes = tag.getAttributes();
        ArrayList attributes = Lists.newArrayListWithExpectedSize((int)renderAttributes.size());
        for (RenderXmlAttribute renderAttribute : renderAttributes) {
            AttributeSnapshot attribute2;
            if (renderAttribute.isNamespaceDeclaration() || (attribute2 = AttributeSnapshot.createAttributeSnapshot(renderAttribute)) == null) continue;
            attributes.add(attribute2);
        }
        return attributes;
    }

    public String toString() {
        return "AttributeSnapshot{" + this.name + "=\"" + this.value + "\"}";
    }
}

