/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AaptAttrAttributeSnapshot
extends AttributeSnapshot {
    @VisibleForTesting
    static final AtomicLong ourUniqueId = new AtomicLong(0L);
    private final String myId;
    private final TagSnapshot myBundledTag;

    AaptAttrAttributeSnapshot(@Nullable String namespace, @Nullable String prefix, @NotNull String name2, @NotNull String id2, @NotNull TagSnapshot bundledTag) {
        super(namespace, prefix, name2, "@aapt:_aapt/aapt" + id2);
        this.myId = id2;
        this.myBundledTag = bundledTag;
    }

    @Nullable
    public static AaptAttrAttributeSnapshot createAttributeSnapshot(@NotNull RenderXmlTag tag) {
        RenderXmlTag parent2 = tag.getParentTag();
        String name2 = tag.getAttributeValue("name");
        if (parent2 == null || name2 == null) {
            return null;
        }
        List<RenderXmlTag> subTags = tag.getSubTags();
        if (subTags.size() == 0) {
            return null;
        }
        RenderXmlTag bundledTag = subTags.get(0);
        String prefix = XmlUtil.findPrefixByQualifiedName((String)name2);
        return new AaptAttrAttributeSnapshot(tag.getNamespaceByPrefix(prefix), prefix, XmlUtil.findLocalNameByQualifiedName((String)name2), Long.toString(ourUniqueId.getAndIncrement()), TagSnapshot.createTagSnapshot(bundledTag, null));
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public TagSnapshot getBundledTag() {
        return this.myBundledTag;
    }
}

