/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.imagepool;

import com.android.tools.idea.rendering.imagepool.DisposableImage;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.imagepool.ImagePoolUtil;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NonPooledImage
implements ImagePool.Image,
DisposableImage {
    private static final Logger LOG = Logger.getInstance(NonPooledImage.class);
    private static final boolean ourTrackDisposeCall = NonPooledImage.class.desiredAssertionStatus();
    private BufferedImage myImage;
    private final int myWidth;
    private final int myHeight;
    private StackTraceElement[] myDisposeStackTrace = null;

    private NonPooledImage(@NotNull BufferedImage image) {
        this.myImage = image;
        this.myHeight = this.myImage.getHeight();
        this.myWidth = this.myImage.getWidth();
    }

    private void assertIfDisposed() {
        if (this.myDisposeStackTrace != null) {
            LOG.warn("Accessing already disposed image\nDispose trace: \n" + ImagePoolUtil.stackTraceToAssertionString(this.myDisposeStackTrace), new Throwable());
        }
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public int getHeight() {
        return this.myHeight;
    }

    @Override
    public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        this.assertIfDisposed();
        g.drawImage(this.myImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    @Override
    public void paint(Consumer<Graphics2D> command) {
        this.assertIfDisposed();
        command.accept(this.myImage.createGraphics());
    }

    @Override
    @Nullable
    public BufferedImage getCopy(@Nullable GraphicsConfiguration gc, int x, int y, int w, int h) {
        this.assertIfDisposed();
        if (x == 0 && y == 0 && w == this.getWidth() && h == this.getHeight()) {
            return NonPooledImage.copy(this.myImage);
        }
        return NonPooledImage.copy(this.myImage.getSubimage(x, y, w, h));
    }

    @Override
    public void dispose() {
        if (ourTrackDisposeCall) {
            this.myDisposeStackTrace = Thread.currentThread().getStackTrace();
        }
        this.myImage = null;
    }

    @Override
    public boolean isValid() {
        return this.myImage != null;
    }

    @NotNull
    private static BufferedImage copy(@NotNull BufferedImage originalImage) {
        WritableRaster raster = originalImage.copyData(originalImage.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(originalImage.getColorModel(), raster, originalImage.isAlphaPremultiplied(), null);
    }

    @NotNull
    public static NonPooledImage create(int w, int h, int type) {
        return new NonPooledImage(new BufferedImage(w, h, type));
    }

    @NotNull
    static NonPooledImage copyOf(@NotNull BufferedImage image) {
        return new NonPooledImage(NonPooledImage.copy(image));
    }
}

