/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading.loaders;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.classloading.loaders.DelegatingClassLoader;
import com.android.tools.idea.rendering.classloading.loaders.JarManager;
import com.android.tools.idea.rendering.classloading.loaders.ProjectSystemClassLoader;
import com.android.tools.idea.rendering.classloading.loaders.ProjectSystemClassLoaderKt;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.android.uipreview.ClassModificationTimestamp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006BA\u0012$\u0010\u0007\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\u0002`\u000b0\b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0004J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0005H\u0007J\u0006\u0010\u001f\u001a\u00020\u001dJ\u0012\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\u000e\u0010!\u001a\u0004\u0018\u00010\n*\u00020\u0005H\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010\n*\u00020\u0005H\u0002R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R)\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R&\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/rendering/classloading/loaders/ProjectSystemClassLoader;", "Lcom/android/tools/idea/rendering/classloading/loaders/DelegatingClassLoader$Loader;", "findClassVirtualFileImpl", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lkotlin/jvm/functions/Function1;)V", "jarLoaderCache", "Lcom/google/common/cache/Cache;", "", "", "Lcom/android/tools/idea/rendering/classloading/loaders/EntryCache;", "(Lcom/google/common/cache/Cache;Lkotlin/jvm/functions/Function1;)V", "jarManager", "Lcom/android/tools/idea/rendering/classloading/loaders/JarManager;", "getJarManager", "()Lcom/android/tools/idea/rendering/classloading/loaders/JarManager;", "loadedVirtualFiles", "Lkotlin/sequences/Sequence;", "Lkotlin/Triple;", "Lorg/jetbrains/android/uipreview/ClassModificationTimestamp;", "getLoadedVirtualFiles", "()Lkotlin/sequences/Sequence;", "virtualFileCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "findClassVirtualFile", "fqcn", "injectClassFile", "", "virtualFile", "invalidateCaches", "loadClass", "readBytesUsingNio", "readFromJar", "intellij.android.core"})
public final class ProjectSystemClassLoader
implements DelegatingClassLoader.Loader {
    @NotNull
    private final Function1<String, VirtualFile> findClassVirtualFileImpl;
    @VisibleForTesting
    @NotNull
    private final JarManager jarManager;
    @NotNull
    private final ConcurrentHashMap<String, Pair<VirtualFile, ClassModificationTimestamp>> virtualFileCache;

    public ProjectSystemClassLoader(@NotNull Cache<String, Map<String, byte[]>> jarLoaderCache, @NotNull Function1<? super String, ? extends VirtualFile> findClassVirtualFileImpl) {
        Intrinsics.checkNotNullParameter(jarLoaderCache, (String)"jarLoaderCache");
        Intrinsics.checkNotNullParameter(findClassVirtualFileImpl, (String)"findClassVirtualFileImpl");
        this.findClassVirtualFileImpl = findClassVirtualFileImpl;
        this.jarManager = new JarManager(true, jarLoaderCache);
        this.virtualFileCache = new ConcurrentHashMap();
    }

    public ProjectSystemClassLoader(@NotNull Function1<? super String, ? extends VirtualFile> findClassVirtualFileImpl) {
        Intrinsics.checkNotNullParameter(findClassVirtualFileImpl, (String)"findClassVirtualFileImpl");
        Cache cache2 = CacheBuilder.newBuilder().softValues().weigher((Weigher)1.INSTANCE).maximumWeight((long)((Number)StudioFlags.PROJECT_SYSTEM_CLASS_LOADER_CACHE_LIMIT.get()).intValue()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"newBuilder()\n           \u2026ild<String, EntryCache>()");
        this((Cache<String, Map<String, byte[]>>)cache2, findClassVirtualFileImpl);
    }

    @NotNull
    public final JarManager getJarManager() {
        return this.jarManager;
    }

    @NotNull
    public final Sequence<Triple<String, VirtualFile, ClassModificationTimestamp>> getLoadedVirtualFiles() {
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence((Map)this.virtualFileCache), (Function1)loadedVirtualFiles.1.INSTANCE), (Function1)loadedVirtualFiles.2.INSTANCE);
    }

    @Nullable
    public final VirtualFile findClassVirtualFile(@NotNull String fqcn) {
        Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
        if (ProjectSystemClassLoaderKt.access$isSystemPrefix(fqcn)) {
            return null;
        }
        VirtualFile cachedVirtualFile = this.virtualFileCache.get(fqcn);
        VirtualFile virtualFile = cachedVirtualFile;
        boolean bl = virtualFile != null && (virtualFile = (VirtualFile)virtualFile.getFirst()) != null ? virtualFile.isValid() : false;
        if (bl) {
            return (VirtualFile)cachedVirtualFile.getFirst();
        }
        VirtualFile vFile = (VirtualFile)this.findClassVirtualFileImpl.invoke((Object)fqcn);
        if (vFile != null) {
            ((Map)this.virtualFileCache).put(fqcn, new Pair((Object)vFile, (Object)ClassModificationTimestamp.Companion.fromVirtualFile(vFile)));
        }
        return vFile;
    }

    public final void invalidateCaches() {
        this.virtualFileCache.clear();
    }

    private final byte[] readBytesUsingNio(VirtualFile $this$readBytesUsingNio) {
        try {
            return Files.readAllBytes($this$readBytesUsingNio.toNioPath());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private final byte[] readFromJar(VirtualFile $this$readFromJar) {
        String string = $this$readFromJar.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
        return StringsKt.startsWith$default((String)string, (String)"jar:", (boolean)false, (int)2, null) ? this.jarManager.loadFileFromJar(new URI(URLEncoder.encode($this$readFromJar.getUrl(), Charsets.UTF_8))) : null;
    }

    @Override
    @Nullable
    public byte[] loadClass(@NotNull String fqcn) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
        try {
            Object contents;
            Object object2;
            block5: {
                VirtualFile vFile;
                block4: {
                    vFile = this.findClassVirtualFile(fqcn);
                    object2 = vFile;
                    if (object2 == null) break block4;
                    byte[] byArray = this.readBytesUsingNio((VirtualFile)object2);
                    object2 = byArray;
                    if (byArray != null) break block5;
                }
                VirtualFile virtualFile = vFile;
                object2 = virtualFile != null ? (Object)this.readFromJar(virtualFile) : null;
            }
            object = contents = object2;
        }
        catch (Throwable throwable) {
            object = null;
        }
        return object;
    }

    @TestOnly
    public final void injectClassFile(@NotNull String fqcn, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ((Map)this.virtualFileCache).put(fqcn, new Pair((Object)virtualFile, (Object)ClassModificationTimestamp.Companion.fromVirtualFile(virtualFile)));
    }
}

