/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.AndroidXConstants;
import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.resources.ResourceType;
import com.android.support.FragmentTagUtil;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.ReplaceTagFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.SdkUtils;
import com.android.utils.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.PsiNavigateUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioHtmlLinkManager
implements HtmlLinkManager {
    private static final String URL_SHOW_XML = "action:showXml";
    private static final String URL_RUNNABLE = "runnable:";
    private static final String URL_COMMAND = "command:";
    private SparseArray<Runnable> myLinkRunnables;
    private SparseArray<HtmlLinkManager.CommandLink> myLinkCommands;
    private int myNextLinkId = 0;
    private static final NotificationGroup NOTIFICATIONS_GROUP = new NotificationGroup("Render error panel notifications", NotificationDisplayType.BALLOON, false, null, null, null, PluginId.getId((String)"org.jetbrains.android"));

    public static void showNotification(@NotNull String content2) {
        Notification notification = NOTIFICATIONS_GROUP.createNotification(content2, NotificationType.INFORMATION);
        Notifications.Bus.notify((Notification)notification);
        new Alarm().addRequest(() -> ((Notification)notification).expire(), TimeUnit.SECONDS.toMillis(2L));
    }

    @Override
    public void handleUrl(@NotNull String url, @Nullable Module module2, @Nullable PsiFile file2, boolean hasRenderResult, @NotNull HtmlLinkManager.RefreshableSurface surface) {
        if (url.startsWith("http:") || url.startsWith("https:")) {
            BrowserLauncher.getInstance().browse(url, null, module2 == null ? null : module2.getProject());
        } else if (url.startsWith("file:")) {
            assert (module2 != null);
            StudioHtmlLinkManager.handleFileUrl(url, module2);
        } else if (url.startsWith("replaceTags:")) {
            assert (module2 != null);
            assert (file2 != null);
            StudioHtmlLinkManager.handleReplaceTagsUrl(url, module2, file2);
        } else if (url.equals("action:build")) {
            assert (module2 != null);
            StudioHtmlLinkManager.handleBuildProjectUrl(url, module2.getProject());
        } else if (url.equals("action:sync")) {
            assert (module2 != null);
            StudioHtmlLinkManager.handleSyncProjectUrl(url, module2.getProject());
        } else if (url.equals("action:classpath")) {
            assert (module2 != null);
            StudioHtmlLinkManager.handleEditClassPathUrl(url, module2);
        } else if (url.startsWith("createClass:")) {
            assert (module2 != null && file2 != null);
            StudioHtmlLinkManager.handleNewClassUrl(url, module2);
        } else if (url.startsWith("open:")) {
            assert (module2 != null);
            StudioHtmlLinkManager.handleOpenStackUrl(url, module2);
        } else if (url.startsWith("openClass:")) {
            assert (module2 != null);
            StudioHtmlLinkManager.handleOpenClassUrl(url, module2);
        } else if (url.equals(URL_SHOW_XML)) {
            assert (module2 != null && file2 != null);
            StudioHtmlLinkManager.handleShowXmlUrl(url, module2, file2);
        } else if (url.startsWith("showTag:")) {
            assert (module2 != null && file2 != null);
            StudioHtmlLinkManager.handleShowTagUrl(url, module2, file2);
        } else if (url.startsWith("assignFragmentUrl:")) {
            assert (module2 != null && file2 != null);
            StudioHtmlLinkManager.handleAssignFragmentUrl(url, module2, file2);
        } else if (url.startsWith("assignLayoutUrl:")) {
            assert (module2 != null && file2 != null);
            StudioHtmlLinkManager.handleAssignLayoutUrl(url, module2, file2);
        } else if (url.equals("action:ignoreFragment")) {
            assert (hasRenderResult);
            StudioHtmlLinkManager.handleIgnoreFragments(url, surface);
        } else if (url.startsWith("editAttribute:")) {
            assert (hasRenderResult);
            if (module2 != null && file2 != null) {
                StudioHtmlLinkManager.handleEditAttribute(url, module2, file2);
            }
        } else if (url.startsWith("replaceAttributeValue:")) {
            assert (hasRenderResult);
            if (module2 != null && file2 != null) {
                StudioHtmlLinkManager.handleReplaceAttributeValue(url, module2, file2);
            }
        } else if (url.startsWith("disableSandbox:")) {
            assert (module2 != null);
            StudioHtmlLinkManager.handleDisableSandboxUrl(module2, surface);
        } else if (url.startsWith(URL_RUNNABLE)) {
            Runnable linkRunnable = this.getLinkRunnable(url);
            if (linkRunnable != null) {
                linkRunnable.run();
            }
        } else if (url.startsWith("addDependency:") && module2 != null) {
            assert (module2.getModuleFile() != null);
            StudioHtmlLinkManager.handleAddDependency(url, module2);
            ProjectSystemUtil.getSyncManager(module2.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        } else if (url.startsWith(URL_COMMAND)) {
            String idString;
            int id2;
            HtmlLinkManager.CommandLink command;
            if (this.myLinkCommands != null && url.startsWith(URL_COMMAND) && (command = (HtmlLinkManager.CommandLink)this.myLinkCommands.get(id2 = Integer.decode(idString = url.substring(URL_COMMAND.length())).intValue())) != null) {
                command.executeCommand();
            }
        } else if (url.startsWith("refreshRender")) {
            surface.handleRefreshRenderUrl();
        } else if (url.startsWith("clearCacheAndNotify")) {
            surface.handleRefreshRenderUrl();
            StudioHtmlLinkManager.showNotification("Cache cleared");
        } else assert (false) : "Unexpected URL: " + url;
    }

    private static void handleFileUrl(@NotNull String url, @NotNull Module module2) {
        Project project = module2.getProject();
        try {
            int line2 = -1;
            int column2 = 0;
            Pattern pattern = Pattern.compile(".*:(\\d+)(:(\\d+))");
            Matcher matcher = pattern.matcher(url);
            if (matcher.matches()) {
                line2 = Integer.parseInt(matcher.group(1));
                column2 = Integer.parseInt(matcher.group(3));
                url = url.substring(0, matcher.start(1) - 1);
            } else {
                matcher = Pattern.compile(".*:(\\d+)").matcher(url);
                if (matcher.matches()) {
                    line2 = Integer.parseInt(matcher.group(1));
                    url = url.substring(0, matcher.start(1) - 1);
                }
            }
            File ioFile = SdkUtils.urlToFile((String)url);
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            if (file2 != null) {
                StudioHtmlLinkManager.openEditor(project, file2, line2, column2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public String createCommandLink(@NotNull HtmlLinkManager.CommandLink command) {
        String url = URL_COMMAND + this.myNextLinkId;
        if (this.myLinkCommands == null) {
            this.myLinkCommands = new SparseArray(5);
        }
        this.myLinkCommands.put(this.myNextLinkId, (Object)command);
        ++this.myNextLinkId;
        return url;
    }

    @Override
    public String createRunnableLink(@NotNull Runnable runnable2) {
        String url = URL_RUNNABLE + this.myNextLinkId;
        if (this.myLinkRunnables == null) {
            this.myLinkRunnables = new SparseArray(5);
        }
        this.myLinkRunnables.put(this.myNextLinkId, (Object)runnable2);
        ++this.myNextLinkId;
        return url;
    }

    @Nullable
    private Runnable getLinkRunnable(String url) {
        if (this.myLinkRunnables != null && url.startsWith(URL_RUNNABLE)) {
            String idString = url.substring(URL_RUNNABLE.length());
            int id2 = Integer.decode(idString);
            return (Runnable)this.myLinkRunnables.get(id2);
        }
        return null;
    }

    private static void handleReplaceTagsUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        assert (url.startsWith("replaceTags:")) : url;
        int start2 = "replaceTags:".length();
        int delimiterPos = url.indexOf(47, start2);
        if (delimiterPos != -1) {
            String wrongTag = url.substring(start2, delimiterPos);
            String rightTag = url.substring(delimiterPos + 1);
            new ReplaceTagFix((XmlFile)file2, wrongTag, rightTag).run();
        }
    }

    private static void handleBuildProjectUrl(@NotNull String url, @NotNull Project project) {
        assert (url.equals("action:build")) : url;
        ProjectSystemUtil.getProjectSystem(project).getBuildManager().compileProject();
    }

    private static void handleSyncProjectUrl(@NotNull String url, @NotNull Project project) {
        assert (url.equals("action:sync")) : url;
        ProjectSystemSyncManager.SyncReason reason = project.isInitialized() ? ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED : ProjectSystemSyncManager.SyncReason.PROJECT_LOADED;
        ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(reason);
    }

    private static void handleEditClassPathUrl(@NotNull String url, @NotNull Module module2) {
        assert (url.equals("action:classpath")) : url;
        ProjectSettingsService.getInstance((Project)module2.getProject()).openModuleSettings(module2);
    }

    private static void handleOpenClassUrl(@NotNull String url, @NotNull Module module2) {
        PsiFile containingFile;
        assert (url.startsWith("openClass:")) : url;
        String className = url.substring("openClass:".length());
        Project project = module2.getProject();
        PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        if (clz != null && (containingFile = clz.getContainingFile()) != null) {
            StudioHtmlLinkManager.openEditor(project, containingFile, clz.getTextOffset());
        }
    }

    private static void handleShowXmlUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        assert (url.equals(URL_SHOW_XML)) : url;
        StudioHtmlLinkManager.openEditor(module2.getProject(), file2, 0, -1);
    }

    private static void handleShowTagUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        assert (url.startsWith("showTag:")) : url;
        String tagName = url.substring("showTag:".length());
        XmlTag first = (XmlTag)ApplicationManager.getApplication().runReadAction(() -> {
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlTag.class);
            for (XmlTag tag : xmlTags) {
                if (!tagName.equals(tag.getName())) continue;
                return tag;
            }
            return null;
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first);
        } else {
            StudioHtmlLinkManager.openEditor(module2.getProject(), file2, 0, -1);
        }
    }

    private static void handleNewClassUrl(@NotNull String url, @NotNull Module module2) {
        PsiFile file2;
        PsiClass newClass;
        PsiDirectory targetDirectory;
        String packageName2;
        String className;
        assert (url.startsWith("createClass:")) : url;
        String s = url.substring("createClass:".length());
        Project project = module2.getProject();
        String title = "Create Custom View";
        int index2 = s.lastIndexOf(46);
        if (index2 == -1) {
            className = s;
            packageName2 = ProjectSystemUtil.getModuleSystem(module2).getPackageName();
            if (packageName2 == null) {
                return;
            }
        } else {
            packageName2 = s.substring(0, index2);
            className = s.substring(index2 + 1);
        }
        CreateClassDialog dialog2 = new CreateClassDialog(project, title, className, packageName2, (ClassKind)CreateClassKind.CLASS, true, module2){

            protected boolean reportBaseInSourceSelectionInTest() {
                return true;
            }
        };
        dialog2.show();
        if (dialog2.getExitCode() == 0 && (targetDirectory = dialog2.getTargetDirectory()) != null && (newClass = (PsiClass)WriteCommandAction.writeCommandAction((Project)project).withName("Create Class").compute(() -> {
            PsiClass targetClass = JavaDirectoryService.getInstance().createClass(targetDirectory, className);
            PsiManager manager = PsiManager.getInstance((Project)project);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiElementFactory factory2 = facade.getElementFactory();
            PsiJavaCodeReferenceElement superclassReference = factory2.createReferenceElementByFQClassName("android.view.View", targetClass.getResolveScope());
            PsiReferenceList extendsList = targetClass.getExtendsList();
            if (extendsList != null) {
                extendsList.add((PsiElement)superclassReference);
            }
            GlobalSearchScope scope2 = GlobalSearchScope.allScope((Project)project);
            PsiJavaFile javaFile = (PsiJavaFile)targetClass.getContainingFile();
            PsiImportList importList = javaFile.getImportList();
            if (importList != null) {
                PsiClass attributeSetClass;
                PsiClass contextClass = JavaPsiFacade.getInstance((Project)project).findClass("android.content.Context", scope2);
                if (contextClass != null) {
                    importList.add((PsiElement)factory2.createImportStatement(contextClass));
                }
                if ((attributeSetClass = JavaPsiFacade.getInstance((Project)project).findClass("android.util.AttributeSet", scope2)) != null) {
                    importList.add((PsiElement)factory2.createImportStatement(attributeSetClass));
                }
            }
            PsiMethod constructor1arg = factory2.createMethodFromText("public " + className + "(Context context) {\n  this(context, null);\n}\n", (PsiElement)targetClass);
            targetClass.add((PsiElement)constructor1arg);
            PsiMethod constructor2args = factory2.createMethodFromText("public " + className + "(Context context, AttributeSet attrs) {\n  this(context, attrs, 0);\n}\n", (PsiElement)targetClass);
            targetClass.add((PsiElement)constructor2args);
            PsiMethod constructor3args = factory2.createMethodFromText("public " + className + "(Context context, AttributeSet attrs, int defStyle) {\n  super(context, attrs, defStyle);\n}\n", (PsiElement)targetClass);
            targetClass.add((PsiElement)constructor3args);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
            PsiFile containingFile = targetClass.getContainingFile();
            if (containingFile != null) {
                codeStyleManager.reformat((PsiElement)javaFile);
            }
            return targetClass;
        })) != null && (file2 = newClass.getContainingFile()) != null) {
            StudioHtmlLinkManager.openEditor(project, file2, newClass.getTextOffset());
        }
    }

    private static void handleOpenStackUrl(@NotNull String url, @NotNull Module module2) {
        Project project;
        PsiClass clz;
        int line2;
        String fileName;
        String className;
        assert (url.startsWith("open:")) : url;
        int start2 = "open:".length();
        int semi = url.indexOf(59, start2);
        if (semi != -1) {
            className = url.substring(start2, semi);
            int colon = url.indexOf(58, semi + 1);
            if (colon != -1) {
                fileName = url.substring(semi + 1, colon);
                line = Integer.decode(url.substring(colon + 1));
            } else {
                fileName = url.substring(semi + 1);
                line = -1;
            }
        } else {
            className = url.substring(start2);
            fileName = null;
            line2 = -1;
        }
        String method2 = null;
        int hash2 = className.indexOf(35);
        if (hash2 != -1) {
            method2 = className.substring(hash2 + 1);
            className = className.substring(0, hash2);
        }
        if ((clz = JavaPsiFacade.getInstance((Project)(project = module2.getProject())).findClass(className, GlobalSearchScope.allScope((Project)project))) != null) {
            String name2;
            VirtualFile virtualFile;
            PsiFile containingFile = clz.getContainingFile();
            if (fileName != null && containingFile != null && line2 != -1 && (virtualFile = containingFile.getVirtualFile()) != null && fileName.equals(name2 = virtualFile.getName())) {
                StudioHtmlLinkManager.openEditor(project, containingFile, line2 - 1, -1);
                return;
            }
            if (method2 != null) {
                PsiMethod[] methodsByName;
                for (PsiMethod psiMethod : methodsByName = clz.findMethodsByName(method2, true)) {
                    VirtualFile virtualFile2;
                    PsiFile psiFile = psiMethod.getContainingFile();
                    if (psiFile == null || (virtualFile2 = psiFile.getVirtualFile()) == null) continue;
                    OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, virtualFile2, psiMethod.getTextOffset());
                    FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
                    return;
                }
            }
            if (fileName != null) {
                PsiFile[] files2 = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                for (PsiMethod psiMethod : files2) {
                    if (StudioHtmlLinkManager.openEditor(project, (PsiFile)psiMethod, line2 != -1 ? line2 - 1 : -1, -1)) break;
                }
            }
        }
    }

    private static boolean openEditor(@NotNull Project project, @NotNull PsiFile psiFile, int line2, int column2) {
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 != null) {
            return StudioHtmlLinkManager.openEditor(project, file2, line2, column2);
        }
        return false;
    }

    private static boolean openEditor(@NotNull Project project, @NotNull VirtualFile file2, int line2, int column2) {
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file2, line2, column2);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        if (manager.openTextEditor(descriptor2, true) != null) {
            return true;
        }
        return !manager.openEditor(descriptor2, true).isEmpty();
    }

    private static boolean openEditor(@NotNull Project project, @NotNull PsiFile psiFile, int offset) {
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 != null) {
            return StudioHtmlLinkManager.openEditor(project, file2, offset);
        }
        return false;
    }

    private static boolean openEditor(@NotNull Project project, @NotNull VirtualFile file2, int offset) {
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file2, offset);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true).isEmpty();
    }

    @NotNull
    private static String getFragmentClass(@NotNull Module module2, @NotNull String fqcn) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            String jvmClassName;
            Project project = module2.getProject();
            JavaPsiFacade finder2 = JavaPsiFacade.getInstance((Project)project);
            PsiClass psiClass = finder2.findClass(fqcn, module2.getModuleScope());
            if (psiClass == null) {
                psiClass = finder2.findClass(fqcn, GlobalSearchScope.allScope((Project)project));
            }
            if (psiClass != null && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)psiClass)) != null) {
                return jvmClassName.replace('/', '.');
            }
            return fqcn;
        });
    }

    private static void handleAssignFragmentUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        assert (url.startsWith("assignFragmentUrl:")) : url;
        Predicate<PsiClass> psiFilter = ChooseClassDialog.getUserDefinedPublicAndUnrestrictedFilter();
        String className = ChooseClassDialog.openDialog(module2, "Fragments", null, psiFilter, "android.app.Fragment", AndroidXConstants.CLASS_V4_FRAGMENT.oldName(), AndroidXConstants.CLASS_V4_FRAGMENT.newName());
        if (className == null) {
            return;
        }
        String fragmentClass = StudioHtmlLinkManager.getFragmentClass(module2, className);
        int start2 = "assignFragmentUrl:".length();
        String id2 = start2 == url.length() ? null : Lint.stripIdPrefix((String)url.substring(start2));
        WriteCommandAction.writeCommandAction((Project)module2.getProject(), (PsiFile[])new PsiFile[]{file2}).withName("Assign Fragment").run(() -> {
            Collection tags = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlTag.class);
            for (XmlTag tag : tags) {
                String tagId;
                if (!FragmentTagUtil.isFragmentTag((String)tag.getName()) || id2 != null && ((tagId = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android")) == null || !tagId.endsWith(id2) || !id2.equals(Lint.stripIdPrefix((String)tagId))) || tag.getAttribute("name", "http://schemas.android.com/apk/res/android") != null || tag.getAttribute("class") != null) continue;
                tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                return;
            }
            if (id2 == null) {
                for (XmlTag tag : tags) {
                    if (!FragmentTagUtil.isFragmentTag((String)tag.getName())) continue;
                    tag.setAttribute("name", "http://schemas.android.com/apk/res/android", fragmentClass);
                    break;
                }
            }
        });
    }

    private static void handleAssignLayoutUrl(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        assert (url.startsWith("assignLayoutUrl:")) : url;
        int start2 = "assignLayoutUrl:".length();
        int layoutStart = url.indexOf(58, start2 + 1);
        Project project = module2.getProject();
        XmlFile xmlFile = (XmlFile)file2;
        if (layoutStart == -1) {
            String activityName = url.substring(start2);
            StudioHtmlLinkManager.pickLayout(module2, xmlFile, activityName);
        } else {
            String activityName = url.substring(start2, layoutStart);
            String layoutName = url.substring(layoutStart + 1);
            String layout = "@layout/" + layoutName;
            StudioHtmlLinkManager.assignLayout(project, xmlFile, activityName, layout);
        }
    }

    private static void pickLayout(@NotNull Module module2, @NotNull XmlFile file2, @NotNull String activityName) {
        String layout;
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        assert (facet2 != null);
        ResourcePickerDialog dialog2 = ResourceChooserHelperKt.createResourcePickerDialog("Choose a Layout", null, facet2, EnumSet.of(ResourceType.LAYOUT), null, true, false, true, file2.getVirtualFile());
        if (dialog2.showAndGet() && !(layout = dialog2.getResourceName()).equals("@layout/" + file2.getName())) {
            StudioHtmlLinkManager.assignLayout(module2.getProject(), file2, activityName, layout);
        }
    }

    private static void assignLayout(@NotNull Project project, @NotNull XmlFile file2, @NotNull String activityName, @NotNull String layout) {
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).withName("Assign Preview Layout").run(() -> {
            IdeResourcesUtil.ensureNamespaceImported(file2, "http://schemas.android.com/tools", null);
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlTag.class);
            for (XmlTag tag : xmlTags) {
                if (!FragmentTagUtil.isFragmentTag((String)tag.getName())) continue;
                String name2 = tag.getAttributeValue("class");
                if (name2 == null || name2.isEmpty()) {
                    name2 = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                }
                if (!activityName.equals(name2)) continue;
                tag.setAttribute("layout", "http://schemas.android.com/tools", layout);
            }
        });
    }

    private static void handleIgnoreFragments(@NotNull String url, @NotNull HtmlLinkManager.RefreshableSurface surface) {
        assert (url.equals("action:ignoreFragment"));
        RenderLogger.ignoreFragments();
        surface.requestRender();
    }

    private static void handleEditAttribute(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        assert (url.startsWith("editAttribute:"));
        int attributeStart = "editAttribute:".length();
        int valueStart = url.indexOf(47);
        String attributeName = url.substring(attributeStart, valueStart);
        String value2 = url.substring(valueStart + 1);
        XmlAttribute first = (XmlAttribute)ApplicationManager.getApplication().runReadAction(() -> {
            Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlAttribute.class);
            for (XmlAttribute attribute2 : attributes) {
                if (!attributeName.equals(attribute2.getLocalName()) || !value2.equals(attribute2.getValue())) continue;
                return attribute2;
            }
            return null;
        });
        if (first != null) {
            PsiNavigateUtil.navigate((PsiElement)first.getValueElement());
        } else {
            StudioHtmlLinkManager.openEditor(module2.getProject(), file2, 0, -1);
        }
    }

    private static void handleReplaceAttributeValue(@NotNull String url, @NotNull Module module2, @NotNull PsiFile file2) {
        assert (url.startsWith("replaceAttributeValue:"));
        int attributeStart = "replaceAttributeValue:".length();
        int valueStart = url.indexOf(47);
        int newValueStart = url.indexOf(47, valueStart + 1);
        String attributeName = url.substring(attributeStart, valueStart);
        String oldValue = url.substring(valueStart + 1, newValueStart);
        String newValue = url.substring(newValueStart + 1);
        WriteCommandAction.writeCommandAction((Project)module2.getProject(), (PsiFile[])new PsiFile[]{file2}).withName("Set Attribute Value").run(() -> {
            Collection attributes = PsiTreeUtil.findChildrenOfType((PsiElement)file2, XmlAttribute.class);
            int oldValueLen = oldValue.length();
            for (XmlAttribute attribute2 : attributes) {
                Object attributeValue;
                if (!attributeName.equals(attribute2.getLocalName()) || (attributeValue = attribute2.getValue()) == null) continue;
                if (oldValue.equals(attributeValue)) {
                    attribute2.setValue(newValue);
                    continue;
                }
                int index2 = ((String)attributeValue).indexOf(oldValue);
                if (index2 == -1 || index2 != 0 && ((String)attributeValue).charAt(index2 - 1) != '|' || index2 + oldValueLen != ((String)attributeValue).length() && ((String)attributeValue).charAt(index2 + oldValueLen) != '|') continue;
                attributeValue = ((String)attributeValue).substring(0, index2) + newValue + ((String)attributeValue).substring(index2 + oldValueLen);
                attribute2.setValue((String)attributeValue);
            }
        });
    }

    private static void handleDisableSandboxUrl(@NotNull Module module2, @Nullable HtmlLinkManager.RefreshableSurface surface) {
        RenderSecurityManager.sEnabled = false;
        surface.requestRender();
        Messages.showInfoMessage((Project)module2.getProject(), (String)"The custom view rendering sandbox was disabled for this session.\n\nYou can turn it off permanently by adding\nandroid.render.sandbox=false\nto {install}/bin/idea.properties.", (String)"Disabled Rendering Sandbox");
    }

    @UiThread
    @VisibleForTesting
    static void handleAddDependency(@NotNull String url, @NotNull Module module2) {
        assert (url.startsWith("addDependency:")) : url;
        String coordinateStr = url.substring("addDependency:".length());
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateStr + ":+"));
        if (coordinate == null) {
            Logger.getInstance(StudioHtmlLinkManager.class).warn("Invalid coordinate " + coordinateStr);
            return;
        }
        if (DependencyManagementUtil.addDependenciesWithUiConfirmation(module2, Collections.singletonList(coordinate), false, false).isEmpty()) {
            return;
        }
        Logger.getInstance(StudioHtmlLinkManager.class).warn("Could not add dependency " + coordinate);
    }

    static abstract class StudioCommandLink
    implements HtmlLinkManager.CommandLink {
        private final String myCommandName;
        private final PsiFile myFile;

        StudioCommandLink(@NotNull String commandName, @NotNull PsiFile file2) {
            this.myCommandName = commandName;
            this.myFile = file2;
        }

        @Override
        public void executeCommand() {
            WriteCommandAction.writeCommandAction((Project)this.myFile.getProject(), (PsiFile[])new PsiFile[]{this.myFile}).withName(this.myCommandName).run(() -> this.run());
        }
    }
}

