/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderParamsFlags;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.CachingImageFactory;
import com.android.tools.idea.rendering.ExecuteCallbacksResult;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.InteractionEventResult;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.NoDeviceException;
import com.android.tools.idea.rendering.ProblemSeverity;
import com.android.tools.idea.rendering.RenderAsyncActionExecutor;
import com.android.tools.idea.rendering.RenderConfiguration;
import com.android.tools.idea.rendering.RenderContext;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderModelManifest;
import com.android.tools.idea.rendering.RenderModelModule;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderResultStats;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderSessionCleanerKt;
import com.android.tools.idea.rendering.RenderTaskAllocationTrackerKt;
import com.android.tools.idea.rendering.StackTraceCapture;
import com.android.tools.idea.rendering.classloading.ClassTransform;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutFilePullParser;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.LayoutRenderPullParser;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kotlin.jvm.functions.Function0;
import org.jetbrains.android.uipreview.ClassLoaderPreloaderKt;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.uipreview.ModuleClassLoaderManager;
import org.jetbrains.android.uipreview.ModuleRenderContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderTask {
    private static final Logger LOG = Logger.getInstance(RenderTask.class);
    private static final int MIN_BITMAP_SIZE_PX = 1;
    private static final IImageFactory SIMPLE_IMAGE_FACTORY = new IImageFactory(){

        @NotNull
        public BufferedImage getImage(int width, int height) {
            BufferedImage image = new BufferedImage(Math.max(1, width), Math.max(1, height), 2);
            image.setAccelerationPriority(1.0f);
            return image;
        }
    };
    private static final int DEFAULT_DOWNSCALED_IMAGE_MAX_BYTES = 2500000;
    private static final ExecutorService ourDisposeService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"RenderTask Dispose Thread", (int)1);
    @NotNull
    private final ImagePool myImagePool;
    @NotNull
    private final RenderContext myContext;
    @NotNull
    private final ModuleClassLoaderManager myClassLoaderManager;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final LayoutlibCallbackImpl myLayoutlibCallback;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @NotNull
    private final HardwareConfigHelper myHardwareConfigHelper;
    private final float myMinDownscalingFactor;
    private final float myDefaultQuality;
    private final long myDownScaledImageMaxBytes;
    @Nullable
    private IncludeReference myIncludedWithin;
    @NotNull
    private SessionParams.RenderingMode myRenderingMode = SessionParams.RenderingMode.NORMAL;
    private boolean mySetTransparentBackground = false;
    private boolean myShowDecorations = true;
    private boolean myEnableLayoutScanner = false;
    private boolean myShowWithToolsVisibilityAndPosition = true;
    private Function<Object, List<ViewInfo>> myCustomContentHierarchyParser = null;
    private long myTimeout;
    @NotNull
    private final Locale myLocale;
    @NotNull
    private final Object myCredential;
    private boolean myProvideCookiesForIncludedViews = false;
    @Nullable
    private RenderSession myRenderSession;
    @NotNull
    private IImageFactory myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
    @Nullable
    private IImageFactory myImageFactoryDelegate;
    private final boolean isSecurityManagerEnabled;
    @NotNull
    private CrashReporter myCrashReporter;
    private final List<CompletableFuture<?>> myRunningFutures = new LinkedList();
    @NotNull
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    @Nullable
    private RenderXmlFile myXmlFile;
    @NotNull
    private final ModuleClassLoader myModuleClassLoader;
    private final boolean reportOutOfDateUserClasses;
    @NotNull
    private final RenderAsyncActionExecutor.RenderingPriority myPriority;

    RenderTask(@NotNull RenderContext renderContext, @NotNull ModuleClassLoaderManager classLoaderManager, @NotNull RenderLogger logger2, @NotNull LayoutLibrary layoutLib, @NotNull Object credential, @NotNull CrashReporter crashReporter, @NotNull ImagePool imagePool, @Nullable ILayoutPullParserFactory parserFactory, boolean isSecurityManagerEnabled, float quality, @NotNull StackTraceCapture stackTraceCaptureElement, boolean privateClassLoader, @NotNull ClassTransform additionalProjectTransform, @NotNull ClassTransform additionalNonProjectTransform, @NotNull Runnable onNewModuleClassLoader, @NotNull Collection<String> classesToPreload, boolean reportOutOfDateUserClasses, @NotNull RenderAsyncActionExecutor.RenderingPriority priority, float minDownscalingFactor) throws NoDeviceException {
        this.myImagePool = imagePool;
        this.myContext = renderContext;
        this.myClassLoaderManager = classLoaderManager;
        this.isSecurityManagerEnabled = isSecurityManagerEnabled;
        this.reportOutOfDateUserClasses = reportOutOfDateUserClasses;
        if (!isSecurityManagerEnabled) {
            LOG.debug("Security manager was disabled");
        }
        this.myPriority = priority;
        this.myLogger = logger2;
        this.myCredential = credential;
        this.myCrashReporter = crashReporter;
        Device device2 = renderContext.getConfiguration().getDevice();
        if (device2 == null) {
            throw new NoDeviceException();
        }
        this.myHardwareConfigHelper = new HardwareConfigHelper(device2);
        ScreenOrientation orientation = renderContext.getConfiguration().getFullConfig().getScreenOrientationQualifier() != null ? renderContext.getConfiguration().getFullConfig().getScreenOrientationQualifier().getValue() : ScreenOrientation.PORTRAIT;
        this.myHardwareConfigHelper.setOrientation(orientation);
        this.myLayoutLib = layoutLib;
        ActionBarHandler actionBarHandler = new ActionBarHandler(this, this.myCredential);
        WeakReference<RenderTask> xmlFileProvider = new WeakReference<RenderTask>(this);
        ModuleRenderContext moduleRenderContext = ModuleRenderContext.forFile(renderContext.getModule(), () -> {
            RenderTask task2 = (RenderTask)xmlFileProvider.get();
            RenderXmlFile xmlFile = task2 != null ? task2.getXmlFile() : null;
            return xmlFile != null ? xmlFile.getPsiFile() : null;
        });
        if (privateClassLoader) {
            this.myModuleClassLoader = classLoaderManager.getPrivate(this.myLayoutLib.getClassLoader(), moduleRenderContext, this, additionalProjectTransform, additionalNonProjectTransform);
            onNewModuleClassLoader.run();
        } else {
            this.myModuleClassLoader = classLoaderManager.getShared(this.myLayoutLib.getClassLoader(), moduleRenderContext, this, additionalProjectTransform, additionalNonProjectTransform, onNewModuleClassLoader);
        }
        ClassLoaderPreloaderKt.preload(this.myModuleClassLoader, (Function0<Boolean>)((Function0)() -> Disposer.isDisposed((Disposable)this.myModuleClassLoader)), classesToPreload);
        try {
            this.myLayoutlibCallback = new LayoutlibCallbackImpl(this, this.myLayoutLib, renderContext.getModule(), this.myLogger, this.myCredential, actionBarHandler, parserFactory, this.myModuleClassLoader);
            if (renderContext.getModule().getResourceIdManager().getFinalIdsUsed()) {
                this.myLayoutlibCallback.loadAndParseRClass();
            }
            this.myLocale = renderContext.getConfiguration().getLocale();
            this.myMinDownscalingFactor = minDownscalingFactor;
            this.myDefaultQuality = quality;
            this.myDownScaledImageMaxBytes = "_device_class_desktop".equals(device2.getId()) ? 18000000L : ("_device_class_tablet".equals(device2.getId()) ? 9000000L : 2500000L);
            this.restoreDefaultQuality();
            stackTraceCaptureElement.bind(this);
        }
        catch (Exception ex) {
            this.clearClassLoader();
            throw ex;
        }
    }

    public void setQuality(float quality) {
        if (quality >= 1.0f) {
            this.myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
            return;
        }
        float actualSamplingFactor = this.myMinDownscalingFactor + Math.max(Math.min(quality, 1.0f), 0.0f) * (1.0f - this.myMinDownscalingFactor);
        long maxSize = (long)((float)this.myDownScaledImageMaxBytes * actualSamplingFactor);
        this.myCachingImageFactory = new CachingImageFactory((width, height) -> {
            int downscaleWidth = width;
            int downscaleHeight = height;
            int size = width * height;
            if ((long)size > maxSize) {
                double scale = (double)maxSize / (double)size;
                downscaleWidth = (int)((double)downscaleWidth * scale);
                downscaleHeight = (int)((double)downscaleHeight * scale);
            }
            return SIMPLE_IMAGE_FACTORY.getImage(downscaleWidth, downscaleHeight);
        });
    }

    public void restoreDefaultQuality() {
        this.setQuality(this.myDefaultQuality);
    }

    public void setXmlFile(@NotNull RenderXmlFile file2) {
        this.myXmlFile = file2;
        ReadAction.run(() -> this.getContext().setFolderType(file2.getFolderType()));
    }

    @Nullable
    public RenderXmlFile getXmlFile() {
        return this.myXmlFile;
    }

    @NotNull
    public IRenderLogger getLogger() {
        return this.myLogger;
    }

    @NotNull
    public HardwareConfigHelper getHardwareConfigHelper() {
        return this.myHardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public boolean getShowWithToolsVisibilityAndPosition() {
        return this.myShowWithToolsVisibilityAndPosition;
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    private void clearClassLoader() {
        try {
            this.myClassLoaderManager.release(this.myModuleClassLoader, this);
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    public Future<?> dispose() {
        if (this.isDisposed.getAndSet(true)) {
            assert (false) : "RenderTask was already disposed";
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("RenderTask was already disposed"));
        }
        RenderTaskAllocationTrackerKt.captureDisposeStackTrace().bind(this);
        return ourDisposeService.submit(() -> {
            try {
                CompletableFuture[] currentRunningFutures;
                List<CompletableFuture<?>> list2 = this.myRunningFutures;
                synchronized (list2) {
                    currentRunningFutures = this.myRunningFutures.toArray(new CompletableFuture[0]);
                    this.myRunningFutures.clear();
                }
                CompletableFuture.allOf(currentRunningFutures).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            this.myLayoutlibCallback.setLogger(IRenderLogger.NULL_LOGGER);
            if (this.myRenderSession != null) {
                try {
                    ((CompletableFuture)this.disposeRenderSession(this.myRenderSession).whenComplete((result2, ex) -> this.clearClassLoader())).join();
                    this.myRenderSession = null;
                }
                catch (Exception exception) {}
            } else {
                this.clearClassLoader();
            }
            this.myImageFactoryDelegate = null;
            Disposer.dispose((Disposable)this.myContext.getModule());
            return null;
        });
    }

    @NotNull
    public RenderTask setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        return this;
    }

    @NotNull
    public RenderTask setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        return this;
    }

    @NotNull
    public RenderTask setRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
        this.myRenderingMode = renderingMode;
        return this;
    }

    @NotNull
    public RenderTask setTimeout(long timeout) {
        this.myTimeout = timeout;
        return this;
    }

    @NotNull
    public RenderTask setTransparentBackground() {
        this.mySetTransparentBackground = true;
        return this;
    }

    @NotNull
    public RenderTask setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        return this;
    }

    public RenderTask setEnableLayoutScanner(boolean enableLayoutScanner) {
        this.myEnableLayoutScanner = enableLayoutScanner;
        return this;
    }

    @NotNull
    public RenderTask setShowWithToolsVisibilityAndPosition(boolean showWithToolsVisibilityAndPosition) {
        this.myShowWithToolsVisibilityAndPosition = showWithToolsVisibilityAndPosition;
        return this;
    }

    @NotNull
    public RenderTask setCustomContentHierarchyParser(@NotNull Function<Object, List<ViewInfo>> parser2) {
        this.myCustomContentHierarchyParser = parser2;
        return this;
    }

    public boolean getProvideCookiesForIncludedViews() {
        return this.myProvideCookiesForIncludedViews;
    }

    @Nullable
    private static String getRootTagName(@NotNull RenderXmlFile file2) {
        ResourceFolderType folderType = file2.getFolderType();
        if (folderType == ResourceFolderType.XML || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.DRAWABLE) {
            RenderXmlTag rootTag = file2.getRootTag();
            return rootTag == null ? null : rootTag.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RenderResult createRenderSession(@NotNull IImageFactory factory2) {
        RenderSecurityManager securityManager;
        IAndroidTarget target2;
        ILayoutPullParser includingParser;
        RenderContext context2 = this.getContext();
        RenderModelModule module2 = context2.getModule();
        if (module2.isDisposed()) {
            return null;
        }
        RenderXmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("createRenderSession shouldn't be called on RenderTask without PsiFile");
        }
        if (this.isDisposed.get()) {
            return null;
        }
        RenderConfiguration configuration = context2.getConfiguration();
        ResourceResolver resolver = ResourceResolver.copy((ResourceResolver)configuration.getResourceResolver());
        if (resolver == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParsers.create(this);
        if (modelParser == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        if (modelParser instanceof LayoutRenderPullParser) {
            boolean useSrcCompat = context2.getModule().getDependencies().getDependsOnAppCompat() || context2.getModule().getDependencies().getDependsOnAndroidXAppCompat();
            ((LayoutRenderPullParser)modelParser).setUseSrcCompat(useSrcCompat);
            this.myLayoutlibCallback.setAaptDeclaredResources((Map<String, TagSnapshot>)((LayoutRenderPullParser)modelParser).getAaptDeclaredAttrs());
        }
        if ((includingParser = this.getIncludingLayoutParser((RenderResources)resolver, modelParser)) != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target2 = configuration.getTarget()) instanceof CompatibilityRenderTarget ? target2.getVersion().getApiLevel() : 0;
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params2 = new SessionParams(modelParser, this.myRenderingMode, context2.getModule().getModuleKey(), hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context2.getMinSdkVersion().getApiLevel(), context2.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger, simulatedPlatform);
        params2.setAssetRepository(context2.getModule().getAssetRepository());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG, (Object)RenderTask.getRootTagName(xmlFile));
        params2.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)true);
        params2.setFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE, (Object)true);
        params2.setFlag(RenderParamsFlags.FLAG_KEY_RESULT_IMAGE_AUTO_SCALE, (Object)true);
        params2.setFlag(RenderParamsFlags.FLAG_KEY_ENABLE_LAYOUT_SCANNER, (Object)this.myEnableLayoutScanner);
        params2.setFlag(RenderParamsFlags.FLAG_ENABLE_LAYOUT_SCANNER_IMAGE_CHECK, (Object)this.myEnableLayoutScanner);
        params2.setFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH, (Object)configuration.getAdaptiveShape().getPathDescription());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON, (Object)configuration.getUseThemedIcon());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH, (Object)configuration.getWallpaperPath());
        params2.setCustomContentHierarchyParser(this.myCustomContentHierarchyParser);
        params2.setExtendedViewInfoMode(true);
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL && !this.getLayoutLib().isRtl(this.myLocale.toLocaleId())) {
            params2.setLocale("ur");
        } else {
            params2.setLocale(this.myLocale.toLocaleId());
        }
        try {
            RenderModelManifest manifestInfo = context2.getModule().getManifest();
            params2.setRtlSupport(manifestInfo != null && manifestInfo.isRtlSupported());
        }
        catch (Exception manifestInfo) {
            // empty catch block
        }
        Device device2 = configuration.getDevice();
        if (!this.myShowDecorations || HardwareConfigHelper.isWear((Device)device2)) {
            params2.setForceNoDecor();
        } else {
            try {
                ResourceValue resource;
                String activity;
                ResourceValue appLabel;
                RenderModelManifest manifestInfo = context2.getModule().getManifest();
                Object object = appLabel = manifestInfo != null ? manifestInfo.getApplicationLabel() : new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STRING, "appName", "");
                if (manifestInfo != null) {
                    params2.setAppIcon(manifestInfo.getApplicationIcon());
                }
                if ((activity = configuration.getActivity()) != null) {
                    ActivityAttributesSnapshot attributes;
                    params2.setActivityName(activity);
                    ActivityAttributesSnapshot activityAttributesSnapshot = attributes = manifestInfo != null ? manifestInfo.getActivityAttributes(activity) : null;
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            appLabel = attributes.getLabel();
                        }
                        if (attributes.getIcon() != null) {
                            params2.setAppIcon(attributes.getIcon());
                        }
                    }
                }
                if ((resource = params2.getResources().resolveResValue(appLabel)) != null) {
                    params2.setAppLabel(resource.getValue());
                }
            }
            catch (Exception manifestInfo) {
                // empty catch block
            }
        }
        if (this.mySetTransparentBackground || this.requiresTransparency()) {
            params2.setTransparentBackground();
        }
        params2.setImageFactory(factory2);
        if (this.myTimeout > 0L) {
            params2.setTimeout(this.myTimeout);
        }
        params2.setFontScale(configuration.getFontScale());
        params2.setUiMode(configuration.getUiModeFlagValue());
        this.myLayoutlibCallback.setLogger(this.myLogger);
        RenderSecurityManager renderSecurityManager = securityManager = this.isSecurityManagerEnabled ? RenderSecurityManagerFactory.create(module2.getProject().getBasePath(), context2.getModule().getAndroidPlatform()) : null;
        if (securityManager != null) {
            securityManager.setActive(true, this.myCredential);
        }
        try {
            RenderSession session2 = this.myLayoutLib.createSession(params2);
            if (session2.getResult().isSuccess()) {
                session2.setSystemBootTimeNanos(0L);
                session2.setSystemTimeNanos(0L);
                session2.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            RenderResult result2 = RenderResult.create(context2, session2, xmlFile.getPsiFile(), this.myLogger, this.myImagePool.copyOf(session2.getImage()), this.myLayoutlibCallback.isUsed());
            RenderSession oldRenderSession = this.myRenderSession;
            this.myRenderSession = session2;
            if (oldRenderSession != null) {
                this.disposeRenderSession(oldRenderSession);
            }
            this.addDiagnostics(result2.getRenderResult());
            RenderResult renderResult = result2;
            if (securityManager != null) {
                securityManager.dispose(this.myCredential);
            }
            return renderResult;
        }
        catch (Throwable throwable) {
            try {
                if (securityManager != null) {
                    securityManager.dispose(this.myCredential);
                }
                throw throwable;
            }
            catch (RuntimeException t) {
                this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
                throw t;
            }
        }
    }

    @Nullable
    private ILayoutPullParser getIncludingLayoutParser(RenderResources resolver, ILayoutPullParser modelParser) {
        RenderXmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("getIncludingLayoutParser shouldn't be called on RenderTask without PsiFile");
        }
        if (!this.myShowWithToolsVisibilityAndPosition) {
            return null;
        }
        if (this.myIncludedWithin == null) {
            this.myIncludedWithin = this.myContext.getModule().getEnvironment().createIncludeReference(xmlFile, resolver);
        }
        ILayoutPullParser topParser = null;
        if (this.myIncludedWithin != IncludeReference.NONE) {
            String queryLayoutName = SdkUtils.fileNameToResourceName((String)xmlFile.getName());
            this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
            RenderXmlFile fromXmlFile = this.myIncludedWithin.getFromXmlFile(this.myContext.getModule().getProject());
            if (fromXmlFile != null) {
                LayoutRenderPullParser parser2 = LayoutRenderPullParser.create(fromXmlFile, this.myLogger, this.myContext.getModule().getResourceRepositoryManager());
                parser2.setProvideViewCookies(this.myProvideCookiesForIncludedViews);
                topParser = parser2;
            } else {
                topParser = LayoutFilePullParser.create(new PathString(this.myIncludedWithin.getFromPath()), ResourceNamespace.TODO());
                if (topParser == null) {
                    this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), null, null, null);
                }
            }
        }
        return topParser;
    }

    private static <T> CompletableFuture<T> immediateFailedFuture(Throwable exception) {
        CompletableFuture future2 = new CompletableFuture();
        future2.completeExceptionally(exception);
        return future2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    private <V> CompletableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable, long timeout, @NotNull TimeUnit unit) {
        if (this.isDisposed.get()) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("RenderTask was already disposed"));
        }
        List<CompletableFuture<?>> list2 = this.myRunningFutures;
        synchronized (list2) {
            CompletableFuture newFuture = timeout < 1L ? RenderService.getRenderAsyncActionExecutor().runAsyncAction(this.myPriority, callable) : RenderService.getRenderAsyncActionExecutor().runAsyncActionWithTimeout(timeout, unit, this.myPriority, callable);
            this.myRunningFutures.add(newFuture);
            newFuture.whenCompleteAsync((result2, ex) -> {
                List<CompletableFuture<?>> list2 = this.myRunningFutures;
                synchronized (list2) {
                    this.myRunningFutures.remove(newFuture);
                }
            });
            return newFuture;
        }
    }

    @VisibleForTesting
    @NotNull
    public <V> CompletableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable) {
        return this.runAsyncRenderAction(callable, 0L, TimeUnit.SECONDS);
    }

    @NotNull
    public CompletableFuture<RenderResult> inflate() {
        RenderXmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("inflate shouldn't be called on RenderTask without PsiFile"));
        }
        if (xmlFile.getProject().isDisposed()) {
            return CompletableFuture.completedFuture(null);
        }
        long startInflateTimeMs = System.currentTimeMillis();
        return this.runAsyncRenderAction(() -> this.createRenderSession((width, height) -> {
            if (this.myImageFactoryDelegate != null) {
                return this.myImageFactoryDelegate.getImage(width, height);
            }
            return new BufferedImage(width, height, 2);
        }), RenderAsyncActionExecutor.DEFAULT_RENDER_THREAD_TIMEOUT_MS * 10L, TimeUnit.MILLISECONDS).handle((result2, ex) -> {
            if (ex != null) {
                while (ex instanceof CompletionException) {
                    ex = ex.getCause();
                }
                String message2 = ex.getMessage();
                if (message2 == null) {
                    message2 = ex.toString();
                }
                RenderProblem.RunnableFixFactory fixFactory = this.myContext.getModule().getEnvironment().getRunnableFixFactory();
                this.myLogger.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, message2, this.myLogger.getProject(), this.myLogger.getLinkManager(), ex, fixFactory));
            }
            if (result2 != null) {
                return result2.createWithStats(new RenderResultStats(System.currentTimeMillis() - startInflateTimeMs, -1L, this.myModuleClassLoader.getStats()));
            }
            if (xmlFile.isValid()) {
                return RenderResult.createRenderTaskErrorResult(this.myContext.getModule(), xmlFile.getPsiFile(), ex);
            }
            LOG.warn("Invalid file " + xmlFile);
            return null;
        });
    }

    @NotNull
    public CompletableFuture<RenderResult> layout() {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        assert (this.getXmlFile() != null);
        try {
            RenderSession renderSession = this.myRenderSession;
            RenderXmlFile xmlFile = this.getXmlFile();
            return this.runAsyncRenderAction(() -> {
                this.myRenderSession.measure();
                return RenderResult.create(this.myContext, renderSession, xmlFile.getPsiFile(), this.myLogger, ImagePool.NULL_POOLED_IMAGE, this.myLayoutlibCallback.isUsed());
            });
        }
        catch (Exception exception) {
            return CompletableFuture.completedFuture(null);
        }
    }

    @NotNull
    public CompletableFuture<ExecuteCallbacksResult> executeCallbacks(long timeNanos) {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(ExecuteCallbacksResult.EMPTY);
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            long start2 = System.currentTimeMillis();
            boolean hasMoreCallbacks = this.myRenderSession.executeCallbacks(timeNanos);
            return ExecuteCallbacksResult.create(hasMoreCallbacks, System.currentTimeMillis() - start2);
        }, 500L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public CompletableFuture<InteractionEventResult> triggerTouchEvent(@NotNull RenderSession.TouchEventType touchEventType, int x, int y, long timeNanos) {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            long start2 = System.currentTimeMillis();
            this.myRenderSession.triggerTouchEvent(touchEventType, x, y);
            return InteractionEventResult.create(System.currentTimeMillis() - start2);
        });
    }

    @NotNull
    public CompletableFuture<InteractionEventResult> triggerKeyEvent(@NotNull KeyEvent event2, long timeNanos) {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            long start2 = System.currentTimeMillis();
            this.myRenderSession.triggerKeyEvent(event2);
            return InteractionEventResult.create(System.currentTimeMillis() - start2);
        });
    }

    private void reportException(@NotNull Throwable e) {
        if (e instanceof CancellationException) {
            return;
        }
        this.myCrashReporter.submit((CrashReport)new StudioExceptionReport.Builder().setThrowable(e, false, true).build());
    }

    @NotNull
    private CompletableFuture<RenderResult> renderInner() {
        RenderXmlFile xmlFile = this.getXmlFile();
        assert (xmlFile != null);
        CompletionStage<Object> inflateCompletableResult = this.myRenderSession == null ? this.inflate().whenComplete((renderResult, exception) -> {
            Result result2;
            Result result3 = result2 = renderResult != null ? renderResult.getRenderResult() : null;
            if (result2 == null || !result2.isSuccess()) {
                Throwable e;
                Throwable throwable = e = result2 != null ? result2.getException() : exception;
                if (e != null) {
                    this.reportException(e);
                }
                if (result2 != null) {
                    this.myLogger.error(null, result2.getErrorMessage(), e, null, null);
                }
            }
        }) : CompletableFuture.completedFuture(null);
        return inflateCompletableResult.thenCompose(inflateResult -> {
            try {
                long startRenderTimeMs = System.currentTimeMillis();
                return this.runAsyncRenderAction(() -> {
                    this.myRenderSession.render();
                    RenderResult result2 = RenderResult.create(this.myContext, this.myRenderSession, xmlFile.getPsiFile(), this.myLogger, this.myImagePool.copyOf(this.myRenderSession.getImage()), this.myLayoutlibCallback.isUsed());
                    Result renderResult = result2.getRenderResult();
                    if (renderResult.getException() != null) {
                        this.reportException(renderResult.getException());
                        this.myLogger.error(null, renderResult.getErrorMessage(), renderResult.getException(), null, null);
                    }
                    if (this.reportOutOfDateUserClasses && !this.myModuleClassLoader.isUserCodeUpToDate()) {
                        RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                        HtmlBuilder builder2 = problem.getHtmlBuilder();
                        builder2.addLink("The project has been edited more recently than the last build: ", "Build", " the project.", this.myLogger.getLinkManager().createBuildProjectUrl());
                        this.myLogger.addMessage(problem);
                    }
                    return result2;
                }).handle((result2, ex) -> {
                    RenderSessionCleanerKt.clearGapWorkerCache(this.myLayoutlibCallback);
                    return result2.createWithStats(new RenderResultStats(inflateResult != null ? inflateResult.getStats().getInflateDurationMs() : result2.getStats().getInflateDurationMs(), System.currentTimeMillis() - startRenderTimeMs, this.myModuleClassLoader.getStats().getClassesFound(), this.myModuleClassLoader.getStats().getAccumulatedFindTimeMs(), this.myModuleClassLoader.getStats().getAccumulatedRewriteTimeMs()));
                });
            }
            catch (Exception e) {
                this.reportException(e);
                String message2 = e.getMessage();
                if (message2 == null) {
                    message2 = e.toString();
                }
                RenderProblem.RunnableFixFactory fixFactory = this.myContext.getModule().getEnvironment().getRunnableFixFactory();
                this.myLogger.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, message2, this.myLogger.getProject(), this.myLogger.getLinkManager(), e, fixFactory));
                return CompletableFuture.completedFuture(RenderResult.createRenderTaskErrorResult(this.myContext.getModule(), xmlFile.getPsiFile(), e));
            }
        });
    }

    @NotNull
    CompletableFuture<RenderResult> render(@NotNull IImageFactory factory2) {
        this.myImageFactoryDelegate = factory2;
        return this.renderInner();
    }

    @NotNull
    public CompletableFuture<RenderResult> render() {
        return this.render(this.myCachingImageFactory);
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        if (this.myRenderSession != null) {
            this.myRenderSession.setElapsedFrameTimeNanos(nanos);
        }
    }

    private void addDiagnostics(@NotNull Result result2) {
        ILayoutPullParser layoutEmbeddedParser;
        if (!this.myLogger.hasProblems() && !result2.isSuccess()) {
            if (result2.getException() != null || result2.getErrorMessage() != null) {
                this.myLogger.error(null, result2.getErrorMessage(), result2.getException(), null, null);
            } else if (result2.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null, null, null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + result2.getStatus(), null, null, null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null, null, null);
        }
    }

    @NotNull
    public CompletableFuture<BufferedImage> renderDrawable(@NotNull ResourceValue drawableResourceValue) {
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        RenderContext context2 = this.getContext();
        RenderConfiguration configuration = context2.getConfiguration();
        DrawableParams params2 = new DrawableParams(drawableResourceValue, context2.getModule().getModuleKey(), hardwareConfig, (RenderResources)configuration.getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, context2.getMinSdkVersion().getApiLevel(), context2.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger);
        params2.setForceNoDecor();
        params2.setAssetRepository(context2.getModule().getAssetRepository());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH, (Object)configuration.getAdaptiveShape().getPathDescription());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON, (Object)configuration.getUseThemedIcon());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH, (Object)configuration.getWallpaperPath());
        return this.runAsyncRenderAction(() -> this.myLayoutLib.renderDrawable(params2)).thenCompose(result2 -> {
            Throwable exception;
            if (result2 != null && result2.isSuccess()) {
                Object data = result2.getData();
                if (!(data instanceof BufferedImage)) {
                    data = null;
                }
                return CompletableFuture.completedFuture((BufferedImage)data);
            }
            if (result2.getStatus() == Result.Status.ERROR_NOT_A_DRAWABLE) {
                LOG.debug("renderDrawable called with a non-drawable resource" + drawableResourceValue);
                return CompletableFuture.completedFuture(null);
            }
            Throwable throwable = exception = result2 == null ? new RuntimeException("Rendering failed - null result") : result2.getException();
            if (exception == null) {
                String message2 = result2.getErrorMessage();
                exception = new RuntimeException((String)(message2 == null ? "Rendering failed" : "Rendering failed - " + message2));
            }
            this.reportException(exception);
            return RenderTask.immediateFailedFuture(exception);
        });
    }

    @NotNull
    private LayoutLibrary getLayoutLib() {
        return this.myLayoutLib;
    }

    @NotNull
    public LayoutlibCallbackImpl getLayoutlibCallback() {
        return this.myLayoutlibCallback;
    }

    private boolean isNonRectangular() {
        ResourceFolderType folderType = this.getContext().getFolderType();
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
    }

    private boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    @NotNull
    public CompletableFuture<Map<RenderXmlTag, ViewInfo>> measureChildren(@NotNull RenderXmlTag parent2, @Nullable AttributeFilter filter2) {
        LayoutRenderPullParser modelParser = LayoutRenderPullParser.create(filter2, parent2, this.myLogger, this.myContext.getModule().getResourceRepositoryManager());
        HashMap map2 = new HashMap();
        return RenderService.getRenderAsyncActionExecutor().runAsyncAction(this.myPriority, () -> this.measure(modelParser)).thenComposeAsync(session2 -> {
            if (session2 != null) {
                try {
                    Result result2 = session2.getResult();
                    if (result2 != null && result2.isSuccess()) {
                        assert (session2.getRootViews().size() == 1);
                        ViewInfo root = (ViewInfo)session2.getRootViews().get(0);
                        List children2 = root.getChildren();
                        for (ViewInfo info2 : children2) {
                            RenderXmlTag tag = RenderService.getXmlTag(info2);
                            if (tag == null) continue;
                            map2.put(tag, info2);
                        }
                    }
                    CompletableFuture<Map> completableFuture = CompletableFuture.completedFuture(map2);
                    return completableFuture;
                }
                finally {
                    this.disposeRenderSession((RenderSession)session2);
                }
            }
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public CompletableFuture<ViewInfo> measureChild(@NotNull RenderXmlTag tag, @Nullable AttributeFilter filter2) {
        RenderXmlTag parent2 = tag.getParentTag();
        if (parent2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.measureChildren(parent2, filter2).thenApply(map2 -> (ViewInfo)map2.get(tag));
    }

    @Nullable
    private RenderSession measure(ILayoutPullParser parser2) {
        RenderContext context2 = this.getContext();
        RenderConfiguration configuration = context2.getConfiguration();
        ResourceResolver resolver = configuration.getResourceResolver();
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params2 = new SessionParams(parser2, SessionParams.RenderingMode.NORMAL, context2.getModule().getModuleKey(), hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context2.getMinSdkVersion().getApiLevel(), context2.getTargetSdkVersion().getApiLevel(), (ILayoutLog)this.myLogger);
        params2.setForceNoDecor();
        params2.setExtendedViewInfoMode(true);
        params2.setLocale(this.myLocale.toLocaleId());
        params2.setAssetRepository(context2.getModule().getAssetRepository());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH, (Object)configuration.getAdaptiveShape().getPathDescription());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON, (Object)configuration.getUseThemedIcon());
        params2.setFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH, (Object)configuration.getWallpaperPath());
        RenderModelManifest manifestInfo = context2.getModule().getManifest();
        params2.setRtlSupport(manifestInfo != null && manifestInfo.isRtlSupported());
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            return this.myLayoutLib.createSession(params2);
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
            throw t;
        }
    }

    @NotNull
    public CompletableFuture<Void> runAsyncRenderActionWithSession(@NotNull Runnable block) {
        if (this.isDisposed.get()) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("RenderTask was already disposed"));
        }
        RenderSession renderSession = this.myRenderSession;
        if (renderSession == null) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("No RenderSession available"));
        }
        return this.runAsyncRenderAction(() -> {
            renderSession.execute(block);
            return null;
        });
    }

    @VisibleForTesting
    void setCrashReporter(@NotNull CrashReporter crashReporter) {
        this.myCrashReporter = crashReporter;
    }

    @NotNull
    public RenderContext getContext() {
        return this.myContext;
    }

    @NotNull
    private CompletableFuture<Void> disposeRenderSession(@NotNull RenderSession renderSession) {
        return RenderSessionCleanerKt.dispose(renderSession, this.myLayoutlibCallback);
    }

    public static interface AttributeFilter {
        @Nullable
        public String getAttribute(@NotNull RenderXmlTag var1, @Nullable String var2, @NotNull String var3);
    }
}

