/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.tools.idea.rendering.EnvironmentContext;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.NoAndroidPlatformException;
import com.android.tools.idea.rendering.NoAndroidTargetException;
import com.android.tools.idea.rendering.NoDeviceException;
import com.android.tools.idea.rendering.ProblemSeverity;
import com.android.tools.idea.rendering.RenderAsyncActionExecutor;
import com.android.tools.idea.rendering.RenderConfiguration;
import com.android.tools.idea.rendering.RenderContext;
import com.android.tools.idea.rendering.RenderExecutor;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderModelModule;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.RenderTaskAllocationTrackerKt;
import com.android.tools.idea.rendering.StackTraceCapture;
import com.android.tools.idea.rendering.classloading.ClassTransform;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.imagepool.ImagePoolFactory;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidTargetData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.android.uipreview.StudioModuleClassLoaderManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class RenderService
implements Disposable {
    private static RenderExecutor ourExecutor = RenderExecutor.create();
    private static final String JDK_INSTALL_URL = "https://developer.android.com/preview/setup-sdk.html#java8";
    private final Object myCredential = new Object();
    private final ImagePool myImagePool = ImagePoolFactory.createImagePool();
    private final Consumer<RenderTaskBuilder> myConfigureBuilder;
    private static final int MEASURE_SPEC_MODE_SHIFT = 30;
    private static final int MAX_MAGNITUDE = 0x2000000;
    private static final RenderAsyncActionExecutor.RenderingPriority DEFAULT_RENDERING_PRIORITY = RenderAsyncActionExecutor.RenderingPriority.HIGH;

    @TestOnly
    public static void initializeRenderExecutor() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourExecutor = RenderExecutor.create();
    }

    protected static void shutdownRenderExecutor() {
        ourExecutor.shutdown();
    }

    @TestOnly
    public static void shutdownRenderExecutor(long timeoutSeconds) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourExecutor.shutdown(timeoutSeconds);
    }

    @NotNull
    public static RenderAsyncActionExecutor getRenderAsyncActionExecutor() {
        return ourExecutor;
    }

    @Nullable
    public static LayoutLibrary getLayoutLibrary(@Nullable IAndroidTarget target2, @Nullable AndroidPlatform platform, @NotNull EnvironmentContext environment) throws RenderingException, NoAndroidTargetException, NoAndroidPlatformException {
        if (platform == null) {
            throw new NoAndroidPlatformException();
        }
        if (target2 == null) {
            throw new NoAndroidTargetException();
        }
        return AndroidTargetData.get(platform.getSdkData(), target2).getLayoutLibrary(environment.getParentDisposable(), environment::hasLayoutlibCrash);
    }

    protected RenderService(@NotNull Consumer<RenderTaskBuilder> configureBuilder) {
        this.myConfigureBuilder = configureBuilder;
    }

    @NotNull
    public RenderLogger createLogger(@Nullable Project project, boolean logFramework, @NotNull RenderProblem.RunnableFixFactory fixFactory, @NotNull Supplier<HtmlLinkManager> linkManagerFactory) {
        return new RenderLogger(project, this.myCredential, logFramework, fixFactory, linkManagerFactory);
    }

    @NotNull
    public RenderLogger getNopLogger() {
        return RenderLogger.NOP_RENDER_LOGGER;
    }

    @NotNull
    public RenderTaskBuilder taskBuilder(@NotNull RenderModelModule module2, @NotNull RenderConfiguration configuration, @NotNull RenderLogger logger2) {
        RenderTaskBuilder builder2 = new RenderTaskBuilder(module2, configuration, this.myImagePool, this.myCredential, logger2);
        this.myConfigureBuilder.accept(builder2);
        return builder2;
    }

    public void dispose() {
        this.myImagePool.dispose();
    }

    public static boolean isBusy() {
        return ourExecutor.isBusy();
    }

    @NotNull
    public static ViewInfo getSafeBounds(@NotNull ViewInfo view) {
        int left2 = Math.abs(view.getLeft());
        int right = Math.abs(view.getRight());
        int top = Math.abs(view.getTop());
        int bottom = Math.abs(view.getBottom());
        if (left2 < 0x2000000 && right < 0x2000000 && top < 0x2000000 && bottom < 0x2000000) {
            return view;
        }
        return new ViewInfo(null, null, 0, 0, 0, 0);
    }

    @Nullable
    public static RenderXmlTag getXmlTag(@NotNull ViewInfo view) {
        Object cookie = view.getCookie();
        if (cookie != null) {
            if (cookie instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof MergeCookie && (cookie = ((MergeCookie)cookie).getCookie()) instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof RenderXmlTag) {
                return (RenderXmlTag)cookie;
            }
        }
        return null;
    }

    @NotNull
    public ImagePool getSharedImagePool() {
        return this.myImagePool;
    }

    private static Logger getLogger() {
        return Logger.getInstance(RenderService.class);
    }

    public static class RenderTaskBuilder {
        private final RenderContext myContext;
        private final Object myCredential;
        @NotNull
        private ImagePool myImagePool;
        @Nullable
        private XmlFile myXmlFile;
        @NotNull
        private final RenderLogger myLogger;
        @Nullable
        private ILayoutPullParserFactory myParserFactory;
        private boolean isSecurityManagerEnabled = true;
        private float myQuality = 1.0f;
        private boolean showDecorations = true;
        private boolean showWithToolsVisibilityAndPosition = true;
        private int myMaxRenderWidth = -1;
        private int myMaxRenderHeight = -1;
        private boolean enableLayoutScanner = false;
        private SessionParams.RenderingMode myRenderingMode = null;
        private boolean useTransparentBackground = false;
        private Function<Object, List<ViewInfo>> myCustomContentHierarchyParser = null;
        private boolean privateClassLoader = false;
        private Collection<String> classesToPreload = Collections.emptyList();
        private ClassTransform myAdditionalProjectTransform = ClassTransform.getIdentity();
        private ClassTransform myAdditionalNonProjectTransform = ClassTransform.getIdentity();
        @NotNull
        private Runnable myOnNewModuleClassLoader = () -> {};
        private boolean reportOutOfDateUserClasses = true;
        @NotNull
        private RenderAsyncActionExecutor.RenderingPriority myPriority = DEFAULT_RENDERING_PRIORITY;
        private float myMinDownscalingFactor = 0.5f;

        private RenderTaskBuilder(@NotNull RenderModelModule module2, @NotNull RenderConfiguration configuration, @NotNull ImagePool defaultImagePool, @NotNull Object credential, @NotNull RenderLogger logger2) {
            this.myContext = new RenderContext(module2, configuration);
            this.myImagePool = defaultImagePool;
            this.myCredential = credential;
            this.myLogger = logger2;
        }

        @NotNull
        public RenderTaskBuilder preloadClasses(Collection<String> classesToPreload) {
            this.classesToPreload = classesToPreload;
            return this;
        }

        @NotNull
        public RenderTaskBuilder usePrivateClassLoader() {
            this.privateClassLoader = true;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withPsiFile(@NotNull XmlFile xmlFile) {
            this.myXmlFile = xmlFile;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withParserFactory(@NotNull ILayoutPullParserFactory parserFactory) {
            this.myParserFactory = parserFactory;
            return this;
        }

        public RenderTaskBuilder withLayoutScanner(Boolean enableLayoutScanner) {
            this.enableLayoutScanner = enableLayoutScanner;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableImagePool() {
            this.myImagePool = ImagePoolFactory.getNonPooledPool();
            return this;
        }

        @NotNull
        public RenderTaskBuilder withQuality(float quality) {
            this.myQuality = quality;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
            this.myMaxRenderWidth = maxRenderWidth;
            this.myMaxRenderHeight = maxRenderHeight;
            return this;
        }

        @TestOnly
        @VisibleForTesting
        @NotNull
        public RenderTaskBuilder disableSecurityManager() {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalStateException("This method can only be called in unit test mode");
            }
            this.isSecurityManagerEnabled = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableDecorations() {
            this.showDecorations = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableToolsVisibilityAndPosition() {
            this.showWithToolsVisibilityAndPosition = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
            this.myRenderingMode = renderingMode;
            return this;
        }

        @NotNull
        public RenderTaskBuilder useTransparentBackground() {
            this.useTransparentBackground = true;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setProjectClassesTransform(@NotNull ClassTransform transform2) {
            this.myAdditionalProjectTransform = transform2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setNonProjectClassesTransform(@NotNull ClassTransform transform2) {
            this.myAdditionalNonProjectTransform = transform2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setOnNewClassLoader(@NotNull Runnable runnable2) {
            this.myOnNewModuleClassLoader = runnable2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder doNotReportOutOfDateUserClasses() {
            this.reportOutOfDateUserClasses = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withPriority(@NotNull RenderAsyncActionExecutor.RenderingPriority priority) {
            this.myPriority = priority;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withMinDownscalingFactor(float downscalingFactor) {
            this.myMinDownscalingFactor = downscalingFactor;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setCustomContentHierarchyParser(@NotNull Function<Object, List<ViewInfo>> parser2) {
            this.myCustomContentHierarchyParser = parser2;
            return this;
        }

        @NotNull
        public CompletableFuture<RenderTask> build() {
            StackTraceCapture stackTraceCaptureElement = RenderTaskAllocationTrackerKt.captureAllocationStackTrace();
            return CompletableFuture.supplyAsync(() -> {
                LayoutLibrary layoutLib;
                RenderModelModule module2 = this.myContext.getModule();
                if (module2.isDisposed()) {
                    RenderService.getLogger().warn("Module was already disposed");
                    return null;
                }
                IAndroidTarget target2 = this.myContext.getConfiguration().getTarget();
                try {
                    layoutLib = RenderService.getLayoutLibrary(target2, module2.getAndroidPlatform(), module2.getEnvironment());
                }
                catch (UnsupportedJavaRuntimeException e) {
                    RenderProblem.Html javaVersionProblem = RenderProblem.create(ProblemSeverity.ERROR);
                    javaVersionProblem.getHtmlBuilder().add(e.getPresentableMessage()).newline().addLink("Install a supported JDK", RenderService.JDK_INSTALL_URL);
                    this.myLogger.addMessage(javaVersionProblem);
                    return null;
                }
                catch (RenderingException e) {
                    String message2 = e.getPresentableMessage();
                    message2 = message2 != null ? message2 : AndroidBundle.message("android.layout.preview.default.error.message", new Object[0]);
                    this.myLogger.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, message2, module2.getProject(), this.myLogger.getLinkManager(), e, module2.getEnvironment().getRunnableFixFactory()));
                    return null;
                }
                catch (NoAndroidTargetException e) {
                    this.myLogger.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, "No render target was chosen"));
                    return null;
                }
                catch (NoAndroidPlatformException e) {
                    this.myContext.getModule().getDependencies().reportMissingSdkDependency(this.myLogger);
                    return null;
                }
                try {
                    RenderTask task2 = new RenderTask(this.myContext, StudioModuleClassLoaderManager.get(), this.myLogger, layoutLib, this.myCredential, (CrashReporter)StudioCrashReporter.getInstance(), this.myImagePool, this.myParserFactory, this.isSecurityManagerEnabled, this.myQuality, stackTraceCaptureElement, this.privateClassLoader, this.myAdditionalProjectTransform, this.myAdditionalNonProjectTransform, this.myOnNewModuleClassLoader, this.classesToPreload, this.reportOutOfDateUserClasses, this.myPriority, this.myMinDownscalingFactor);
                    if (this.myXmlFile != null) {
                        task2.setXmlFile(new PsiXmlFile(this.myXmlFile));
                    }
                    task2.setDecorations(this.showDecorations).setShowWithToolsVisibilityAndPosition(this.showWithToolsVisibilityAndPosition).setEnableLayoutScanner(this.enableLayoutScanner);
                    if (this.myMaxRenderWidth != -1 && this.myMaxRenderHeight != -1) {
                        task2.setMaxRenderSize(this.myMaxRenderWidth, this.myMaxRenderHeight);
                    }
                    if (this.useTransparentBackground) {
                        task2.setTransparentBackground();
                    }
                    if (this.myRenderingMode != null) {
                        task2.setRenderingMode(this.myRenderingMode);
                    }
                    if (this.myCustomContentHierarchyParser != null) {
                        task2.setCustomContentHierarchyParser(this.myCustomContentHierarchyParser);
                    }
                    return task2;
                }
                catch (NoDeviceException e) {
                    this.myLogger.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, "No device selected"));
                    return null;
                }
                catch (IncorrectOperationException | AssertionError | IllegalStateException e) {
                    if (!module2.isDisposed()) {
                        throw e;
                    }
                    return null;
                }
            }, AppExecutorUtil.getAppExecutorService());
        }
    }
}

