/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.IdeaModuleProvider;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderResultStats;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\"\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createBlank", "Lcom/android/tools/idea/rendering/RenderResult;", "file", "Lcom/intellij/psi/PsiFile;", "createErrorResult", "errorResult", "Lcom/android/ide/common/rendering/api/Result;", "logger", "Lcom/android/tools/idea/rendering/RenderLogger;", "createRenderTaskErrorResult", "throwable", "", "intellij.android.core"})
@JvmName(name="RenderResults")
public final class RenderResults {
    @NotNull
    private static final Logger LOG;

    private static final RenderResult createErrorResult(PsiFile file2, Result errorResult, RenderLogger logger2) {
        boolean bl;
        Module module2 = (Module)ReadAction.compute((ThrowableComputable)new ThrowableComputable(file2){
            final /* synthetic */ PsiFile $file;
            {
                this.$file = $file;
            }

            public final Module compute() {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.$file));
            }
        });
        boolean bl2 = bl = module2 != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Project project = module2.getProject();
        IdeaModuleProvider ideaModuleProvider = new IdeaModuleProvider(module2){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
            }

            @NotNull
            public final Module getIdeaModule() {
                Module module2 = this.$module;
                Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
                return module2;
            }
        };
        RenderLogger renderLogger = logger2;
        if (renderLogger == null) {
            renderLogger = new RenderLogger(module2.getProject());
        }
        RenderResult result2 = new RenderResult(file2, project, ideaModuleProvider, renderLogger, null, false, errorResult, (ImmutableList<ViewInfo>)ImmutableList.of(), (ImmutableList<ViewInfo>)ImmutableList.of(), ImagePool.NULL_POOLED_IMAGE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), null, RenderResultStats.Companion.getEMPTY());
        if (LOG.isDebugEnabled()) {
            LOG.debug(result2.toString());
        }
        return result2;
    }

    @NotNull
    public static final RenderResult createBlank(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Result result2 = Result.Status.ERROR_UNKNOWN.createResult("");
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"ERROR_UNKNOWN.createResult(\"\")");
        return RenderResults.createErrorResult(file2, result2, null);
    }

    @NotNull
    public static final RenderResult createRenderTaskErrorResult(@NotNull PsiFile file2, @NotNull RenderLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Result result2 = Result.Status.ERROR_RENDER_TASK.createResult();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"ERROR_RENDER_TASK.createResult()");
        return RenderResults.createErrorResult(file2, result2, logger2);
    }

    @NotNull
    public static final RenderResult createRenderTaskErrorResult(@NotNull PsiFile file2, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Result result2 = Result.Status.ERROR_RENDER_TASK.createResult("Render error", throwable);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"ERROR_RENDER_TASK.create\u2026Render error\", throwable)");
        return RenderResults.createErrorResult(file2, result2, null);
    }

    static {
        Logger logger2 = Logger.getInstance(RenderResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(RenderResult::class.java)");
        LOG = logger2;
    }
}

