/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.ProblemSeverity;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderProblem
implements Comparable<RenderProblem> {
    public static final int PRIORITY_UNEXPECTED = 10;
    public static final int PRIORITY_RENDERING_FIDELITY = 1000;
    @NotNull
    private final ProblemSeverity mySeverity;
    private final int myOrdinal;
    private int myPriority = 10;
    @Nullable
    private Throwable myThrowable;
    @Nullable
    private Object myClientData;
    @Nullable
    private String myTag;
    protected boolean myIsDefaultHtml;
    private static int ourNextOrdinal;
    public static final RunnableFixFactory NOOP_RUNNABLE_FIX_FACTORY;

    @NotNull
    public static RenderProblem createPlain(@NotNull ProblemSeverity severity, @Nullable String message2) {
        return new Plain(severity, ourNextOrdinal++, message2 != null ? XmlUtils.toXmlTextValue((String)message2) : "");
    }

    @NotNull
    public static RenderProblem createPlain(@NotNull ProblemSeverity severity, @NotNull String message2, @Nullable Project project, @NotNull HtmlLinkManager linkManager, @Nullable Throwable throwable, @NotNull RunnableFixFactory fixFactory) {
        Html problem = new Html(severity, ourNextOrdinal++);
        HtmlBuilder builder2 = problem.getHtmlBuilder();
        builder2.add(message2);
        if (throwable != null) {
            problem.throwable(throwable);
            String url = linkManager.createRunnableLink(fixFactory.create(project, problem));
            builder2.add(" (").addLink("Details", url).add(")");
            if (message2.equals(throwable.getMessage())) {
                problem.myIsDefaultHtml = true;
            }
        }
        return problem;
    }

    @NotNull
    public static Html create(@NotNull ProblemSeverity severity) {
        return new Html(severity, ourNextOrdinal++);
    }

    @NotNull
    public static RenderProblem createDeferred(@NotNull ProblemSeverity severity, @Nullable String tag, @NotNull String text2, @Nullable Throwable throwable) {
        return new Deferred(severity, tag, text2, throwable);
    }

    private RenderProblem(@NotNull ProblemSeverity severity, int ordinal) {
        this.mySeverity = severity;
        this.myOrdinal = ordinal;
    }

    public RenderProblem throwable(@Nullable Throwable throwable) {
        this.myThrowable = throwable;
        return this;
    }

    public RenderProblem priority(int priority) {
        this.myPriority = priority;
        return this;
    }

    public RenderProblem tag(@Nullable String tag) {
        this.myTag = tag;
        return this;
    }

    @Nullable
    public String getTag() {
        return this.myTag;
    }

    @NotNull
    public abstract String getHtml();

    public boolean isDefaultHtml() {
        return this.myIsDefaultHtml;
    }

    public void appendHtml(@NotNull StringBuilder stringBuilder) {
        stringBuilder.append(this.getHtml());
    }

    @Override
    public int compareTo(RenderProblem other) {
        if (this.mySeverity != other.mySeverity) {
            return this.mySeverity.compareTo(other.mySeverity);
        }
        if (this.myPriority != other.myPriority) {
            return this.myPriority - other.myPriority;
        }
        return this.myOrdinal - other.myOrdinal;
    }

    @NotNull
    public static String format(List<RenderProblem> messages) {
        StringBuilder sb = new StringBuilder();
        for (RenderProblem message2 : messages) {
            sb.append(message2.getHtml());
            sb.append("<br/>\n");
        }
        return sb.toString();
    }

    @NotNull
    public ProblemSeverity getSeverity() {
        return this.mySeverity;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.myThrowable;
    }

    @Nullable
    public Object getClientData() {
        return this.myClientData;
    }

    public void setClientData(@Nullable Object clientData) {
        this.myClientData = clientData;
    }

    static {
        NOOP_RUNNABLE_FIX_FACTORY = (project, problem) -> () -> {};
    }

    public static class Plain
    extends RenderProblem {
        @NotNull
        private final String myHtml;

        private Plain(@NotNull ProblemSeverity severity, int ordinal, @NotNull String text2) {
            super(severity, ordinal);
            this.myHtml = text2;
        }

        @Override
        @NotNull
        public String getHtml() {
            return this.myHtml;
        }
    }

    public static class Html
    extends RenderProblem {
        @NotNull
        private final HtmlBuilder myBuilder = new HtmlBuilder();

        private Html(@NotNull ProblemSeverity severity, int ordinal) {
            super(severity, ordinal);
        }

        @Override
        @NotNull
        public String getHtml() {
            return this.myBuilder.getHtml();
        }

        @NotNull
        public HtmlBuilder getHtmlBuilder() {
            this.myIsDefaultHtml = false;
            return this.myBuilder;
        }
    }

    public static interface RunnableFixFactory {
        public Runnable create(Project var1, RenderProblem var2);
    }

    public static class Deferred
    extends RenderProblem {
        protected final String myText;

        protected Deferred(@NotNull ProblemSeverity severity, @Nullable String tag, @NotNull String text2, @Nullable Throwable throwable) {
            super(severity, ourNextOrdinal++);
            this.myText = text2;
            this.tag(tag);
            this.throwable(throwable);
        }

        @Override
        @NotNull
        public String getHtml() {
            return new HtmlBuilder().add(this.myText).getHtml();
        }
    }
}

