/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.ProblemSeverity;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

public class RenderLogger
implements IRenderLogger {
    public static final RenderLogger NOP_RENDER_LOGGER = new RenderLogger(){

        @Override
        public void addMessage(@NotNull RenderProblem message2) {
        }

        @Override
        public void error(@Nullable String tag, @Nullable String message2, @Nullable Object viewCookie, @Nullable Object data) {
        }

        @Override
        public void error(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        }

        @Override
        public void warning(@Nullable String tag, @NotNull String message2, @Nullable Object viewCookie, @Nullable Object data) {
        }

        @Override
        public void fidelityWarning(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        }

        @Override
        public void setHasLoadedClasses() {
        }

        @Override
        public void setMissingResourceClass() {
        }

        @Override
        public void setResourceClass(@NotNull String resourceClass) {
        }

        @Override
        public void addMissingClass(@NotNull String className) {
        }

        @Override
        public void addBrokenClass(@NotNull String className, @NotNull Throwable exception) {
        }

        @Override
        public void logAndroidFramework(int priority, String tag, @NotNull String message2) {
        }
    };
    public static final String TAG_MISSING_DIMENSION = "missing.dimension";
    public static final String TAG_MISSING_FRAGMENT = "missing.fragment";
    public static final String TAG_STILL_BUILDING = "project.building";
    static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.RenderLogger");
    @VisibleForTesting
    static final int RENDER_PROBLEMS_LIMIT = Integer.getInteger("com.android.tools.idea.rendering.RENDER_PROBLEMS_LIMIT", 100);
    @VisibleForTesting
    static final int STACK_OVERFLOW_TRACE_LIMIT = Integer.getInteger("com.android.tools.idea.rendering.STACK_OVERFLOW_TRACE_LIMIT", 100);
    private static Set<String> ourIgnoredFidelityWarnings;
    private static boolean ourIgnoreAllFidelityWarnings;
    private static boolean ourIgnoreFragments;
    private final Project myProject;
    private Set<String> myFidelityWarningStrings;
    private boolean myHaveExceptions;
    private Multiset<String> myTags;
    private final List<RenderProblem> myMessages = new ArrayList<RenderProblem>();
    private int myMessagesOverflowCounter;
    private List<RenderProblem> myFidelityWarnings;
    private Set<String> myMissingClasses;
    private Map<String, Throwable> myBrokenClasses;
    private String myResourceClass;
    private boolean myMissingResourceClass;
    private boolean myHasLoadedClasses;
    private HtmlLinkManager myLinkManager;
    private boolean myMissingSize;
    private List<String> myMissingFragments;
    private Object myCredential;
    private final boolean myLogFramework;
    private final RenderProblem.RunnableFixFactory myFixFactory;
    private final Supplier<HtmlLinkManager> myHtmlLinkManagerFactory;
    private static final int ANDROID_LOG_VERBOSE = 0;
    private static final int ANDROID_LOG_DEBUG = 1;
    private static final int ANDROID_LOG_INFO = 2;
    private static final int ANDROID_LOG_WARN = 3;
    private static final int ANDROID_LOG_ERROR = 4;
    private static final int ANDROID_LOG_FATAL_WITHOUT_ABORT = 5;
    private static final int ANDROID_LOG_FATAL = 6;

    public RenderLogger(@Nullable Project project, @Nullable Object credential, boolean logFramework, @NotNull RenderProblem.RunnableFixFactory fixFactory, @NotNull Supplier<HtmlLinkManager> linkManagerFactory) {
        this.myProject = project;
        this.myCredential = credential;
        this.myLogFramework = logFramework;
        this.myFixFactory = fixFactory;
        this.myHtmlLinkManagerFactory = linkManagerFactory;
    }

    public RenderLogger(@Nullable Project project) {
        this(project, null, false, RenderProblem.NOOP_RUNNABLE_FIX_FACTORY, () -> HtmlLinkManager.NOOP_LINK_MANAGER);
    }

    @VisibleForTesting
    public RenderLogger() {
        this(null);
    }

    @VisibleForTesting
    public static void resetFidelityErrorsFilters() {
        ourIgnoreAllFidelityWarnings = false;
        if (ourIgnoredFidelityWarnings != null) {
            ourIgnoredFidelityWarnings.clear();
        }
    }

    public static void ignoreFidelityWarning(@NotNull Object clientData) {
        if (ourIgnoredFidelityWarnings == null) {
            ourIgnoredFidelityWarnings = new HashSet<String>();
        }
        ourIgnoredFidelityWarnings.add((String)clientData);
    }

    public static void ignoreAllFidelityWarnings() {
        ourIgnoreAllFidelityWarnings = true;
    }

    public static void ignoreFragments() {
        ourIgnoreFragments = true;
    }

    @NotNull
    private static String describe(@Nullable String message2, @Nullable Throwable throwable) {
        if (StringUtil.isEmptyOrSpaces((String)message2)) {
            return throwable != null && throwable.getMessage() != null ? throwable.getMessage() : "";
        }
        return message2;
    }

    static boolean isIssue164378(@Nullable Throwable throwable) {
        StackTraceElement[] stackTrace;
        return throwable instanceof NoSuchFieldError && (stackTrace = throwable.getStackTrace()).length >= 1 && stackTrace[0].getClassName().startsWith("android.support");
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageToIdeaLog(@NotNull String message2, @Nullable Throwable t) {
        Object logMessage;
        if (t == null) {
            logMessage = message2;
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer2 = new PrintWriter(stringWriter);
            writer2.println(t.getMessage());
            t.printStackTrace(writer2);
            logMessage = message2 + "\n" + stringWriter.toString();
        }
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            LOG.debug((String)logMessage);
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private void logMessageToIdeaLog(@NotNull String message2) {
        this.logMessageToIdeaLog(message2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(@NotNull RenderProblem message2) {
        List<RenderProblem> list2 = this.myMessages;
        synchronized (list2) {
            if (this.myMessages.size() < RENDER_PROBLEMS_LIMIT) {
                this.myMessages.add(message2);
            } else {
                ++this.myMessagesOverflowCounter;
            }
        }
        this.logMessageToIdeaLog(XmlUtils.fromXmlAttributeValue((String)message2.getHtml()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<RenderProblem> getMessages() {
        int overflowCounter;
        ImmutableList.Builder builder2 = ImmutableList.builder();
        List<RenderProblem> list2 = this.myMessages;
        synchronized (list2) {
            builder2.addAll(this.myMessages);
            overflowCounter = this.myMessagesOverflowCounter;
        }
        if (overflowCounter > 0) {
            builder2.add((Object)RenderProblem.createPlain(ProblemSeverity.WARNING, String.format(Locale.US, "Too many errors (%d more errors not displayed)", overflowCounter)));
        }
        return builder2.build();
    }

    public boolean hasProblems() {
        return this.hasErrors() || this.myFidelityWarnings != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors() {
        boolean hasErrorMessage;
        List<RenderProblem> list2 = this.myMessages;
        synchronized (list2) {
            hasErrorMessage = this.myMessages.stream().anyMatch(message2 -> message2.getSeverity().compareTo(ProblemSeverity.ERROR) >= 0);
        }
        return this.myHaveExceptions || hasErrorMessage || this.myBrokenClasses != null || this.myMissingClasses != null || this.myMissingSize || this.myMissingFragments != null;
    }

    @NotNull
    public List<RenderProblem> getFidelityWarnings() {
        return this.myFidelityWarnings != null ? this.myFidelityWarnings : Collections.emptyList();
    }

    public void error(@Nullable String tag, @Nullable String message2, @Nullable Object viewCookie, @Nullable Object data) {
        String description2 = RenderLogger.describe(message2, null);
        if (tag == null && message2 != null && (message2.startsWith("Failed to find style ") || message2.startsWith("Unable to resolve parent style name: "))) {
            tag = "resources.resolve.theme";
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, description2).tag(tag));
    }

    @NotNull
    private static StackOverflowError summarizeStackOverFlowException(@NotNull StackOverflowError stackOverflowError) {
        StackTraceElement[] stackTraceElements = stackOverflowError.getStackTrace();
        int traceSize = stackTraceElements.length;
        if (traceSize < STACK_OVERFLOW_TRACE_LIMIT) {
            return stackOverflowError;
        }
        int elementsToCopy = STACK_OVERFLOW_TRACE_LIMIT / 2;
        StackTraceElement[] newStackTraceElements = new StackTraceElement[elementsToCopy * 2 + 1];
        newStackTraceElements[elementsToCopy] = new StackTraceElement("omitted", "omitted", "omitted", -1);
        System.arraycopy(stackTraceElements, 0, newStackTraceElements, 0, elementsToCopy);
        System.arraycopy(stackTraceElements, stackTraceElements.length - elementsToCopy, newStackTraceElements, elementsToCopy + 1, elementsToCopy);
        stackOverflowError.setStackTrace(newStackTraceElements);
        return stackOverflowError;
    }

    public void error(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        Object description2 = RenderLogger.describe(message2, throwable);
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException) {
                return;
            }
            if (RenderLogger.isIssue164378(throwable)) {
                return;
            }
            if ("Unable to find the layout for Action Bar.".equals(description2)) {
                description2 = (String)description2 + "\nConsider updating to a more recent version of appcompat, or switch the rendering library in the IDE down to API 21";
            }
            if (((String)description2).isEmpty()) {
                description2 = "Exception raised during rendering";
            } else if (((String)description2).equals(throwable.getLocalizedMessage()) || ((String)description2).equals(throwable.getMessage())) {
                description2 = "Exception raised during rendering: " + (String)description2;
            } else if (message2 != null && message2.startsWith("Failed to configure parser for ") && message2.endsWith(".png")) {
                StackTraceElement[] frames;
                for (StackTraceElement frame : frames = throwable.getStackTrace()) {
                    if (frame.getMethodName().equals("createFromXml") && frame.getClassName().equals("android.content.res.ColorStateList")) {
                        String basePath;
                        String path2 = message2.substring("Failed to configure parser for ".length());
                        RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                        problem.tag("bitmapAsColor");
                        HtmlBuilder builder2 = problem.getHtmlBuilder();
                        builder2.add("Resource error: Attempted to load a bitmap as a color state list.").newline();
                        builder2.add("Verify that your style/theme attributes are correct, and make sure layouts are using the right attributes.");
                        builder2.newline().newline();
                        path2 = FileUtil.toSystemIndependentName((String)path2);
                        String string = basePath = this.getProject() != null && this.getProject().getBasePath() != null ? FileUtil.toSystemIndependentName((String)this.getProject().getBasePath()) : null;
                        if (basePath != null && path2.startsWith(basePath)) {
                            path2 = path2.substring(basePath.length());
                            path2 = StringUtil.trimStart((String)path2, (String)File.separator);
                        }
                        path2 = FileUtil.toSystemDependentName((String)path2);
                        builder2.add("The relevant image is ").add(path2);
                        HashSet widgets = Sets.newHashSet();
                        for (StackTraceElement f : frames) {
                            String className;
                            if (!f.getMethodName().equals("<init>") || !(className = f.getClassName()).startsWith("android.widget.")) continue;
                            widgets.add(className.substring(className.lastIndexOf(46) + 1));
                        }
                        if (!widgets.isEmpty()) {
                            ArrayList sorted2 = Lists.newArrayList((Iterable)widgets);
                            Collections.sort(sorted2);
                            builder2.newline().newline().add("Widgets possibly involved: ").add(Joiner.on((String)", ").join((Iterable)sorted2));
                        }
                        this.addMessage(problem);
                        return;
                    }
                    if (!frame.getClassName().startsWith("com.android.tools.")) {
                        continue;
                    }
                    break;
                }
            } else {
                if (message2 != null && message2.startsWith("Failed to parse file ") && throwable instanceof XmlPullParserException) {
                    int end;
                    int index2;
                    XmlPullParserException e = (XmlPullParserException)throwable;
                    Object msg = e.getMessage();
                    if (((String)msg).startsWith("Binary XML file ") && (index2 = ((String)msg).indexOf(58)) != -1 && index2 < ((String)msg).length() - 1) {
                        msg = ((String)msg).substring(index2 + 1).trim();
                    }
                    int lineNumber = e.getLineNumber();
                    int column2 = e.getColumnNumber();
                    String reader2 = " in java.io.InputStreamReader@";
                    int index3 = ((String)msg).indexOf(reader2);
                    if (index3 != -1 && (end = ((String)msg).indexOf(41, index3 + 1)) != -1) {
                        msg = ((String)msg).substring(0, index3) + ((String)msg).substring(end);
                    }
                    String path3 = message2.substring("Failed to parse file ".length());
                    RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                    problem.tag("xmlParse");
                    HtmlBuilder builder3 = problem.getHtmlBuilder();
                    if (lineNumber != -1) {
                        builder3.add("Line ").add(Integer.toString(lineNumber)).add(": ");
                    }
                    builder3.add((String)msg);
                    if (lineNumber != -1) {
                        builder3.add(" (");
                        File file2 = new File(path3);
                        String url = HtmlLinkManager.createFilePositionUrl(file2, lineNumber, column2);
                        if (url != null) {
                            builder3.addLink("Show", url);
                            builder3.add(")");
                        }
                    }
                    this.addMessage(problem);
                    return;
                }
                if (throwable instanceof StackOverflowError) {
                    throwable = RenderLogger.summarizeStackOverFlowException((StackOverflowError)throwable);
                }
            }
            this.myHaveExceptions = true;
        }
        this.addTag(tag);
        if (this.getProject() == null) {
            this.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, (String)description2).tag(tag).throwable(throwable));
        } else {
            this.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, (String)description2, this.getProject(), this.getLinkManager(), throwable, this.myFixFactory).tag(tag));
        }
    }

    public void warning(@Nullable String tag, @NotNull String message2, @Nullable Object viewCookie, @Nullable Object data) {
        String description2 = RenderLogger.describe(message2, null);
        if ("info".equals(tag)) {
            Logger.getInstance(this.getClass()).info(description2);
            return;
        }
        if ("resources.format".equals(tag)) {
            Pattern pattern;
            Matcher matcher;
            if (description2.equals("You must supply a layout_width attribute.") || description2.equals("You must supply a layout_height attribute.")) {
                this.myMissingSize = true;
                this.addTag(TAG_MISSING_DIMENSION);
                return;
            }
            if (description2.endsWith(" is not a valid value") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid value")).matcher(description2)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                problem.tag(tag);
                String attribute2 = matcher.group(2);
                String value2 = matcher.group(1);
                problem.setClientData(new String[]{attribute2, value2});
                String url = this.getLinkManager().createEditAttributeUrl(attribute2, value2);
                problem.getHtmlBuilder().add(description2).add(" (").addLink("Edit", url).add(")");
                this.addMessage(problem);
                return;
            }
            if (description2.endsWith(" is not a valid format.") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid format.")).matcher(description2)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                problem.tag(tag);
                String attribute3 = matcher.group(2);
                String value3 = matcher.group(1);
                problem.setClientData(new String[]{attribute3, value3});
                String url = this.getLinkManager().createEditAttributeUrl(attribute3, value3);
                problem.getHtmlBuilder().add(description2).add(" (").addLink("Edit", url).add(")");
                problem.setClientData(url);
                this.addMessage(problem);
                return;
            }
        } else {
            if (TAG_MISSING_FRAGMENT.equals(tag)) {
                if (!ourIgnoreFragments) {
                    if (this.myMissingFragments == null) {
                        this.myMissingFragments = new ArrayList<String>();
                    }
                    String name2 = data instanceof String ? (String)data : null;
                    this.myMissingFragments.add(name2);
                }
                return;
            }
            if ("thread-creation".equals(tag)) {
                this.addTag(tag);
                RenderProblem problem = RenderProblem.createPlain(ProblemSeverity.WARNING, description2).tag(tag);
                if (data instanceof Throwable) {
                    problem.throwable((Throwable)data);
                }
                this.addMessage(problem);
                return;
            }
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(ProblemSeverity.WARNING, description2).tag(tag));
    }

    public void fidelityWarning(@Nullable String tag, @Nullable String message2, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data) {
        if (ourIgnoreAllFidelityWarnings || ourIgnoredFidelityWarnings != null && ourIgnoredFidelityWarnings.contains(message2)) {
            return;
        }
        String description2 = RenderLogger.describe(message2, throwable);
        if (this.myFidelityWarningStrings != null && this.myFidelityWarningStrings.contains(description2)) {
            return;
        }
        if (throwable != null) {
            this.myHaveExceptions = true;
        }
        RenderProblem error = RenderProblem.createDeferred(ProblemSeverity.ERROR, tag, description2, throwable);
        error.setClientData(description2);
        if (this.myFidelityWarnings == null) {
            this.myFidelityWarnings = new ArrayList<RenderProblem>();
            this.myFidelityWarningStrings = Sets.newHashSet();
        }
        this.myFidelityWarnings.add(error);
        assert (this.myFidelityWarningStrings != null);
        this.myFidelityWarningStrings.add(description2);
        this.addTag(tag);
    }

    private void addTag(@Nullable String tag) {
        if (tag == null) {
            return;
        }
        if (this.myTags == null) {
            this.myTags = HashMultiset.create();
        }
        this.myTags.add((Object)tag);
    }

    public boolean seenTagPrefix(@NotNull String prefix) {
        if (this.myTags == null) {
            return false;
        }
        return this.myTags.stream().anyMatch(s -> s.startsWith(prefix));
    }

    @Override
    @NotNull
    public HtmlLinkManager getLinkManager() {
        if (this.myLinkManager == null) {
            this.myLinkManager = this.myHtmlLinkManagerFactory.get();
        }
        return this.myLinkManager;
    }

    @Override
    public void setHasLoadedClasses() {
        this.myHasLoadedClasses = true;
    }

    public boolean isMissingSize() {
        return this.myMissingSize;
    }

    public boolean hasLoadedClasses() {
        return this.myHasLoadedClasses;
    }

    public boolean isMissingResourceClass() {
        return this.myMissingResourceClass;
    }

    @Override
    public void setMissingResourceClass() {
        this.myMissingResourceClass = true;
    }

    @Nullable
    public String getResourceClass() {
        return this.myResourceClass;
    }

    @Override
    public void setResourceClass(@NotNull String resourceClass) {
        this.myResourceClass = resourceClass;
    }

    @NotNull
    public Map<String, Throwable> getBrokenClasses() {
        return this.myBrokenClasses != null ? this.myBrokenClasses : Collections.emptyMap();
    }

    @NotNull
    public Set<String> getMissingClasses() {
        return this.myMissingClasses != null ? this.myMissingClasses : Collections.emptySet();
    }

    @Override
    public void addMissingClass(@NotNull String className) {
        if (!className.equals("fragment")) {
            if (this.myMissingClasses == null) {
                this.myMissingClasses = new TreeSet<String>();
            }
            this.myMissingClasses.add(className);
            this.logMessageToIdeaLog("Class not found " + className);
        }
    }

    @Override
    public void addBrokenClass(@NotNull String className, @NotNull Throwable exception) {
        while (exception.getCause() != null && exception.getCause() != exception) {
            exception = exception.getCause();
        }
        if (exception instanceof StackOverflowError) {
            exception = RenderLogger.summarizeStackOverFlowException((StackOverflowError)exception);
        }
        if (this.myBrokenClasses == null) {
            this.myBrokenClasses = new HashMap<String, Throwable>();
        }
        this.myBrokenClasses.put(className, exception);
        this.logMessageToIdeaLog("Broken class " + className, exception);
    }

    @Nullable
    public List<String> getMissingFragments() {
        return this.myMissingFragments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logAndroidFramework(int priority, String tag, @NotNull String message2) {
        if (!this.myLogFramework) return;
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            String fullMessage = tag + ": " + message2;
            switch (priority) {
                case 0: 
                case 1: {
                    LOG.debug(fullMessage);
                    return;
                }
                case 2: {
                    LOG.info(fullMessage);
                    return;
                }
                case 3: 
                case 4: {
                    LOG.warn(fullMessage);
                    return;
                }
                case 5: 
                case 6: {
                    LOG.error(fullMessage);
                    return;
                }
            }
            return;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }
}

