/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.intellij.openapi.application.ApplicationManager;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public interface RenderAsyncActionExecutor {
    public static final long DEFAULT_RENDER_THREAD_TIMEOUT_MS = Long.getLong("layoutlib.thread.timeout", TimeUnit.SECONDS.toMillis(10L));
    public static final long DEFAULT_RENDER_THREAD_QUEUE_TIMEOUT_MS = Long.getLong("layoutlib.thread.queue.timeout", TimeUnit.SECONDS.toMillis(ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode() ? 50L : 60L));

    public long getExecutedRenderActionCount();

    @NotNull
    public <T> CompletableFuture<T> runAsyncActionWithTimeout(long var1, @NotNull TimeUnit var3, long var4, @NotNull TimeUnit var6, @NotNull RenderingPriority var7, @NotNull Callable<T> var8);

    @NotNull
    default public <T> CompletableFuture<T> runAsyncActionWithTimeout(long actionTimeout, @NotNull TimeUnit actionTimeoutUnit, @NotNull RenderingPriority priority, @NotNull Callable<T> callable) {
        return this.runAsyncActionWithTimeout(DEFAULT_RENDER_THREAD_QUEUE_TIMEOUT_MS, TimeUnit.MILLISECONDS, actionTimeout, actionTimeoutUnit, priority, callable);
    }

    @NotNull
    default public <T> CompletableFuture<T> runAsyncActionWithTimeout(long actionTimeout, @NotNull TimeUnit actionTimeoutUnit, @NotNull Callable<T> callable) {
        return this.runAsyncActionWithTimeout(DEFAULT_RENDER_THREAD_QUEUE_TIMEOUT_MS, TimeUnit.MILLISECONDS, actionTimeout, actionTimeoutUnit, RenderingPriority.HIGH, callable);
    }

    @NotNull
    default public <T> CompletableFuture<T> runAsyncAction(@NotNull Callable<T> callable) {
        return this.runAsyncActionWithTimeout(DEFAULT_RENDER_THREAD_QUEUE_TIMEOUT_MS, TimeUnit.MILLISECONDS, DEFAULT_RENDER_THREAD_TIMEOUT_MS, TimeUnit.MILLISECONDS, RenderingPriority.HIGH, callable);
    }

    @NotNull
    default public <T> CompletableFuture<T> runAsyncAction(@NotNull RenderingPriority priority, @NotNull Callable<T> callable) {
        return this.runAsyncActionWithTimeout(DEFAULT_RENDER_THREAD_QUEUE_TIMEOUT_MS, TimeUnit.MILLISECONDS, DEFAULT_RENDER_THREAD_TIMEOUT_MS, TimeUnit.MILLISECONDS, priority, callable);
    }

    @NotNull
    default public CompletableFuture<Void> runAsyncAction(@NotNull Runnable runnable2) {
        return this.runAsyncAction(RenderingPriority.HIGH, () -> {
            runnable2.run();
            return null;
        });
    }

    @NotNull
    default public CompletableFuture<Void> runAsyncAction(@NotNull RenderingPriority priority, @NotNull Runnable runnable2) {
        return this.runAsyncAction(priority, () -> {
            runnable2.run();
            return null;
        });
    }

    public int cancelLowerPriorityActions(@NotNull RenderingPriority var1);

    public static enum RenderingPriority {
        LOW(1),
        HIGH(100);

        private final int myPriority;

        private RenderingPriority(int priority) {
            this.myPriority = priority;
        }

        public int getPriority() {
            return this.myPriority;
        }
    }
}

