/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.Function;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class FlagManager {
    private static final FlagManager ourInstance = new FlagManager();
    @NotNull
    private final Map<String, Icon> myImageMap = Maps.newHashMap();

    @NotNull
    public static FlagManager get() {
        return ourInstance;
    }

    private FlagManager() {
    }

    public Icon getFlag(String language, String region) {
        assert (region != null || language != null);
        if (region == null || region.isEmpty() || region.length() == 3) {
            return null;
        }
        return this.getIcon(region);
    }

    public Icon getFlag(FolderConfiguration configuration) {
        return this.getFlag(configuration.getLocaleQualifier());
    }

    public Icon getFlag(LocaleQualifier locale) {
        if (locale == null) {
            return null;
        }
        String languageCode = locale.getLanguage();
        String regionCode = locale.getRegion();
        if ("__".equals(languageCode)) {
            languageCode = null;
        }
        return this.getFlag(languageCode, regionCode);
    }

    public Icon getFlagForFolderName(@NotNull String folder) {
        FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)folder);
        if (configuration != null) {
            return FlagManager.get().getFlag(configuration);
        }
        return null;
    }

    public Icon getFlag(@NotNull String region) {
        assert (region.length() == 2 && Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1))) : region;
        return this.getIcon(region);
    }

    private Icon getIcon(@NotNull String base) {
        Icon flagImage = this.myImageMap.get(base);
        if (flagImage == null) {
            if (this.myImageMap.containsKey(base)) {
                return null;
            }
            String flagFileName = StringUtil.toLowerCase((String)base) + ".png";
            try {
                flagImage = IconLoader.findResolvedIcon((String)("icons/flags/" + flagFileName), (ClassLoader)AndroidIcons.class.getClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (flagImage == null) {
                flagImage = StudioIcons.LayoutEditor.Toolbar.EMPTY_FLAG;
            }
            this.myImageMap.put(base, flagImage);
        }
        return flagImage;
    }

    @NotNull
    public ListCellRenderer getLanguageCodeCellRenderer() {
        Function<Object, String> nameMapper = FlagManager.getLanguageNameMapper();
        return SimpleListCellRenderer.create((label, value2, index2) -> {
            label.setText((String)nameMapper.fun(value2));
            label.setIcon(this.getFlag((String)value2, null));
        });
    }

    @NotNull
    public ListCellRenderer getRegionCodeCellRenderer() {
        Function<Object, String> nameMapper = FlagManager.getRegionNameMapper();
        return SimpleListCellRenderer.create((label, value2, index2) -> {
            label.setText((String)nameMapper.fun(value2));
            label.setIcon(this.getFlag(null, (String)value2));
        });
    }

    @NotNull
    public static Function<Object, String> getLanguageNameMapper() {
        return new Function<Object, String>(){

            public String fun(Object value2) {
                String languageCode = (String)value2;
                if (languageCode.equals("__")) {
                    return "Any Language";
                }
                Object languageName = LocaleManager.getLanguageName((String)languageCode);
                if (languageName != null && ((String)languageName).length() > 30) {
                    languageName = ((String)languageName).substring(0, 27) + "...";
                }
                return String.format("%1$s: %2$s", languageCode, languageName);
            }
        };
    }

    @NotNull
    public static Function<Object, String> getRegionNameMapper() {
        return new Function<Object, String>(){

            public String fun(Object value2) {
                String regionCode = (String)value2;
                if (regionCode.equals("__")) {
                    return "Any Region";
                }
                Object regionName = LocaleManager.getRegionName((String)regionCode);
                if (regionName != null && ((String)regionName).length() > 30) {
                    regionName = ((String)regionName).substring(0, 27) + "...";
                }
                return String.format("%1$s: %2$s", regionCode, regionName);
            }
        };
    }

    @NotNull
    public static Icon getFlagImage(Locale locale) {
        String languageCode;
        String string = languageCode = locale.qualifier.hasLanguage() ? locale.qualifier.getLanguage() : null;
        if (languageCode == null) {
            return StudioIcons.LayoutEditor.Toolbar.EMPTY_FLAG;
        }
        String regionCode = locale.hasRegion() ? locale.qualifier.getRegion() : null;
        FlagManager icons = FlagManager.get();
        Icon image = icons.getFlag(languageCode, regionCode);
        if (image == null) {
            image = StudioIcons.LayoutEditor.Toolbar.EMPTY_FLAG;
        }
        return image;
    }
}

