/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.ShowFixFactory;
import com.android.tools.idea.rendering.StudioHtmlLinkManager;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.StudioRenderServiceKt;
import com.android.tools.idea.rendering.VectorDrawableTransformer;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutRenderPullParser;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.res.ResourceRepositoryManager;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableRenderer
implements Disposable {
    @NotNull
    private final CompletableFuture<RenderTask> myRenderTaskFuture;
    @NotNull
    private final Object myRenderLock = new Object();
    @NotNull
    private final MyLayoutPullParserFactory myParserFactory;
    @NotNull
    private final AtomicInteger myCounter = new AtomicInteger();

    public DrawableRenderer(@NotNull AndroidFacet facet2) {
        this(facet2, ConfigurationManager.getConfigurationForModule(facet2.getModule()));
    }

    public DrawableRenderer(@NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        Module module2 = facet2.getModule();
        RenderLogger logger2 = new RenderLogger(module2.getProject(), null, (Boolean)StudioFlags.NELE_LOG_ANDROID_FRAMEWORK.get(), ShowFixFactory.INSTANCE, StudioHtmlLinkManager::new);
        this.myParserFactory = new MyLayoutPullParserFactory();
        RenderService service = StudioRenderService.getInstance(module2.getProject());
        this.myRenderTaskFuture = StudioRenderServiceKt.taskBuilder(service, facet2, configuration, logger2).withParserFactory(this.myParserFactory).build().whenComplete((task2, ex) -> {
            if (task2 != null) {
                task2.getLayoutlibCallback().setLogger(logger2);
            }
            if (logger2.hasProblems()) {
                DrawableRenderer.getLog().error(RenderProblem.format(logger2.getMessages()));
            }
        });
        Disposer.register((Disposable)facet2, (Disposable)this);
    }

    @NotNull
    public CompletableFuture<BufferedImage> renderDrawable(@NotNull String xmlDrawableText, @NotNull Dimension size) {
        String xmlText = VectorDrawableTransformer.transform(xmlDrawableText, size);
        String resourceName = String.format("preview_%x.xml", this.myCounter.getAndIncrement());
        ResourceValueImpl value2 = new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.DRAWABLE, "ic_image_preview", "file://" + resourceName);
        return this.myRenderTaskFuture.thenCompose(arg_0 -> this.lambda$renderDrawable$1(resourceName, xmlText, size, (ResourceValue)value2, arg_0));
    }

    public void dispose() {
        this.myRenderTaskFuture.whenComplete((renderTask, throwable) -> {
            if (renderTask != null) {
                renderTask.dispose();
            }
        });
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(DrawableRenderer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ CompletionStage lambda$renderDrawable$1(String resourceName, String xmlText, Dimension size, ResourceValue value2, RenderTask renderTask) {
        if (renderTask == null) {
            return CompletableFuture.completedFuture(new BufferedImage(1, 1, 2));
        }
        Object object = this.myRenderLock;
        synchronized (object) {
            this.myParserFactory.addFileContent(new PathString(resourceName), xmlText);
            renderTask.setOverrideRenderSize(size.width, size.height);
            renderTask.setMaxRenderSize(size.width, size.height);
            return renderTask.renderDrawable(value2);
        }
    }

    private static class MyLayoutPullParserFactory
    implements ILayoutPullParserFactory {
        @NotNull
        private final ConcurrentMap<PathString, String> myFileContent = new ConcurrentHashMap<PathString, String>();

        private MyLayoutPullParserFactory() {
        }

        @Override
        @Nullable
        public ILayoutPullParser create(@NotNull Project project, @NotNull IRenderLogger logger2, @NotNull PathString file2, @NotNull LayoutlibCallback layoutlibCallback, @Nullable ResourceRepositoryManager resourceRepositoryManager) {
            String content2 = (String)this.myFileContent.remove(file2);
            if (content2 == null) {
                return null;
            }
            XmlFile xmlFile = (XmlFile)MyLayoutPullParserFactory.createEphemeralPsiFile(project, file2.getFileName(), (LanguageFileType)XmlFileType.INSTANCE, content2);
            return LayoutRenderPullParser.create(new PsiXmlFile(xmlFile), logger2, resourceRepositoryManager);
        }

        void addFileContent(@NotNull PathString file2, @NotNull String content2) {
            this.myFileContent.put(file2, content2);
        }

        @NotNull
        private static PsiFile createEphemeralPsiFile(@NotNull Project project, @NotNull String filename, @NotNull LanguageFileType fileType, @NotNull String contents) {
            LightVirtualFile virtualFile;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(psiManager, (VirtualFile)(virtualFile = new LightVirtualFile(filename, (FileType)fileType, (CharSequence)contents)));
            PsiFile psiFile = viewProvider.getPsi(fileType.getLanguage());
            if (psiFile == null) {
                throw new IllegalArgumentException("Unsupported language: " + fileType.getLanguage().getDisplayName());
            }
            return psiFile;
        }
    }
}

