/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.AssetRepository;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifestException;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.EnvironmentContext;
import com.android.tools.idea.rendering.RenderMergedManifest;
import com.android.tools.idea.rendering.RenderModelManifest;
import com.android.tools.idea.rendering.RenderModelModule;
import com.android.tools.idea.rendering.RenderModuleDependencies;
import com.android.tools.idea.rendering.StudioEnvironmentContext;
import com.android.tools.idea.rendering.StudioRenderModuleDependencies;
import com.android.tools.idea.res.AssetRepositoryImpl;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u0004\u0018\u00010+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010-R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006@"}, d2={"Lcom/android/tools/idea/rendering/AndroidFacetRenderModelModule;", "Lcom/android/tools/idea/rendering/RenderModelModule;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "_isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "androidPlatform", "Lcom/android/tools/sdk/AndroidPlatform;", "getAndroidPlatform", "()Lcom/android/tools/sdk/AndroidPlatform;", "<set-?>", "Lcom/android/ide/common/rendering/api/AssetRepository;", "assetRepository", "getAssetRepository", "()Lcom/android/ide/common/rendering/api/AssetRepository;", "dependencies", "Lcom/android/tools/idea/rendering/RenderModuleDependencies;", "getDependencies", "()Lcom/android/tools/idea/rendering/RenderModuleDependencies;", "environment", "Lcom/android/tools/idea/rendering/EnvironmentContext;", "getEnvironment", "()Lcom/android/tools/idea/rendering/EnvironmentContext;", "info", "Lcom/android/tools/idea/model/AndroidModuleInfo;", "getInfo", "()Lcom/android/tools/idea/model/AndroidModuleInfo;", "isDisposed", "", "()Z", "manifest", "Lcom/android/tools/idea/rendering/RenderModelManifest;", "getManifest", "()Lcom/android/tools/idea/rendering/RenderModelManifest;", "moduleKey", "", "getModuleKey", "()Ljava/lang/Object;", "name", "", "getName", "()Ljava/lang/String;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "resourceIdManager", "Lcom/android/tools/idea/res/ResourceIdManager;", "getResourceIdManager", "()Lcom/android/tools/idea/res/ResourceIdManager;", "resourcePackage", "getResourcePackage", "resourceRepositoryManager", "Lcom/android/tools/idea/res/StudioResourceRepositoryManager;", "getResourceRepositoryManager", "()Lcom/android/tools/idea/res/StudioResourceRepositoryManager;", "dispose", "", "getIdeaModule", "Lcom/intellij/openapi/module/Module;", "intellij.android.core"})
public final class AndroidFacetRenderModelModule
implements RenderModelModule {
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final AtomicBoolean _isDisposed;
    @Nullable
    private AssetRepository assetRepository;
    @NotNull
    private final RenderModuleDependencies dependencies;
    @NotNull
    private final EnvironmentContext environment;

    public AndroidFacetRenderModelModule(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.facet = facet2;
        Logger logger2 = Logger.getInstance(AndroidFacetRenderModelModule.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AndroidFacet\u2026rModelModule::class.java)");
        this.LOG = logger2;
        this._isDisposed = new AtomicBoolean(false);
        if (!Disposer.tryRegister((Disposable)((Disposable)this.facet), (Disposable)this)) {
            this._isDisposed.set(true);
        }
        this.assetRepository = new AssetRepositoryImpl(this.facet);
        Module module2 = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        this.dependencies = new StudioRenderModuleDependencies(module2);
        Project project = this.facet.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
        this.environment = new StudioEnvironmentContext(project);
    }

    @Override
    @NotNull
    public Module getIdeaModule() {
        Module module2 = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        return module2;
    }

    @Override
    @Nullable
    public AssetRepository getAssetRepository() {
        return this.assetRepository;
    }

    @Override
    @Nullable
    public RenderModelManifest getManifest() {
        try {
            Module module2 = this.facet.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
            Object object = MergedManifestManager.Companion.getMergedManifest(module2).get(1L, TimeUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MergedManifestManager.ge\u2026.get(1, TimeUnit.SECONDS)");
            return new RenderMergedManifest((MergedManifestSnapshot)object);
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (TimeoutException e) {
            this.LOG.warn((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw cause;
            }
            if (cause instanceof MergedManifestException) {
                this.LOG.warn((Throwable)e);
            }
            this.LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    @NotNull
    public StudioResourceRepositoryManager getResourceRepositoryManager() {
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance(this.facet);
        Intrinsics.checkNotNullExpressionValue((Object)studioResourceRepositoryManager, (String)"getInstance(facet)");
        return studioResourceRepositoryManager;
    }

    @Override
    @NotNull
    public AndroidModuleInfo getInfo() {
        AndroidModuleInfo androidModuleInfo = StudioAndroidModuleInfo.getInstance(this.facet);
        Intrinsics.checkNotNullExpressionValue((Object)androidModuleInfo, (String)"getInstance(facet)");
        return androidModuleInfo;
    }

    @Override
    @Nullable
    public AndroidPlatform getAndroidPlatform() {
        Module module2 = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        return AndroidPlatforms.getInstance(module2);
    }

    @Override
    @NotNull
    public ResourceIdManager getResourceIdManager() {
        Module module2 = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        return ResourceIdManager.Companion.get(module2);
    }

    @Override
    @NotNull
    public Object getModuleKey() {
        Module module2 = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        return module2;
    }

    @Override
    @Nullable
    public String getResourcePackage() {
        Module module2 = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        return ProjectSystemUtil.getModuleSystem(module2).getPackageName();
    }

    @Override
    @NotNull
    public RenderModuleDependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.facet.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
        return project;
    }

    @Override
    public boolean isDisposed() {
        return this._isDisposed.get();
    }

    public void dispose() {
        this._isDisposed.set(true);
        this.assetRepository = null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.facet.getModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"facet.module.name");
        return string;
    }

    @Override
    @NotNull
    public EnvironmentContext getEnvironment() {
        return this.environment;
    }
}

