/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.refactoring.modularize.DependencyTreeNode;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0018\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/refactoring/modularize/UsageInfoTreeNode;", "Lcom/android/tools/idea/refactoring/modularize/DependencyTreeNode;", "usageInfo", "Lcom/intellij/usageView/UsageInfo;", "referenceCount", "", "(Lcom/intellij/usageView/UsageInfo;I)V", "psiElement", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/Nullable;", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "render", "", "renderer", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "renderQualifiers", "config", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "attr", "Lcom/intellij/ui/SimpleTextAttributes;", "intellij.android.core"})
public final class UsageInfoTreeNode
extends DependencyTreeNode {
    @Nullable
    private final PsiElement psiElement;

    public UsageInfoTreeNode(@NotNull UsageInfo usageInfo, int referenceCount) {
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        super(usageInfo, referenceCount);
        this.psiElement = usageInfo.getElement();
    }

    @Nullable
    public final PsiElement getPsiElement() {
        return this.psiElement;
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer2) {
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        renderer2.setIcon((Icon)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ UsageInfoTreeNode this$0;
            {
                this.this$0 = $receiver;
            }

            public final Icon compute() {
                PsiElement psiElement = this.this$0.getPsiElement();
                Intrinsics.checkNotNull((Object)psiElement);
                return psiElement.getIcon(3);
            }
        }));
        PsiElement psiElement = this.psiElement;
        if (psiElement instanceof PsiFile) {
            renderer2.append(((PsiFile)this.psiElement).getName(), this.getTextAttributes());
            this.renderQualifiers(IdeResourcesUtil.getFolderConfiguration((PsiFile)this.psiElement), renderer2, this.getTextAttributes());
            this.renderReferenceCount(renderer2, this.getTextAttributes());
        } else if (psiElement instanceof PsiClass) {
            String string = ((PsiClass)this.psiElement).getName();
            if (string == null) {
                string = "<unknown>";
            }
            renderer2.append(string, this.getTextAttributes());
            this.renderReferenceCount(renderer2, this.getTextAttributes());
        } else if (psiElement instanceof KtClass) {
            String string = ((KtClass)this.psiElement).getName();
            if (string == null) {
                string = "<unknown>";
            }
            renderer2.append(string, this.getTextAttributes());
            this.renderReferenceCount(renderer2, this.getTextAttributes());
        } else if (psiElement instanceof KtDeclaration) {
            String string = ((KtDeclaration)this.psiElement).getName();
            if (string == null) {
                string = "<unknown>";
            }
            renderer2.append(string, this.getTextAttributes());
            this.renderReferenceCount(renderer2, this.getTextAttributes());
        } else if (psiElement instanceof XmlTag) {
            renderer2.append(((XmlTag)this.psiElement).getText(), this.getTextAttributes());
        } else {
            throw new IllegalArgumentException("Unknown psiElement " + this.psiElement);
        }
    }

    private final void renderQualifiers(FolderConfiguration config2, ColoredTreeCellRenderer renderer2, SimpleTextAttributes attr) {
        FolderConfiguration folderConfiguration = config2;
        Intrinsics.checkNotNull((Object)folderConfiguration);
        String qualifier = folderConfiguration.getQualifierString();
        Intrinsics.checkNotNullExpressionValue((Object)qualifier, (String)"qualifier");
        if (!StringsKt.isBlank((CharSequence)qualifier)) {
            renderer2.append(" (" + qualifier + ")", new SimpleTextAttributes(attr.getStyle() | 0x80, attr.getFgColor()));
        }
    }
}

