/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.android.tools.idea.refactoring.modularize.AndroidCodeAndResourcesGraph;
import com.android.tools.idea.refactoring.modularize.AndroidModularizeDialog;
import com.android.tools.idea.refactoring.modularize.AndroidModularizeHandlerKt;
import com.android.tools.idea.refactoring.modularize.AndroidModularizeProcessor;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.structuralsearch.visitor.KotlinRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ)\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0097\u0002J0\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u000e\b\u0001\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0097\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "()V", "createProcessor", "Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;)Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeProcessor;", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "CodeAndResourcesReferenceCollector", "Companion", "intellij.android.core"})
public final class AndroidModularizeHandler
implements RefactoringActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;
    private static final int RESOURCE_SET_INITIAL_SIZE = 100;

    @UiThread
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        PsiElement[] psiElementArray = BaseRefactoringAction.getPsiElementArray((DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getPsiElementArray(dataContext)");
        this.invoke(project, psiElementArray, dataContext);
    }

    @UiThread
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        AndroidModularizeProcessor processor = this.createProcessor(project, elements);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Module targetModule = (Module)LangDataKeys.TARGET_MODULE.getData(dataContext);
            if (targetModule != null) {
                processor.setTargetModule(targetModule);
            }
            processor.run();
        } else {
            List suitableModules = new ArrayList();
            for (AndroidFacet facet2 : ProjectSystemUtil.getAndroidFacets(project)) {
                if (!(!((Collection)ResourceFolderManager.Companion.getInstance(facet2).getFolders()).isEmpty())) continue;
                Module module2 = facet2.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
                suitableModules.add(ModuleSystemUtil.getMainModule(module2));
            }
            for (PsiElement root : elements) {
                Module sourceModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)root);
                if (sourceModule == null) continue;
                suitableModules.remove(sourceModule);
            }
            AndroidModularizeDialog dialog2 = new AndroidModularizeDialog(project, suitableModules, processor);
            dialog2.show();
        }
    }

    @VisibleForTesting
    @NotNull
    public final AndroidModularizeProcessor createProcessor(@NotNull Project project, @NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        CodeAndResourcesReferenceCollector scanner = new CodeAndResourcesReferenceCollector(project);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(scanner, elements){
            final /* synthetic */ CodeAndResourcesReferenceCollector $scanner;
            final /* synthetic */ PsiElement[] $elements;
            {
                this.$scanner = $scanner;
                this.$elements = $elements;
            }

            public final void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(this.$scanner, this.$elements){
                    final /* synthetic */ CodeAndResourcesReferenceCollector $scanner;
                    final /* synthetic */ PsiElement[] $elements;
                    {
                        this.$scanner = $scanner;
                        this.$elements = $elements;
                    }

                    public final void run() {
                        this.$scanner.accumulate(Arrays.copyOf(this.$elements, this.$elements.length));
                    }
                });
            }
        }, "Computing references", false, project);
        return new AndroidModularizeProcessor(project, elements, (Set<? extends PsiElement>)scanner.getClassReferences(), (Set<? extends ResourceItem>)scanner.getResourceReferences(), (Set<? extends PsiElement>)scanner.getManifestReferences(), (Set<? extends PsiFile>)scanner.getCodeFileReferences(), scanner.getReferenceGraph());
    }

    static {
        Logger logger2 = Logger.getInstance(AndroidModularizeHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AndroidModularizeHandler::class.java)");
        LOGGER = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0003234B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070$\"\u00020\u0007\u00a2\u0006\u0002\u0010%J \u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0002J(\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u00101\u001a\u00020\u001cR!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0006j\b\u0012\u0004\u0012\u00020\f`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000fj\b\u0012\u0004\u0012\u00020\u0007`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u0006j\b\u0012\u0004\u0012\u00020\u001c`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\nR\u0018\u0010\u001e\u001a\u00020\u001f*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 \u00a8\u00065"}, d2={"Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "classReferences", "Ljava/util/LinkedHashSet;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/collections/LinkedHashSet;", "getClassReferences", "()Ljava/util/LinkedHashSet;", "codeFileReferences", "Lcom/intellij/psi/PsiFile;", "getCodeFileReferences", "manifestReferences", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getManifestReferences", "()Ljava/util/HashSet;", "myGraphBuilder", "Lcom/android/tools/idea/refactoring/modularize/AndroidCodeAndResourcesGraph$Builder;", "myVisitQueue", "Lkotlin/collections/ArrayDeque;", "referenceGraph", "Lcom/android/tools/idea/refactoring/modularize/AndroidCodeAndResourcesGraph;", "getReferenceGraph", "()Lcom/android/tools/idea/refactoring/modularize/AndroidCodeAndResourcesGraph;", "resourceReferences", "Lcom/android/ide/common/resources/ResourceItem;", "getResourceReferences", "isClass", "", "(Lcom/intellij/psi/PsiElement;)Z", "accumulate", "", "roots", "", "([Lcom/intellij/psi/PsiElement;)V", "commonVisitReferenceElement", "target", "mySource", "myFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "commonVisitReferenceExpression", "reference", "element", "myResourceRepository", "Lcom/android/tools/idea/res/LocalResourceRepository;", "getResourceDefinition", "resource", "JavaReferenceVisitor", "KotlinReferenceVisitor", "XmlResourceReferenceVisitor", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nAndroidModularizeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidModularizeHandler.kt\ncom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,471:1\n1851#2,2:472\n1851#2,2:476\n1851#2:478\n1851#2,2:479\n1852#2:481\n1851#2,2:482\n37#3,2:474\n37#3,2:488\n11335#4:484\n11670#4,3:485\n13543#4,2:490\n*S KotlinDebug\n*F\n+ 1 AndroidModularizeHandler.kt\ncom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector\n*L\n226#1:472,2\n250#1:476,2\n257#1:478\n258#1:479,2\n257#1:481\n280#1:482,2\n246#1:474,2\n421#1:488,2\n421#1:484\n421#1:485,3\n423#1:490,2\n*E\n"})
    private static final class CodeAndResourcesReferenceCollector {
        @NotNull
        private final Project myProject;
        @NotNull
        private final LinkedHashSet<PsiElement> classReferences;
        @NotNull
        private final LinkedHashSet<ResourceItem> resourceReferences;
        @NotNull
        private final HashSet<PsiElement> manifestReferences;
        @NotNull
        private final LinkedHashSet<PsiFile> codeFileReferences;
        @NotNull
        private final ArrayDeque<PsiElement> myVisitQueue;
        @NotNull
        private final AndroidCodeAndResourcesGraph.Builder myGraphBuilder;

        public CodeAndResourcesReferenceCollector(@NotNull Project myProject) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            this.myProject = myProject;
            this.classReferences = new LinkedHashSet();
            this.resourceReferences = new LinkedHashSet(100);
            this.manifestReferences = new HashSet();
            this.codeFileReferences = new LinkedHashSet();
            this.myVisitQueue = new ArrayDeque();
            this.myGraphBuilder = new AndroidCodeAndResourcesGraph.Builder();
        }

        @NotNull
        public final LinkedHashSet<PsiElement> getClassReferences() {
            return this.classReferences;
        }

        @NotNull
        public final LinkedHashSet<ResourceItem> getResourceReferences() {
            return this.resourceReferences;
        }

        @NotNull
        public final HashSet<PsiElement> getManifestReferences() {
            return this.manifestReferences;
        }

        @NotNull
        public final LinkedHashSet<PsiFile> getCodeFileReferences() {
            return this.codeFileReferences;
        }

        private final boolean isClass(PsiElement $this$isClass) {
            Language language = $this$isClass.getLanguage();
            return Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE) ? $this$isClass instanceof PsiClass : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? $this$isClass instanceof KtClass : false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void accumulate(PsiElement ... roots) {
            Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
            this.myVisitQueue.clear();
            for (PsiElement element2 : roots) {
                PsiFile it;
                if (element2 instanceof PsiClass || element2 instanceof KtClass) {
                    this.classReferences.add(element2);
                }
                if (element2.getContainingFile() == null) continue;
                boolean bl = false;
                if (!this.codeFileReferences.add(it)) continue;
                this.myVisitQueue.add((Object)it);
                this.myGraphBuilder.addRoot((PsiElement)it);
            }
            Set facetSet = new LinkedHashSet();
            Set fileScope = new LinkedHashSet();
            Set elementScope = new LinkedHashSet();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.pushState();
                indicator.setIndeterminate(false);
            }
            try {
                int numVisited = 0;
                while (!((Collection)this.myVisitQueue).isEmpty()) {
                    PsiClass[] classes2;
                    Object object;
                    AndroidFacet facet2;
                    PsiElement element3;
                    if ((PsiElement)this.myVisitQueue.removeFirstOrNull() == null) continue;
                    ++numVisited;
                    if (AndroidFacet.getInstance((PsiElement)element3) == null) continue;
                    facetSet.add(facet2);
                    if (indicator != null) {
                        object = Locale.US;
                        String string = "Scanning definition %1$d of %2$d";
                        Object[] objectArray = new Object[]{numVisited, numVisited + this.myVisitQueue.size()};
                        String string2 = String.format((Locale)object, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                        indicator.setText(string2);
                        indicator.setFraction((double)numVisited / (double)(numVisited + this.myVisitQueue.size()));
                    }
                    if (!(element3 instanceof PsiFile)) {
                        elementScope.add(element3);
                        element3.accept((PsiElementVisitor)new XmlResourceReferenceVisitor(facet2, element3));
                        continue;
                    }
                    VirtualFile virtualFile = ((PsiFile)element3).getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"element.virtualFile");
                    fileScope.add(virtualFile);
                    Language language = ((PsiFile)element3).getLanguage();
                    if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
                        element3.accept((PsiElementVisitor)new JavaReferenceVisitor(facet2, element3));
                    } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
                        element3.accept((PsiElementVisitor)new KotlinReferenceVisitor(facet2, element3));
                    } else {
                        element3.accept((PsiElementVisitor)new XmlResourceReferenceVisitor(facet2, element3));
                        continue;
                    }
                    object = element3;
                    Intrinsics.checkNotNull((Object)(object instanceof PsiJavaFile ? ((PsiJavaFile)element3).getClasses() : (object instanceof KtFile ? ((KtFile)element3).getClasses() : null)));
                    for (PsiClass clazz : classes2) {
                        GlobalSearchScope manifestScope;
                        Intrinsics.checkNotNullExpressionValue((Object)GlobalSearchScope.filesScope((Project)this.myProject, (Collection)SourceProvidersKt.getManifestFiles(facet2)), (String)"filesScope(myProject, facet.getManifestFiles())");
                        Query query = ReferencesSearch.search((PsiElement)((PsiElement)clazz), (SearchScope)((SearchScope)manifestScope));
                        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(clazz, manifestScope)");
                        Iterable $this$forEach$iv = (Iterable)query;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            XmlTag parentTag;
                            PsiElement tag;
                            PsiReference reference = (PsiReference)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)reference.getElement(), (String)"reference.element");
                            if ((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class) == null) continue;
                            boolean bl2 = false;
                            if (this.manifestReferences.add((PsiElement)parentTag)) {
                                Intrinsics.checkNotNullExpressionValue((Object)parentTag, (String)"parentTag");
                                this.myVisitQueue.add((Object)parentTag);
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)parentTag, (String)"parentTag");
                            this.myGraphBuilder.markReference(element3, (PsiElement)parentTag);
                        }
                    }
                }
                GlobalSearchScope globalSearchScope = null;
                globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                for (Object facet3 : facetSet) {
                    globalSearchScope = globalSearchScope.union((SearchScope)facet3.getModule().getModuleScope(false));
                }
                Collection $this$toTypedArray$iv = elementScope;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.filesScope((Project)this.myProject, (Collection)fileScope).union(new LocalSearchScope(thisCollection$iv.toArray(new PsiElement[0])));
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"filesScope(myProject, fi\u2026entScope.toTypedArray()))");
                GlobalSearchScope visitedScope = globalSearchScope2;
                globalSearchScope = globalSearchScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)visitedScope));
                for (PsiElement clazz : this.classReferences) {
                    Query query = ReferencesSearch.search((PsiElement)clazz, (SearchScope)((SearchScope)globalSearchScope));
                    Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(clazz, globalSearchScope)");
                    Iterable $this$forEach$iv = (Iterable)query;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PsiReference reference = (PsiReference)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"clazz");
                        this.myGraphBuilder.markReferencedOutsideScope(clazz);
                        LOGGER.debug(clazz + " referenced from " + reference.getElement().getContainingFile());
                    }
                    if (!(clazz instanceof KtClass)) continue;
                    $this$forEach$iv = ((KtClass)clazz).getCompanionObjects();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KtObjectDeclaration companion = (KtObjectDeclaration)element$iv;
                        boolean bl = false;
                        Query query2 = ReferencesSearch.search((PsiElement)((PsiElement)companion), (SearchScope)((SearchScope)globalSearchScope));
                        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"search(companion, globalSearchScope)");
                        Iterable $this$forEach$iv2 = (Iterable)query2;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PsiReference reference = (PsiReference)element$iv2;
                            boolean bl3 = false;
                            this.myGraphBuilder.markReferencedOutsideScope(clazz);
                            LOGGER.debug(clazz + " referenced from " + reference.getElement().getContainingFile());
                        }
                    }
                }
                HashSet<ResourceReference> seenResources = new HashSet<ResourceReference>(this.resourceReferences.size());
                for (ResourceItem item2 : this.resourceReferences) {
                    PsiField[] psiFieldArray;
                    PsiElement elm;
                    ResourceReference ref = item2.getReferenceToSelf();
                    if (!seenResources.add(ref)) continue;
                    PsiField[] fields = null;
                    Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"item");
                    PsiElement psiElement = elm = this.getResourceDefinition(item2);
                    if (psiElement instanceof PsiFile) {
                        psiFieldArray = IdeResourcesUtil.findResourceFieldsForFileResource((PsiFile)elm, true);
                    } else {
                        if (!(psiElement instanceof XmlTag)) continue;
                        psiFieldArray = IdeResourcesUtil.findResourceFieldsForValueResource((XmlTag)elm, true);
                    }
                    for (PsiField field2 : psiFieldArray) {
                        Query query = ReferencesSearch.search((PsiElement)((PsiElement)field2), (SearchScope)((SearchScope)globalSearchScope));
                        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(field, globalSearchScope)");
                        Iterable $this$forEach$iv = (Iterable)query;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            PsiReference reference = (PsiReference)element$iv;
                            boolean bl = false;
                            this.myGraphBuilder.markReferencedOutsideScope(elm);
                            LOGGER.debug(item2 + " referenced from " + reference.getElement().getContainingFile());
                        }
                    }
                }
            }
            finally {
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    progressIndicator.popState();
                }
            }
        }

        @NotNull
        public final AndroidCodeAndResourcesGraph getReferenceGraph() {
            return this.myGraphBuilder.build();
        }

        @Nullable
        public final PsiElement getResourceDefinition(@NotNull ResourceItem resource) {
            PsiNamedElement psiNamedElement;
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            PsiFile psiFile = IdeResourcesUtil.getItemPsiFile(this.myProject, resource);
            if (psiFile != null) {
                PsiFile file2 = psiFile;
                boolean bl = false;
                psiNamedElement = IdeResourcesUtil.getFolderType(file2) == ResourceFolderType.VALUES ? (PsiNamedElement)IdeResourcesUtil.getItemTag(this.myProject, resource) : (PsiNamedElement)file2;
            } else {
                psiNamedElement = null;
            }
            return (PsiElement)psiNamedElement;
        }

        private final void commonVisitReferenceExpression(PsiElement reference, PsiElement element2, PsiElement mySource, LocalResourceRepository myResourceRepository) {
            if ((element2 instanceof PsiField || element2 instanceof KtProperty) && AndroidModularizeHandlerKt.isAppResource(element2)) {
                ResourceType resourceType = AndroidModularizeHandlerKt.getResourceType(element2);
                if (resourceType != null) {
                    ResourceType type = resourceType;
                    boolean bl = false;
                    if (type != ResourceType.ID) {
                        String name2 = Intrinsics.areEqual((Object)reference.getLanguage(), (Object)JavaLanguage.INSTANCE) ? AndroidPsiUtils.getResourceName((PsiElement)reference) : reference.getText();
                        List<ResourceItem> list2 = myResourceRepository.getResources(ResourceNamespace.TODO(), type, name2);
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"myResourceRepository.get\u2026space.TODO(), type, name)");
                        List<ResourceItem> matches = list2;
                        for (ResourceItem match2 : matches) {
                            Intrinsics.checkNotNullExpressionValue((Object)match2, (String)"match");
                            if (this.getResourceDefinition(match2) != null) {
                                PsiElement target2;
                                boolean bl2 = false;
                                if (this.resourceReferences.add(match2)) {
                                    this.myVisitQueue.add((Object)target2);
                                }
                                this.myGraphBuilder.markReference(mySource, target2);
                            }
                        }
                    }
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void commonVisitReferenceElement(PsiElement target2, PsiElement mySource, AndroidFacet myFacet) {
            if ((target2 instanceof PsiClass || target2 instanceof KtClass || target2 instanceof KtDeclaration && KtPsiUtilKt.containingClass((KtElement)((KtElement)target2)) == null || target2 instanceof KtObjectDeclaration && ((KtObjectDeclaration)target2).isCompanion()) && !(target2 instanceof KtTypeParameter) && !(target2 instanceof SyntheticElement)) {
                PsiElement[] file2 = target2.getContainingFile();
                IdeaSourceProvider ideaSourceProvider = SourceProviderManager.Companion.getInstance(myFacet).getSources();
                VirtualFile virtualFile = file2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.virtualFile");
                if (SourceProvidersKt.containsFile(ideaSourceProvider, virtualFile)) {
                    void $this$forEach$iv;
                    PsiElement[] psiElementArray;
                    PsiElement[] psiElementArray2;
                    if (target2 instanceof KtClass || target2 instanceof PsiClass) {
                        this.classReferences.add(target2);
                    }
                    if ((psiElementArray2 = file2) instanceof PsiJavaFile) {
                        psiElementArray = (PsiElement[])((PsiJavaFile)file2).getClasses();
                    } else if (psiElementArray2 instanceof KtFile) {
                        void $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv;
                        Object $this$map$iv = ((KtFile)file2).getClasses();
                        boolean $i$f$map = false;
                        PsiClass[] psiClassArray = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(((PsiClass[])$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        int n = ((void)$this$mapTo$iv$iv).length;
                        for (int i = 0; i < n; ++i) {
                            void it;
                            void item$iv$iv;
                            void var14_17 = item$iv$iv = $this$mapTo$iv$iv[i];
                            Collection collection2 = destination$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.asJava.classes.KtLightClass");
                            KtElement ktElement = ((KtLightClass)it).getKotlinOrigin();
                            collection2.add(ktElement instanceof KtClass ? (KtClass)ktElement : null);
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        psiElementArray = (PsiElement[])thisCollection$iv.toArray(new KtClass[0]);
                    } else {
                        psiElementArray = null;
                    }
                    Intrinsics.checkNotNull((Object)psiElementArray);
                    psiElementArray2 = psiElementArray;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        void v3 = it;
                        if (v3 == null) continue;
                        this.classReferences.add((PsiElement)v3);
                    }
                    if (this.codeFileReferences.add((PsiFile)file2)) {
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                        this.myVisitQueue.add((Object)file2);
                    }
                    if (!Intrinsics.areEqual((Object)target2, (Object)mySource) && !Intrinsics.areEqual((Object)file2, (Object)mySource)) {
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                        this.myGraphBuilder.markReference(mySource, (PsiElement)file2);
                    }
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector$JavaReferenceVisitor;", "Lcom/intellij/psi/JavaRecursiveElementWalkingVisitor;", "myFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "mySource", "Lcom/intellij/psi/PsiElement;", "(Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector;Lorg/jetbrains/android/facet/AndroidFacet;Lcom/intellij/psi/PsiElement;)V", "myResourceRepository", "Lcom/android/tools/idea/res/LocalResourceRepository;", "visitReferenceElement", "", "reference", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "visitReferenceExpression", "expression", "Lcom/intellij/psi/PsiReferenceExpression;", "intellij.android.core"})
        @SourceDebugExtension(value={"SMAP\nAndroidModularizeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidModularizeHandler.kt\ncom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector$JavaReferenceVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,471:1\n1#2:472\n*E\n"})
        private final class JavaReferenceVisitor
        extends JavaRecursiveElementWalkingVisitor {
            @NotNull
            private final AndroidFacet myFacet;
            @NotNull
            private final PsiElement mySource;
            @NotNull
            private final LocalResourceRepository myResourceRepository;

            public JavaReferenceVisitor(@NotNull AndroidFacet myFacet, PsiElement mySource) {
                Intrinsics.checkNotNullParameter((Object)myFacet, (String)"myFacet");
                Intrinsics.checkNotNullParameter((Object)mySource, (String)"mySource");
                this.myFacet = myFacet;
                this.mySource = mySource;
                LocalResourceRepository localResourceRepository = StudioResourceRepositoryManager.getModuleResources(this.myFacet);
                Intrinsics.checkNotNullExpressionValue((Object)localResourceRepository, (String)"getModuleResources(myFacet)");
                this.myResourceRepository = localResourceRepository;
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                PsiElement psiElement = expression2.resolve();
                if (psiElement != null) {
                    PsiElement psiElement2 = psiElement;
                    CodeAndResourcesReferenceCollector codeAndResourcesReferenceCollector = CodeAndResourcesReferenceCollector.this;
                    PsiElement element2 = psiElement2;
                    boolean bl = false;
                    codeAndResourcesReferenceCollector.commonVisitReferenceExpression((PsiElement)expression2, element2, this.mySource, this.myResourceRepository);
                }
                super.visitReferenceExpression(expression2);
            }

            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                PsiElement psiElement = reference.advancedResolve(false).getElement();
                if (psiElement == null) {
                    return;
                }
                CodeAndResourcesReferenceCollector.this.commonVisitReferenceElement(psiElement, this.mySource, this.myFacet);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector$KotlinReferenceVisitor;", "Lorg/jetbrains/kotlin/idea/structuralsearch/visitor/KotlinRecursiveElementWalkingVisitor;", "myFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "mySource", "Lcom/intellij/psi/PsiElement;", "(Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector;Lorg/jetbrains/android/facet/AndroidFacet;Lcom/intellij/psi/PsiElement;)V", "myResourceRepository", "Lcom/android/tools/idea/res/LocalResourceRepository;", "visitReferenceExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "intellij.android.core"})
        @SourceDebugExtension(value={"SMAP\nAndroidModularizeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidModularizeHandler.kt\ncom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector$KotlinReferenceVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,471:1\n13543#2,2:472\n*S KotlinDebug\n*F\n+ 1 AndroidModularizeHandler.kt\ncom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector$KotlinReferenceVisitor\n*L\n359#1:472,2\n*E\n"})
        private final class KotlinReferenceVisitor
        extends KotlinRecursiveElementWalkingVisitor {
            @NotNull
            private final AndroidFacet myFacet;
            @NotNull
            private final PsiElement mySource;
            @NotNull
            private final LocalResourceRepository myResourceRepository;

            public KotlinReferenceVisitor(@NotNull AndroidFacet myFacet, PsiElement mySource) {
                Intrinsics.checkNotNullParameter((Object)myFacet, (String)"myFacet");
                Intrinsics.checkNotNullParameter((Object)mySource, (String)"mySource");
                this.myFacet = myFacet;
                this.mySource = mySource;
                LocalResourceRepository localResourceRepository = StudioResourceRepositoryManager.getModuleResources(this.myFacet);
                Intrinsics.checkNotNullExpressionValue((Object)localResourceRepository, (String)"getModuleResources(myFacet)");
                this.myResourceRepository = localResourceRepository;
            }

            /*
             * WARNING - void declaration
             */
            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                PsiReference[] psiReferenceArray = expression2.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"expression.references");
                Object[] objectArray = psiReferenceArray;
                CodeAndResourcesReferenceCollector codeAndResourcesReferenceCollector = CodeAndResourcesReferenceCollector.this;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    PsiReference it = (PsiReference)element$iv;
                    boolean bl = false;
                    PsiReference psiReference = it;
                    if (psiReference == null || (psiReference = psiReference.resolve()) == null) continue;
                    PsiReference element2 = psiReference;
                    boolean bl2 = false;
                    PsiElement psiElement = it.getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it.element");
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
                    codeAndResourcesReferenceCollector.commonVisitReferenceExpression(psiElement, (PsiElement)element2, this.mySource, this.myResourceRepository);
                    codeAndResourcesReferenceCollector.commonVisitReferenceElement((PsiElement)element2, this.mySource, this.myFacet);
                }
                super.visitReferenceExpression(expression2);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector$XmlResourceReferenceVisitor;", "Lcom/intellij/psi/XmlRecursiveElementWalkingVisitor;", "myFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "mySource", "Lcom/intellij/psi/PsiElement;", "(Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$CodeAndResourcesReferenceCollector;Lorg/jetbrains/android/facet/AndroidFacet;Lcom/intellij/psi/PsiElement;)V", "myResourceRepository", "Lcom/android/tools/idea/res/LocalResourceRepository;", "processPotentialReference", "", "text", "", "visitXmlAttributeValue", "element", "Lcom/intellij/psi/xml/XmlAttributeValue;", "visitXmlToken", "token", "Lcom/intellij/psi/xml/XmlToken;", "intellij.android.core"})
        private final class XmlResourceReferenceVisitor
        extends XmlRecursiveElementWalkingVisitor {
            @NotNull
            private final AndroidFacet myFacet;
            @NotNull
            private final PsiElement mySource;
            @NotNull
            private final LocalResourceRepository myResourceRepository;

            public XmlResourceReferenceVisitor(@NotNull AndroidFacet myFacet, PsiElement mySource) {
                Intrinsics.checkNotNullParameter((Object)myFacet, (String)"myFacet");
                Intrinsics.checkNotNullParameter((Object)mySource, (String)"mySource");
                this.myFacet = myFacet;
                this.mySource = mySource;
                LocalResourceRepository localResourceRepository = StudioResourceRepositoryManager.getModuleResources(this.myFacet);
                Intrinsics.checkNotNullExpressionValue((Object)localResourceRepository, (String)"getModuleResources(myFacet)");
                this.myResourceRepository = localResourceRepository;
            }

            public void visitXmlAttributeValue(@NotNull XmlAttributeValue element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                String string = element2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.value");
                this.processPotentialReference(string);
            }

            public void visitXmlToken(@NotNull XmlToken token) {
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                String string = token.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"token.text");
                this.processPotentialReference(string);
            }

            private final void processPotentialReference(String text2) {
                ResourceUrl resourceUrl = ResourceUrl.parse((String)text2);
                if (resourceUrl == null) {
                    return;
                }
                ResourceUrl url = resourceUrl;
                if (!url.isFramework() && !url.isCreate() && url.type != ResourceType.ID) {
                    List<ResourceItem> list2 = this.myResourceRepository.getResources(ResourceNamespace.TODO(), url.type, url.name);
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"myResourceRepository.get\u2026DO(), url.type, url.name)");
                    List<ResourceItem> matches = list2;
                    for (ResourceItem match2 : matches) {
                        PsiElement psiElement;
                        if (CodeAndResourcesReferenceCollector.this.getResourceDefinition(match2) == null) continue;
                        CodeAndResourcesReferenceCollector codeAndResourcesReferenceCollector = CodeAndResourcesReferenceCollector.this;
                        PsiElement target2 = psiElement;
                        boolean bl = false;
                        if (codeAndResourcesReferenceCollector.getResourceReferences().add(match2)) {
                            codeAndResourcesReferenceCollector.myVisitQueue.add((Object)target2);
                        }
                        codeAndResourcesReferenceCollector.myGraphBuilder.markReference(this.mySource, target2);
                    }
                } else {
                    PsiClass psiClass = JavaPsiFacade.getInstance((Project)CodeAndResourcesReferenceCollector.this.myProject).findClass(text2, this.myFacet.getModule().getModuleScope(false));
                    if (psiClass == null) {
                        return;
                    }
                    PsiClass psiClass2 = psiClass;
                    PsiFile psiFile = psiClass2.getContainingFile();
                    if (psiFile == null) {
                        return;
                    }
                    PsiFile file2 = psiFile;
                    CodeAndResourcesReferenceCollector.this.getClassReferences().add((PsiElement)psiClass2);
                    if (CodeAndResourcesReferenceCollector.this.getCodeFileReferences().add(file2)) {
                        CodeAndResourcesReferenceCollector.this.myVisitQueue.add((Object)file2);
                    }
                    CodeAndResourcesReferenceCollector.this.myGraphBuilder.markReference(this.mySource, (PsiElement)file2);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/refactoring/modularize/AndroidModularizeHandler$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RESOURCE_SET_INITIAL_SIZE", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

