/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.ide.common.repository.NetworkCache;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.gradle.IdeGooglePlaySdkIndexKt;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.lint.checks.GooglePlaySdkIndex;
import com.android.tools.lint.detector.api.LintFix;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.SdkIndexLibraryDetails;
import com.google.wireless.android.sdk.stats.SdkIndexLoadingDetails;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0016J\u0006\u0010\u001c\u001a\u00020\u000fJ\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J*\u0010#\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0014J*\u0010%\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J*\u0010&\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J \u0010'\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020!H\u0002J:\u0010)\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u000200H\u0014J\f\u00101\u001a\u000202*\u00020!H\u0002J\f\u00101\u001a\u000203*\u000204H\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00065"}, d2={"Lcom/android/tools/idea/projectsystem/gradle/IdeGooglePlaySdkIndex;", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "createTrackerEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "file", "Ljava/io/File;", "kind", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$EventKind;", "error", "", "throwable", "", "message", "", "findProject", "Lcom/intellij/openapi/project/Project;", "generateSdkLinkLintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "groupId", "artifactId", "versionString", "buildFile", "initializeAndSetFlags", "logCachingError", "readResult", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataResult;", "dataSourceType", "Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "logErrorInDefaultData", "logHasCriticalIssues", "logIndexLoadedCorrectly", "logNonCompliant", "logOutdated", "logTrackerEventForIndexLoadingError", "dataSource", "logTrackerEventForLibraryVersion", "isBlocking", "", "readUrlData", "", "url", "timeout", "", "toTrackerType", "Lcom/google/wireless/android/sdk/stats/SdkIndexLoadingDetails$SourceType;", "Lcom/google/wireless/android/sdk/stats/SdkIndexLoadingDetails$ReadErrorType;", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;", "intellij.android.projectSystem.gradle"})
public final class IdeGooglePlaySdkIndex
extends GooglePlaySdkIndex {
    @NotNull
    public static final IdeGooglePlaySdkIndex INSTANCE = new IdeGooglePlaySdkIndex();
    @NotNull
    private static final Logger logger;

    private IdeGooglePlaySdkIndex() {
        super(IdeGooglePlaySdkIndexKt.getCacheDir());
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @Nullable
    protected byte[] readUrlData(@NotNull String url, int timeout) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpRequests.request((String)new URL(url).toExternalForm()).connectTimeout(timeout).readTimeout(timeout).readBytes(null);
    }

    protected void error(@NotNull Throwable throwable, @Nullable String message2) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        logger.error(message2, throwable);
    }

    protected void logNonCompliant(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        super.logNonCompliant(groupId, artifactId, versionString, file2);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        logger.warn(this.generatePolicyMessage(groupId, artifactId, versionString));
        this.logTrackerEventForLibraryVersion(groupId, artifactId, versionString, isBlocking, file2, AndroidStudioEvent.EventKind.SDK_INDEX_LIBRARY_IS_NON_COMPLIANT);
    }

    protected void logHasCriticalIssues(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        super.logHasCriticalIssues(groupId, artifactId, versionString, file2);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        String warnMsg = isBlocking ? this.generateBlockingCriticalMessage(groupId, artifactId, versionString) : this.generateCriticalMessage(groupId, artifactId, versionString);
        logger.warn(warnMsg);
        this.logTrackerEventForLibraryVersion(groupId, artifactId, versionString, isBlocking, file2, AndroidStudioEvent.EventKind.SDK_INDEX_LIBRARY_HAS_CRITICAL_ISSUES);
    }

    protected void logOutdated(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file2) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        super.logOutdated(groupId, artifactId, versionString, file2);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        String warnMsg = isBlocking ? this.generateBlockingOutdatedMessage(groupId, artifactId, versionString) : this.generateOutdatedMessage(groupId, artifactId, versionString);
        logger.warn(warnMsg);
        this.logTrackerEventForLibraryVersion(groupId, artifactId, versionString, isBlocking, file2, AndroidStudioEvent.EventKind.SDK_INDEX_LIBRARY_IS_OUTDATED);
    }

    protected void logIndexLoadedCorrectly(@NotNull NetworkCache.DataSourceType dataSourceType) {
        Intrinsics.checkNotNullParameter((Object)dataSourceType, (String)"dataSourceType");
        super.logIndexLoadedCorrectly(dataSourceType);
        logger.info("SDK Index data loaded correctly from " + dataSourceType);
        AndroidStudioEvent.Builder event2 = this.createTrackerEvent(null, AndroidStudioEvent.EventKind.SDK_INDEX_LOADED_CORRECTLY);
        event2.setSdkIndexLoadingDetails(SdkIndexLoadingDetails.newBuilder().setSourceType(this.toTrackerType(dataSourceType)));
        UsageTracker.log((AndroidStudioEvent.Builder)event2);
    }

    protected void logCachingError(@NotNull GooglePlaySdkIndex.ReadDataResult readResult, @NotNull NetworkCache.DataSourceType dataSourceType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
        Intrinsics.checkNotNullParameter((Object)dataSourceType, (String)"dataSourceType");
        super.logCachingError(readResult, dataSourceType);
        Exception exception = readResult.getException();
        CharSequence charSequence = exception != null ? exception.getMessage() : null;
        if (charSequence == null || charSequence.length() == 0) {
            object = "";
        } else {
            Exception exception2 = readResult.getException();
            object = ": " + (exception2 != null ? exception2.getMessage() : null);
        }
        String warnMsg = object;
        logger.warn("Could not use data from cache" + warnMsg + " (error: " + readResult.getReadDataErrorType() + ", source: " + dataSourceType + ")");
        this.logTrackerEventForIndexLoadingError(AndroidStudioEvent.EventKind.SDK_INDEX_CACHING_ERROR, readResult, dataSourceType);
    }

    protected void logErrorInDefaultData(@NotNull GooglePlaySdkIndex.ReadDataResult readResult) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
        super.logErrorInDefaultData(readResult);
        Exception exception = readResult.getException();
        CharSequence charSequence = exception != null ? exception.getMessage() : null;
        if (charSequence == null || charSequence.length() == 0) {
            object = "";
        } else {
            Exception exception2 = readResult.getException();
            object = ": " + (exception2 != null ? exception2.getMessage() : null);
        }
        String warnMsg = object;
        logger.warn("Could not use default SDK Index" + warnMsg + " (" + readResult.getReadDataErrorType() + ")");
        this.logTrackerEventForIndexLoadingError(AndroidStudioEvent.EventKind.SDK_INDEX_DEFAULT_DATA_ERROR, readResult, NetworkCache.DataSourceType.DEFAULT_DATA);
    }

    @Nullable
    public LintFix generateSdkLinkLintFix(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String url = this.getSdkUrl(groupId, artifactId);
        boolean isBlocking = this.hasLibraryBlockingIssues(groupId, artifactId, versionString);
        return url != null ? (LintFix)new LintFix.ShowUrl("View details in Google Play SDK Index", null, url, (Function0)new Function0<Unit>(groupId, artifactId, versionString, isBlocking, buildFile){
            final /* synthetic */ String $groupId;
            final /* synthetic */ String $artifactId;
            final /* synthetic */ String $versionString;
            final /* synthetic */ boolean $isBlocking;
            final /* synthetic */ File $buildFile;
            {
                this.$groupId = $groupId;
                this.$artifactId = $artifactId;
                this.$versionString = $versionString;
                this.$isBlocking = $isBlocking;
                this.$buildFile = $buildFile;
                super(0);
            }

            public final void invoke() {
                IdeGooglePlaySdkIndex.access$logTrackerEventForLibraryVersion(IdeGooglePlaySdkIndex.INSTANCE, this.$groupId, this.$artifactId, this.$versionString, this.$isBlocking, this.$buildFile, AndroidStudioEvent.EventKind.SDK_INDEX_LINK_FOLLOWED);
            }
        }) : null;
    }

    public final void initializeAndSetFlags() {
        this.initialize();
        Object t = StudioFlags.SHOW_SDK_INDEX_CRITICAL_ISSUES.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"SHOW_SDK_INDEX_CRITICAL_ISSUES.get()");
        this.setShowCriticalIssues((Boolean)t);
        Object t2 = StudioFlags.SHOW_SDK_INDEX_MESSAGES.get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"SHOW_SDK_INDEX_MESSAGES.get()");
        this.setShowMessages((Boolean)t2);
        Object t3 = StudioFlags.INCLUDE_LINKS_TO_SDK_INDEX.get();
        Intrinsics.checkNotNullExpressionValue(t3, (String)"INCLUDE_LINKS_TO_SDK_INDEX.get()");
        this.setShowLinks((Boolean)t3);
        Object t4 = StudioFlags.SHOW_SDK_INDEX_POLICY_ISSUES.get();
        Intrinsics.checkNotNullExpressionValue(t4, (String)"SHOW_SDK_INDEX_POLICY_ISSUES.get()");
        this.setShowPolicyIssues((Boolean)t4);
    }

    private final Project findProject(File file2) {
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(file2.toPath());
        return virtualFile == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
    }

    private final void logTrackerEventForLibraryVersion(String groupId, String artifactId, String versionString, boolean isBlocking, File file2, AndroidStudioEvent.EventKind kind) {
        AndroidStudioEvent.Builder event2 = this.createTrackerEvent(file2, kind);
        event2.setSdkIndexLibraryDetails(SdkIndexLibraryDetails.newBuilder().setGroupId(groupId).setArtifactId(artifactId).setVersionString(versionString).setIsBlocking(isBlocking));
        UsageTracker.log((AndroidStudioEvent.Builder)event2);
    }

    private final void logTrackerEventForIndexLoadingError(AndroidStudioEvent.EventKind kind, GooglePlaySdkIndex.ReadDataResult readResult, NetworkCache.DataSourceType dataSource) {
        AndroidStudioEvent.Builder event2 = this.createTrackerEvent(null, kind);
        event2.setSdkIndexLoadingDetails(SdkIndexLoadingDetails.newBuilder().setReadErrorType(this.toTrackerType(readResult.getReadDataErrorType())).setSourceType(this.toTrackerType(dataSource)));
        UsageTracker.log((AndroidStudioEvent.Builder)event2);
    }

    private final AndroidStudioEvent.Builder createTrackerEvent(File file2, AndroidStudioEvent.EventKind kind) {
        Project project;
        AndroidStudioEvent.Builder event2 = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GOOGLE_PLAY_SDK_INDEX).setKind(kind);
        Project project2 = project = file2 != null ? this.findProject(file2) : null;
        if (project != null) {
            Intrinsics.checkNotNullExpressionValue((Object)event2, (String)"event");
            UsageTrackerUtils.withProjectId(event2, project);
        }
        Intrinsics.checkNotNullExpressionValue((Object)event2, (String)"event");
        return event2;
    }

    private final SdkIndexLoadingDetails.SourceType toTrackerType(NetworkCache.DataSourceType $this$toTrackerType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toTrackerType.ordinal()]) {
            case 1 -> SdkIndexLoadingDetails.SourceType.UNKNOWN_SOURCE;
            case 2 -> SdkIndexLoadingDetails.SourceType.TEST_DATA;
            case 3 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_EXPIRED_NO_NETWORK;
            case 4 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_EXPIRED_NETWORK_ERROR;
            case 5 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_EXPIRED_UNKNOWN;
            case 6 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_RECENT;
            case 7 -> SdkIndexLoadingDetails.SourceType.CACHE_FILE_NEW;
            case 8 -> SdkIndexLoadingDetails.SourceType.DEFAULT_DATA;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final SdkIndexLoadingDetails.ReadErrorType toTrackerType(GooglePlaySdkIndex.ReadDataErrorType $this$toTrackerType) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toTrackerType.ordinal()]) {
            case 1 -> SdkIndexLoadingDetails.ReadErrorType.NO_ERROR;
            case 2 -> SdkIndexLoadingDetails.ReadErrorType.DATA_FUNCTION_EXCEPTION;
            case 3 -> SdkIndexLoadingDetails.ReadErrorType.DATA_FUNCTION_NULL_ERROR;
            case 4 -> SdkIndexLoadingDetails.ReadErrorType.GZIP_EXCEPTION;
            case 5 -> SdkIndexLoadingDetails.ReadErrorType.INDEX_PARSE_EXCEPTION;
            case 6 -> SdkIndexLoadingDetails.ReadErrorType.INDEX_PARSE_NULL_ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ void access$logTrackerEventForLibraryVersion(IdeGooglePlaySdkIndex $this, String groupId, String artifactId, String versionString, boolean isBlocking, File file2, AndroidStudioEvent.EventKind kind) {
        $this.logTrackerEventForLibraryVersion(groupId, artifactId, versionString, isBlocking, file2, kind);
    }

    static {
        Logger logger2 = Logger.getInstance(((Object)((Object)INSTANCE)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(this::class.java)");
        logger = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[NetworkCache.DataSourceType.values().length];
            try {
                nArray[NetworkCache.DataSourceType.UNKNOWN_SOURCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.TEST_DATA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_EXPIRED_NO_NETWORK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_EXPIRED_NETWORK_ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_EXPIRED_UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_RECENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.CACHE_FILE_NEW.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkCache.DataSourceType.DEFAULT_DATA.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GooglePlaySdkIndex.ReadDataErrorType.values().length];
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.NO_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.DATA_FUNCTION_EXCEPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.DATA_FUNCTION_NULL_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.GZIP_EXCEPTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.INDEX_PARSE_EXCEPTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GooglePlaySdkIndex.ReadDataErrorType.INDEX_PARSE_NULL_ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

