/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogView;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleVersionCatalogViewImpl;
import com.android.tools.idea.gradle.dsl.model.ProjectBuildModelImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class GradleModelSource
extends GradleModelProvider {
    private static final BuildModelContext.ResolvedConfigurationFileLocationProvider myResolvedConfigurationFileLocationProvider = new ResolvedConfigurationFileLocationProviderImpl();

    @Override
    @NotNull
    public ProjectBuildModel getProjectModel(@NotNull Project project) {
        BuildModelContext context2 = GradleModelSource.createContext(project);
        VirtualFile file2 = context2.getGradleBuildFile(Projects.getBaseDirPath((Project)project));
        return new ProjectBuildModelImpl(project, file2, context2);
    }

    @Override
    @Nullable
    public ProjectBuildModel getProjectModel(@NotNull Project hostProject, @NotNull String compositeRoot) {
        BuildModelContext context2 = GradleModelSource.createContext(hostProject);
        VirtualFile file2 = context2.getGradleBuildFile(new File(compositeRoot));
        if (file2 == null) {
            return null;
        }
        return new ProjectBuildModelImpl(hostProject, file2, context2);
    }

    @Override
    @Nullable
    public GradleBuildModel getBuildModel(@NotNull Project project) {
        BuildModelContext context2 = GradleModelSource.createContext(project);
        VirtualFile file2 = context2.getGradleBuildFile(Projects.getBaseDirPath((Project)project));
        return file2 != null ? GradleModelSource.internalCreateBuildModel(context2, file2, project.getName()) : null;
    }

    @Override
    @Nullable
    public GradleBuildModel getBuildModel(@NotNull Module module2) {
        BuildModelContext context2 = GradleModelSource.createContext(module2.getProject());
        VirtualFile file2 = context2.getGradleBuildFile(module2);
        return file2 != null ? GradleModelSource.internalCreateBuildModel(context2, file2, module2.getName()) : null;
    }

    @Override
    @NotNull
    public GradleBuildModel parseBuildFile(@NotNull VirtualFile file2, @NotNull Project project) {
        return GradleModelSource.internalCreateBuildModel(GradleModelSource.createContext(project), file2, "<Unknown>");
    }

    @Override
    @NotNull
    public GradleBuildModel parseBuildFile(@NotNull VirtualFile file2, @NotNull Project project, @NotNull String moduleName2) {
        return GradleModelSource.internalCreateBuildModel(GradleModelSource.createContext(project), file2, moduleName2);
    }

    @Override
    @Nullable
    public GradleSettingsModel getSettingsModel(@NotNull Project project) {
        BuildModelContext context2 = GradleModelSource.createContext(project);
        VirtualFile file2 = context2.getGradleSettingsFile(Projects.getBaseDirPath((Project)project));
        return file2 != null ? GradleModelSource.parseSettingsFile(context2, file2, project, "settings") : null;
    }

    @Override
    @NotNull
    public GradleSettingsModel getSettingsModel(@NotNull VirtualFile settingsFile, @NotNull Project hostProject) {
        return GradleModelSource.parseSettingsFile(GradleModelSource.createContext(hostProject), settingsFile, hostProject, "settings");
    }

    @Override
    @NotNull
    public GradleVersionCatalogView getVersionCatalogView(@NotNull Project hostProject) {
        GradleSettingsModel settings = this.getSettingsModel(hostProject);
        return new GradleVersionCatalogViewImpl(settings);
    }

    @NotNull
    private static GradleBuildModel internalCreateBuildModel(@NotNull BuildModelContext context2, @NotNull VirtualFile file2, @NotNull String moduleName2) {
        return new GradleBuildModelImpl(context2.getOrCreateBuildFile(file2, moduleName2, false));
    }

    @NotNull
    private static GradleSettingsModel parseSettingsFile(@NotNull BuildModelContext context2, @NotNull VirtualFile file2, @NotNull Project project, @NotNull String moduleName2) {
        GradleSettingsFile settingsFile = new GradleSettingsFile(file2, project, moduleName2, context2);
        settingsFile.parse();
        return new GradleSettingsModelImpl(settingsFile);
    }

    @NotNull
    private static BuildModelContext createContext(@NotNull Project project) {
        return BuildModelContext.create(project, myResolvedConfigurationFileLocationProvider);
    }

    private static class ResolvedConfigurationFileLocationProviderImpl
    implements BuildModelContext.ResolvedConfigurationFileLocationProvider {
        private ResolvedConfigurationFileLocationProviderImpl() {
        }

        @Override
        @Nullable
        public VirtualFile getGradleBuildFile(@NotNull Module module2) {
            GradleModuleModel moduleModel = GradleUtil.getGradleModuleModel(module2);
            if (moduleModel != null) {
                return moduleModel.getBuildFile();
            }
            return null;
        }

        @Override
        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Module module2) {
            return AndroidProjectRootUtil.getModuleDirPath(module2);
        }

        @Override
        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Project project) {
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
            if (projectDir == null) {
                return null;
            }
            return projectDir.getPath();
        }
    }
}

