/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem;

import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.AndroidProjectSystemProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.util.Computable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0007H\u0007R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/projectsystem/ProjectSystemService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedProjectSystem", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectSystem", "getProjectSystem", "()Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "detectProjectSystem", "replaceProjectSystemForTests", "", "Companion", "intellij.android.projectSystem"})
@SourceDebugExtension(value={"SMAP\nProjectSystemService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectSystemService.kt\ncom/android/tools/idea/projectsystem/ProjectSystemService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 actions.kt\ncom/intellij/openapi/application/ActionsKt\n*L\n1#1,83:1\n1#2:84\n9#3:85\n*S KotlinDebug\n*F\n+ 1 ProjectSystemService.kt\ncom/android/tools/idea/projectsystem/ProjectSystemService\n*L\n74#1:85\n*E\n"})
public final class ProjectSystemService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<AndroidProjectSystem> cachedProjectSystem;

    public ProjectSystemService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cachedProjectSystem = new AtomicReference();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final AndroidProjectSystem getProjectSystem() {
        AndroidProjectSystem cache2 = this.cachedProjectSystem.get();
        if (cache2 == null) {
            cache2 = this.detectProjectSystem(this.project);
            if (this.cachedProjectSystem.compareAndSet(null, cache2)) {
                Logger.getInstance(ProjectSystemService.class).info(cache2.getClass().getSimpleName() + " project system has been detected");
            }
            AndroidProjectSystem androidProjectSystem = this.cachedProjectSystem.get();
            Intrinsics.checkNotNull((Object)androidProjectSystem);
            cache2 = androidProjectSystem;
        }
        return cache2;
    }

    private final AndroidProjectSystem detectProjectSystem(Project project) {
        AndroidProjectSystemProvider androidProjectSystemProvider;
        AndroidProjectSystemProvider androidProjectSystemProvider2;
        int n;
        AndroidProjectSystemProvider[] extensions;
        block4: {
            extensions = (AndroidProjectSystemProvider[])ProjectSystemUtil.getEP_NAME().getExtensions((AreaInstance)project);
            Intrinsics.checkNotNullExpressionValue((Object)extensions, (String)"extensions");
            AndroidProjectSystemProvider[] androidProjectSystemProviderArray = extensions;
            n = androidProjectSystemProviderArray.length;
            for (int i = 0; i < n; ++i) {
                AndroidProjectSystemProvider androidProjectSystemProvider3;
                AndroidProjectSystemProvider it = androidProjectSystemProvider3 = androidProjectSystemProviderArray[i];
                boolean bl = false;
                if (!it.isApplicable()) continue;
                androidProjectSystemProvider2 = androidProjectSystemProvider3;
                break block4;
            }
            androidProjectSystemProvider2 = androidProjectSystemProvider = null;
        }
        if (androidProjectSystemProvider2 == null) {
            AndroidProjectSystemProvider androidProjectSystemProvider4;
            block5: {
                AndroidProjectSystemProvider[] androidProjectSystemProviderArray = extensions;
                int n2 = androidProjectSystemProviderArray.length;
                for (n = 0; n < n2; ++n) {
                    AndroidProjectSystemProvider androidProjectSystemProvider5;
                    AndroidProjectSystemProvider it = androidProjectSystemProvider5 = androidProjectSystemProviderArray[n];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"")) continue;
                    androidProjectSystemProvider4 = androidProjectSystemProvider5;
                    break block5;
                }
                androidProjectSystemProvider4 = androidProjectSystemProvider = null;
            }
            if (androidProjectSystemProvider4 == null) {
                throw new IllegalStateException("Default AndroidProjectSystem not found for project " + project.getName());
            }
        }
        AndroidProjectSystemProvider provider2 = androidProjectSystemProvider;
        return provider2.getProjectSystem();
    }

    @TestOnly
    public final void replaceProjectSystemForTests(@NotNull AndroidProjectSystem projectSystem2) {
        Intrinsics.checkNotNullParameter((Object)projectSystem2, (String)"projectSystem");
        AndroidProjectSystem old2 = this.cachedProjectSystem.getAndUpdate(new UnaryOperator(projectSystem2){
            final /* synthetic */ AndroidProjectSystem $projectSystem;
            {
                this.$projectSystem = $projectSystem;
            }

            @Nullable
            public final AndroidProjectSystem apply(@Nullable AndroidProjectSystem it) {
                return this.$projectSystem;
            }
        });
        if (old2 != null) {
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(this){
                final /* synthetic */ ProjectSystemService this$0;
                {
                    this.this$0 = projectSystemService;
                }

                public final T compute() {
                    boolean bl = false;
                    Object object = this.this$0.getProject().getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.messageBus.syncP\u2026jectTopics.PROJECT_ROOTS)");
                    ModuleRootListener publisher = (ModuleRootListener)object;
                    ModuleRootEventImpl rootChangedEvent = new ModuleRootEventImpl(this.this$0.getProject(), false);
                    publisher.beforeRootsChange((ModuleRootEvent)rootChangedEvent);
                    publisher.rootsChanged((ModuleRootEvent)rootChangedEvent);
                    return (T)Unit.INSTANCE;
                }
            });
        }
    }

    @JvmStatic
    @NotNull
    public static final ProjectSystemService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/projectsystem/ProjectSystemService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/projectsystem/ProjectSystemService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.projectSystem"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProjectSystemService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ProjectSystemService.class);
            Intrinsics.checkNotNull((Object)object);
            return (ProjectSystemService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

